/*
 * Decompiled with CFR 0.152.
 */
package android.media.videoeditor;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.media.videoeditor.MediaArtistNativeHelper;
import android.media.videoeditor.MediaItem;
import android.media.videoeditor.MediaProperties;
import android.media.videoeditor.Overlay;
import android.util.Pair;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;

public class OverlayFrame
extends Overlay {
    private Bitmap mBitmap;
    private String mFilename;
    private String mBitmapFileName;
    private int mOFWidth;
    private int mOFHeight;
    private int mResizedRGBWidth;
    private int mResizedRGBHeight;
    private static final Paint sResizePaint = new Paint(2);

    private OverlayFrame() {
        this(null, null, (String)null, 0L, 0L);
    }

    public OverlayFrame(MediaItem mediaItem, String overlayId, Bitmap bitmap, long startTimeMs, long durationMs) {
        super(mediaItem, overlayId, startTimeMs, durationMs);
        this.mBitmap = bitmap;
        this.mFilename = null;
        this.mBitmapFileName = null;
        this.mResizedRGBWidth = 0;
        this.mResizedRGBHeight = 0;
    }

    OverlayFrame(MediaItem mediaItem, String overlayId, String filename, long startTimeMs, long durationMs) {
        super(mediaItem, overlayId, startTimeMs, durationMs);
        this.mBitmapFileName = filename;
        this.mBitmap = BitmapFactory.decodeFile(this.mBitmapFileName);
        this.mFilename = null;
        this.mResizedRGBWidth = 0;
        this.mResizedRGBHeight = 0;
    }

    public Bitmap getBitmap() {
        return this.mBitmap;
    }

    String getBitmapImageFileName() {
        return this.mBitmapFileName;
    }

    public void setBitmap(Bitmap bitmap) {
        this.getMediaItem().getNativeContext().setGeneratePreview(true);
        this.invalidate();
        this.mBitmap = bitmap;
        if (this.mFilename != null) {
            new File(this.mFilename).delete();
            this.mFilename = null;
        }
        this.getMediaItem().invalidateTransitions(this.mStartTimeMs, this.mDurationMs);
    }

    String getFilename() {
        return this.mFilename;
    }

    void setFilename(String filename) {
        this.mFilename = filename;
    }

    String save(String path) throws FileNotFoundException, IOException {
        if (this.mFilename != null) {
            return this.mFilename;
        }
        this.mBitmapFileName = path + "/" + "Overlay" + this.getId() + ".png";
        if (!new File(this.mBitmapFileName).exists()) {
            FileOutputStream out = new FileOutputStream(this.mBitmapFileName);
            this.mBitmap.compress(Bitmap.CompressFormat.PNG, 100, out);
            out.flush();
            out.close();
        }
        this.mOFWidth = this.mBitmap.getWidth();
        this.mOFHeight = this.mBitmap.getHeight();
        this.mFilename = path + "/" + "Overlay" + this.getId() + ".rgb";
        MediaArtistNativeHelper nativeHelper = super.getMediaItem().getNativeContext();
        Pair<Integer, Integer>[] resolutions = MediaProperties.getSupportedResolutions(nativeHelper.nativeHelperGetAspectRatio());
        Pair<Integer, Integer> maxResolution = resolutions[resolutions.length - 1];
        this.generateOverlayWithRenderingMode(super.getMediaItem(), this, (Integer)maxResolution.second, (Integer)maxResolution.first);
        return this.mFilename;
    }

    int getOverlayFrameHeight() {
        return this.mOFHeight;
    }

    int getOverlayFrameWidth() {
        return this.mOFWidth;
    }

    void setOverlayFrameHeight(int height) {
        this.mOFHeight = height;
    }

    void setOverlayFrameWidth(int width) {
        this.mOFWidth = width;
    }

    void setResizedRGBSize(int width, int height) {
        this.mResizedRGBWidth = width;
        this.mResizedRGBHeight = height;
    }

    int getResizedRGBSizeHeight() {
        return this.mResizedRGBHeight;
    }

    int getResizedRGBSizeWidth() {
        return this.mResizedRGBWidth;
    }

    void invalidate() {
        if (this.mBitmap != null) {
            this.mBitmap.recycle();
            this.mBitmap = null;
        }
        if (this.mFilename != null) {
            new File(this.mFilename).delete();
            this.mFilename = null;
        }
        if (this.mBitmapFileName != null) {
            new File(this.mBitmapFileName).delete();
            this.mBitmapFileName = null;
        }
    }

    void invalidateGeneratedFiles() {
        if (this.mFilename != null) {
            new File(this.mFilename).delete();
            this.mFilename = null;
        }
        if (this.mBitmapFileName != null) {
            new File(this.mBitmapFileName).delete();
            this.mBitmapFileName = null;
        }
    }

    void generateOverlayWithRenderingMode(MediaItem mediaItemsList, OverlayFrame overlay, int height, int width) throws FileNotFoundException, IOException {
        MediaItem t = mediaItemsList;
        int renderMode = t.getRenderingMode();
        Bitmap overlayBitmap = overlay.getBitmap();
        int resizedRGBFileHeight = overlay.getResizedRGBSizeHeight();
        int resizedRGBFileWidth = overlay.getResizedRGBSizeWidth();
        if (resizedRGBFileWidth == 0) {
            resizedRGBFileWidth = overlayBitmap.getWidth();
        }
        if (resizedRGBFileHeight == 0) {
            resizedRGBFileHeight = overlayBitmap.getHeight();
        }
        if (resizedRGBFileWidth != width || resizedRGBFileHeight != height || !new File(overlay.getFilename()).exists()) {
            Rect srcRect;
            Rect destRect;
            Bitmap destBitmap = Bitmap.createBitmap(width, height, Bitmap.Config.ARGB_8888);
            Canvas overlayCanvas = new Canvas(destBitmap);
            switch (renderMode) {
                case 1: {
                    destRect = new Rect(0, 0, overlayCanvas.getWidth(), overlayCanvas.getHeight());
                    srcRect = new Rect(0, 0, overlayBitmap.getWidth(), overlayBitmap.getHeight());
                    break;
                }
                case 0: {
                    int newWidth;
                    int bottom;
                    int right;
                    int top;
                    int left;
                    int newHeight;
                    float aROverlayImage = (float)overlayBitmap.getWidth() / (float)overlayBitmap.getHeight();
                    float aRCanvas = (float)overlayCanvas.getWidth() / (float)overlayCanvas.getHeight();
                    if (aROverlayImage > aRCanvas) {
                        newHeight = overlayCanvas.getWidth() * overlayBitmap.getHeight() / overlayBitmap.getWidth();
                        left = 0;
                        top = (overlayCanvas.getHeight() - newHeight) / 2;
                        right = overlayCanvas.getWidth();
                        bottom = top + newHeight;
                    } else {
                        newWidth = overlayCanvas.getHeight() * overlayBitmap.getWidth() / overlayBitmap.getHeight();
                        left = (overlayCanvas.getWidth() - newWidth) / 2;
                        top = 0;
                        right = left + newWidth;
                        bottom = overlayCanvas.getHeight();
                    }
                    destRect = new Rect(left, top, right, bottom);
                    srcRect = new Rect(0, 0, overlayBitmap.getWidth(), overlayBitmap.getHeight());
                    break;
                }
                case 2: {
                    int newWidth;
                    int bottom;
                    int right;
                    int top;
                    int left;
                    int newHeight;
                    float aROverlayImage = (float)overlayBitmap.getWidth() / (float)overlayBitmap.getHeight();
                    float aRCanvas = (float)overlayCanvas.getWidth() / (float)overlayCanvas.getHeight();
                    if (aROverlayImage < aRCanvas) {
                        newHeight = overlayBitmap.getWidth() * overlayCanvas.getHeight() / overlayCanvas.getWidth();
                        left = 0;
                        top = (overlayBitmap.getHeight() - newHeight) / 2;
                        right = overlayBitmap.getWidth();
                        bottom = top + newHeight;
                    } else {
                        newWidth = overlayBitmap.getHeight() * overlayCanvas.getWidth() / overlayCanvas.getHeight();
                        left = (overlayBitmap.getWidth() - newWidth) / 2;
                        top = 0;
                        right = left + newWidth;
                        bottom = overlayBitmap.getHeight();
                    }
                    srcRect = new Rect(left, top, right, bottom);
                    destRect = new Rect(0, 0, overlayCanvas.getWidth(), overlayCanvas.getHeight());
                    break;
                }
                default: {
                    throw new IllegalStateException("Rendering mode: " + renderMode);
                }
            }
            overlayCanvas.drawBitmap(overlayBitmap, srcRect, destRect, sResizePaint);
            overlayCanvas.setBitmap(null);
            String outFileName = overlay.getFilename();
            if (outFileName != null) {
                new File(outFileName).delete();
            }
            FileOutputStream fl = new FileOutputStream(outFileName);
            DataOutputStream dos = new DataOutputStream(fl);
            int[] framingBuffer = new int[width];
            ByteBuffer byteBuffer = ByteBuffer.allocate(framingBuffer.length * 4);
            byte[] array2 = byteBuffer.array();
            for (int tmp = 0; tmp < height; ++tmp) {
                destBitmap.getPixels(framingBuffer, 0, width, 0, tmp, width, 1);
                IntBuffer intBuffer = byteBuffer.asIntBuffer();
                intBuffer.put(framingBuffer, 0, width);
                dos.write(array2);
            }
            fl.flush();
            fl.close();
            overlay.setResizedRGBSize(width, height);
        }
    }
}

