/*
 * Decompiled with CFR 0.152.
 */
package android.media.videoeditor;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.media.videoeditor.AudioTrack;
import android.media.videoeditor.MediaItem;
import android.media.videoeditor.Transition;
import android.view.SurfaceHolder;
import java.io.IOException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface VideoEditor {
    public static final String THUMBNAIL_FILENAME = "thumbnail.jpg";
    public static final int DURATION_OF_STORYBOARD = -1;
    public static final long MAX_SUPPORTED_FILE_SIZE = 0x80000000L;

    public String getPath();

    public void release();

    public void save() throws IOException;

    public void export(String var1, int var2, int var3, ExportProgressListener var4) throws IOException;

    public void export(String var1, int var2, int var3, int var4, int var5, ExportProgressListener var6) throws IOException;

    public void cancelExport(String var1);

    public void addMediaItem(MediaItem var1);

    public void insertMediaItem(MediaItem var1, String var2);

    public void moveMediaItem(String var1, String var2);

    public MediaItem removeMediaItem(String var1);

    public void removeAllMediaItems();

    public List<MediaItem> getAllMediaItems();

    public MediaItem getMediaItem(String var1);

    public void addTransition(Transition var1);

    public Transition removeTransition(String var1);

    public List<Transition> getAllTransitions();

    public Transition getTransition(String var1);

    public void addAudioTrack(AudioTrack var1);

    public void insertAudioTrack(AudioTrack var1, String var2);

    public void moveAudioTrack(String var1, String var2);

    public AudioTrack removeAudioTrack(String var1);

    public List<AudioTrack> getAllAudioTracks();

    public AudioTrack getAudioTrack(String var1);

    public void setAspectRatio(int var1);

    public int getAspectRatio();

    public long getDuration();

    public long renderPreviewFrame(SurfaceHolder var1, long var2, OverlayData var4);

    public void generatePreview(MediaProcessingProgressListener var1);

    public void startPreview(SurfaceHolder var1, long var2, long var4, boolean var6, int var7, PreviewProgressListener var8);

    public long stopPreview();

    public void clearSurface(SurfaceHolder var1);

    public static final class OverlayData {
        private Bitmap mOverlayBitmap = null;
        private int mRenderingMode = 2;
        private boolean mClear = false;
        private static final Paint sResizePaint = new Paint(2);

        public void release() {
            if (this.mOverlayBitmap != null) {
                this.mOverlayBitmap.recycle();
                this.mOverlayBitmap = null;
            }
        }

        public boolean needsRendering() {
            return this.mClear || this.mOverlayBitmap != null;
        }

        void set(Bitmap overlayBitmap, int renderingMode) {
            this.mOverlayBitmap = overlayBitmap;
            this.mRenderingMode = renderingMode;
            this.mClear = false;
        }

        void setClear() {
            this.mClear = true;
        }

        public void renderOverlay(Bitmap destBitmap) {
            if (this.mClear) {
                destBitmap.eraseColor(0);
            } else if (this.mOverlayBitmap != null) {
                Rect srcRect;
                Rect destRect;
                Canvas overlayCanvas = new Canvas(destBitmap);
                switch (this.mRenderingMode) {
                    case 0: {
                        destRect = new Rect(0, 0, overlayCanvas.getWidth(), overlayCanvas.getHeight());
                        srcRect = new Rect(0, 0, this.mOverlayBitmap.getWidth(), this.mOverlayBitmap.getHeight());
                        break;
                    }
                    case 2: {
                        int bottom;
                        int right;
                        int top;
                        int left;
                        float aROverlayImage = (float)this.mOverlayBitmap.getWidth() / (float)this.mOverlayBitmap.getHeight();
                        float aRCanvas = (float)overlayCanvas.getWidth() / (float)overlayCanvas.getHeight();
                        if (aROverlayImage > aRCanvas) {
                            int newHeight = overlayCanvas.getWidth() * this.mOverlayBitmap.getHeight() / this.mOverlayBitmap.getWidth();
                            left = 0;
                            top = (overlayCanvas.getHeight() - newHeight) / 2;
                            right = overlayCanvas.getWidth();
                            bottom = top + newHeight;
                        } else {
                            int newWidth = overlayCanvas.getHeight() * this.mOverlayBitmap.getWidth() / this.mOverlayBitmap.getHeight();
                            left = (overlayCanvas.getWidth() - newWidth) / 2;
                            top = 0;
                            right = left + newWidth;
                            bottom = overlayCanvas.getHeight();
                        }
                        destRect = new Rect(left, top, right, bottom);
                        srcRect = new Rect(0, 0, this.mOverlayBitmap.getWidth(), this.mOverlayBitmap.getHeight());
                        break;
                    }
                    case 1: {
                        int bottom;
                        int right;
                        int top;
                        int left;
                        float aROverlayImage = (float)this.mOverlayBitmap.getWidth() / (float)this.mOverlayBitmap.getHeight();
                        float aRCanvas = (float)overlayCanvas.getWidth() / (float)overlayCanvas.getHeight();
                        if (aROverlayImage < aRCanvas) {
                            int newHeight = this.mOverlayBitmap.getWidth() * overlayCanvas.getHeight() / overlayCanvas.getWidth();
                            left = 0;
                            top = (this.mOverlayBitmap.getHeight() - newHeight) / 2;
                            right = this.mOverlayBitmap.getWidth();
                            bottom = top + newHeight;
                        } else {
                            int newWidth = this.mOverlayBitmap.getHeight() * overlayCanvas.getWidth() / overlayCanvas.getHeight();
                            left = (this.mOverlayBitmap.getWidth() - newWidth) / 2;
                            top = 0;
                            right = left + newWidth;
                            bottom = this.mOverlayBitmap.getHeight();
                        }
                        srcRect = new Rect(left, top, right, bottom);
                        destRect = new Rect(0, 0, overlayCanvas.getWidth(), overlayCanvas.getHeight());
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Rendering mode: " + this.mRenderingMode);
                    }
                }
                destBitmap.eraseColor(0);
                overlayCanvas.drawBitmap(this.mOverlayBitmap, srcRect, destRect, sResizePaint);
                this.mOverlayBitmap.recycle();
            }
        }
    }

    public static interface MediaProcessingProgressListener {
        public static final int ACTION_ENCODE = 1;
        public static final int ACTION_DECODE = 2;

        public void onProgress(Object var1, int var2, int var3);
    }

    public static interface ExportProgressListener {
        public void onProgress(VideoEditor var1, String var2, int var3);
    }

    public static interface PreviewProgressListener {
        public void onProgress(VideoEditor var1, long var2, OverlayData var4);

        public void onStart(VideoEditor var1);

        public void onStop(VideoEditor var1);

        public void onError(VideoEditor var1, int var2);
    }
}

