/*
 * Decompiled with CFR 0.152.
 */
package android.net.dhcp;

import android.net.dhcp.DhcpPacket;
import android.net.dhcp.DhcpStateMachine;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.nio.ByteBuffer;

class DhcpOfferPacket
extends DhcpPacket {
    private final InetAddress mSrcIp;

    DhcpOfferPacket(int transId, boolean broadcast, InetAddress serverAddress, InetAddress clientIp, byte[] clientMac) {
        super(transId, Inet4Address.ANY, clientIp, Inet4Address.ANY, Inet4Address.ANY, clientMac, broadcast);
        this.mSrcIp = serverAddress;
    }

    public String toString() {
        String s = super.toString();
        String dnsServers = ", DNS servers: ";
        if (this.mDnsServers != null) {
            for (InetAddress dnsServer : this.mDnsServers) {
                dnsServers = dnsServers + dnsServer + " ";
            }
        }
        return s + " OFFER, ip " + this.mYourIp + ", mask " + this.mSubnetMask + dnsServers + ", gateway " + this.mGateway + " lease time " + this.mLeaseTime + ", domain " + this.mDomainName;
    }

    public ByteBuffer buildPacket(int encap, short destUdp, short srcUdp) {
        ByteBuffer result = ByteBuffer.allocate(1500);
        InetAddress destIp = this.mBroadcast ? Inet4Address.ALL : this.mYourIp;
        InetAddress srcIp = this.mBroadcast ? Inet4Address.ANY : this.mSrcIp;
        this.fillInPacket(encap, destIp, srcIp, destUdp, srcUdp, result, (byte)2, this.mBroadcast);
        result.flip();
        return result;
    }

    void finishPacket(ByteBuffer buffer) {
        this.addTlv(buffer, (byte)53, (byte)2);
        this.addTlv(buffer, (byte)54, this.mServerIdentifier);
        this.addTlv(buffer, (byte)51, this.mLeaseTime);
        if (this.mLeaseTime != null) {
            this.addTlv(buffer, (byte)58, this.mLeaseTime / 2);
        }
        this.addTlv(buffer, (byte)1, this.mSubnetMask);
        this.addTlv(buffer, (byte)3, this.mGateway);
        this.addTlv(buffer, (byte)15, this.mDomainName);
        this.addTlv(buffer, (byte)28, this.mBroadcastAddress);
        this.addTlv(buffer, (byte)6, this.mDnsServers);
        this.addTlvEnd(buffer);
    }

    public void doNextOp(DhcpStateMachine machine) {
        machine.onOfferReceived(this.mBroadcast, this.mTransId, this.mClientMac, this.mYourIp, this.mServerIdentifier);
    }
}

