/*
 * Decompiled with CFR 0.152.
 */
package android.net.http;

import android.content.Context;
import android.net.http.AndroidHttpClientConnection;
import android.net.http.CertificateChainValidator;
import android.net.http.Connection;
import android.net.http.Headers;
import android.net.http.Request;
import android.net.http.RequestFeeder;
import android.net.http.SSLConnectionClosedByUserException;
import android.net.http.SslCertificate;
import android.net.http.SslError;
import android.util.Log;
import com.android.org.conscrypt.FileClientSessionCache;
import com.android.org.conscrypt.OpenSSLContextImpl;
import com.android.org.conscrypt.SSLClientSessionCache;
import java.io.File;
import java.io.IOException;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.cert.X509Certificate;
import java.util.Locale;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.ParseException;
import org.apache.http.ProtocolVersion;
import org.apache.http.message.BasicHttpRequest;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;

public class HttpsConnection
extends Connection {
    private static SSLSocketFactory mSslSocketFactory = null;
    private Object mSuspendLock = new Object();
    private boolean mSuspended = false;
    private boolean mAborted = false;
    private HttpHost mProxyHost;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initializeEngine(File sessionDir) {
        try {
            SSLClientSessionCache cache = null;
            if (sessionDir != null) {
                Log.d("HttpsConnection", "Caching SSL sessions in " + sessionDir + ".");
                cache = FileClientSessionCache.usingDirectory(sessionDir);
            }
            OpenSSLContextImpl sslContext = new OpenSSLContextImpl();
            TrustManager[] trustManagers = new TrustManager[]{new X509TrustManager(){

                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }};
            sslContext.engineInit(null, trustManagers, null);
            sslContext.engineGetClientSessionContext().setPersistentCache(cache);
            Class<HttpsConnection> clazz = HttpsConnection.class;
            synchronized (HttpsConnection.class) {
                mSslSocketFactory = sslContext.engineGetSocketFactory();
                // ** MonitorExit[var4_6] (shouldn't be in output)
            }
        }
        catch (KeyManagementException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        {
            return;
        }
    }

    private static synchronized SSLSocketFactory getSocketFactory() {
        return mSslSocketFactory;
    }

    HttpsConnection(Context context, HttpHost host, HttpHost proxy, RequestFeeder requestFeeder) {
        super(context, host, requestFeeder);
        this.mProxyHost = proxy;
    }

    void setCertificate(SslCertificate certificate) {
        this.mCertificate = certificate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AndroidHttpClientConnection openConnection(Request req) throws IOException {
        Object statusLine;
        BasicHttpParams params;
        Socket sslSock = null;
        if (this.mProxyHost != null) {
            AndroidHttpClientConnection proxyConnection = null;
            Socket proxySock = null;
            try {
                proxySock = new Socket(this.mProxyHost.getHostName(), this.mProxyHost.getPort());
                proxySock.setSoTimeout(60000);
                proxyConnection = new AndroidHttpClientConnection();
                params = new BasicHttpParams();
                HttpConnectionParams.setSocketBufferSize(params, 8192);
                proxyConnection.bind(proxySock, params);
            }
            catch (IOException e) {
                String errorMessage;
                if (proxyConnection != null) {
                    proxyConnection.close();
                }
                if ((errorMessage = e.getMessage()) == null) {
                    errorMessage = "failed to establish a connection to the proxy";
                }
                throw new IOException(errorMessage);
            }
            statusLine = null;
            int statusCode = 0;
            Headers headers = new Headers();
            try {
                BasicHttpRequest proxyReq = new BasicHttpRequest("CONNECT", this.mHost.toHostString());
                for (Header h : req.mHttpRequest.getAllHeaders()) {
                    String headerName = h.getName().toLowerCase(Locale.ROOT);
                    if (!headerName.startsWith("proxy") && !headerName.equals("keep-alive") && !headerName.equals("host")) continue;
                    proxyReq.addHeader(h);
                }
                proxyConnection.sendRequestHeader(proxyReq);
                proxyConnection.flush();
                while ((statusCode = (statusLine = proxyConnection.parseResponseHeader(headers)).getStatusCode()) < 200) {
                }
            }
            catch (ParseException e) {
                String errorMessage = e.getMessage();
                if (errorMessage == null) {
                    errorMessage = "failed to send a CONNECT request";
                }
                throw new IOException(errorMessage);
            }
            catch (HttpException e) {
                String errorMessage = e.getMessage();
                if (errorMessage == null) {
                    errorMessage = "failed to send a CONNECT request";
                }
                throw new IOException(errorMessage);
            }
            catch (IOException e) {
                String errorMessage = e.getMessage();
                if (errorMessage == null) {
                    errorMessage = "failed to send a CONNECT request";
                }
                throw new IOException(errorMessage);
            }
            if (statusCode == 200) {
                try {
                    sslSock = (SSLSocket)HttpsConnection.getSocketFactory().createSocket(proxySock, this.mHost.getHostName(), this.mHost.getPort(), true);
                }
                catch (IOException e) {
                    String errorMessage;
                    if (sslSock != null) {
                        sslSock.close();
                    }
                    if ((errorMessage = e.getMessage()) == null) {
                        errorMessage = "failed to create an SSL socket";
                    }
                    throw new IOException(errorMessage);
                }
            }
            ProtocolVersion version = statusLine.getProtocolVersion();
            req.mEventHandler.status(version.getMajor(), version.getMinor(), statusCode, statusLine.getReasonPhrase());
            req.mEventHandler.headers(headers);
            req.mEventHandler.endData();
            proxyConnection.close();
            return null;
        }
        try {
            sslSock = (SSLSocket)HttpsConnection.getSocketFactory().createSocket(this.mHost.getHostName(), this.mHost.getPort());
            sslSock.setSoTimeout(60000);
        }
        catch (IOException e) {
            String errorMessage;
            if (sslSock != null) {
                sslSock.close();
            }
            if ((errorMessage = e.getMessage()) == null) {
                errorMessage = "failed to create an SSL socket";
            }
            throw new IOException(errorMessage);
        }
        SslError error = CertificateChainValidator.getInstance().doHandshakeAndValidateServerCertificates(this, (SSLSocket)sslSock, this.mHost.getHostName());
        if (error != null) {
            Object errorMessage = this.mSuspendLock;
            synchronized (errorMessage) {
                this.mSuspended = true;
            }
            boolean canHandle = req.getEventHandler().handleSslErrorRequest(error);
            if (!canHandle) {
                throw new IOException("failed to handle " + error);
            }
            statusLine = this.mSuspendLock;
            synchronized (statusLine) {
                if (this.mSuspended) {
                    try {
                        this.mSuspendLock.wait(600000L);
                        if (this.mSuspended) {
                            this.mSuspended = false;
                            this.mAborted = true;
                        }
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
                if (this.mAborted) {
                    sslSock.close();
                    throw new SSLConnectionClosedByUserException("connection closed by the user");
                }
            }
        }
        AndroidHttpClientConnection conn = new AndroidHttpClientConnection();
        params = new BasicHttpParams();
        params.setIntParameter("http.socket.buffer-size", 8192);
        conn.bind(sslSock, params);
        return conn;
    }

    void closeConnection() {
        if (this.mSuspended) {
            this.restartConnection(false);
        }
        try {
            if (this.mHttpClientConnection != null && this.mHttpClientConnection.isOpen()) {
                this.mHttpClientConnection.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void restartConnection(boolean proceed) {
        Object object = this.mSuspendLock;
        synchronized (object) {
            if (this.mSuspended) {
                this.mSuspended = false;
                this.mAborted = !proceed;
                this.mSuspendLock.notify();
            }
        }
    }

    String getScheme() {
        return "https";
    }

    static {
        HttpsConnection.initializeEngine(null);
    }
}

