/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.database.ContentObserver;
import android.net.ConnectivityManager;
import android.net.LinkProperties;
import android.net.NetworkInfo;
import android.net.wifi.RssiPacketCountInfo;
import android.net.wifi.SupplicantState;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Message;
import android.os.SystemClock;
import android.provider.Settings;
import android.util.LruCache;
import com.android.internal.util.AsyncChannel;
import com.android.internal.util.State;
import com.android.internal.util.StateMachine;
import java.io.FileDescriptor;
import java.io.PrintWriter;

public class WifiWatchdogStateMachine
extends StateMachine {
    private static final boolean DBG = false;
    private static final int BASE = 135168;
    private static final int EVENT_WATCHDOG_TOGGLED = 135169;
    private static final int EVENT_NETWORK_STATE_CHANGE = 135170;
    private static final int EVENT_RSSI_CHANGE = 135171;
    private static final int EVENT_SUPPLICANT_STATE_CHANGE = 135172;
    private static final int EVENT_WIFI_RADIO_STATE_CHANGE = 135173;
    private static final int EVENT_WATCHDOG_SETTINGS_CHANGE = 135174;
    private static final int EVENT_BSSID_CHANGE = 135175;
    private static final int EVENT_SCREEN_ON = 135176;
    private static final int EVENT_SCREEN_OFF = 135177;
    private static final int CMD_RSSI_FETCH = 135179;
    static final int POOR_LINK_DETECTED = 135189;
    static final int GOOD_LINK_DETECTED = 135190;
    public static final boolean DEFAULT_POOR_NETWORK_AVOIDANCE_ENABLED = false;
    private static final int LINK_MONITOR_LEVEL_THRESHOLD = 4;
    private static final int BSSID_STAT_CACHE_SIZE = 20;
    private static final int BSSID_STAT_RANGE_LOW_DBM = -105;
    private static final int BSSID_STAT_RANGE_HIGH_DBM = -45;
    private static final int BSSID_STAT_EMPTY_COUNT = 3;
    private static final long LINK_SAMPLING_INTERVAL_MS = 1000L;
    private static final double EXP_COEFFICIENT_RECORD = 0.1;
    private static final double EXP_COEFFICIENT_MONITOR = 0.5;
    private static final double POOR_LINK_LOSS_THRESHOLD = 0.5;
    private static final double GOOD_LINK_LOSS_THRESHOLD = 0.1;
    private static final int POOR_LINK_SAMPLE_COUNT = 3;
    private static final double POOR_LINK_MIN_VOLUME = 2.0;
    private static final int GOOD_LINK_RSSI_RANGE_MIN = 3;
    private static final int GOOD_LINK_RSSI_RANGE_MAX = 20;
    private static final GoodLinkTarget[] GOOD_LINK_TARGET = new GoodLinkTarget[]{new GoodLinkTarget(0, 3, 1800000), new GoodLinkTarget(3, 5, 300000), new GoodLinkTarget(6, 10, 60000), new GoodLinkTarget(9, 30, 0)};
    private static final MaxAvoidTime[] MAX_AVOID_TIME = new MaxAvoidTime[]{new MaxAvoidTime(1800000, -200), new MaxAvoidTime(300000, -70), new MaxAvoidTime(0, -55)};
    private Context mContext;
    private ContentResolver mContentResolver;
    private WifiManager mWifiManager;
    private IntentFilter mIntentFilter;
    private BroadcastReceiver mBroadcastReceiver;
    private AsyncChannel mWsmChannel = new AsyncChannel();
    private WifiInfo mWifiInfo;
    private LinkProperties mLinkProperties;
    private static boolean sWifiOnly = false;
    private boolean mPoorNetworkDetectionEnabled;
    private LruCache<String, BssidStatistics> mBssidCache = new LruCache(20);
    private int mRssiFetchToken = 0;
    private int mCurrentSignalLevel;
    private BssidStatistics mCurrentBssid;
    private VolumeWeightedEMA mCurrentLoss;
    private boolean mIsScreenOn = true;
    private static double[] sPresetLoss;
    private DefaultState mDefaultState = new DefaultState();
    private WatchdogDisabledState mWatchdogDisabledState = new WatchdogDisabledState();
    private WatchdogEnabledState mWatchdogEnabledState = new WatchdogEnabledState();
    private NotConnectedState mNotConnectedState = new NotConnectedState();
    private VerifyingLinkState mVerifyingLinkState = new VerifyingLinkState();
    private ConnectedState mConnectedState = new ConnectedState();
    private OnlineWatchState mOnlineWatchState = new OnlineWatchState();
    private LinkMonitoringState mLinkMonitoringState = new LinkMonitoringState();
    private OnlineState mOnlineState = new OnlineState();

    private WifiWatchdogStateMachine(Context context) {
        super("WifiWatchdogStateMachine");
        this.mContext = context;
        this.mContentResolver = context.getContentResolver();
        this.mWifiManager = (WifiManager)context.getSystemService("wifi");
        this.mWsmChannel.connectSync(this.mContext, this.getHandler(), this.mWifiManager.getWifiStateMachineMessenger());
        this.setupNetworkReceiver();
        this.registerForSettingsChanges();
        this.registerForWatchdogToggle();
        this.addState(this.mDefaultState);
        this.addState(this.mWatchdogDisabledState, this.mDefaultState);
        this.addState(this.mWatchdogEnabledState, this.mDefaultState);
        this.addState(this.mNotConnectedState, this.mWatchdogEnabledState);
        this.addState(this.mVerifyingLinkState, this.mWatchdogEnabledState);
        this.addState(this.mConnectedState, this.mWatchdogEnabledState);
        this.addState(this.mOnlineWatchState, this.mConnectedState);
        this.addState(this.mLinkMonitoringState, this.mConnectedState);
        this.addState(this.mOnlineState, this.mConnectedState);
        if (this.isWatchdogEnabled()) {
            this.setInitialState(this.mNotConnectedState);
        } else {
            this.setInitialState(this.mWatchdogDisabledState);
        }
        this.setLogRecSize(25);
        this.setLogOnlyTransitions(true);
        this.updateSettings();
    }

    public static WifiWatchdogStateMachine makeWifiWatchdogStateMachine(Context context) {
        ContentResolver contentResolver = context.getContentResolver();
        ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
        sWifiOnly = !cm.isNetworkSupported(0);
        WifiWatchdogStateMachine.putSettingsGlobalBoolean(contentResolver, "wifi_watchdog_on", true);
        WifiWatchdogStateMachine wwsm = new WifiWatchdogStateMachine(context);
        wwsm.start();
        return wwsm;
    }

    private void setupNetworkReceiver() {
        this.mBroadcastReceiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                String action = intent.getAction();
                if (action.equals("android.net.wifi.RSSI_CHANGED")) {
                    WifiWatchdogStateMachine.this.obtainMessage(135171, intent.getIntExtra("newRssi", -200), 0).sendToTarget();
                } else if (action.equals("android.net.wifi.supplicant.STATE_CHANGE")) {
                    WifiWatchdogStateMachine.this.sendMessage(135172, intent);
                } else if (action.equals("android.net.wifi.STATE_CHANGE")) {
                    WifiWatchdogStateMachine.this.sendMessage(135170, intent);
                } else if (action.equals("android.intent.action.SCREEN_ON")) {
                    WifiWatchdogStateMachine.this.sendMessage(135176);
                } else if (action.equals("android.intent.action.SCREEN_OFF")) {
                    WifiWatchdogStateMachine.this.sendMessage(135177);
                } else if (action.equals("android.net.wifi.WIFI_STATE_CHANGED")) {
                    WifiWatchdogStateMachine.this.sendMessage(135173, intent.getIntExtra("wifi_state", 4));
                }
            }
        };
        this.mIntentFilter = new IntentFilter();
        this.mIntentFilter.addAction("android.net.wifi.STATE_CHANGE");
        this.mIntentFilter.addAction("android.net.wifi.WIFI_STATE_CHANGED");
        this.mIntentFilter.addAction("android.net.wifi.RSSI_CHANGED");
        this.mIntentFilter.addAction("android.net.wifi.supplicant.STATE_CHANGE");
        this.mIntentFilter.addAction("android.intent.action.SCREEN_ON");
        this.mIntentFilter.addAction("android.intent.action.SCREEN_OFF");
        this.mContext.registerReceiver(this.mBroadcastReceiver, this.mIntentFilter);
    }

    private void registerForWatchdogToggle() {
        ContentObserver contentObserver = new ContentObserver(this.getHandler()){

            public void onChange(boolean selfChange) {
                WifiWatchdogStateMachine.this.sendMessage(135169);
            }
        };
        this.mContext.getContentResolver().registerContentObserver(Settings.Global.getUriFor("wifi_watchdog_on"), false, contentObserver);
    }

    private void registerForSettingsChanges() {
        ContentObserver contentObserver = new ContentObserver(this.getHandler()){

            public void onChange(boolean selfChange) {
                WifiWatchdogStateMachine.this.sendMessage(135174);
            }
        };
        this.mContext.getContentResolver().registerContentObserver(Settings.Global.getUriFor("wifi_watchdog_poor_network_test_enabled"), false, contentObserver);
    }

    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        super.dump(fd, pw, args);
        pw.println("mWifiInfo: [" + this.mWifiInfo + "]");
        pw.println("mLinkProperties: [" + this.mLinkProperties + "]");
        pw.println("mCurrentSignalLevel: [" + this.mCurrentSignalLevel + "]");
        pw.println("mPoorNetworkDetectionEnabled: [" + this.mPoorNetworkDetectionEnabled + "]");
    }

    private boolean isWatchdogEnabled() {
        boolean ret = WifiWatchdogStateMachine.getSettingsGlobalBoolean(this.mContentResolver, "wifi_watchdog_on", true);
        return ret;
    }

    private void updateSettings() {
        if (sWifiOnly) {
            this.logd("Disabling poor network avoidance for wi-fi only device");
            this.mPoorNetworkDetectionEnabled = false;
        } else {
            this.mPoorNetworkDetectionEnabled = WifiWatchdogStateMachine.getSettingsGlobalBoolean(this.mContentResolver, "wifi_watchdog_poor_network_test_enabled", false);
        }
    }

    private void updateCurrentBssid(String bssid) {
        if (bssid == null) {
            if (this.mCurrentBssid == null) {
                return;
            }
            this.mCurrentBssid = null;
            this.sendMessage(135175);
            return;
        }
        if (this.mCurrentBssid != null && bssid.equals(this.mCurrentBssid.mBssid)) {
            return;
        }
        this.mCurrentBssid = this.mBssidCache.get(bssid);
        if (this.mCurrentBssid == null) {
            this.mCurrentBssid = new BssidStatistics(bssid);
            this.mBssidCache.put(bssid, this.mCurrentBssid);
        }
        this.sendMessage(135175);
    }

    private int calculateSignalLevel(int rssi) {
        int signalLevel = WifiManager.calculateSignalLevel(rssi, 5);
        return signalLevel;
    }

    private void sendLinkStatusNotification(boolean isGood) {
        if (isGood) {
            this.mWsmChannel.sendMessage(135190);
            if (this.mCurrentBssid != null) {
                this.mCurrentBssid.mLastTimeGood = SystemClock.elapsedRealtime();
            }
        } else {
            this.mWsmChannel.sendMessage(135189);
            if (this.mCurrentBssid != null) {
                this.mCurrentBssid.mLastTimePoor = SystemClock.elapsedRealtime();
            }
            this.logd("Poor link notification is sent");
        }
    }

    private static boolean getSettingsGlobalBoolean(ContentResolver cr, String name, boolean def) {
        return Settings.Global.getInt(cr, name, def ? 1 : 0) == 1;
    }

    private static boolean putSettingsGlobalBoolean(ContentResolver cr, String name, boolean value) {
        return Settings.Global.putInt(cr, name, value ? 1 : 0);
    }

    static /* synthetic */ double[] access$4802(double[] x0) {
        sPresetLoss = x0;
        return x0;
    }

    private class BssidStatistics {
        private final String mBssid;
        private VolumeWeightedEMA[] mEntries;
        private int mRssiBase;
        private int mEntriesSize;
        private int mGoodLinkTargetRssi;
        private int mGoodLinkTargetCount;
        private int mGoodLinkTargetIndex;
        private long mLastTimeSample;
        private long mLastTimeGood;
        private long mLastTimePoor;
        private long mBssidAvoidTimeMax;

        public BssidStatistics(String bssid) {
            this.mBssid = bssid;
            this.mRssiBase = -105;
            this.mEntriesSize = 61;
            this.mEntries = new VolumeWeightedEMA[this.mEntriesSize];
            for (int i = 0; i < this.mEntriesSize; ++i) {
                this.mEntries[i] = new VolumeWeightedEMA(0.1);
            }
        }

        public void updateLoss(int rssi, double value, int volume) {
            if (volume <= 0) {
                return;
            }
            int index = rssi - this.mRssiBase;
            if (index < 0 || index >= this.mEntriesSize) {
                return;
            }
            this.mEntries[index].update(value, volume);
        }

        public double presetLoss(int rssi) {
            if (rssi <= -90) {
                return 1.0;
            }
            if (rssi > 0) {
                return 0.0;
            }
            if (sPresetLoss == null) {
                int size = 90;
                WifiWatchdogStateMachine.access$4802(new double[90]);
                for (int i = 0; i < 90; ++i) {
                    sPresetLoss[i] = 1.0 / Math.pow(90 - i, 1.5);
                }
            }
            return sPresetLoss[-rssi];
        }

        public boolean poorLinkDetected(int rssi) {
            int p;
            long now = SystemClock.elapsedRealtime();
            long lastGood = now - this.mLastTimeGood;
            long lastPoor = now - this.mLastTimePoor;
            while (this.mGoodLinkTargetIndex > 0 && lastPoor >= (long)GOOD_LINK_TARGET[this.mGoodLinkTargetIndex - 1].REDUCE_TIME_MS) {
                --this.mGoodLinkTargetIndex;
            }
            this.mGoodLinkTargetCount = GOOD_LINK_TARGET[this.mGoodLinkTargetIndex].SAMPLE_COUNT;
            int from = rssi + 3;
            int to = rssi + 20;
            this.mGoodLinkTargetRssi = this.findRssiTarget(from, to, 0.1);
            this.mGoodLinkTargetRssi += GOOD_LINK_TARGET[this.mGoodLinkTargetIndex].RSSI_ADJ_DBM;
            if (this.mGoodLinkTargetIndex < GOOD_LINK_TARGET.length - 1) {
                ++this.mGoodLinkTargetIndex;
            }
            int pmax = MAX_AVOID_TIME.length - 1;
            for (p = 0; p < pmax && rssi >= MAX_AVOID_TIME[p + 1].MIN_RSSI_DBM; ++p) {
            }
            long avoidMax = MAX_AVOID_TIME[p].TIME_MS;
            if (avoidMax <= 0L) {
                return false;
            }
            this.mBssidAvoidTimeMax = now + avoidMax;
            return true;
        }

        public void newLinkDetected() {
            if (this.mBssidAvoidTimeMax > 0L) {
                return;
            }
            int from = -105;
            int to = -45;
            this.mGoodLinkTargetRssi = this.findRssiTarget(from, to, 0.1);
            this.mGoodLinkTargetCount = 1;
            this.mBssidAvoidTimeMax = SystemClock.elapsedRealtime() + (long)MAX_AVOID_TIME[0].TIME_MS;
        }

        public int findRssiTarget(int from, int to, double threshold) {
            int emptyCount = 0;
            int d = (from -= this.mRssiBase) < (to -= this.mRssiBase) ? 1 : -1;
            for (int i = from; i != to; i += d) {
                double lossPreset;
                int rssi;
                if (i >= 0 && i < this.mEntriesSize && this.mEntries[i].mVolume > 1.0) {
                    emptyCount = 0;
                    if (!(this.mEntries[i].mValue < threshold)) continue;
                    rssi = this.mRssiBase + i;
                    return rssi;
                }
                if (++emptyCount < 3 || !((lossPreset = this.presetLoss(rssi = this.mRssiBase + i)) < threshold)) continue;
                return rssi;
            }
            return this.mRssiBase + to;
        }
    }

    private class VolumeWeightedEMA {
        private double mValue = 0.0;
        private double mVolume = 0.0;
        private double mProduct = 0.0;
        private final double mAlpha;

        public VolumeWeightedEMA(double coefficient) {
            this.mAlpha = coefficient;
        }

        public void update(double newValue, int newVolume) {
            if (newVolume <= 0) {
                return;
            }
            double newProduct = newValue * (double)newVolume;
            this.mProduct = this.mAlpha * newProduct + (1.0 - this.mAlpha) * this.mProduct;
            this.mVolume = this.mAlpha * (double)newVolume + (1.0 - this.mAlpha) * this.mVolume;
            this.mValue = this.mProduct / this.mVolume;
        }
    }

    private static class MaxAvoidTime {
        public final int TIME_MS;
        public final int MIN_RSSI_DBM;

        public MaxAvoidTime(int time, int rssi) {
            this.TIME_MS = time;
            this.MIN_RSSI_DBM = rssi;
        }
    }

    private static class GoodLinkTarget {
        public final int RSSI_ADJ_DBM;
        public final int SAMPLE_COUNT;
        public final int REDUCE_TIME_MS;

        public GoodLinkTarget(int adj, int count, int time) {
            this.RSSI_ADJ_DBM = adj;
            this.SAMPLE_COUNT = count;
            this.REDUCE_TIME_MS = time;
        }
    }

    class OnlineState
    extends State {
        OnlineState() {
        }

        public void enter() {
        }

        public boolean processMessage(Message msg) {
            switch (msg.what) {
                case 135176: {
                    WifiWatchdogStateMachine.this.mIsScreenOn = true;
                    if (!WifiWatchdogStateMachine.this.mPoorNetworkDetectionEnabled) break;
                    WifiWatchdogStateMachine.this.transitionTo(WifiWatchdogStateMachine.this.mOnlineWatchState);
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        }
    }

    class LinkMonitoringState
    extends State {
        private int mSampleCount;
        private int mLastRssi;
        private int mLastTxGood;
        private int mLastTxBad;

        LinkMonitoringState() {
        }

        public void enter() {
            this.mSampleCount = 0;
            WifiWatchdogStateMachine.this.mCurrentLoss = new VolumeWeightedEMA(0.5);
            WifiWatchdogStateMachine.this.sendMessage(WifiWatchdogStateMachine.this.obtainMessage(135179, ++WifiWatchdogStateMachine.this.mRssiFetchToken, 0));
        }

        public boolean processMessage(Message msg) {
            switch (msg.what) {
                case 135171: {
                    WifiWatchdogStateMachine.this.mCurrentSignalLevel = WifiWatchdogStateMachine.this.calculateSignalLevel(msg.arg1);
                    if (WifiWatchdogStateMachine.this.mCurrentSignalLevel <= 4) break;
                    WifiWatchdogStateMachine.this.transitionTo(WifiWatchdogStateMachine.this.mOnlineWatchState);
                    break;
                }
                case 135175: {
                    WifiWatchdogStateMachine.this.transitionTo(WifiWatchdogStateMachine.this.mLinkMonitoringState);
                    break;
                }
                case 135179: {
                    if (!WifiWatchdogStateMachine.this.mIsScreenOn) {
                        WifiWatchdogStateMachine.this.transitionTo(WifiWatchdogStateMachine.this.mOnlineState);
                        break;
                    }
                    if (msg.arg1 != WifiWatchdogStateMachine.this.mRssiFetchToken) break;
                    WifiWatchdogStateMachine.this.mWsmChannel.sendMessage(151572);
                    WifiWatchdogStateMachine.this.sendMessageDelayed(WifiWatchdogStateMachine.this.obtainMessage(135179, ++WifiWatchdogStateMachine.this.mRssiFetchToken, 0), 1000L);
                    break;
                }
                case 151573: {
                    int dgood;
                    int dbad;
                    int dtotal;
                    RssiPacketCountInfo info = (RssiPacketCountInfo)msg.obj;
                    int rssi = info.rssi;
                    int mrssi = (this.mLastRssi + rssi) / 2;
                    int txbad = info.txbad;
                    int txgood = info.txgood;
                    long now = SystemClock.elapsedRealtime();
                    if (now - WifiWatchdogStateMachine.this.mCurrentBssid.mLastTimeSample < 2000L && (dtotal = (dbad = txbad - this.mLastTxBad) + (dgood = txgood - this.mLastTxGood)) > 0) {
                        double loss = (double)dbad / (double)dtotal;
                        WifiWatchdogStateMachine.this.mCurrentLoss.update(loss, dtotal);
                        WifiWatchdogStateMachine.this.mCurrentBssid.updateLoss(mrssi, loss, dtotal);
                        if (WifiWatchdogStateMachine.this.mCurrentLoss.mValue > 0.5 && WifiWatchdogStateMachine.this.mCurrentLoss.mVolume > 2.0) {
                            if (++this.mSampleCount >= 3 && WifiWatchdogStateMachine.this.mCurrentBssid.poorLinkDetected(rssi)) {
                                WifiWatchdogStateMachine.this.sendLinkStatusNotification(false);
                                ++WifiWatchdogStateMachine.this.mRssiFetchToken;
                            }
                        } else {
                            this.mSampleCount = 0;
                        }
                    }
                    WifiWatchdogStateMachine.this.mCurrentBssid.mLastTimeSample = now;
                    this.mLastTxBad = txbad;
                    this.mLastTxGood = txgood;
                    this.mLastRssi = rssi;
                    break;
                }
                case 151574: {
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        }
    }

    class OnlineWatchState
    extends State {
        OnlineWatchState() {
        }

        public void enter() {
            if (WifiWatchdogStateMachine.this.mPoorNetworkDetectionEnabled) {
                this.handleRssiChange();
            } else {
                WifiWatchdogStateMachine.this.transitionTo(WifiWatchdogStateMachine.this.mOnlineState);
            }
        }

        private void handleRssiChange() {
            if (WifiWatchdogStateMachine.this.mCurrentSignalLevel <= 4 && WifiWatchdogStateMachine.this.mCurrentBssid != null) {
                WifiWatchdogStateMachine.this.transitionTo(WifiWatchdogStateMachine.this.mLinkMonitoringState);
            }
        }

        public boolean processMessage(Message msg) {
            switch (msg.what) {
                case 135171: {
                    WifiWatchdogStateMachine.this.mCurrentSignalLevel = WifiWatchdogStateMachine.this.calculateSignalLevel(msg.arg1);
                    this.handleRssiChange();
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        }
    }

    class ConnectedState
    extends State {
        ConnectedState() {
        }

        public void enter() {
        }

        public boolean processMessage(Message msg) {
            switch (msg.what) {
                case 135174: {
                    WifiWatchdogStateMachine.this.updateSettings();
                    if (WifiWatchdogStateMachine.this.mPoorNetworkDetectionEnabled) {
                        WifiWatchdogStateMachine.this.transitionTo(WifiWatchdogStateMachine.this.mOnlineWatchState);
                    } else {
                        WifiWatchdogStateMachine.this.transitionTo(WifiWatchdogStateMachine.this.mOnlineState);
                    }
                    return true;
                }
            }
            return false;
        }
    }

    class VerifyingLinkState
    extends State {
        private int mSampleCount;

        VerifyingLinkState() {
        }

        public void enter() {
            this.mSampleCount = 0;
            WifiWatchdogStateMachine.this.mCurrentBssid.newLinkDetected();
            WifiWatchdogStateMachine.this.sendMessage(WifiWatchdogStateMachine.this.obtainMessage(135179, ++WifiWatchdogStateMachine.this.mRssiFetchToken, 0));
        }

        public boolean processMessage(Message msg) {
            switch (msg.what) {
                case 135174: {
                    WifiWatchdogStateMachine.this.updateSettings();
                    if (WifiWatchdogStateMachine.this.mPoorNetworkDetectionEnabled) break;
                    WifiWatchdogStateMachine.this.sendLinkStatusNotification(true);
                    break;
                }
                case 135175: {
                    WifiWatchdogStateMachine.this.transitionTo(WifiWatchdogStateMachine.this.mVerifyingLinkState);
                    break;
                }
                case 135179: {
                    if (msg.arg1 != WifiWatchdogStateMachine.this.mRssiFetchToken) break;
                    WifiWatchdogStateMachine.this.mWsmChannel.sendMessage(151572);
                    WifiWatchdogStateMachine.this.sendMessageDelayed(WifiWatchdogStateMachine.this.obtainMessage(135179, ++WifiWatchdogStateMachine.this.mRssiFetchToken, 0), 1000L);
                    break;
                }
                case 151573: {
                    RssiPacketCountInfo info = (RssiPacketCountInfo)msg.obj;
                    int rssi = info.rssi;
                    long time = WifiWatchdogStateMachine.this.mCurrentBssid.mBssidAvoidTimeMax - SystemClock.elapsedRealtime();
                    if (time <= 0L) {
                        WifiWatchdogStateMachine.this.sendLinkStatusNotification(true);
                        break;
                    }
                    if (rssi >= WifiWatchdogStateMachine.this.mCurrentBssid.mGoodLinkTargetRssi) {
                        if (++this.mSampleCount < WifiWatchdogStateMachine.this.mCurrentBssid.mGoodLinkTargetCount) break;
                        WifiWatchdogStateMachine.this.mCurrentBssid.mBssidAvoidTimeMax = 0L;
                        WifiWatchdogStateMachine.this.sendLinkStatusNotification(true);
                        break;
                    }
                    this.mSampleCount = 0;
                    break;
                }
                case 151574: {
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        }
    }

    class NotConnectedState
    extends State {
        NotConnectedState() {
        }

        public void enter() {
        }
    }

    class WatchdogEnabledState
    extends State {
        WatchdogEnabledState() {
        }

        public void enter() {
        }

        public boolean processMessage(Message msg) {
            block0 : switch (msg.what) {
                case 135169: {
                    if (WifiWatchdogStateMachine.this.isWatchdogEnabled()) break;
                    WifiWatchdogStateMachine.this.transitionTo(WifiWatchdogStateMachine.this.mWatchdogDisabledState);
                    break;
                }
                case 135170: {
                    Intent intent = (Intent)msg.obj;
                    NetworkInfo networkInfo = (NetworkInfo)intent.getParcelableExtra("networkInfo");
                    WifiWatchdogStateMachine.this.mWifiInfo = (WifiInfo)intent.getParcelableExtra("wifiInfo");
                    WifiWatchdogStateMachine.this.updateCurrentBssid(WifiWatchdogStateMachine.this.mWifiInfo != null ? WifiWatchdogStateMachine.this.mWifiInfo.getBSSID() : null);
                    switch (networkInfo.getDetailedState()) {
                        case VERIFYING_POOR_LINK: {
                            WifiWatchdogStateMachine.this.mLinkProperties = (LinkProperties)intent.getParcelableExtra("linkProperties");
                            if (WifiWatchdogStateMachine.this.mPoorNetworkDetectionEnabled) {
                                if (WifiWatchdogStateMachine.this.mWifiInfo == null || WifiWatchdogStateMachine.this.mCurrentBssid == null) {
                                    WifiWatchdogStateMachine.this.loge("Ignore, wifiinfo " + WifiWatchdogStateMachine.this.mWifiInfo + " bssid " + WifiWatchdogStateMachine.this.mCurrentBssid);
                                    WifiWatchdogStateMachine.this.sendLinkStatusNotification(true);
                                    break block0;
                                }
                                WifiWatchdogStateMachine.this.transitionTo(WifiWatchdogStateMachine.this.mVerifyingLinkState);
                                break block0;
                            }
                            WifiWatchdogStateMachine.this.sendLinkStatusNotification(true);
                            break block0;
                        }
                        case CONNECTED: {
                            WifiWatchdogStateMachine.this.transitionTo(WifiWatchdogStateMachine.this.mOnlineWatchState);
                            break block0;
                        }
                    }
                    WifiWatchdogStateMachine.this.transitionTo(WifiWatchdogStateMachine.this.mNotConnectedState);
                    break;
                }
                case 135172: {
                    Intent intent = (Intent)msg.obj;
                    SupplicantState supplicantState = (SupplicantState)intent.getParcelableExtra("newState");
                    if (supplicantState != SupplicantState.COMPLETED) break;
                    WifiWatchdogStateMachine.this.mWifiInfo = WifiWatchdogStateMachine.this.mWifiManager.getConnectionInfo();
                    WifiWatchdogStateMachine.this.updateCurrentBssid(WifiWatchdogStateMachine.this.mWifiInfo.getBSSID());
                    break;
                }
                case 135173: {
                    if (msg.arg1 != 0) break;
                    WifiWatchdogStateMachine.this.transitionTo(WifiWatchdogStateMachine.this.mNotConnectedState);
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        }
    }

    class WatchdogDisabledState
    extends State {
        WatchdogDisabledState() {
        }

        public void enter() {
        }

        public boolean processMessage(Message msg) {
            block0 : switch (msg.what) {
                case 135169: {
                    if (WifiWatchdogStateMachine.this.isWatchdogEnabled()) {
                        WifiWatchdogStateMachine.this.transitionTo(WifiWatchdogStateMachine.this.mNotConnectedState);
                    }
                    return true;
                }
                case 135170: {
                    Intent intent = (Intent)msg.obj;
                    NetworkInfo networkInfo = (NetworkInfo)intent.getParcelableExtra("networkInfo");
                    switch (networkInfo.getDetailedState()) {
                        case VERIFYING_POOR_LINK: {
                            WifiWatchdogStateMachine.this.sendLinkStatusNotification(true);
                            break block0;
                        }
                    }
                }
            }
            return false;
        }
    }

    class DefaultState
    extends State {
        DefaultState() {
        }

        public void enter() {
        }

        public boolean processMessage(Message msg) {
            switch (msg.what) {
                case 135174: {
                    WifiWatchdogStateMachine.this.updateSettings();
                    break;
                }
                case 135171: {
                    WifiWatchdogStateMachine.this.mCurrentSignalLevel = WifiWatchdogStateMachine.this.calculateSignalLevel(msg.arg1);
                    break;
                }
                case 135170: 
                case 135172: 
                case 135173: 
                case 135175: 
                case 135179: 
                case 151573: 
                case 151574: {
                    break;
                }
                case 135176: {
                    WifiWatchdogStateMachine.this.mIsScreenOn = true;
                    break;
                }
                case 135177: {
                    WifiWatchdogStateMachine.this.mIsScreenOn = false;
                    break;
                }
                default: {
                    WifiWatchdogStateMachine.this.loge("Unhandled message " + msg + " in state " + WifiWatchdogStateMachine.this.getCurrentState().getName());
                }
            }
            return true;
        }
    }
}

