/*
 * Decompiled with CFR 0.152.
 */
package android.provider;

import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.net.Uri;
import android.provider.BaseColumns;
import android.text.TextUtils;
import android.util.Log;
import java.util.concurrent.Semaphore;

public class SearchRecentSuggestions {
    private static final String LOG_TAG = "SearchSuggestions";
    public static final String[] QUERIES_PROJECTION_1LINE = new String[]{"_id", "date", "query", "display1"};
    public static final String[] QUERIES_PROJECTION_2LINE = new String[]{"_id", "date", "query", "display1", "display2"};
    public static final int QUERIES_PROJECTION_DATE_INDEX = 1;
    public static final int QUERIES_PROJECTION_QUERY_INDEX = 2;
    public static final int QUERIES_PROJECTION_DISPLAY1_INDEX = 3;
    public static final int QUERIES_PROJECTION_DISPLAY2_INDEX = 4;
    private static final int MAX_HISTORY_COUNT = 250;
    private final Context mContext;
    private final String mAuthority;
    private final boolean mTwoLineDisplay;
    private final Uri mSuggestionsUri;
    private static final Semaphore sWritesInProgress = new Semaphore(0);

    public SearchRecentSuggestions(Context context, String authority, int mode) {
        if (TextUtils.isEmpty(authority) || (mode & 1) == 0) {
            throw new IllegalArgumentException();
        }
        this.mTwoLineDisplay = 0 != (mode & 2);
        this.mContext = context;
        this.mAuthority = new String(authority);
        this.mSuggestionsUri = Uri.parse("content://" + this.mAuthority + "/suggestions");
    }

    public void saveRecentQuery(final String queryString, final String line2) {
        if (TextUtils.isEmpty(queryString)) {
            return;
        }
        if (!this.mTwoLineDisplay && !TextUtils.isEmpty(line2)) {
            throw new IllegalArgumentException();
        }
        new Thread("saveRecentQuery"){

            public void run() {
                SearchRecentSuggestions.this.saveRecentQueryBlocking(queryString, line2);
                sWritesInProgress.release();
            }
        }.start();
    }

    void waitForSave() {
        do {
            sWritesInProgress.acquireUninterruptibly();
        } while (sWritesInProgress.availablePermits() > 0);
    }

    private void saveRecentQueryBlocking(String queryString, String line2) {
        ContentResolver cr = this.mContext.getContentResolver();
        long now = System.currentTimeMillis();
        try {
            ContentValues values = new ContentValues();
            values.put("display1", queryString);
            if (this.mTwoLineDisplay) {
                values.put("display2", line2);
            }
            values.put("query", queryString);
            values.put("date", now);
            cr.insert(this.mSuggestionsUri, values);
        }
        catch (RuntimeException e) {
            Log.e(LOG_TAG, "saveRecentQuery", e);
        }
        this.truncateHistory(cr, 250);
    }

    public void clearHistory() {
        ContentResolver cr = this.mContext.getContentResolver();
        this.truncateHistory(cr, 0);
    }

    protected void truncateHistory(ContentResolver cr, int maxEntries) {
        if (maxEntries < 0) {
            throw new IllegalArgumentException();
        }
        try {
            String selection = null;
            if (maxEntries > 0) {
                selection = "_id IN (SELECT _id FROM suggestions ORDER BY date DESC LIMIT -1 OFFSET " + String.valueOf(maxEntries) + ")";
            }
            cr.delete(this.mSuggestionsUri, selection, null);
        }
        catch (RuntimeException e) {
            Log.e(LOG_TAG, "truncateHistory", e);
        }
    }

    private static class SuggestionColumns
    implements BaseColumns {
        public static final String DISPLAY1 = "display1";
        public static final String DISPLAY2 = "display2";
        public static final String QUERY = "query";
        public static final String DATE = "date";

        private SuggestionColumns() {
        }
    }
}

