/*
 * Decompiled with CFR 0.152.
 */
package android.sax;

import android.sax.BadXmlException;
import android.sax.Children;
import android.sax.Element;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class RootElement
extends Element {
    final Handler handler = new Handler();

    public RootElement(String uri, String localName) {
        super(null, uri, localName, 0);
    }

    public RootElement(String localName) {
        this("", localName);
    }

    public ContentHandler getContentHandler() {
        return this.handler;
    }

    class Handler
    extends DefaultHandler {
        Locator locator;
        int depth = -1;
        Element current = null;
        StringBuilder bodyBuilder = null;

        Handler() {
        }

        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            Element child;
            Children children;
            int depth;
            if ((depth = ++this.depth) == 0) {
                this.startRoot(uri, localName, attributes);
                return;
            }
            if (this.bodyBuilder != null) {
                throw new BadXmlException("Encountered mixed content within text element named " + this.current + ".", this.locator);
            }
            if (depth == this.current.depth + 1 && (children = this.current.children) != null && (child = children.get(uri, localName)) != null) {
                this.start(child, attributes);
            }
        }

        void startRoot(String uri, String localName, Attributes attributes) throws SAXException {
            RootElement root = RootElement.this;
            if (root.uri.compareTo(uri) != 0 || root.localName.compareTo(localName) != 0) {
                throw new BadXmlException("Root element name does not match. Expected: " + root + ", Got: " + Element.toString(uri, localName), this.locator);
            }
            this.start(root, attributes);
        }

        void start(Element e, Attributes attributes) {
            this.current = e;
            if (e.startElementListener != null) {
                e.startElementListener.start(attributes);
            }
            if (e.endTextElementListener != null) {
                this.bodyBuilder = new StringBuilder();
            }
            e.resetRequiredChildren();
            e.visited = true;
        }

        public void characters(char[] buffer, int start, int length) throws SAXException {
            if (this.bodyBuilder != null) {
                this.bodyBuilder.append(buffer, start, length);
            }
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            Element current = this.current;
            if (this.depth == current.depth) {
                current.checkRequiredChildren(this.locator);
                if (current.endElementListener != null) {
                    current.endElementListener.end();
                }
                if (this.bodyBuilder != null) {
                    String body = this.bodyBuilder.toString();
                    this.bodyBuilder = null;
                    current.endTextElementListener.end(body);
                }
                this.current = current.parent;
            }
            --this.depth;
        }
    }
}

