/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.graphics.Rect;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FocusFinder {
    private static final ThreadLocal<FocusFinder> tlFocusFinder = new ThreadLocal<FocusFinder>(){

        @Override
        protected FocusFinder initialValue() {
            return new FocusFinder();
        }
    };
    final Rect mFocusedRect = new Rect();
    final Rect mOtherRect = new Rect();
    final Rect mBestCandidateRect = new Rect();
    final SequentialFocusComparator mSequentialFocusComparator = new SequentialFocusComparator();
    private final ArrayList<View> mTempList = new ArrayList();

    public static FocusFinder getInstance() {
        return tlFocusFinder.get();
    }

    private FocusFinder() {
    }

    public final View findNextFocus(ViewGroup root, View focused, int direction) {
        return this.findNextFocus(root, focused, null, direction);
    }

    public View findNextFocusFromRect(ViewGroup root, Rect focusedRect, int direction) {
        this.mFocusedRect.set(focusedRect);
        return this.findNextFocus(root, null, this.mFocusedRect, direction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private View findNextFocus(ViewGroup root, View focused, Rect focusedRect, int direction) {
        View next = null;
        if (focused != null) {
            next = this.findNextUserSpecifiedFocus(root, focused, direction);
        }
        if (next != null) {
            return next;
        }
        ArrayList<View> focusables = this.mTempList;
        try {
            focusables.clear();
            root.addFocusables(focusables, direction);
            if (!focusables.isEmpty()) {
                next = this.findNextFocus(root, focused, focusedRect, direction, focusables);
            }
        }
        finally {
            focusables.clear();
        }
        return next;
    }

    private View findNextUserSpecifiedFocus(ViewGroup root, View focused, int direction) {
        View userSetNextFocus = focused.findUserSetNextFocus(root, direction);
        if (userSetNextFocus != null && userSetNextFocus.isFocusable() && (!userSetNextFocus.isInTouchMode() || userSetNextFocus.isFocusableInTouchMode())) {
            return userSetNextFocus;
        }
        return null;
    }

    private View findNextFocus(ViewGroup root, View focused, Rect focusedRect, int direction, ArrayList<View> focusables) {
        if (focused != null) {
            if (focusedRect == null) {
                focusedRect = this.mFocusedRect;
            }
            focused.getFocusedRect(focusedRect);
            root.offsetDescendantRectToMyCoords(focused, focusedRect);
        } else if (focusedRect == null) {
            focusedRect = this.mFocusedRect;
            switch (direction) {
                case 66: 
                case 130: {
                    this.setFocusTopLeft(root, focusedRect);
                    break;
                }
                case 2: {
                    if (root.isLayoutRtl()) {
                        this.setFocusBottomRight(root, focusedRect);
                        break;
                    }
                    this.setFocusTopLeft(root, focusedRect);
                    break;
                }
                case 17: 
                case 33: {
                    this.setFocusBottomRight(root, focusedRect);
                    break;
                }
                case 1: {
                    if (root.isLayoutRtl()) {
                        this.setFocusTopLeft(root, focusedRect);
                        break;
                    }
                    this.setFocusBottomRight(root, focusedRect);
                }
            }
        }
        switch (direction) {
            case 1: 
            case 2: {
                return this.findNextFocusInRelativeDirection(focusables, root, focused, focusedRect, direction);
            }
            case 17: 
            case 33: 
            case 66: 
            case 130: {
                return this.findNextFocusInAbsoluteDirection(focusables, root, focused, focusedRect, direction);
            }
        }
        throw new IllegalArgumentException("Unknown direction: " + direction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private View findNextFocusInRelativeDirection(ArrayList<View> focusables, ViewGroup root, View focused, Rect focusedRect, int direction) {
        try {
            this.mSequentialFocusComparator.setRoot(root);
            this.mSequentialFocusComparator.setIsLayoutRtl(root.isLayoutRtl());
            Collections.sort(focusables, this.mSequentialFocusComparator);
        }
        finally {
            this.mSequentialFocusComparator.recycle();
        }
        int count = focusables.size();
        switch (direction) {
            case 2: {
                return FocusFinder.getNextFocusable(focused, focusables, count);
            }
            case 1: {
                return FocusFinder.getPreviousFocusable(focused, focusables, count);
            }
        }
        return focusables.get(count - 1);
    }

    private void setFocusBottomRight(ViewGroup root, Rect focusedRect) {
        int rootBottom = root.getScrollY() + root.getHeight();
        int rootRight = root.getScrollX() + root.getWidth();
        focusedRect.set(rootRight, rootBottom, rootRight, rootBottom);
    }

    private void setFocusTopLeft(ViewGroup root, Rect focusedRect) {
        int rootTop = root.getScrollY();
        int rootLeft = root.getScrollX();
        focusedRect.set(rootLeft, rootTop, rootLeft, rootTop);
    }

    View findNextFocusInAbsoluteDirection(ArrayList<View> focusables, ViewGroup root, View focused, Rect focusedRect, int direction) {
        this.mBestCandidateRect.set(focusedRect);
        switch (direction) {
            case 17: {
                this.mBestCandidateRect.offset(focusedRect.width() + 1, 0);
                break;
            }
            case 66: {
                this.mBestCandidateRect.offset(-(focusedRect.width() + 1), 0);
                break;
            }
            case 33: {
                this.mBestCandidateRect.offset(0, focusedRect.height() + 1);
                break;
            }
            case 130: {
                this.mBestCandidateRect.offset(0, -(focusedRect.height() + 1));
            }
        }
        View closest = null;
        int numFocusables = focusables.size();
        for (int i = 0; i < numFocusables; ++i) {
            View focusable = focusables.get(i);
            if (focusable == focused || focusable == root) continue;
            focusable.getFocusedRect(this.mOtherRect);
            root.offsetDescendantRectToMyCoords(focusable, this.mOtherRect);
            if (!this.isBetterCandidate(direction, focusedRect, this.mOtherRect, this.mBestCandidateRect)) continue;
            this.mBestCandidateRect.set(this.mOtherRect);
            closest = focusable;
        }
        return closest;
    }

    private static View getNextFocusable(View focused, ArrayList<View> focusables, int count) {
        int position;
        if (focused != null && (position = focusables.lastIndexOf(focused)) >= 0 && position + 1 < count) {
            return focusables.get(position + 1);
        }
        if (!focusables.isEmpty()) {
            return focusables.get(0);
        }
        return null;
    }

    private static View getPreviousFocusable(View focused, ArrayList<View> focusables, int count) {
        int position;
        if (focused != null && (position = focusables.indexOf(focused)) > 0) {
            return focusables.get(position - 1);
        }
        if (!focusables.isEmpty()) {
            return focusables.get(count - 1);
        }
        return null;
    }

    boolean isBetterCandidate(int direction, Rect source, Rect rect1, Rect rect2) {
        if (!this.isCandidate(source, rect1, direction)) {
            return false;
        }
        if (!this.isCandidate(source, rect2, direction)) {
            return true;
        }
        if (this.beamBeats(direction, source, rect1, rect2)) {
            return true;
        }
        if (this.beamBeats(direction, source, rect2, rect1)) {
            return false;
        }
        return this.getWeightedDistanceFor(FocusFinder.majorAxisDistance(direction, source, rect1), FocusFinder.minorAxisDistance(direction, source, rect1)) < this.getWeightedDistanceFor(FocusFinder.majorAxisDistance(direction, source, rect2), FocusFinder.minorAxisDistance(direction, source, rect2));
    }

    boolean beamBeats(int direction, Rect source, Rect rect1, Rect rect2) {
        boolean rect1InSrcBeam = this.beamsOverlap(direction, source, rect1);
        boolean rect2InSrcBeam = this.beamsOverlap(direction, source, rect2);
        if (rect2InSrcBeam || !rect1InSrcBeam) {
            return false;
        }
        if (!this.isToDirectionOf(direction, source, rect2)) {
            return true;
        }
        if (direction == 17 || direction == 66) {
            return true;
        }
        return FocusFinder.majorAxisDistance(direction, source, rect1) < FocusFinder.majorAxisDistanceToFarEdge(direction, source, rect2);
    }

    int getWeightedDistanceFor(int majorAxisDistance, int minorAxisDistance) {
        return 13 * majorAxisDistance * majorAxisDistance + minorAxisDistance * minorAxisDistance;
    }

    boolean isCandidate(Rect srcRect, Rect destRect, int direction) {
        switch (direction) {
            case 17: {
                return (srcRect.right > destRect.right || srcRect.left >= destRect.right) && srcRect.left > destRect.left;
            }
            case 66: {
                return (srcRect.left < destRect.left || srcRect.right <= destRect.left) && srcRect.right < destRect.right;
            }
            case 33: {
                return (srcRect.bottom > destRect.bottom || srcRect.top >= destRect.bottom) && srcRect.top > destRect.top;
            }
            case 130: {
                return (srcRect.top < destRect.top || srcRect.bottom <= destRect.top) && srcRect.bottom < destRect.bottom;
            }
        }
        throw new IllegalArgumentException("direction must be one of {FOCUS_UP, FOCUS_DOWN, FOCUS_LEFT, FOCUS_RIGHT}.");
    }

    boolean beamsOverlap(int direction, Rect rect1, Rect rect2) {
        switch (direction) {
            case 17: 
            case 66: {
                return rect2.bottom >= rect1.top && rect2.top <= rect1.bottom;
            }
            case 33: 
            case 130: {
                return rect2.right >= rect1.left && rect2.left <= rect1.right;
            }
        }
        throw new IllegalArgumentException("direction must be one of {FOCUS_UP, FOCUS_DOWN, FOCUS_LEFT, FOCUS_RIGHT}.");
    }

    boolean isToDirectionOf(int direction, Rect src, Rect dest) {
        switch (direction) {
            case 17: {
                return src.left >= dest.right;
            }
            case 66: {
                return src.right <= dest.left;
            }
            case 33: {
                return src.top >= dest.bottom;
            }
            case 130: {
                return src.bottom <= dest.top;
            }
        }
        throw new IllegalArgumentException("direction must be one of {FOCUS_UP, FOCUS_DOWN, FOCUS_LEFT, FOCUS_RIGHT}.");
    }

    static int majorAxisDistance(int direction, Rect source, Rect dest) {
        return Math.max(0, FocusFinder.majorAxisDistanceRaw(direction, source, dest));
    }

    static int majorAxisDistanceRaw(int direction, Rect source, Rect dest) {
        switch (direction) {
            case 17: {
                return source.left - dest.right;
            }
            case 66: {
                return dest.left - source.right;
            }
            case 33: {
                return source.top - dest.bottom;
            }
            case 130: {
                return dest.top - source.bottom;
            }
        }
        throw new IllegalArgumentException("direction must be one of {FOCUS_UP, FOCUS_DOWN, FOCUS_LEFT, FOCUS_RIGHT}.");
    }

    static int majorAxisDistanceToFarEdge(int direction, Rect source, Rect dest) {
        return Math.max(1, FocusFinder.majorAxisDistanceToFarEdgeRaw(direction, source, dest));
    }

    static int majorAxisDistanceToFarEdgeRaw(int direction, Rect source, Rect dest) {
        switch (direction) {
            case 17: {
                return source.left - dest.left;
            }
            case 66: {
                return dest.right - source.right;
            }
            case 33: {
                return source.top - dest.top;
            }
            case 130: {
                return dest.bottom - source.bottom;
            }
        }
        throw new IllegalArgumentException("direction must be one of {FOCUS_UP, FOCUS_DOWN, FOCUS_LEFT, FOCUS_RIGHT}.");
    }

    static int minorAxisDistance(int direction, Rect source, Rect dest) {
        switch (direction) {
            case 17: 
            case 66: {
                return Math.abs(source.top + source.height() / 2 - (dest.top + dest.height() / 2));
            }
            case 33: 
            case 130: {
                return Math.abs(source.left + source.width() / 2 - (dest.left + dest.width() / 2));
            }
        }
        throw new IllegalArgumentException("direction must be one of {FOCUS_UP, FOCUS_DOWN, FOCUS_LEFT, FOCUS_RIGHT}.");
    }

    public View findNearestTouchable(ViewGroup root, int x, int y, int direction, int[] deltas) {
        ArrayList<View> touchables = root.getTouchables();
        int minDistance = Integer.MAX_VALUE;
        View closest = null;
        int numTouchables = touchables.size();
        int edgeSlop = ViewConfiguration.get(root.mContext).getScaledEdgeSlop();
        Rect closestBounds = new Rect();
        Rect touchableBounds = this.mOtherRect;
        block12: for (int i = 0; i < numTouchables; ++i) {
            View touchable = touchables.get(i);
            touchable.getDrawingRect(touchableBounds);
            root.offsetRectBetweenParentAndChild(touchable, touchableBounds, true, true);
            if (!this.isTouchCandidate(x, y, touchableBounds, direction)) continue;
            int distance = Integer.MAX_VALUE;
            switch (direction) {
                case 17: {
                    distance = x - touchableBounds.right + 1;
                    break;
                }
                case 66: {
                    distance = touchableBounds.left;
                    break;
                }
                case 33: {
                    distance = y - touchableBounds.bottom + 1;
                    break;
                }
                case 130: {
                    distance = touchableBounds.top;
                }
            }
            if (distance >= edgeSlop || closest != null && !closestBounds.contains(touchableBounds) && (touchableBounds.contains(closestBounds) || distance >= minDistance)) continue;
            minDistance = distance;
            closest = touchable;
            closestBounds.set(touchableBounds);
            switch (direction) {
                case 17: {
                    deltas[0] = -distance;
                    continue block12;
                }
                case 66: {
                    deltas[0] = distance;
                    continue block12;
                }
                case 33: {
                    deltas[1] = -distance;
                    continue block12;
                }
                case 130: {
                    deltas[1] = distance;
                }
            }
        }
        return closest;
    }

    private boolean isTouchCandidate(int x, int y, Rect destRect, int direction) {
        switch (direction) {
            case 17: {
                return destRect.left <= x && destRect.top <= y && y <= destRect.bottom;
            }
            case 66: {
                return destRect.left >= x && destRect.top <= y && y <= destRect.bottom;
            }
            case 33: {
                return destRect.top <= y && destRect.left <= x && x <= destRect.right;
            }
            case 130: {
                return destRect.top >= y && destRect.left <= x && x <= destRect.right;
            }
        }
        throw new IllegalArgumentException("direction must be one of {FOCUS_UP, FOCUS_DOWN, FOCUS_LEFT, FOCUS_RIGHT}.");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SequentialFocusComparator
    implements Comparator<View> {
        private final Rect mFirstRect = new Rect();
        private final Rect mSecondRect = new Rect();
        private ViewGroup mRoot;
        private boolean mIsLayoutRtl;

        private SequentialFocusComparator() {
        }

        public void recycle() {
            this.mRoot = null;
        }

        public void setRoot(ViewGroup root) {
            this.mRoot = root;
        }

        public void setIsLayoutRtl(boolean b) {
            this.mIsLayoutRtl = b;
        }

        @Override
        public int compare(View first, View second) {
            if (first == second) {
                return 0;
            }
            this.getRect(first, this.mFirstRect);
            this.getRect(second, this.mSecondRect);
            if (this.mFirstRect.top < this.mSecondRect.top) {
                return -1;
            }
            if (this.mFirstRect.top > this.mSecondRect.top) {
                return 1;
            }
            if (this.mFirstRect.left < this.mSecondRect.left) {
                return this.mIsLayoutRtl ? 1 : -1;
            }
            if (this.mFirstRect.left > this.mSecondRect.left) {
                return this.mIsLayoutRtl ? -1 : 1;
            }
            if (this.mFirstRect.bottom < this.mSecondRect.bottom) {
                return -1;
            }
            if (this.mFirstRect.bottom > this.mSecondRect.bottom) {
                return 1;
            }
            if (this.mFirstRect.right < this.mSecondRect.right) {
                return this.mIsLayoutRtl ? 1 : -1;
            }
            if (this.mFirstRect.right > this.mSecondRect.right) {
                return this.mIsLayoutRtl ? -1 : 1;
            }
            return 0;
        }

        private void getRect(View view, Rect rect) {
            view.getDrawingRect(rect);
            this.mRoot.offsetDescendantRectToMyCoords(view, rect);
        }
    }
}

