/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.DrawFilter;
import android.graphics.Matrix;
import android.graphics.NinePatch;
import android.graphics.Paint;
import android.graphics.PaintFlagsDrawFilter;
import android.graphics.Path;
import android.graphics.Picture;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import android.graphics.Shader;
import android.graphics.SurfaceTexture;
import android.graphics.TemporaryBuffer;
import android.text.GraphicsOperations;
import android.text.SpannableString;
import android.text.SpannedString;
import android.text.TextUtils;
import android.view.DisplayList;
import android.view.GLES20DisplayList;
import android.view.GLES20Layer;
import android.view.GLES20RenderLayer;
import android.view.GraphicBuffer;
import android.view.HardwareCanvas;
import android.view.HardwareLayer;

class GLES20Canvas
extends HardwareCanvas {
    private static final int MODIFIER_NONE = 0;
    private static final int MODIFIER_SHADOW = 1;
    private static final int MODIFIER_SHADER = 2;
    private static final int MODIFIER_COLOR_FILTER = 4;
    private final boolean mOpaque;
    private int mRenderer;
    private CanvasFinalizer mFinalizer;
    private int mWidth;
    private int mHeight;
    private float[] mPoint;
    private float[] mLine;
    private Rect mClipBounds;
    private RectF mPathBounds;
    private DrawFilter mFilter;
    private static boolean sIsAvailable = GLES20Canvas.nIsAvailable();
    static final int FLUSH_CACHES_LAYERS = 0;
    static final int FLUSH_CACHES_MODERATE = 1;
    static final int FLUSH_CACHES_FULL = 2;

    private static native boolean nIsAvailable();

    static boolean isAvailable() {
        return sIsAvailable;
    }

    GLES20Canvas(boolean translucent) {
        this(false, translucent);
    }

    GLES20Canvas(int layer, boolean translucent) {
        this.mOpaque = !translucent;
        this.mRenderer = GLES20Canvas.nCreateLayerRenderer(layer);
        this.setupFinalizer();
    }

    protected GLES20Canvas(boolean record, boolean translucent) {
        this.mOpaque = !translucent;
        this.mRenderer = record ? GLES20Canvas.nCreateDisplayListRenderer() : GLES20Canvas.nCreateRenderer();
        this.setupFinalizer();
    }

    private void setupFinalizer() {
        if (this.mRenderer == 0) {
            throw new IllegalStateException("Could not create GLES20Canvas renderer");
        }
        this.mFinalizer = new CanvasFinalizer(this.mRenderer);
    }

    protected void resetDisplayListRenderer() {
        GLES20Canvas.nResetDisplayListRenderer(this.mRenderer);
    }

    private static native int nCreateRenderer();

    private static native int nCreateLayerRenderer(int var0);

    private static native int nCreateDisplayListRenderer();

    private static native void nResetDisplayListRenderer(int var0);

    private static native void nDestroyRenderer(int var0);

    public void setName(String name) {
        super.setName(name);
        GLES20Canvas.nSetName(this.mRenderer, name);
    }

    private static native void nSetName(int var0, String var1);

    void pushLayerUpdate(HardwareLayer layer) {
        GLES20Canvas.nPushLayerUpdate(this.mRenderer, ((GLES20RenderLayer)layer).mLayer);
    }

    void cancelLayerUpdate(HardwareLayer layer) {
        GLES20Canvas.nCancelLayerUpdate(this.mRenderer, ((GLES20RenderLayer)layer).mLayer);
    }

    void flushLayerUpdates() {
        GLES20Canvas.nFlushLayerUpdates(this.mRenderer);
    }

    void clearLayerUpdates() {
        GLES20Canvas.nClearLayerUpdates(this.mRenderer);
    }

    static native int nCreateTextureLayer(boolean var0, int[] var1);

    static native int nCreateLayer(int var0, int var1, boolean var2, int[] var3);

    static native boolean nResizeLayer(int var0, int var1, int var2, int[] var3);

    static native void nSetOpaqueLayer(int var0, boolean var1);

    static native void nSetLayerPaint(int var0, int var1);

    static native void nSetLayerColorFilter(int var0, int var1);

    static native void nUpdateTextureLayer(int var0, int var1, int var2, boolean var3, SurfaceTexture var4);

    static native void nClearLayerTexture(int var0);

    static native void nSetTextureLayerTransform(int var0, int var1);

    static native void nDestroyLayer(int var0);

    static native void nDestroyLayerDeferred(int var0);

    static native void nUpdateRenderLayer(int var0, int var1, int var2, int var3, int var4, int var5, int var6);

    static native boolean nCopyLayer(int var0, int var1);

    private static native void nClearLayerUpdates(int var0);

    private static native void nFlushLayerUpdates(int var0);

    private static native void nPushLayerUpdate(int var0, int var1);

    private static native void nCancelLayerUpdate(int var0, int var1);

    public boolean isOpaque() {
        return this.mOpaque;
    }

    public int getWidth() {
        return this.mWidth;
    }

    public int getHeight() {
        return this.mHeight;
    }

    public int getMaximumBitmapWidth() {
        return GLES20Canvas.nGetMaximumTextureWidth();
    }

    public int getMaximumBitmapHeight() {
        return GLES20Canvas.nGetMaximumTextureHeight();
    }

    private static native int nGetMaximumTextureWidth();

    private static native int nGetMaximumTextureHeight();

    int getRenderer() {
        return this.mRenderer;
    }

    public void setViewport(int width, int height) {
        this.mWidth = width;
        this.mHeight = height;
        GLES20Canvas.nSetViewport(this.mRenderer, width, height);
    }

    private static native void nSetViewport(int var0, int var1, int var2);

    public int onPreDraw(Rect dirty) {
        if (dirty != null) {
            return GLES20Canvas.nPrepareDirty(this.mRenderer, dirty.left, dirty.top, dirty.right, dirty.bottom, this.mOpaque);
        }
        return GLES20Canvas.nPrepare(this.mRenderer, this.mOpaque);
    }

    private static native int nPrepare(int var0, boolean var1);

    private static native int nPrepareDirty(int var0, int var1, int var2, int var3, int var4, boolean var5);

    public void onPostDraw() {
        GLES20Canvas.nFinish(this.mRenderer);
    }

    private static native void nFinish(int var0);

    public static int getStencilSize() {
        return GLES20Canvas.nGetStencilSize();
    }

    private static native int nGetStencilSize();

    void setCountOverdrawEnabled(boolean enabled) {
        GLES20Canvas.nSetCountOverdrawEnabled(this.mRenderer, enabled);
    }

    static native void nSetCountOverdrawEnabled(int var0, boolean var1);

    float getOverdraw() {
        return GLES20Canvas.nGetOverdraw(this.mRenderer);
    }

    static native float nGetOverdraw(int var0);

    public int callDrawGLFunction(int drawGLFunction) {
        return GLES20Canvas.nCallDrawGLFunction(this.mRenderer, drawGLFunction);
    }

    private static native int nCallDrawGLFunction(int var0, int var1);

    public int invokeFunctors(Rect dirty) {
        return GLES20Canvas.nInvokeFunctors(this.mRenderer, dirty);
    }

    private static native int nInvokeFunctors(int var0, Rect var1);

    public void detachFunctor(int functor) {
        GLES20Canvas.nDetachFunctor(this.mRenderer, functor);
    }

    private static native void nDetachFunctor(int var0, int var1);

    public void attachFunctor(int functor) {
        GLES20Canvas.nAttachFunctor(this.mRenderer, functor);
    }

    private static native void nAttachFunctor(int var0, int var1);

    static void flushCaches(int level) {
        GLES20Canvas.nFlushCaches(level);
    }

    private static native void nFlushCaches(int var0);

    static void terminateCaches() {
        GLES20Canvas.nTerminateCaches();
    }

    private static native void nTerminateCaches();

    static boolean initCaches() {
        return GLES20Canvas.nInitCaches();
    }

    private static native boolean nInitCaches();

    static void initAtlas(GraphicBuffer buffer, int[] map) {
        GLES20Canvas.nInitAtlas(buffer, map, map.length);
    }

    private static native void nInitAtlas(GraphicBuffer var0, int[] var1, int var2);

    int getDisplayList(int displayList) {
        return GLES20Canvas.nGetDisplayList(this.mRenderer, displayList);
    }

    private static native int nGetDisplayList(int var0, int var1);

    void outputDisplayList(DisplayList displayList) {
        GLES20Canvas.nOutputDisplayList(this.mRenderer, ((GLES20DisplayList)displayList).getNativeDisplayList());
    }

    private static native void nOutputDisplayList(int var0, int var1);

    public int drawDisplayList(DisplayList displayList, Rect dirty, int flags) {
        return GLES20Canvas.nDrawDisplayList(this.mRenderer, ((GLES20DisplayList)displayList).getNativeDisplayList(), dirty, flags);
    }

    private static native int nDrawDisplayList(int var0, int var1, Rect var2, int var3);

    void drawHardwareLayer(HardwareLayer layer, float x, float y, Paint paint) {
        layer.setLayerPaint(paint);
        GLES20Layer glLayer = (GLES20Layer)layer;
        GLES20Canvas.nDrawLayer(this.mRenderer, glLayer.getLayer(), x, y);
    }

    private static native void nDrawLayer(int var0, int var1, float var2, float var3);

    void interrupt() {
        GLES20Canvas.nInterrupt(this.mRenderer);
    }

    void resume() {
        GLES20Canvas.nResume(this.mRenderer);
    }

    private static native void nInterrupt(int var0);

    private static native void nResume(int var0);

    private Rect getInternalClipBounds() {
        if (this.mClipBounds == null) {
            this.mClipBounds = new Rect();
        }
        return this.mClipBounds;
    }

    private RectF getPathBounds() {
        if (this.mPathBounds == null) {
            this.mPathBounds = new RectF();
        }
        return this.mPathBounds;
    }

    private float[] getPointStorage() {
        if (this.mPoint == null) {
            this.mPoint = new float[2];
        }
        return this.mPoint;
    }

    private float[] getLineStorage() {
        if (this.mLine == null) {
            this.mLine = new float[4];
        }
        return this.mLine;
    }

    public boolean clipPath(Path path) {
        return GLES20Canvas.nClipPath(this.mRenderer, path.mNativePath, Region.Op.INTERSECT.nativeInt);
    }

    public boolean clipPath(Path path, Region.Op op) {
        return GLES20Canvas.nClipPath(this.mRenderer, path.mNativePath, op.nativeInt);
    }

    private static native boolean nClipPath(int var0, int var1, int var2);

    public boolean clipRect(float left, float top, float right, float bottom) {
        return GLES20Canvas.nClipRect(this.mRenderer, left, top, right, bottom, Region.Op.INTERSECT.nativeInt);
    }

    private static native boolean nClipRect(int var0, float var1, float var2, float var3, float var4, int var5);

    public boolean clipRect(float left, float top, float right, float bottom, Region.Op op) {
        return GLES20Canvas.nClipRect(this.mRenderer, left, top, right, bottom, op.nativeInt);
    }

    public boolean clipRect(int left, int top, int right, int bottom) {
        return GLES20Canvas.nClipRect(this.mRenderer, left, top, right, bottom, Region.Op.INTERSECT.nativeInt);
    }

    private static native boolean nClipRect(int var0, int var1, int var2, int var3, int var4, int var5);

    public boolean clipRect(Rect rect) {
        return GLES20Canvas.nClipRect(this.mRenderer, rect.left, rect.top, rect.right, rect.bottom, Region.Op.INTERSECT.nativeInt);
    }

    public boolean clipRect(Rect rect, Region.Op op) {
        return GLES20Canvas.nClipRect(this.mRenderer, rect.left, rect.top, rect.right, rect.bottom, op.nativeInt);
    }

    public boolean clipRect(RectF rect) {
        return GLES20Canvas.nClipRect(this.mRenderer, rect.left, rect.top, rect.right, rect.bottom, Region.Op.INTERSECT.nativeInt);
    }

    public boolean clipRect(RectF rect, Region.Op op) {
        return GLES20Canvas.nClipRect(this.mRenderer, rect.left, rect.top, rect.right, rect.bottom, op.nativeInt);
    }

    public boolean clipRegion(Region region) {
        return GLES20Canvas.nClipRegion(this.mRenderer, region.mNativeRegion, Region.Op.INTERSECT.nativeInt);
    }

    public boolean clipRegion(Region region, Region.Op op) {
        return GLES20Canvas.nClipRegion(this.mRenderer, region.mNativeRegion, op.nativeInt);
    }

    private static native boolean nClipRegion(int var0, int var1, int var2);

    public boolean getClipBounds(Rect bounds) {
        return GLES20Canvas.nGetClipBounds(this.mRenderer, bounds);
    }

    private static native boolean nGetClipBounds(int var0, Rect var1);

    public boolean quickReject(float left, float top, float right, float bottom, Canvas.EdgeType type) {
        return GLES20Canvas.nQuickReject(this.mRenderer, left, top, right, bottom);
    }

    private static native boolean nQuickReject(int var0, float var1, float var2, float var3, float var4);

    public boolean quickReject(Path path, Canvas.EdgeType type) {
        RectF pathBounds = this.getPathBounds();
        path.computeBounds(pathBounds, true);
        return GLES20Canvas.nQuickReject(this.mRenderer, pathBounds.left, pathBounds.top, pathBounds.right, pathBounds.bottom);
    }

    public boolean quickReject(RectF rect, Canvas.EdgeType type) {
        return GLES20Canvas.nQuickReject(this.mRenderer, rect.left, rect.top, rect.right, rect.bottom);
    }

    public void translate(float dx, float dy) {
        if (dx != 0.0f || dy != 0.0f) {
            GLES20Canvas.nTranslate(this.mRenderer, dx, dy);
        }
    }

    private static native void nTranslate(int var0, float var1, float var2);

    public void skew(float sx, float sy) {
        GLES20Canvas.nSkew(this.mRenderer, sx, sy);
    }

    private static native void nSkew(int var0, float var1, float var2);

    public void rotate(float degrees) {
        GLES20Canvas.nRotate(this.mRenderer, degrees);
    }

    private static native void nRotate(int var0, float var1);

    public void scale(float sx, float sy) {
        GLES20Canvas.nScale(this.mRenderer, sx, sy);
    }

    private static native void nScale(int var0, float var1, float var2);

    public void setMatrix(Matrix matrix) {
        GLES20Canvas.nSetMatrix(this.mRenderer, matrix == null ? 0 : matrix.native_instance);
    }

    private static native void nSetMatrix(int var0, int var1);

    public void getMatrix(Matrix matrix) {
        GLES20Canvas.nGetMatrix(this.mRenderer, matrix.native_instance);
    }

    private static native void nGetMatrix(int var0, int var1);

    public void concat(Matrix matrix) {
        if (matrix != null) {
            GLES20Canvas.nConcatMatrix(this.mRenderer, matrix.native_instance);
        }
    }

    private static native void nConcatMatrix(int var0, int var1);

    public int save() {
        return GLES20Canvas.nSave(this.mRenderer, 3);
    }

    public int save(int saveFlags) {
        return GLES20Canvas.nSave(this.mRenderer, saveFlags);
    }

    private static native int nSave(int var0, int var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int saveLayer(RectF bounds, Paint paint, int saveFlags) {
        int count;
        if (bounds != null) {
            return this.saveLayer(bounds.left, bounds.top, bounds.right, bounds.bottom, paint, saveFlags);
        }
        int modifier = paint != null ? this.setupColorFilter(paint) : 0;
        try {
            int nativePaint = paint == null ? 0 : paint.mNativePaint;
            count = GLES20Canvas.nSaveLayer(this.mRenderer, nativePaint, saveFlags);
        }
        finally {
            if (modifier != 0) {
                GLES20Canvas.nResetModifiers(this.mRenderer, modifier);
            }
        }
        return count;
    }

    private static native int nSaveLayer(int var0, int var1, int var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int saveLayer(float left, float top, float right, float bottom, Paint paint, int saveFlags) {
        if (left < right && top < bottom) {
            int count;
            int modifier = paint != null ? this.setupColorFilter(paint) : 0;
            try {
                int nativePaint = paint == null ? 0 : paint.mNativePaint;
                count = GLES20Canvas.nSaveLayer(this.mRenderer, left, top, right, bottom, nativePaint, saveFlags);
            }
            finally {
                if (modifier != 0) {
                    GLES20Canvas.nResetModifiers(this.mRenderer, modifier);
                }
            }
            return count;
        }
        return this.save(saveFlags);
    }

    private static native int nSaveLayer(int var0, float var1, float var2, float var3, float var4, int var5, int var6);

    public int saveLayerAlpha(RectF bounds, int alpha, int saveFlags) {
        if (bounds != null) {
            return this.saveLayerAlpha(bounds.left, bounds.top, bounds.right, bounds.bottom, alpha, saveFlags);
        }
        return GLES20Canvas.nSaveLayerAlpha(this.mRenderer, alpha, saveFlags);
    }

    private static native int nSaveLayerAlpha(int var0, int var1, int var2);

    public int saveLayerAlpha(float left, float top, float right, float bottom, int alpha, int saveFlags) {
        if (left < right && top < bottom) {
            return GLES20Canvas.nSaveLayerAlpha(this.mRenderer, left, top, right, bottom, alpha, saveFlags);
        }
        return this.save(saveFlags);
    }

    private static native int nSaveLayerAlpha(int var0, float var1, float var2, float var3, float var4, int var5, int var6);

    public void restore() {
        GLES20Canvas.nRestore(this.mRenderer);
    }

    private static native void nRestore(int var0);

    public void restoreToCount(int saveCount) {
        GLES20Canvas.nRestoreToCount(this.mRenderer, saveCount);
    }

    private static native void nRestoreToCount(int var0, int var1);

    public int getSaveCount() {
        return GLES20Canvas.nGetSaveCount(this.mRenderer);
    }

    private static native int nGetSaveCount(int var0);

    public void setDrawFilter(DrawFilter filter) {
        this.mFilter = filter;
        if (filter == null) {
            GLES20Canvas.nResetPaintFilter(this.mRenderer);
        } else if (filter instanceof PaintFlagsDrawFilter) {
            PaintFlagsDrawFilter flagsFilter = (PaintFlagsDrawFilter)filter;
            GLES20Canvas.nSetupPaintFilter(this.mRenderer, flagsFilter.clearBits, flagsFilter.setBits);
        }
    }

    private static native void nResetPaintFilter(int var0);

    private static native void nSetupPaintFilter(int var0, int var1, int var2);

    public DrawFilter getDrawFilter() {
        return this.mFilter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawArc(RectF oval, float startAngle, float sweepAngle, boolean useCenter, Paint paint) {
        int modifiers = this.setupModifiers(paint, 6);
        try {
            GLES20Canvas.nDrawArc(this.mRenderer, oval.left, oval.top, oval.right, oval.bottom, startAngle, sweepAngle, useCenter, paint.mNativePaint);
        }
        finally {
            if (modifiers != 0) {
                GLES20Canvas.nResetModifiers(this.mRenderer, modifiers);
            }
        }
    }

    private static native void nDrawArc(int var0, float var1, float var2, float var3, float var4, float var5, float var6, boolean var7, int var8);

    public void drawARGB(int a, int r, int g, int b) {
        this.drawColor((a & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawPatch(NinePatch patch, Rect dst, Paint paint) {
        Bitmap bitmap = patch.getBitmap();
        GLES20Canvas.throwIfCannotDraw(bitmap);
        int modifier = paint != null ? this.setupColorFilter(paint) : 0;
        try {
            int nativePaint = paint == null ? 0 : paint.mNativePaint;
            GLES20Canvas.nDrawPatch(this.mRenderer, bitmap.mNativeBitmap, bitmap.mBuffer, patch.mNativeChunk, dst.left, dst.top, dst.right, dst.bottom, nativePaint);
        }
        finally {
            if (modifier != 0) {
                GLES20Canvas.nResetModifiers(this.mRenderer, modifier);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawPatch(NinePatch patch, RectF dst, Paint paint) {
        Bitmap bitmap = patch.getBitmap();
        GLES20Canvas.throwIfCannotDraw(bitmap);
        int modifier = paint != null ? this.setupColorFilter(paint) : 0;
        try {
            int nativePaint = paint == null ? 0 : paint.mNativePaint;
            GLES20Canvas.nDrawPatch(this.mRenderer, bitmap.mNativeBitmap, bitmap.mBuffer, patch.mNativeChunk, dst.left, dst.top, dst.right, dst.bottom, nativePaint);
        }
        finally {
            if (modifier != 0) {
                GLES20Canvas.nResetModifiers(this.mRenderer, modifier);
            }
        }
    }

    private static native void nDrawPatch(int var0, int var1, byte[] var2, int var3, float var4, float var5, float var6, float var7, int var8);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawBitmap(Bitmap bitmap, float left, float top, Paint paint) {
        GLES20Canvas.throwIfCannotDraw(bitmap);
        int modifiers = paint != null ? this.setupModifiers(bitmap, paint) : 0;
        try {
            int nativePaint = paint == null ? 0 : paint.mNativePaint;
            GLES20Canvas.nDrawBitmap(this.mRenderer, bitmap.mNativeBitmap, bitmap.mBuffer, left, top, nativePaint);
        }
        finally {
            if (modifiers != 0) {
                GLES20Canvas.nResetModifiers(this.mRenderer, modifiers);
            }
        }
    }

    private static native void nDrawBitmap(int var0, int var1, byte[] var2, float var3, float var4, int var5);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawBitmap(Bitmap bitmap, Matrix matrix, Paint paint) {
        GLES20Canvas.throwIfCannotDraw(bitmap);
        int modifiers = paint != null ? this.setupModifiers(bitmap, paint) : 0;
        try {
            int nativePaint = paint == null ? 0 : paint.mNativePaint;
            GLES20Canvas.nDrawBitmap(this.mRenderer, bitmap.mNativeBitmap, bitmap.mBuffer, matrix.native_instance, nativePaint);
        }
        finally {
            if (modifiers != 0) {
                GLES20Canvas.nResetModifiers(this.mRenderer, modifiers);
            }
        }
    }

    private static native void nDrawBitmap(int var0, int var1, byte[] var2, int var3, int var4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawBitmap(Bitmap bitmap, Rect src, Rect dst, Paint paint) {
        GLES20Canvas.throwIfCannotDraw(bitmap);
        int modifiers = paint != null ? this.setupModifiers(bitmap, paint) : 0;
        try {
            int bottom;
            int right;
            int left;
            int top;
            int nativePaint;
            int n = nativePaint = paint == null ? 0 : paint.mNativePaint;
            if (src == null) {
                top = 0;
                left = 0;
                right = bitmap.getWidth();
                bottom = bitmap.getHeight();
            } else {
                left = src.left;
                right = src.right;
                top = src.top;
                bottom = src.bottom;
            }
            GLES20Canvas.nDrawBitmap(this.mRenderer, bitmap.mNativeBitmap, bitmap.mBuffer, left, top, right, bottom, dst.left, dst.top, dst.right, dst.bottom, nativePaint);
        }
        finally {
            if (modifiers != 0) {
                GLES20Canvas.nResetModifiers(this.mRenderer, modifiers);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawBitmap(Bitmap bitmap, Rect src, RectF dst, Paint paint) {
        GLES20Canvas.throwIfCannotDraw(bitmap);
        int modifiers = paint != null ? this.setupModifiers(bitmap, paint) : 0;
        try {
            float bottom;
            float right;
            float left;
            float top;
            int nativePaint;
            int n = nativePaint = paint == null ? 0 : paint.mNativePaint;
            if (src == null) {
                top = 0.0f;
                left = 0.0f;
                right = bitmap.getWidth();
                bottom = bitmap.getHeight();
            } else {
                left = src.left;
                right = src.right;
                top = src.top;
                bottom = src.bottom;
            }
            GLES20Canvas.nDrawBitmap(this.mRenderer, bitmap.mNativeBitmap, bitmap.mBuffer, left, top, right, bottom, dst.left, dst.top, dst.right, dst.bottom, nativePaint);
        }
        finally {
            if (modifiers != 0) {
                GLES20Canvas.nResetModifiers(this.mRenderer, modifiers);
            }
        }
    }

    private static native void nDrawBitmap(int var0, int var1, byte[] var2, float var3, float var4, float var5, float var6, float var7, float var8, float var9, float var10, int var11);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawBitmap(int[] colors, int offset, int stride, float x, float y, int width, int height, boolean hasAlpha, Paint paint) {
        if (width < 0) {
            throw new IllegalArgumentException("width must be >= 0");
        }
        if (height < 0) {
            throw new IllegalArgumentException("height must be >= 0");
        }
        if (Math.abs(stride) < width) {
            throw new IllegalArgumentException("abs(stride) must be >= width");
        }
        int lastScanline = offset + (height - 1) * stride;
        int length = colors.length;
        if (offset < 0 || offset + width > length || lastScanline < 0 || lastScanline + width > length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int modifier = paint != null ? this.setupColorFilter(paint) : 0;
        try {
            int nativePaint = paint == null ? 0 : paint.mNativePaint;
            GLES20Canvas.nDrawBitmap(this.mRenderer, colors, offset, stride, x, y, width, height, hasAlpha, nativePaint);
        }
        finally {
            if (modifier != 0) {
                GLES20Canvas.nResetModifiers(this.mRenderer, modifier);
            }
        }
    }

    private static native void nDrawBitmap(int var0, int[] var1, int var2, int var3, float var4, float var5, int var6, int var7, boolean var8, int var9);

    public void drawBitmap(int[] colors, int offset, int stride, int x, int y, int width, int height, boolean hasAlpha, Paint paint) {
        this.drawBitmap(colors, offset, stride, (float)x, (float)y, width, height, hasAlpha, paint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawBitmapMesh(Bitmap bitmap, int meshWidth, int meshHeight, float[] verts, int vertOffset, int[] colors, int colorOffset, Paint paint) {
        GLES20Canvas.throwIfCannotDraw(bitmap);
        if (meshWidth < 0 || meshHeight < 0 || vertOffset < 0 || colorOffset < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (meshWidth == 0 || meshHeight == 0) {
            return;
        }
        int count = (meshWidth + 1) * (meshHeight + 1);
        GLES20Canvas.checkRange(verts.length, vertOffset, count * 2);
        if (colors != null) {
            GLES20Canvas.checkRange(colors.length, colorOffset, count);
        }
        int modifiers = paint != null ? this.setupModifiers(bitmap, paint) : 0;
        try {
            int nativePaint = paint == null ? 0 : paint.mNativePaint;
            GLES20Canvas.nDrawBitmapMesh(this.mRenderer, bitmap.mNativeBitmap, bitmap.mBuffer, meshWidth, meshHeight, verts, vertOffset, colors, colorOffset, nativePaint);
        }
        finally {
            if (modifiers != 0) {
                GLES20Canvas.nResetModifiers(this.mRenderer, modifiers);
            }
        }
    }

    private static native void nDrawBitmapMesh(int var0, int var1, byte[] var2, int var3, int var4, float[] var5, int var6, int[] var7, int var8, int var9);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawCircle(float cx, float cy, float radius, Paint paint) {
        int modifiers = this.setupModifiers(paint, 6);
        try {
            GLES20Canvas.nDrawCircle(this.mRenderer, cx, cy, radius, paint.mNativePaint);
        }
        finally {
            if (modifiers != 0) {
                GLES20Canvas.nResetModifiers(this.mRenderer, modifiers);
            }
        }
    }

    private static native void nDrawCircle(int var0, float var1, float var2, float var3, int var4);

    public void drawColor(int color2) {
        this.drawColor(color2, PorterDuff.Mode.SRC_OVER);
    }

    public void drawColor(int color2, PorterDuff.Mode mode) {
        GLES20Canvas.nDrawColor(this.mRenderer, color2, mode.nativeInt);
    }

    private static native void nDrawColor(int var0, int var1, int var2);

    public void drawLine(float startX, float startY, float stopX, float stopY, Paint paint) {
        float[] line = this.getLineStorage();
        line[0] = startX;
        line[1] = startY;
        line[2] = stopX;
        line[3] = stopY;
        this.drawLines(line, 0, 4, paint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawLines(float[] pts, int offset, int count, Paint paint) {
        if (count < 4) {
            return;
        }
        if ((offset | count) < 0 || offset + count > pts.length) {
            throw new IllegalArgumentException("The lines array must contain 4 elements per line.");
        }
        int modifiers = this.setupModifiers(paint, 6);
        try {
            GLES20Canvas.nDrawLines(this.mRenderer, pts, offset, count, paint.mNativePaint);
        }
        finally {
            if (modifiers != 0) {
                GLES20Canvas.nResetModifiers(this.mRenderer, modifiers);
            }
        }
    }

    private static native void nDrawLines(int var0, float[] var1, int var2, int var3, int var4);

    public void drawLines(float[] pts, Paint paint) {
        this.drawLines(pts, 0, pts.length, paint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawOval(RectF oval, Paint paint) {
        int modifiers = this.setupModifiers(paint, 6);
        try {
            GLES20Canvas.nDrawOval(this.mRenderer, oval.left, oval.top, oval.right, oval.bottom, paint.mNativePaint);
        }
        finally {
            if (modifiers != 0) {
                GLES20Canvas.nResetModifiers(this.mRenderer, modifiers);
            }
        }
    }

    private static native void nDrawOval(int var0, float var1, float var2, float var3, float var4, int var5);

    public void drawPaint(Paint paint) {
        Rect r = this.getInternalClipBounds();
        GLES20Canvas.nGetClipBounds(this.mRenderer, r);
        this.drawRect(r.left, r.top, r.right, r.bottom, paint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawPath(Path path, Paint paint) {
        int modifiers = this.setupModifiers(paint, 6);
        try {
            if (path.isSimplePath) {
                if (path.rects != null) {
                    GLES20Canvas.nDrawRects(this.mRenderer, path.rects.mNativeRegion, paint.mNativePaint);
                }
            } else {
                GLES20Canvas.nDrawPath(this.mRenderer, path.mNativePath, paint.mNativePaint);
            }
        }
        finally {
            if (modifiers != 0) {
                GLES20Canvas.nResetModifiers(this.mRenderer, modifiers);
            }
        }
    }

    private static native void nDrawPath(int var0, int var1, int var2);

    private static native void nDrawRects(int var0, int var1, int var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void drawRects(float[] rects, int count, Paint paint) {
        int modifiers = this.setupModifiers(paint, 6);
        try {
            GLES20Canvas.nDrawRects(this.mRenderer, rects, count, paint.mNativePaint);
        }
        finally {
            if (modifiers != 0) {
                GLES20Canvas.nResetModifiers(this.mRenderer, modifiers);
            }
        }
    }

    private static native void nDrawRects(int var0, float[] var1, int var2, int var3);

    public void drawPicture(Picture picture) {
        if (picture.createdFromStream) {
            return;
        }
        picture.endRecording();
    }

    public void drawPicture(Picture picture, Rect dst) {
        if (picture.createdFromStream) {
            return;
        }
        this.save();
        this.translate(dst.left, dst.top);
        if (picture.getWidth() > 0 && picture.getHeight() > 0) {
            this.scale(dst.width() / picture.getWidth(), dst.height() / picture.getHeight());
        }
        this.drawPicture(picture);
        this.restore();
    }

    public void drawPicture(Picture picture, RectF dst) {
        if (picture.createdFromStream) {
            return;
        }
        this.save();
        this.translate(dst.left, dst.top);
        if (picture.getWidth() > 0 && picture.getHeight() > 0) {
            this.scale(dst.width() / (float)picture.getWidth(), dst.height() / (float)picture.getHeight());
        }
        this.drawPicture(picture);
        this.restore();
    }

    public void drawPoint(float x, float y, Paint paint) {
        float[] point = this.getPointStorage();
        point[0] = x;
        point[1] = y;
        this.drawPoints(point, 0, 2, paint);
    }

    public void drawPoints(float[] pts, Paint paint) {
        this.drawPoints(pts, 0, pts.length, paint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawPoints(float[] pts, int offset, int count, Paint paint) {
        if (count < 2) {
            return;
        }
        int modifiers = this.setupModifiers(paint, 6);
        try {
            GLES20Canvas.nDrawPoints(this.mRenderer, pts, offset, count, paint.mNativePaint);
        }
        finally {
            if (modifiers != 0) {
                GLES20Canvas.nResetModifiers(this.mRenderer, modifiers);
            }
        }
    }

    private static native void nDrawPoints(int var0, float[] var1, int var2, int var3, int var4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawPosText(char[] text, int index, int count, float[] pos, Paint paint) {
        if (index < 0 || index + count > text.length || count * 2 > pos.length) {
            throw new IndexOutOfBoundsException();
        }
        int modifiers = this.setupModifiers(paint);
        try {
            GLES20Canvas.nDrawPosText(this.mRenderer, text, index, count, pos, paint.mNativePaint);
        }
        finally {
            if (modifiers != 0) {
                GLES20Canvas.nResetModifiers(this.mRenderer, modifiers);
            }
        }
    }

    private static native void nDrawPosText(int var0, char[] var1, int var2, int var3, float[] var4, int var5);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawPosText(String text, float[] pos, Paint paint) {
        if (text.length() * 2 > pos.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int modifiers = this.setupModifiers(paint);
        try {
            GLES20Canvas.nDrawPosText(this.mRenderer, text, 0, text.length(), pos, paint.mNativePaint);
        }
        finally {
            if (modifiers != 0) {
                GLES20Canvas.nResetModifiers(this.mRenderer, modifiers);
            }
        }
    }

    private static native void nDrawPosText(int var0, String var1, int var2, int var3, float[] var4, int var5);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawRect(float left, float top, float right, float bottom, Paint paint) {
        if (left == right || top == bottom) {
            return;
        }
        int modifiers = this.setupModifiers(paint, 6);
        try {
            GLES20Canvas.nDrawRect(this.mRenderer, left, top, right, bottom, paint.mNativePaint);
        }
        finally {
            if (modifiers != 0) {
                GLES20Canvas.nResetModifiers(this.mRenderer, modifiers);
            }
        }
    }

    private static native void nDrawRect(int var0, float var1, float var2, float var3, float var4, int var5);

    public void drawRect(Rect r, Paint paint) {
        this.drawRect(r.left, r.top, r.right, r.bottom, paint);
    }

    public void drawRect(RectF r, Paint paint) {
        this.drawRect(r.left, r.top, r.right, r.bottom, paint);
    }

    public void drawRGB(int r, int g, int b) {
        this.drawColor(0xFF000000 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawRoundRect(RectF rect, float rx, float ry, Paint paint) {
        int modifiers = this.setupModifiers(paint, 6);
        try {
            GLES20Canvas.nDrawRoundRect(this.mRenderer, rect.left, rect.top, rect.right, rect.bottom, rx, ry, paint.mNativePaint);
        }
        finally {
            if (modifiers != 0) {
                GLES20Canvas.nResetModifiers(this.mRenderer, modifiers);
            }
        }
    }

    private static native void nDrawRoundRect(int var0, float var1, float var2, float var3, float var4, float var5, float var6, int var7);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawText(char[] text, int index, int count, float x, float y, Paint paint) {
        if ((index | count | index + count | text.length - index - count) < 0) {
            throw new IndexOutOfBoundsException();
        }
        int modifiers = this.setupModifiers(paint);
        try {
            GLES20Canvas.nDrawText(this.mRenderer, text, index, count, x, y, paint.mBidiFlags, paint.mNativePaint);
        }
        finally {
            if (modifiers != 0) {
                GLES20Canvas.nResetModifiers(this.mRenderer, modifiers);
            }
        }
    }

    private static native void nDrawText(int var0, char[] var1, int var2, int var3, float var4, float var5, int var6, int var7);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawText(CharSequence text, int start, int end, float x, float y, Paint paint) {
        int modifiers = this.setupModifiers(paint);
        try {
            if (text instanceof String || text instanceof SpannedString || text instanceof SpannableString) {
                GLES20Canvas.nDrawText(this.mRenderer, ((Object)text).toString(), start, end, x, y, paint.mBidiFlags, paint.mNativePaint);
            } else if (text instanceof GraphicsOperations) {
                ((GraphicsOperations)text).drawText(this, start, end, x, y, paint);
            } else {
                char[] buf = TemporaryBuffer.obtain(end - start);
                TextUtils.getChars(text, start, end, buf, 0);
                GLES20Canvas.nDrawText(this.mRenderer, buf, 0, end - start, x, y, paint.mBidiFlags, paint.mNativePaint);
                TemporaryBuffer.recycle(buf);
            }
        }
        finally {
            if (modifiers != 0) {
                GLES20Canvas.nResetModifiers(this.mRenderer, modifiers);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawText(String text, int start, int end, float x, float y, Paint paint) {
        if ((start | end | end - start | text.length() - end) < 0) {
            throw new IndexOutOfBoundsException();
        }
        int modifiers = this.setupModifiers(paint);
        try {
            GLES20Canvas.nDrawText(this.mRenderer, text, start, end, x, y, paint.mBidiFlags, paint.mNativePaint);
        }
        finally {
            if (modifiers != 0) {
                GLES20Canvas.nResetModifiers(this.mRenderer, modifiers);
            }
        }
    }

    private static native void nDrawText(int var0, String var1, int var2, int var3, float var4, float var5, int var6, int var7);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawText(String text, float x, float y, Paint paint) {
        int modifiers = this.setupModifiers(paint);
        try {
            GLES20Canvas.nDrawText(this.mRenderer, text, 0, text.length(), x, y, paint.mBidiFlags, paint.mNativePaint);
        }
        finally {
            if (modifiers != 0) {
                GLES20Canvas.nResetModifiers(this.mRenderer, modifiers);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawTextOnPath(char[] text, int index, int count, Path path, float hOffset, float vOffset, Paint paint) {
        if (index < 0 || index + count > text.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int modifiers = this.setupModifiers(paint);
        try {
            GLES20Canvas.nDrawTextOnPath(this.mRenderer, text, index, count, path.mNativePath, hOffset, vOffset, paint.mBidiFlags, paint.mNativePaint);
        }
        finally {
            if (modifiers != 0) {
                GLES20Canvas.nResetModifiers(this.mRenderer, modifiers);
            }
        }
    }

    private static native void nDrawTextOnPath(int var0, char[] var1, int var2, int var3, int var4, float var5, float var6, int var7, int var8);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawTextOnPath(String text, Path path, float hOffset, float vOffset, Paint paint) {
        if (text.length() == 0) {
            return;
        }
        int modifiers = this.setupModifiers(paint);
        try {
            GLES20Canvas.nDrawTextOnPath(this.mRenderer, text, 0, text.length(), path.mNativePath, hOffset, vOffset, paint.mBidiFlags, paint.mNativePaint);
        }
        finally {
            if (modifiers != 0) {
                GLES20Canvas.nResetModifiers(this.mRenderer, modifiers);
            }
        }
    }

    private static native void nDrawTextOnPath(int var0, String var1, int var2, int var3, int var4, float var5, float var6, int var7, int var8);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawTextRun(char[] text, int index, int count, int contextIndex, int contextCount, float x, float y, int dir, Paint paint) {
        if ((index | count | text.length - index - count) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (dir != 0 && dir != 1) {
            throw new IllegalArgumentException("Unknown direction: " + dir);
        }
        int modifiers = this.setupModifiers(paint);
        try {
            GLES20Canvas.nDrawTextRun(this.mRenderer, text, index, count, contextIndex, contextCount, x, y, dir, paint.mNativePaint);
        }
        finally {
            if (modifiers != 0) {
                GLES20Canvas.nResetModifiers(this.mRenderer, modifiers);
            }
        }
    }

    private static native void nDrawTextRun(int var0, char[] var1, int var2, int var3, int var4, int var5, float var6, float var7, int var8, int var9);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawTextRun(CharSequence text, int start, int end, int contextStart, int contextEnd, float x, float y, int dir, Paint paint) {
        if ((start | end | end - start | text.length() - end) < 0) {
            throw new IndexOutOfBoundsException();
        }
        int modifiers = this.setupModifiers(paint);
        try {
            int flags;
            int n = flags = dir == 0 ? 0 : 1;
            if (text instanceof String || text instanceof SpannedString || text instanceof SpannableString) {
                GLES20Canvas.nDrawTextRun(this.mRenderer, ((Object)text).toString(), start, end, contextStart, contextEnd, x, y, flags, paint.mNativePaint);
            } else if (text instanceof GraphicsOperations) {
                ((GraphicsOperations)text).drawTextRun(this, start, end, contextStart, contextEnd, x, y, flags, paint);
            } else {
                int contextLen = contextEnd - contextStart;
                int len = end - start;
                char[] buf = TemporaryBuffer.obtain(contextLen);
                TextUtils.getChars(text, contextStart, contextEnd, buf, 0);
                GLES20Canvas.nDrawTextRun(this.mRenderer, buf, start - contextStart, len, 0, contextLen, x, y, flags, paint.mNativePaint);
                TemporaryBuffer.recycle(buf);
            }
        }
        finally {
            if (modifiers != 0) {
                GLES20Canvas.nResetModifiers(this.mRenderer, modifiers);
            }
        }
    }

    private static native void nDrawTextRun(int var0, String var1, int var2, int var3, int var4, int var5, float var6, float var7, int var8, int var9);

    public void drawVertices(Canvas.VertexMode mode, int vertexCount, float[] verts, int vertOffset, float[] texs, int texOffset, int[] colors, int colorOffset, short[] indices, int indexOffset, int indexCount, Paint paint) {
    }

    private int setupModifiers(Bitmap b, Paint paint) {
        if (b.getConfig() != Bitmap.Config.ALPHA_8) {
            ColorFilter filter = paint.getColorFilter();
            if (filter != null) {
                GLES20Canvas.nSetupColorFilter(this.mRenderer, filter.nativeColorFilter);
                return 4;
            }
            return 0;
        }
        return this.setupModifiers(paint);
    }

    private int setupModifiers(Paint paint) {
        ColorFilter filter;
        Shader shader;
        int modifiers = 0;
        if (paint.hasShadow) {
            GLES20Canvas.nSetupShadow(this.mRenderer, paint.shadowRadius, paint.shadowDx, paint.shadowDy, paint.shadowColor);
            modifiers |= 1;
        }
        if ((shader = paint.getShader()) != null) {
            GLES20Canvas.nSetupShader(this.mRenderer, shader.native_shader);
            modifiers |= 2;
        }
        if ((filter = paint.getColorFilter()) != null) {
            GLES20Canvas.nSetupColorFilter(this.mRenderer, filter.nativeColorFilter);
            modifiers |= 4;
        }
        return modifiers;
    }

    private int setupModifiers(Paint paint, int flags) {
        ColorFilter filter;
        Shader shader;
        int modifiers = 0;
        if (paint.hasShadow && (flags & 1) != 0) {
            GLES20Canvas.nSetupShadow(this.mRenderer, paint.shadowRadius, paint.shadowDx, paint.shadowDy, paint.shadowColor);
            modifiers |= 1;
        }
        if ((shader = paint.getShader()) != null && (flags & 2) != 0) {
            GLES20Canvas.nSetupShader(this.mRenderer, shader.native_shader);
            modifiers |= 2;
        }
        if ((filter = paint.getColorFilter()) != null && (flags & 4) != 0) {
            GLES20Canvas.nSetupColorFilter(this.mRenderer, filter.nativeColorFilter);
            modifiers |= 4;
        }
        return modifiers;
    }

    private int setupColorFilter(Paint paint) {
        ColorFilter filter = paint.getColorFilter();
        if (filter != null) {
            GLES20Canvas.nSetupColorFilter(this.mRenderer, filter.nativeColorFilter);
            return 4;
        }
        return 0;
    }

    private static native void nSetupShader(int var0, int var1);

    private static native void nSetupColorFilter(int var0, int var1);

    private static native void nSetupShadow(int var0, float var1, float var2, float var3, int var4);

    private static native void nResetModifiers(int var0, int var1);

    private static final class CanvasFinalizer {
        private final int mRenderer;

        public CanvasFinalizer(int renderer) {
            this.mRenderer = renderer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() throws Throwable {
            try {
                GLES20Canvas.nDestroyRenderer(this.mRenderer);
            }
            finally {
                super.finalize();
            }
        }
    }
}

