/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.graphics.Matrix;
import android.view.DisplayList;
import android.view.GLES20RecordingCanvas;
import android.view.HardwareCanvas;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GLES20DisplayList
extends DisplayList {
    private ArrayList<DisplayList> mChildDisplayLists;
    private GLES20RecordingCanvas mCanvas;
    private boolean mValid;
    private final String mName;
    private DisplayListFinalizer mFinalizer;

    GLES20DisplayList(String name) {
        this.mName = name;
    }

    boolean hasNativeDisplayList() {
        return this.mValid && this.mFinalizer != null;
    }

    int getNativeDisplayList() {
        if (!this.mValid || this.mFinalizer == null) {
            throw new IllegalStateException("The display list is not valid.");
        }
        return this.mFinalizer.mNativeDisplayList;
    }

    @Override
    public HardwareCanvas start(int width, int height) {
        if (this.mCanvas != null) {
            throw new IllegalStateException("Recording has already started");
        }
        this.mValid = false;
        this.mCanvas = GLES20RecordingCanvas.obtain(this);
        this.mCanvas.start();
        this.mCanvas.setViewport(width, height);
        this.mCanvas.onPreDraw(null);
        return this.mCanvas;
    }

    @Override
    public void clear() {
        this.clearDirty();
        if (this.mCanvas != null) {
            this.mCanvas.recycle();
            this.mCanvas = null;
        }
        this.mValid = false;
        this.clearReferences();
    }

    void clearReferences() {
        if (this.mChildDisplayLists != null) {
            this.mChildDisplayLists.clear();
        }
    }

    ArrayList<DisplayList> getChildDisplayLists() {
        if (this.mChildDisplayLists == null) {
            this.mChildDisplayLists = new ArrayList();
        }
        return this.mChildDisplayLists;
    }

    @Override
    public void reset() {
        if (this.hasNativeDisplayList()) {
            GLES20DisplayList.nReset(this.mFinalizer.mNativeDisplayList);
        }
        this.clear();
    }

    @Override
    public boolean isValid() {
        return this.mValid;
    }

    @Override
    public void end() {
        if (this.mCanvas != null) {
            this.mCanvas.onPostDraw();
            if (this.mFinalizer != null) {
                this.mCanvas.end(this.mFinalizer.mNativeDisplayList);
            } else {
                this.mFinalizer = new DisplayListFinalizer(this.mCanvas.end(0));
                GLES20DisplayList.nSetDisplayListName(this.mFinalizer.mNativeDisplayList, this.mName);
            }
            this.mCanvas.recycle();
            this.mCanvas = null;
            this.mValid = true;
        }
    }

    @Override
    public int getSize() {
        if (this.mFinalizer == null) {
            return 0;
        }
        return GLES20DisplayList.nGetDisplayListSize(this.mFinalizer.mNativeDisplayList);
    }

    private static native void nDestroyDisplayList(int var0);

    private static native int nGetDisplayListSize(int var0);

    private static native void nSetDisplayListName(int var0, String var1);

    @Override
    public void setCaching(boolean caching) {
        if (this.hasNativeDisplayList()) {
            GLES20DisplayList.nSetCaching(this.mFinalizer.mNativeDisplayList, caching);
        }
    }

    @Override
    public void setClipToBounds(boolean clipToBounds) {
        if (this.hasNativeDisplayList()) {
            GLES20DisplayList.nSetClipToBounds(this.mFinalizer.mNativeDisplayList, clipToBounds);
        }
    }

    @Override
    public void setMatrix(Matrix matrix) {
        if (this.hasNativeDisplayList()) {
            GLES20DisplayList.nSetStaticMatrix(this.mFinalizer.mNativeDisplayList, matrix.native_instance);
        }
    }

    @Override
    public Matrix getMatrix(Matrix matrix) {
        if (this.hasNativeDisplayList()) {
            GLES20DisplayList.nGetMatrix(this.mFinalizer.mNativeDisplayList, matrix.native_instance);
        }
        return matrix;
    }

    @Override
    public void setAnimationMatrix(Matrix matrix) {
        if (this.hasNativeDisplayList()) {
            GLES20DisplayList.nSetAnimationMatrix(this.mFinalizer.mNativeDisplayList, matrix != null ? matrix.native_instance : 0);
        }
    }

    @Override
    public void setAlpha(float alpha) {
        if (this.hasNativeDisplayList()) {
            GLES20DisplayList.nSetAlpha(this.mFinalizer.mNativeDisplayList, alpha);
        }
    }

    @Override
    public float getAlpha() {
        if (this.hasNativeDisplayList()) {
            return GLES20DisplayList.nGetAlpha(this.mFinalizer.mNativeDisplayList);
        }
        return 1.0f;
    }

    @Override
    public void setHasOverlappingRendering(boolean hasOverlappingRendering) {
        if (this.hasNativeDisplayList()) {
            GLES20DisplayList.nSetHasOverlappingRendering(this.mFinalizer.mNativeDisplayList, hasOverlappingRendering);
        }
    }

    @Override
    public boolean hasOverlappingRendering() {
        if (this.hasNativeDisplayList()) {
            return GLES20DisplayList.nHasOverlappingRendering(this.mFinalizer.mNativeDisplayList);
        }
        return true;
    }

    @Override
    public void setTranslationX(float translationX) {
        if (this.hasNativeDisplayList()) {
            GLES20DisplayList.nSetTranslationX(this.mFinalizer.mNativeDisplayList, translationX);
        }
    }

    @Override
    public float getTranslationX() {
        if (this.hasNativeDisplayList()) {
            return GLES20DisplayList.nGetTranslationX(this.mFinalizer.mNativeDisplayList);
        }
        return 0.0f;
    }

    @Override
    public void setTranslationY(float translationY) {
        if (this.hasNativeDisplayList()) {
            GLES20DisplayList.nSetTranslationY(this.mFinalizer.mNativeDisplayList, translationY);
        }
    }

    @Override
    public float getTranslationY() {
        if (this.hasNativeDisplayList()) {
            return GLES20DisplayList.nGetTranslationY(this.mFinalizer.mNativeDisplayList);
        }
        return 0.0f;
    }

    @Override
    public void setRotation(float rotation) {
        if (this.hasNativeDisplayList()) {
            GLES20DisplayList.nSetRotation(this.mFinalizer.mNativeDisplayList, rotation);
        }
    }

    @Override
    public float getRotation() {
        if (this.hasNativeDisplayList()) {
            return GLES20DisplayList.nGetRotation(this.mFinalizer.mNativeDisplayList);
        }
        return 0.0f;
    }

    @Override
    public void setRotationX(float rotationX) {
        if (this.hasNativeDisplayList()) {
            GLES20DisplayList.nSetRotationX(this.mFinalizer.mNativeDisplayList, rotationX);
        }
    }

    @Override
    public float getRotationX() {
        if (this.hasNativeDisplayList()) {
            return GLES20DisplayList.nGetRotationX(this.mFinalizer.mNativeDisplayList);
        }
        return 0.0f;
    }

    @Override
    public void setRotationY(float rotationY) {
        if (this.hasNativeDisplayList()) {
            GLES20DisplayList.nSetRotationY(this.mFinalizer.mNativeDisplayList, rotationY);
        }
    }

    @Override
    public float getRotationY() {
        if (this.hasNativeDisplayList()) {
            return GLES20DisplayList.nGetRotationY(this.mFinalizer.mNativeDisplayList);
        }
        return 0.0f;
    }

    @Override
    public void setScaleX(float scaleX) {
        if (this.hasNativeDisplayList()) {
            GLES20DisplayList.nSetScaleX(this.mFinalizer.mNativeDisplayList, scaleX);
        }
    }

    @Override
    public float getScaleX() {
        if (this.hasNativeDisplayList()) {
            return GLES20DisplayList.nGetScaleX(this.mFinalizer.mNativeDisplayList);
        }
        return 1.0f;
    }

    @Override
    public void setScaleY(float scaleY) {
        if (this.hasNativeDisplayList()) {
            GLES20DisplayList.nSetScaleY(this.mFinalizer.mNativeDisplayList, scaleY);
        }
    }

    @Override
    public float getScaleY() {
        if (this.hasNativeDisplayList()) {
            return GLES20DisplayList.nGetScaleY(this.mFinalizer.mNativeDisplayList);
        }
        return 1.0f;
    }

    @Override
    public void setTransformationInfo(float alpha, float translationX, float translationY, float rotation, float rotationX, float rotationY, float scaleX, float scaleY) {
        if (this.hasNativeDisplayList()) {
            GLES20DisplayList.nSetTransformationInfo(this.mFinalizer.mNativeDisplayList, alpha, translationX, translationY, rotation, rotationX, rotationY, scaleX, scaleY);
        }
    }

    @Override
    public void setPivotX(float pivotX) {
        if (this.hasNativeDisplayList()) {
            GLES20DisplayList.nSetPivotX(this.mFinalizer.mNativeDisplayList, pivotX);
        }
    }

    @Override
    public float getPivotX() {
        if (this.hasNativeDisplayList()) {
            return GLES20DisplayList.nGetPivotX(this.mFinalizer.mNativeDisplayList);
        }
        return 0.0f;
    }

    @Override
    public void setPivotY(float pivotY) {
        if (this.hasNativeDisplayList()) {
            GLES20DisplayList.nSetPivotY(this.mFinalizer.mNativeDisplayList, pivotY);
        }
    }

    @Override
    public float getPivotY() {
        if (this.hasNativeDisplayList()) {
            return GLES20DisplayList.nGetPivotY(this.mFinalizer.mNativeDisplayList);
        }
        return 0.0f;
    }

    @Override
    public void setCameraDistance(float distance) {
        if (this.hasNativeDisplayList()) {
            GLES20DisplayList.nSetCameraDistance(this.mFinalizer.mNativeDisplayList, distance);
        }
    }

    @Override
    public float getCameraDistance() {
        if (this.hasNativeDisplayList()) {
            return GLES20DisplayList.nGetCameraDistance(this.mFinalizer.mNativeDisplayList);
        }
        return 0.0f;
    }

    @Override
    public void setLeft(int left) {
        if (this.hasNativeDisplayList()) {
            GLES20DisplayList.nSetLeft(this.mFinalizer.mNativeDisplayList, left);
        }
    }

    @Override
    public float getLeft() {
        if (this.hasNativeDisplayList()) {
            return GLES20DisplayList.nGetLeft(this.mFinalizer.mNativeDisplayList);
        }
        return 0.0f;
    }

    @Override
    public void setTop(int top) {
        if (this.hasNativeDisplayList()) {
            GLES20DisplayList.nSetTop(this.mFinalizer.mNativeDisplayList, top);
        }
    }

    @Override
    public float getTop() {
        if (this.hasNativeDisplayList()) {
            return GLES20DisplayList.nGetTop(this.mFinalizer.mNativeDisplayList);
        }
        return 0.0f;
    }

    @Override
    public void setRight(int right) {
        if (this.hasNativeDisplayList()) {
            GLES20DisplayList.nSetRight(this.mFinalizer.mNativeDisplayList, right);
        }
    }

    @Override
    public float getRight() {
        if (this.hasNativeDisplayList()) {
            return GLES20DisplayList.nGetRight(this.mFinalizer.mNativeDisplayList);
        }
        return 0.0f;
    }

    @Override
    public void setBottom(int bottom) {
        if (this.hasNativeDisplayList()) {
            GLES20DisplayList.nSetBottom(this.mFinalizer.mNativeDisplayList, bottom);
        }
    }

    @Override
    public float getBottom() {
        if (this.hasNativeDisplayList()) {
            return GLES20DisplayList.nGetBottom(this.mFinalizer.mNativeDisplayList);
        }
        return 0.0f;
    }

    @Override
    public void setLeftTopRightBottom(int left, int top, int right, int bottom) {
        if (this.hasNativeDisplayList()) {
            GLES20DisplayList.nSetLeftTopRightBottom(this.mFinalizer.mNativeDisplayList, left, top, right, bottom);
        }
    }

    @Override
    public void offsetLeftAndRight(float offset) {
        if (this.hasNativeDisplayList()) {
            GLES20DisplayList.nOffsetLeftAndRight(this.mFinalizer.mNativeDisplayList, offset);
        }
    }

    @Override
    public void offsetTopAndBottom(float offset) {
        if (this.hasNativeDisplayList()) {
            GLES20DisplayList.nOffsetTopAndBottom(this.mFinalizer.mNativeDisplayList, offset);
        }
    }

    private static native void nReset(int var0);

    private static native void nOffsetTopAndBottom(int var0, float var1);

    private static native void nOffsetLeftAndRight(int var0, float var1);

    private static native void nSetLeftTopRightBottom(int var0, int var1, int var2, int var3, int var4);

    private static native void nSetBottom(int var0, int var1);

    private static native void nSetRight(int var0, int var1);

    private static native void nSetTop(int var0, int var1);

    private static native void nSetLeft(int var0, int var1);

    private static native void nSetCameraDistance(int var0, float var1);

    private static native void nSetPivotY(int var0, float var1);

    private static native void nSetPivotX(int var0, float var1);

    private static native void nSetCaching(int var0, boolean var1);

    private static native void nSetClipToBounds(int var0, boolean var1);

    private static native void nSetAlpha(int var0, float var1);

    private static native void nSetHasOverlappingRendering(int var0, boolean var1);

    private static native void nSetTranslationX(int var0, float var1);

    private static native void nSetTranslationY(int var0, float var1);

    private static native void nSetRotation(int var0, float var1);

    private static native void nSetRotationX(int var0, float var1);

    private static native void nSetRotationY(int var0, float var1);

    private static native void nSetScaleX(int var0, float var1);

    private static native void nSetScaleY(int var0, float var1);

    private static native void nSetTransformationInfo(int var0, float var1, float var2, float var3, float var4, float var5, float var6, float var7, float var8);

    private static native void nSetStaticMatrix(int var0, int var1);

    private static native void nSetAnimationMatrix(int var0, int var1);

    private static native boolean nHasOverlappingRendering(int var0);

    private static native void nGetMatrix(int var0, int var1);

    private static native float nGetAlpha(int var0);

    private static native float nGetLeft(int var0);

    private static native float nGetTop(int var0);

    private static native float nGetRight(int var0);

    private static native float nGetBottom(int var0);

    private static native float nGetCameraDistance(int var0);

    private static native float nGetScaleX(int var0);

    private static native float nGetScaleY(int var0);

    private static native float nGetTranslationX(int var0);

    private static native float nGetTranslationY(int var0);

    private static native float nGetRotation(int var0);

    private static native float nGetRotationX(int var0);

    private static native float nGetRotationY(int var0);

    private static native float nGetPivotX(int var0);

    private static native float nGetPivotY(int var0);

    private static class DisplayListFinalizer {
        final int mNativeDisplayList;

        public DisplayListFinalizer(int nativeDisplayList) {
            this.mNativeDisplayList = nativeDisplayList;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() throws Throwable {
            try {
                GLES20DisplayList.nDestroyDisplayList(this.mNativeDisplayList);
            }
            finally {
                super.finalize();
            }
        }
    }
}

