/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.content.ContentProvider;
import android.content.ContentValues;
import android.content.UriMatcher;
import android.database.Cursor;
import android.database.MatrixCursor;
import android.net.Uri;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.telephony.Rlog;
import android.text.TextUtils;
import com.android.internal.telephony.IIccPhoneBook;
import com.android.internal.telephony.uicc.AdnRecord;
import java.util.List;

public class IccProvider
extends ContentProvider {
    private static final String TAG = "IccProvider";
    private static final boolean DBG = false;
    private static final String[] ADDRESS_BOOK_COLUMN_NAMES = new String[]{"name", "number", "emails", "_id"};
    private static final int ADN = 1;
    private static final int FDN = 2;
    private static final int SDN = 3;
    private static final String STR_TAG = "tag";
    private static final String STR_NUMBER = "number";
    private static final String STR_EMAILS = "emails";
    private static final String STR_PIN2 = "pin2";
    private static final UriMatcher URL_MATCHER = new UriMatcher(-1);

    public boolean onCreate() {
        return true;
    }

    public Cursor query(Uri url, String[] projection, String selection, String[] selectionArgs, String sort) {
        switch (URL_MATCHER.match(url)) {
            case 1: {
                return this.loadFromEf(28474);
            }
            case 2: {
                return this.loadFromEf(28475);
            }
            case 3: {
                return this.loadFromEf(28489);
            }
        }
        throw new IllegalArgumentException("Unknown URL " + url);
    }

    public String getType(Uri url) {
        switch (URL_MATCHER.match(url)) {
            case 1: 
            case 2: 
            case 3: {
                return "vnd.android.cursor.dir/sim-contact";
            }
        }
        throw new IllegalArgumentException("Unknown URL " + url);
    }

    public Uri insert(Uri url, ContentValues initialValues) {
        int efType;
        String pin2 = null;
        int match = URL_MATCHER.match(url);
        switch (match) {
            case 1: {
                efType = 28474;
                break;
            }
            case 2: {
                efType = 28475;
                pin2 = initialValues.getAsString(STR_PIN2);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Cannot insert into URL: " + url);
            }
        }
        String tag = initialValues.getAsString(STR_TAG);
        String number = initialValues.getAsString(STR_NUMBER);
        boolean success = this.addIccRecordToEf(efType, tag, number, null, pin2);
        if (!success) {
            return null;
        }
        StringBuilder buf = new StringBuilder("content://icc/");
        switch (match) {
            case 1: {
                buf.append("adn/");
                break;
            }
            case 2: {
                buf.append("fdn/");
            }
        }
        buf.append(0);
        Uri resultUri = Uri.parse(buf.toString());
        return resultUri;
    }

    private String normalizeValue(String inVal) {
        int len = inVal.length();
        String retVal = inVal;
        if (inVal.charAt(0) == '\'' && inVal.charAt(len - 1) == '\'') {
            retVal = inVal.substring(1, len - 1);
        }
        return retVal;
    }

    public int delete(Uri url, String where, String[] whereArgs) {
        int efType;
        int match = URL_MATCHER.match(url);
        switch (match) {
            case 1: {
                efType = 28474;
                break;
            }
            case 2: {
                efType = 28475;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Cannot insert into URL: " + url);
            }
        }
        String tag = null;
        String number = null;
        Object emails = null;
        String pin2 = null;
        String[] tokens = where.split("AND");
        int n = tokens.length;
        while (--n >= 0) {
            String param = tokens[n];
            String[] pair = param.split("=", 2);
            String key = pair[0].trim();
            String val = pair[1].trim();
            if (STR_TAG.equals(key)) {
                tag = this.normalizeValue(val);
                continue;
            }
            if (STR_NUMBER.equals(key)) {
                number = this.normalizeValue(val);
                continue;
            }
            if (STR_EMAILS.equals(key)) {
                emails = null;
                continue;
            }
            if (!STR_PIN2.equals(key)) continue;
            pin2 = this.normalizeValue(val);
        }
        if (TextUtils.isEmpty(number)) {
            return 0;
        }
        if (efType == 28475 && TextUtils.isEmpty(pin2)) {
            return 0;
        }
        boolean success = this.deleteIccRecordFromEf(efType, tag, number, emails, pin2);
        if (!success) {
            return 0;
        }
        return 1;
    }

    public int update(Uri url, ContentValues values, String where, String[] whereArgs) {
        int efType;
        String pin2 = null;
        int match = URL_MATCHER.match(url);
        switch (match) {
            case 1: {
                efType = 28474;
                break;
            }
            case 2: {
                efType = 28475;
                pin2 = values.getAsString(STR_PIN2);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Cannot insert into URL: " + url);
            }
        }
        String tag = values.getAsString(STR_TAG);
        String number = values.getAsString(STR_NUMBER);
        Object emails = null;
        String newTag = values.getAsString("newTag");
        String newNumber = values.getAsString("newNumber");
        Object newEmails = null;
        boolean success = this.updateIccRecordInEf(efType, tag, number, newTag, newNumber, pin2);
        if (!success) {
            return 0;
        }
        return 1;
    }

    private MatrixCursor loadFromEf(int efType) {
        List<AdnRecord> adnRecords = null;
        try {
            IIccPhoneBook iccIpb = IIccPhoneBook.Stub.asInterface(ServiceManager.getService("simphonebook"));
            if (iccIpb != null) {
                adnRecords = iccIpb.getAdnRecordsInEf(efType);
            }
        }
        catch (RemoteException ex) {
        }
        catch (SecurityException ex) {
            // empty catch block
        }
        if (adnRecords != null) {
            int N = adnRecords.size();
            MatrixCursor cursor = new MatrixCursor(ADDRESS_BOOK_COLUMN_NAMES, N);
            for (int i = 0; i < N; ++i) {
                this.loadRecord(adnRecords.get(i), cursor, i);
            }
            return cursor;
        }
        Rlog.w(TAG, "Cannot load ADN records");
        return new MatrixCursor(ADDRESS_BOOK_COLUMN_NAMES);
    }

    private boolean addIccRecordToEf(int efType, String name, String number, String[] emails, String pin2) {
        boolean success = false;
        try {
            IIccPhoneBook iccIpb = IIccPhoneBook.Stub.asInterface(ServiceManager.getService("simphonebook"));
            if (iccIpb != null) {
                success = iccIpb.updateAdnRecordsInEfBySearch(efType, "", "", name, number, pin2);
            }
        }
        catch (RemoteException ex) {
        }
        catch (SecurityException ex) {
            // empty catch block
        }
        return success;
    }

    private boolean updateIccRecordInEf(int efType, String oldName, String oldNumber, String newName, String newNumber, String pin2) {
        boolean success = false;
        try {
            IIccPhoneBook iccIpb = IIccPhoneBook.Stub.asInterface(ServiceManager.getService("simphonebook"));
            if (iccIpb != null) {
                success = iccIpb.updateAdnRecordsInEfBySearch(efType, oldName, oldNumber, newName, newNumber, pin2);
            }
        }
        catch (RemoteException ex) {
        }
        catch (SecurityException ex) {
            // empty catch block
        }
        return success;
    }

    private boolean deleteIccRecordFromEf(int efType, String name, String number, String[] emails, String pin2) {
        boolean success = false;
        try {
            IIccPhoneBook iccIpb = IIccPhoneBook.Stub.asInterface(ServiceManager.getService("simphonebook"));
            if (iccIpb != null) {
                success = iccIpb.updateAdnRecordsInEfBySearch(efType, name, number, "", "", pin2);
            }
        }
        catch (RemoteException ex) {
        }
        catch (SecurityException ex) {
            // empty catch block
        }
        return success;
    }

    private void loadRecord(AdnRecord record, MatrixCursor cursor, int id2) {
        if (!record.isEmpty()) {
            Object[] contact = new Object[4];
            String alphaTag = record.getAlphaTag();
            String number = record.getNumber();
            contact[0] = alphaTag;
            contact[1] = number;
            String[] emails = record.getEmails();
            if (emails != null) {
                StringBuilder emailString = new StringBuilder();
                for (String email : emails) {
                    emailString.append(email);
                    emailString.append(",");
                }
                contact[2] = emailString.toString();
            }
            contact[3] = id2;
            cursor.addRow(contact);
        }
    }

    private void log(String msg) {
        Rlog.d(TAG, "[IccProvider] " + msg);
    }

    static {
        URL_MATCHER.addURI("icc", "adn", 1);
        URL_MATCHER.addURI("icc", "fdn", 2);
        URL_MATCHER.addURI("icc", "sdn", 3);
    }
}

