/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import java.util.ArrayList;

public abstract class IntRangeManager {
    private static final int INITIAL_CLIENTS_ARRAY_SIZE = 4;
    private ArrayList<IntRange> mRanges = new ArrayList();

    protected IntRangeManager() {
    }

    public synchronized boolean enableRange(int startId, int endId, String client) {
        int len = this.mRanges.size();
        if (len == 0) {
            if (this.tryAddRanges(startId, endId, true)) {
                this.mRanges.add(new IntRange(startId, endId, client));
                return true;
            }
            return false;
        }
        for (int startIndex = 0; startIndex < len; ++startIndex) {
            int newRangeEndId;
            IntRange range = this.mRanges.get(startIndex);
            if (startId >= range.mStartId && endId <= range.mEndId) {
                range.insert(new ClientRange(startId, endId, client));
                return true;
            }
            if (startId - 1 == range.mEndId) {
                int newRangeEndId2 = endId;
                IntRange nextRange = null;
                if (startIndex + 1 < len) {
                    nextRange = this.mRanges.get(startIndex + 1);
                    if (nextRange.mStartId - 1 <= endId) {
                        if (endId <= nextRange.mEndId) {
                            newRangeEndId2 = nextRange.mStartId - 1;
                        }
                    } else {
                        nextRange = null;
                    }
                }
                if (this.tryAddRanges(startId, newRangeEndId2, true)) {
                    range.mEndId = endId;
                    range.insert(new ClientRange(startId, endId, client));
                    if (nextRange != null) {
                        if (range.mEndId < nextRange.mEndId) {
                            range.mEndId = nextRange.mEndId;
                        }
                        range.mClients.addAll(nextRange.mClients);
                        this.mRanges.remove(nextRange);
                    }
                    return true;
                }
                return false;
            }
            if (startId < range.mStartId) {
                if (endId + 1 < range.mStartId) {
                    if (this.tryAddRanges(startId, endId, true)) {
                        this.mRanges.add(startIndex, new IntRange(startId, endId, client));
                        return true;
                    }
                    return false;
                }
                if (endId <= range.mEndId) {
                    if (this.tryAddRanges(startId, range.mStartId - 1, true)) {
                        range.mStartId = startId;
                        range.mClients.add(0, new ClientRange(startId, endId, client));
                        return true;
                    }
                    return false;
                }
                for (int endIndex = startIndex + 1; endIndex < len; ++endIndex) {
                    IntRange endRange = this.mRanges.get(endIndex);
                    if (endId + 1 < endRange.mStartId) {
                        if (this.tryAddRanges(startId, endId, true)) {
                            int joinIndex;
                            range.mStartId = startId;
                            range.mEndId = endId;
                            range.mClients.add(0, new ClientRange(startId, endId, client));
                            for (int i = joinIndex = startIndex + 1; i < endIndex; ++i) {
                                IntRange joinRange = this.mRanges.get(joinIndex);
                                range.mClients.addAll(joinRange.mClients);
                                this.mRanges.remove(joinRange);
                            }
                            return true;
                        }
                        return false;
                    }
                    if (endId > endRange.mEndId) continue;
                    if (this.tryAddRanges(startId, endRange.mStartId - 1, true)) {
                        int joinIndex;
                        range.mStartId = startId;
                        range.mEndId = endRange.mEndId;
                        range.mClients.add(0, new ClientRange(startId, endId, client));
                        for (int i = joinIndex = startIndex + 1; i <= endIndex; ++i) {
                            IntRange joinRange = this.mRanges.get(joinIndex);
                            range.mClients.addAll(joinRange.mClients);
                            this.mRanges.remove(joinRange);
                        }
                        return true;
                    }
                    return false;
                }
                if (this.tryAddRanges(startId, endId, true)) {
                    int joinIndex;
                    range.mStartId = startId;
                    range.mEndId = endId;
                    range.mClients.add(0, new ClientRange(startId, endId, client));
                    for (int i = joinIndex = startIndex + 1; i < len; ++i) {
                        IntRange joinRange = this.mRanges.get(joinIndex);
                        range.mClients.addAll(joinRange.mClients);
                        this.mRanges.remove(joinRange);
                    }
                    return true;
                }
                return false;
            }
            if (startId + 1 > range.mEndId) continue;
            if (endId <= range.mEndId) {
                range.insert(new ClientRange(startId, endId, client));
                return true;
            }
            int endIndex = startIndex;
            int testIndex = startIndex + 1;
            while (testIndex < len) {
                IntRange testRange = this.mRanges.get(testIndex);
                if (endId + 1 < testRange.mStartId) break;
                endIndex = testIndex++;
            }
            if (endIndex == startIndex) {
                if (this.tryAddRanges(range.mEndId + 1, endId, true)) {
                    range.mEndId = endId;
                    range.insert(new ClientRange(startId, endId, client));
                    return true;
                }
                return false;
            }
            IntRange endRange = this.mRanges.get(endIndex);
            int n = newRangeEndId = endId <= endRange.mEndId ? endRange.mStartId - 1 : endId;
            if (this.tryAddRanges(range.mEndId + 1, newRangeEndId, true)) {
                int joinIndex;
                range.mEndId = newRangeEndId = endId <= endRange.mEndId ? endRange.mEndId : endId;
                range.insert(new ClientRange(startId, endId, client));
                for (int i = joinIndex = startIndex + 1; i <= endIndex; ++i) {
                    IntRange joinRange = this.mRanges.get(joinIndex);
                    range.mClients.addAll(joinRange.mClients);
                    this.mRanges.remove(joinRange);
                }
                return true;
            }
            return false;
        }
        if (this.tryAddRanges(startId, endId, true)) {
            this.mRanges.add(new IntRange(startId, endId, client));
            return true;
        }
        return false;
    }

    public synchronized boolean disableRange(int startId, int endId, String client) {
        int len = this.mRanges.size();
        for (int i = 0; i < len; ++i) {
            IntRange range = this.mRanges.get(i);
            if (startId < range.mStartId) {
                return false;
            }
            if (endId > range.mEndId) continue;
            ArrayList<ClientRange> clients = range.mClients;
            int crLength = clients.size();
            if (crLength == 1) {
                ClientRange cr = clients.get(0);
                if (cr.mStartId == startId && cr.mEndId == endId && cr.mClient.equals(client)) {
                    this.mRanges.remove(i);
                    if (this.updateRanges()) {
                        return true;
                    }
                    this.mRanges.add(i, range);
                    return false;
                }
                return false;
            }
            int largestEndId = Integer.MIN_VALUE;
            boolean updateStarted = false;
            for (int crIndex = 0; crIndex < crLength; ++crIndex) {
                ClientRange cr = clients.get(crIndex);
                if (cr.mStartId == startId && cr.mEndId == endId && cr.mClient.equals(client)) {
                    if (crIndex == crLength - 1) {
                        if (range.mEndId == largestEndId) {
                            clients.remove(crIndex);
                            return true;
                        }
                        clients.remove(crIndex);
                        range.mEndId = largestEndId;
                        if (this.updateRanges()) {
                            return true;
                        }
                        clients.add(crIndex, cr);
                        range.mEndId = cr.mEndId;
                        return false;
                    }
                    IntRange rangeCopy = new IntRange(range, crIndex);
                    if (crIndex == 0) {
                        int nextStartId = clients.get((int)1).mStartId;
                        if (nextStartId != range.mStartId) {
                            updateStarted = true;
                            rangeCopy.mStartId = nextStartId;
                        }
                        largestEndId = clients.get((int)1).mEndId;
                    }
                    ArrayList<IntRange> newRanges = new ArrayList<IntRange>();
                    IntRange currentRange = rangeCopy;
                    for (int nextIndex = crIndex + 1; nextIndex < crLength; ++nextIndex) {
                        ClientRange nextCr = clients.get(nextIndex);
                        if (nextCr.mStartId > largestEndId + 1) {
                            updateStarted = true;
                            currentRange.mEndId = largestEndId;
                            newRanges.add(currentRange);
                            currentRange = new IntRange(nextCr);
                        } else {
                            if (currentRange.mEndId < nextCr.mEndId) {
                                currentRange.mEndId = nextCr.mEndId;
                            }
                            currentRange.mClients.add(nextCr);
                        }
                        if (nextCr.mEndId <= largestEndId) continue;
                        largestEndId = nextCr.mEndId;
                    }
                    if (largestEndId < endId) {
                        updateStarted = true;
                        currentRange.mEndId = largestEndId;
                    }
                    newRanges.add(currentRange);
                    this.mRanges.remove(i);
                    this.mRanges.addAll(i, newRanges);
                    if (updateStarted && !this.updateRanges()) {
                        this.mRanges.removeAll(newRanges);
                        this.mRanges.add(i, range);
                        return false;
                    }
                    return true;
                }
                if (cr.mEndId <= largestEndId) continue;
                largestEndId = cr.mEndId;
            }
        }
        return false;
    }

    public boolean updateRanges() {
        this.startUpdate();
        this.populateAllRanges();
        return this.finishUpdate();
    }

    protected boolean tryAddRanges(int startId, int endId, boolean selected) {
        this.startUpdate();
        this.populateAllRanges();
        this.addRange(startId, endId, selected);
        return this.finishUpdate();
    }

    public boolean isEmpty() {
        return this.mRanges.isEmpty();
    }

    private void populateAllRanges() {
        for (IntRange currRange : this.mRanges) {
            this.addRange(currRange.mStartId, currRange.mEndId, true);
        }
    }

    private void populateAllClientRanges() {
        int len = this.mRanges.size();
        for (int i = 0; i < len; ++i) {
            IntRange range = this.mRanges.get(i);
            int clientLen = range.mClients.size();
            for (int j = 0; j < clientLen; ++j) {
                ClientRange nextRange = range.mClients.get(j);
                this.addRange(nextRange.mStartId, nextRange.mEndId, true);
            }
        }
    }

    protected abstract void startUpdate();

    protected abstract void addRange(int var1, int var2, boolean var3);

    protected abstract boolean finishUpdate();

    private class ClientRange {
        final int mStartId;
        final int mEndId;
        final String mClient;

        ClientRange(int startId, int endId, String client) {
            this.mStartId = startId;
            this.mEndId = endId;
            this.mClient = client;
        }

        public boolean equals(Object o) {
            if (o != null && o instanceof ClientRange) {
                ClientRange other = (ClientRange)o;
                return this.mStartId == other.mStartId && this.mEndId == other.mEndId && this.mClient.equals(other.mClient);
            }
            return false;
        }

        public int hashCode() {
            return (this.mStartId * 31 + this.mEndId) * 31 + this.mClient.hashCode();
        }
    }

    private class IntRange {
        int mStartId;
        int mEndId;
        final ArrayList<ClientRange> mClients;

        IntRange(int startId, int endId, String client) {
            this.mStartId = startId;
            this.mEndId = endId;
            this.mClients = new ArrayList(4);
            this.mClients.add(new ClientRange(startId, endId, client));
        }

        IntRange(ClientRange clientRange) {
            this.mStartId = clientRange.mStartId;
            this.mEndId = clientRange.mEndId;
            this.mClients = new ArrayList(4);
            this.mClients.add(clientRange);
        }

        IntRange(IntRange intRange, int numElements) {
            this.mStartId = intRange.mStartId;
            this.mEndId = intRange.mEndId;
            this.mClients = new ArrayList(intRange.mClients.size());
            for (int i = 0; i < numElements; ++i) {
                this.mClients.add(intRange.mClients.get(i));
            }
        }

        void insert(ClientRange range) {
            int len = this.mClients.size();
            int insert = -1;
            for (int i = 0; i < len; ++i) {
                ClientRange nextRange = this.mClients.get(i);
                if (range.mStartId > nextRange.mStartId) continue;
                if (!range.equals(nextRange)) {
                    if (range.mStartId == nextRange.mStartId && range.mEndId > nextRange.mEndId) {
                        insert = i + 1;
                        if (insert >= len) break;
                        continue;
                    }
                    this.mClients.add(i, range);
                }
                return;
            }
            if (insert != -1 && insert < len) {
                this.mClients.add(insert, range);
                return;
            }
            this.mClients.add(range);
        }
    }
}

