/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.os.RemoteException;
import android.telephony.Rlog;
import com.android.internal.telephony.IWapPushManager;
import com.android.internal.telephony.InboundSmsHandler;
import com.android.internal.telephony.SmsApplication;
import com.android.internal.telephony.WspTypeDecoder;
import com.android.internal.telephony.uicc.IccUtils;

public class WapPushOverSms
implements ServiceConnection {
    private static final String TAG = "WAP PUSH";
    private static final boolean DBG = true;
    private final Context mContext;
    private volatile IWapPushManager mWapPushManager;

    public void onServiceConnected(ComponentName name, IBinder service) {
        this.mWapPushManager = IWapPushManager.Stub.asInterface(service);
        Rlog.v(TAG, "wappush manager connected to " + this.hashCode());
    }

    public void onServiceDisconnected(ComponentName name) {
        this.mWapPushManager = null;
        Rlog.v(TAG, "wappush manager disconnected.");
    }

    public WapPushOverSms(Context context) {
        this.mContext = context;
        Intent intent = new Intent(IWapPushManager.class.getName());
        ComponentName comp = intent.resolveSystemService(context.getPackageManager(), 0);
        intent.setComponent(comp);
        if (comp == null || !context.bindService(intent, this, 1)) {
            Rlog.e(TAG, "bindService() for wappush manager failed");
        } else {
            Rlog.v(TAG, "bindService() for wappush manager succeeded");
        }
    }

    void dispose() {
        if (this.mWapPushManager != null) {
            Rlog.v(TAG, "dispose: unbind wappush manager");
            this.mContext.unbindService(this);
        } else {
            Rlog.e(TAG, "dispose: not bound to a wappush manager");
        }
    }

    public int dispatchWapPdu(byte[] pdu, BroadcastReceiver receiver, InboundSmsHandler handler) {
        int appOp;
        String permission2;
        byte[] intentData;
        WspTypeDecoder pduDecoder;
        Rlog.d(TAG, "Rx: " + IccUtils.bytesToHexString(pdu));
        int index = 0;
        int transactionId = pdu[index++] & 0xFF;
        int pduType = pdu[index++] & 0xFF;
        if (pduType != 6 && pduType != 7) {
            index = this.mContext.getResources().getInteger(17694792);
            if (index != -1) {
                transactionId = pdu[index++] & 0xFF;
                pduType = pdu[index++] & 0xFF;
                Rlog.d(TAG, "index = " + index + " PDU Type = " + pduType + " transactionID = " + transactionId);
                if (pduType != 6 && pduType != 7) {
                    Rlog.w(TAG, "Received non-PUSH WAP PDU. Type = " + pduType);
                    return 1;
                }
            } else {
                Rlog.w(TAG, "Received non-PUSH WAP PDU. Type = " + pduType);
                return 1;
            }
        }
        if (!(pduDecoder = new WspTypeDecoder(pdu)).decodeUintvarInteger(index)) {
            Rlog.w(TAG, "Received PDU. Header Length error.");
            return 2;
        }
        int headerLength = (int)pduDecoder.getValue32();
        int headerStartIndex = index += pduDecoder.getDecodedDataLength();
        if (!pduDecoder.decodeContentType(index)) {
            Rlog.w(TAG, "Received PDU. Header Content-Type error.");
            return 2;
        }
        String mimeType = pduDecoder.getValueString();
        long binaryContentType = pduDecoder.getValue32();
        index += pduDecoder.getDecodedDataLength();
        byte[] header = new byte[headerLength];
        System.arraycopy(pdu, headerStartIndex, header, 0, header.length);
        if (mimeType != null && mimeType.equals("application/vnd.wap.coc")) {
            intentData = pdu;
        } else {
            int dataIndex = headerStartIndex + headerLength;
            intentData = new byte[pdu.length - dataIndex];
            System.arraycopy(pdu, dataIndex, intentData, 0, intentData.length);
        }
        if (pduDecoder.seekXWapApplicationId(index, index + headerLength - 1)) {
            index = (int)pduDecoder.getValue32();
            pduDecoder.decodeXWapApplicationId(index);
            String wapAppId = pduDecoder.getValueString();
            if (wapAppId == null) {
                wapAppId = Integer.toString((int)pduDecoder.getValue32());
            }
            String contentType = mimeType == null ? Long.toString(binaryContentType) : mimeType;
            Rlog.v(TAG, "appid found: " + wapAppId + ":" + contentType);
            try {
                boolean processFurther = true;
                IWapPushManager wapPushMan = this.mWapPushManager;
                if (wapPushMan == null) {
                    Rlog.w(TAG, "wap push manager not found!");
                } else {
                    Intent intent = new Intent();
                    intent.putExtra("transactionId", transactionId);
                    intent.putExtra("pduType", pduType);
                    intent.putExtra("header", header);
                    intent.putExtra("data", intentData);
                    intent.putExtra("contentTypeParameters", pduDecoder.getContentParameters());
                    int procRet = wapPushMan.processMessage(wapAppId, contentType, intent);
                    Rlog.v(TAG, "procRet:" + procRet);
                    if ((procRet & 1) > 0 && (procRet & 0x8000) == 0) {
                        processFurther = false;
                    }
                }
                if (!processFurther) {
                    return 1;
                }
            }
            catch (RemoteException e) {
                Rlog.w(TAG, "remote func failed...");
            }
        }
        Rlog.v(TAG, "fall back to existing handler");
        if (mimeType == null) {
            Rlog.w(TAG, "Header Content-Type error.");
            return 2;
        }
        if (mimeType.equals("application/vnd.wap.mms-message")) {
            permission2 = "android.permission.RECEIVE_MMS";
            appOp = 18;
        } else {
            permission2 = "android.permission.RECEIVE_WAP_PUSH";
            appOp = 19;
        }
        Intent intent = new Intent("android.provider.Telephony.WAP_PUSH_DELIVER");
        intent.setType(mimeType);
        intent.putExtra("transactionId", transactionId);
        intent.putExtra("pduType", pduType);
        intent.putExtra("header", header);
        intent.putExtra("data", intentData);
        intent.putExtra("contentTypeParameters", pduDecoder.getContentParameters());
        ComponentName componentName = SmsApplication.getDefaultMmsApplication(this.mContext, true);
        if (componentName != null) {
            intent.setComponent(componentName);
            Rlog.v(TAG, "Delivering MMS to: " + componentName.getPackageName() + " " + componentName.getClassName());
        }
        handler.dispatchIntent(intent, permission2, appOp, receiver);
        return -1;
    }
}

