/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.cat;

import com.android.internal.telephony.cat.ComprehensionTlv;
import com.android.internal.telephony.cat.ComprehensionTlvTag;
import com.android.internal.telephony.cat.ResultCode;
import com.android.internal.telephony.cat.ResultException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BerTlv {
    private int mTag = 0;
    private List<ComprehensionTlv> mCompTlvs = null;
    private boolean mLengthValid = true;
    public static final int BER_UNKNOWN_TAG = 0;
    public static final int BER_PROACTIVE_COMMAND_TAG = 208;
    public static final int BER_MENU_SELECTION_TAG = 211;
    public static final int BER_EVENT_DOWNLOAD_TAG = 214;

    private BerTlv(int tag, List<ComprehensionTlv> ctlvs, boolean lengthValid) {
        this.mTag = tag;
        this.mCompTlvs = ctlvs;
        this.mLengthValid = lengthValid;
    }

    public List<ComprehensionTlv> getComprehensionTlvs() {
        return this.mCompTlvs;
    }

    public int getTag() {
        return this.mTag;
    }

    public boolean isLengthValid() {
        return this.mLengthValid;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static BerTlv decode(byte[] data) throws ResultException {
        int tag;
        int curIndex = 0;
        int endIndex = data.length;
        int length = 0;
        boolean isLengthValid = true;
        try {
            tag = data[curIndex++] & 0xFF;
            if (tag == 208) {
                int temp;
                if ((temp = data[curIndex++] & 0xFF) < 128) {
                    length = temp;
                } else {
                    if (temp != 129) throw new ResultException(ResultCode.CMD_DATA_NOT_UNDERSTOOD, "Expected first byte to be length or a length tag and < 0x81 byte= " + Integer.toHexString(temp) + " curIndex=" + curIndex + " endIndex=" + endIndex);
                    if ((temp = data[curIndex++] & 0xFF) < 128) {
                        throw new ResultException(ResultCode.CMD_DATA_NOT_UNDERSTOOD, "length < 0x80 length=" + Integer.toHexString(length) + " curIndex=" + curIndex + " endIndex=" + endIndex);
                    }
                    length = temp;
                }
            } else if (ComprehensionTlvTag.COMMAND_DETAILS.value() == (tag & 0xFFFFFF7F)) {
                tag = 0;
                curIndex = 0;
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw new ResultException(ResultCode.REQUIRED_VALUES_MISSING, "IndexOutOfBoundsException  curIndex=" + curIndex + " endIndex=" + endIndex);
        }
        catch (ResultException e) {
            throw new ResultException(ResultCode.CMD_DATA_NOT_UNDERSTOOD, e.explanation());
        }
        if (endIndex - curIndex < length) {
            throw new ResultException(ResultCode.CMD_DATA_NOT_UNDERSTOOD, "Command had extra data endIndex=" + endIndex + " curIndex=" + curIndex + " length=" + length);
        }
        List<ComprehensionTlv> ctlvs = ComprehensionTlv.decodeMany(data, curIndex);
        if (tag != 208) return new BerTlv(tag, ctlvs, isLengthValid);
        int totalLength = 0;
        for (ComprehensionTlv item : ctlvs) {
            int itemLength = item.getLength();
            if (itemLength >= 128 && itemLength <= 255) {
                totalLength += itemLength + 3;
                continue;
            }
            if (itemLength >= 0 && itemLength < 128) {
                totalLength += itemLength + 2;
                continue;
            }
            isLengthValid = false;
            break;
        }
        if (length == totalLength) return new BerTlv(tag, ctlvs, isLengthValid);
        isLengthValid = false;
        return new BerTlv(tag, ctlvs, isLengthValid);
    }
}

