/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.gsm;

import android.os.AsyncResult;
import android.os.Handler;
import android.os.Message;
import android.telephony.PhoneNumberUtils;
import android.telephony.Rlog;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.cat.ComprehensionTlvTag;
import com.android.internal.telephony.gsm.SmsMessage;
import com.android.internal.telephony.uicc.IccIoResult;
import com.android.internal.telephony.uicc.IccUtils;
import com.android.internal.telephony.uicc.UsimServiceTable;

public class UsimDataDownloadHandler
extends Handler {
    private static final String TAG = "UsimDataDownloadHandler";
    private static final int BER_SMS_PP_DOWNLOAD_TAG = 209;
    private static final int DEV_ID_UICC = 129;
    private static final int DEV_ID_NETWORK = 131;
    private static final int EVENT_START_DATA_DOWNLOAD = 1;
    private static final int EVENT_SEND_ENVELOPE_RESPONSE = 2;
    private static final int EVENT_WRITE_SMS_COMPLETE = 3;
    private final CommandsInterface mCi;

    public UsimDataDownloadHandler(CommandsInterface commandsInterface) {
        this.mCi = commandsInterface;
    }

    int handleUsimDataDownload(UsimServiceTable ust, SmsMessage smsMessage) {
        if (ust != null && ust.isAvailable(UsimServiceTable.UsimService.DATA_DL_VIA_SMS_PP)) {
            Rlog.d(TAG, "Received SMS-PP data download, sending to UICC.");
            return this.startDataDownload(smsMessage);
        }
        Rlog.d(TAG, "DATA_DL_VIA_SMS_PP service not available, storing message to UICC.");
        String smsc = IccUtils.bytesToHexString(PhoneNumberUtils.networkPortionToCalledPartyBCDWithLength(smsMessage.getServiceCenterAddress()));
        this.mCi.writeSmsToSim(3, smsc, IccUtils.bytesToHexString(smsMessage.getPdu()), this.obtainMessage(3));
        return -1;
    }

    public int startDataDownload(SmsMessage smsMessage) {
        if (this.sendMessage(this.obtainMessage(1, smsMessage))) {
            return -1;
        }
        Rlog.e(TAG, "startDataDownload failed to send message to start data download.");
        return 2;
    }

    private void handleDataDownload(SmsMessage smsMessage) {
        int tpduIndex;
        int tpduLength;
        int bodyLength;
        int dcs = smsMessage.getDataCodingScheme();
        int pid = smsMessage.getProtocolIdentifier();
        byte[] pdu = smsMessage.getPdu();
        int scAddressLength = pdu[0] & 0xFF;
        int totalLength = bodyLength + 1 + ((bodyLength = UsimDataDownloadHandler.getEnvelopeBodyLength(scAddressLength, tpduLength = pdu.length - (tpduIndex = scAddressLength + 1))) > 127 ? 2 : 1);
        byte[] envelope = new byte[totalLength];
        int index = 0;
        envelope[index++] = -47;
        if (bodyLength > 127) {
            envelope[index++] = -127;
        }
        envelope[index++] = (byte)bodyLength;
        envelope[index++] = (byte)(0x80 | ComprehensionTlvTag.DEVICE_IDENTITIES.value());
        envelope[index++] = 2;
        envelope[index++] = -125;
        envelope[index++] = -127;
        if (scAddressLength != 0) {
            envelope[index++] = (byte)ComprehensionTlvTag.ADDRESS.value();
            envelope[index++] = (byte)scAddressLength;
            System.arraycopy(pdu, 1, envelope, index, scAddressLength);
            index += scAddressLength;
        }
        envelope[index++] = (byte)(0x80 | ComprehensionTlvTag.SMS_TPDU.value());
        if (tpduLength > 127) {
            envelope[index++] = -127;
        }
        envelope[index++] = (byte)tpduLength;
        System.arraycopy(pdu, tpduIndex, envelope, index, tpduLength);
        if ((index += tpduLength) != envelope.length) {
            Rlog.e(TAG, "startDataDownload() calculated incorrect envelope length, aborting.");
            this.acknowledgeSmsWithError(255);
            return;
        }
        String encodedEnvelope = IccUtils.bytesToHexString(envelope);
        this.mCi.sendEnvelopeWithStatus(encodedEnvelope, this.obtainMessage(2, new int[]{dcs, pid}));
    }

    private static int getEnvelopeBodyLength(int scAddressLength, int tpduLength) {
        int length = tpduLength + 5;
        length += tpduLength > 127 ? 2 : 1;
        if (scAddressLength != 0) {
            length = length + 2 + scAddressLength;
        }
        return length;
    }

    private void sendSmsAckForEnvelopeResponse(IccIoResult response, int dcs, int pid) {
        byte[] smsAckPdu;
        boolean success;
        int sw1 = response.sw1;
        int sw2 = response.sw2;
        if (sw1 == 144 && sw2 == 0 || sw1 == 145) {
            Rlog.d(TAG, "USIM data download succeeded: " + response.toString());
            success = true;
        } else {
            if (sw1 == 147 && sw2 == 0) {
                Rlog.e(TAG, "USIM data download failed: Toolkit busy");
                this.acknowledgeSmsWithError(212);
                return;
            }
            if (sw1 == 98 || sw1 == 99) {
                Rlog.e(TAG, "USIM data download failed: " + response.toString());
                success = false;
            } else {
                Rlog.e(TAG, "Unexpected SW1/SW2 response from UICC: " + response.toString());
                success = false;
            }
        }
        byte[] responseBytes = response.payload;
        if (responseBytes == null || responseBytes.length == 0) {
            if (success) {
                this.mCi.acknowledgeLastIncomingGsmSms(true, 0, null);
            } else {
                this.acknowledgeSmsWithError(213);
            }
            return;
        }
        int index = 0;
        if (success) {
            smsAckPdu = new byte[responseBytes.length + 5];
            smsAckPdu[index++] = 0;
            smsAckPdu[index++] = 7;
        } else {
            smsAckPdu = new byte[responseBytes.length + 6];
            smsAckPdu[index++] = 0;
            smsAckPdu[index++] = -43;
            smsAckPdu[index++] = 7;
        }
        smsAckPdu[index++] = (byte)pid;
        smsAckPdu[index++] = (byte)dcs;
        if (UsimDataDownloadHandler.is7bitDcs(dcs)) {
            int septetCount = responseBytes.length * 8 / 7;
            smsAckPdu[index++] = (byte)septetCount;
        } else {
            smsAckPdu[index++] = (byte)responseBytes.length;
        }
        System.arraycopy(responseBytes, 0, smsAckPdu, index, responseBytes.length);
        this.mCi.acknowledgeIncomingGsmSmsWithPdu(success, IccUtils.bytesToHexString(smsAckPdu), null);
    }

    private void acknowledgeSmsWithError(int cause) {
        this.mCi.acknowledgeLastIncomingGsmSms(false, cause, null);
    }

    private static boolean is7bitDcs(int dcs) {
        return (dcs & 0x8C) == 0 || (dcs & 0xF4) == 240;
    }

    public void handleMessage(Message msg) {
        switch (msg.what) {
            case 1: {
                this.handleDataDownload((SmsMessage)msg.obj);
                break;
            }
            case 2: {
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception != null) {
                    Rlog.e(TAG, "UICC Send Envelope failure, exception: " + ar.exception);
                    this.acknowledgeSmsWithError(213);
                    return;
                }
                int[] dcsPid = (int[])ar.userObj;
                this.sendSmsAckForEnvelopeResponse((IccIoResult)ar.result, dcsPid[0], dcsPid[1]);
                break;
            }
            case 3: {
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception == null) {
                    Rlog.d(TAG, "Successfully wrote SMS-PP message to UICC");
                    this.mCi.acknowledgeLastIncomingGsmSms(true, 0, null);
                    break;
                }
                Rlog.d(TAG, "Failed to write SMS-PP message to UICC", ar.exception);
                this.mCi.acknowledgeLastIncomingGsmSms(false, 255, null);
                break;
            }
            default: {
                Rlog.e(TAG, "Ignoring unexpected message, what=" + msg.what);
            }
        }
    }
}

