/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.test;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.telephony.PhoneNumberUtils;
import android.telephony.Rlog;
import com.android.internal.telephony.DriverCall;
import com.android.internal.telephony.test.CallInfo;
import com.android.internal.telephony.test.InvalidStateEx;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SimulatedGsmCallState
extends Handler {
    CallInfo[] mCalls = new CallInfo[7];
    private boolean mAutoProgressConnecting = true;
    private boolean mNextDialFailImmediately;
    static final int EVENT_PROGRESS_CALL_STATE = 1;
    static final int MAX_CALLS = 7;
    static final int CONNECTING_PAUSE_MSEC = 500;

    public SimulatedGsmCallState(Looper looper) {
        super(looper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleMessage(Message msg) {
        SimulatedGsmCallState simulatedGsmCallState = this;
        synchronized (simulatedGsmCallState) {
            switch (msg.what) {
                case 1: {
                    this.progressConnectingCallState();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean triggerRing(String number) {
        SimulatedGsmCallState simulatedGsmCallState = this;
        synchronized (simulatedGsmCallState) {
            int empty = -1;
            boolean isCallWaiting = false;
            for (int i = 0; i < this.mCalls.length; ++i) {
                CallInfo call = this.mCalls[i];
                if (call == null && empty < 0) {
                    empty = i;
                    continue;
                }
                if (call != null && (call.mState == CallInfo.State.INCOMING || call.mState == CallInfo.State.WAITING)) {
                    Rlog.w("ModelInterpreter", "triggerRing failed; phone already ringing");
                    return false;
                }
                if (call == null) continue;
                isCallWaiting = true;
            }
            if (empty < 0) {
                Rlog.w("ModelInterpreter", "triggerRing failed; all full");
                return false;
            }
            this.mCalls[empty] = CallInfo.createIncomingCall(PhoneNumberUtils.extractNetworkPortion(number));
            if (isCallWaiting) {
                this.mCalls[empty].mState = CallInfo.State.WAITING;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void progressConnectingCallState() {
        SimulatedGsmCallState simulatedGsmCallState = this;
        synchronized (simulatedGsmCallState) {
            for (int i = 0; i < this.mCalls.length; ++i) {
                CallInfo call = this.mCalls[i];
                if (call != null && call.mState == CallInfo.State.DIALING) {
                    call.mState = CallInfo.State.ALERTING;
                    if (!this.mAutoProgressConnecting) break;
                    this.sendMessageDelayed(this.obtainMessage(1, call), 500L);
                    break;
                }
                if (call == null || call.mState != CallInfo.State.ALERTING) continue;
                call.mState = CallInfo.State.ACTIVE;
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void progressConnectingToActive() {
        SimulatedGsmCallState simulatedGsmCallState = this;
        synchronized (simulatedGsmCallState) {
            for (int i = 0; i < this.mCalls.length; ++i) {
                CallInfo call = this.mCalls[i];
                if (call == null || call.mState != CallInfo.State.DIALING && call.mState != CallInfo.State.ALERTING) continue;
                call.mState = CallInfo.State.ACTIVE;
                break;
            }
        }
    }

    public void setAutoProgressConnectingCall(boolean b) {
        this.mAutoProgressConnecting = b;
    }

    public void setNextDialFailImmediately(boolean b) {
        this.mNextDialFailImmediately = b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean triggerHangupForeground() {
        SimulatedGsmCallState simulatedGsmCallState = this;
        synchronized (simulatedGsmCallState) {
            CallInfo call;
            int i;
            boolean found = false;
            for (i = 0; i < this.mCalls.length; ++i) {
                call = this.mCalls[i];
                if (call == null || call.mState != CallInfo.State.INCOMING && call.mState != CallInfo.State.WAITING) continue;
                this.mCalls[i] = null;
                found = true;
            }
            for (i = 0; i < this.mCalls.length; ++i) {
                call = this.mCalls[i];
                if (call == null || call.mState != CallInfo.State.DIALING && call.mState != CallInfo.State.ACTIVE && call.mState != CallInfo.State.ALERTING) continue;
                this.mCalls[i] = null;
                found = true;
            }
            return found;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean triggerHangupBackground() {
        SimulatedGsmCallState simulatedGsmCallState = this;
        synchronized (simulatedGsmCallState) {
            boolean found = false;
            for (int i = 0; i < this.mCalls.length; ++i) {
                CallInfo call = this.mCalls[i];
                if (call == null || call.mState != CallInfo.State.HOLDING) continue;
                this.mCalls[i] = null;
                found = true;
            }
            return found;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean triggerHangupAll() {
        SimulatedGsmCallState simulatedGsmCallState = this;
        synchronized (simulatedGsmCallState) {
            boolean found = false;
            for (int i = 0; i < this.mCalls.length; ++i) {
                CallInfo call = this.mCalls[i];
                if (this.mCalls[i] != null) {
                    found = true;
                }
                this.mCalls[i] = null;
            }
            return found;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onAnswer() {
        SimulatedGsmCallState simulatedGsmCallState = this;
        synchronized (simulatedGsmCallState) {
            for (int i = 0; i < this.mCalls.length; ++i) {
                CallInfo call = this.mCalls[i];
                if (call == null || call.mState != CallInfo.State.INCOMING && call.mState != CallInfo.State.WAITING) continue;
                return this.switchActiveAndHeldOrWaiting();
            }
        }
        return false;
    }

    public boolean onHangup() {
        boolean found = false;
        for (int i = 0; i < this.mCalls.length; ++i) {
            CallInfo call = this.mCalls[i];
            if (call == null || call.mState == CallInfo.State.WAITING) continue;
            this.mCalls[i] = null;
            found = true;
        }
        return found;
    }

    public boolean onChld(char c0, char c1) {
        boolean ret;
        int callIndex = 0;
        if (c1 != '\u0000' && ((callIndex = c1 - 49) < 0 || callIndex >= this.mCalls.length)) {
            return false;
        }
        switch (c0) {
            case '0': {
                ret = this.releaseHeldOrUDUB();
                break;
            }
            case '1': {
                if (c1 <= '\u0000') {
                    ret = this.releaseActiveAcceptHeldOrWaiting();
                    break;
                }
                if (this.mCalls[callIndex] == null) {
                    ret = false;
                    break;
                }
                this.mCalls[callIndex] = null;
                ret = true;
                break;
            }
            case '2': {
                if (c1 <= '\u0000') {
                    ret = this.switchActiveAndHeldOrWaiting();
                    break;
                }
                ret = this.separateCall(callIndex);
                break;
            }
            case '3': {
                ret = this.conference();
                break;
            }
            case '4': {
                ret = this.explicitCallTransfer();
                break;
            }
            case '5': {
                ret = false;
                break;
            }
            default: {
                ret = false;
            }
        }
        return ret;
    }

    public boolean releaseHeldOrUDUB() {
        CallInfo c;
        int i;
        boolean found = false;
        for (i = 0; i < this.mCalls.length; ++i) {
            c = this.mCalls[i];
            if (c == null || !c.isRinging()) continue;
            found = true;
            this.mCalls[i] = null;
            break;
        }
        if (!found) {
            for (i = 0; i < this.mCalls.length; ++i) {
                c = this.mCalls[i];
                if (c == null || c.mState != CallInfo.State.HOLDING) continue;
                found = true;
                this.mCalls[i] = null;
            }
        }
        return true;
    }

    public boolean releaseActiveAcceptHeldOrWaiting() {
        CallInfo c;
        int i;
        boolean foundHeld = false;
        boolean foundActive = false;
        for (i = 0; i < this.mCalls.length; ++i) {
            c = this.mCalls[i];
            if (c == null || c.mState != CallInfo.State.ACTIVE) continue;
            this.mCalls[i] = null;
            foundActive = true;
        }
        if (!foundActive) {
            for (i = 0; i < this.mCalls.length; ++i) {
                c = this.mCalls[i];
                if (c == null || c.mState != CallInfo.State.DIALING && c.mState != CallInfo.State.ALERTING) continue;
                this.mCalls[i] = null;
                foundActive = true;
            }
        }
        for (i = 0; i < this.mCalls.length; ++i) {
            c = this.mCalls[i];
            if (c == null || c.mState != CallInfo.State.HOLDING) continue;
            c.mState = CallInfo.State.ACTIVE;
            foundHeld = true;
        }
        if (foundHeld) {
            return true;
        }
        for (i = 0; i < this.mCalls.length; ++i) {
            c = this.mCalls[i];
            if (c == null || !c.isRinging()) continue;
            c.mState = CallInfo.State.ACTIVE;
            return true;
        }
        return true;
    }

    public boolean switchActiveAndHeldOrWaiting() {
        CallInfo c;
        int i;
        boolean hasHeld = false;
        for (i = 0; i < this.mCalls.length; ++i) {
            c = this.mCalls[i];
            if (c == null || c.mState != CallInfo.State.HOLDING) continue;
            hasHeld = true;
            break;
        }
        for (i = 0; i < this.mCalls.length; ++i) {
            c = this.mCalls[i];
            if (c == null) continue;
            if (c.mState == CallInfo.State.ACTIVE) {
                c.mState = CallInfo.State.HOLDING;
                continue;
            }
            if (c.mState == CallInfo.State.HOLDING) {
                c.mState = CallInfo.State.ACTIVE;
                continue;
            }
            if (hasHeld || !c.isRinging()) continue;
            c.mState = CallInfo.State.ACTIVE;
        }
        return true;
    }

    public boolean separateCall(int index) {
        try {
            CallInfo c = this.mCalls[index];
            if (c == null || c.isConnecting() || this.countActiveLines() != 1) {
                return false;
            }
            c.mState = CallInfo.State.ACTIVE;
            c.mIsMpty = false;
            for (int i = 0; i < this.mCalls.length; ++i) {
                CallInfo cb;
                int countHeld = 0;
                int lastHeld = 0;
                if (i != index && (cb = this.mCalls[i]) != null && cb.mState == CallInfo.State.ACTIVE) {
                    cb.mState = CallInfo.State.HOLDING;
                    ++countHeld;
                    lastHeld = i;
                }
                if (countHeld != true) continue;
                this.mCalls[lastHeld].mIsMpty = false;
            }
            return true;
        }
        catch (InvalidStateEx ex) {
            return false;
        }
    }

    public boolean conference() {
        CallInfo c;
        int i;
        int countCalls = 0;
        for (i = 0; i < this.mCalls.length; ++i) {
            c = this.mCalls[i];
            if (c == null) continue;
            ++countCalls;
            if (!c.isConnecting()) continue;
            return false;
        }
        for (i = 0; i < this.mCalls.length; ++i) {
            c = this.mCalls[i];
            if (c == null) continue;
            c.mState = CallInfo.State.ACTIVE;
            if (countCalls <= 0) continue;
            c.mIsMpty = true;
        }
        return true;
    }

    public boolean explicitCallTransfer() {
        int countCalls = 0;
        for (int i = 0; i < this.mCalls.length; ++i) {
            CallInfo c = this.mCalls[i];
            if (c == null) continue;
            ++countCalls;
            if (!c.isConnecting()) continue;
            return false;
        }
        return this.triggerHangupAll();
    }

    public boolean onDial(String address) {
        int freeSlot = -1;
        Rlog.d("GSM", "SC> dial '" + address + "'");
        if (this.mNextDialFailImmediately) {
            this.mNextDialFailImmediately = false;
            Rlog.d("GSM", "SC< dial fail (per request)");
            return false;
        }
        String phNum = PhoneNumberUtils.extractNetworkPortion(address);
        if (phNum.length() == 0) {
            Rlog.d("GSM", "SC< dial fail (invalid ph num)");
            return false;
        }
        if (phNum.startsWith("*99") && phNum.endsWith("#")) {
            Rlog.d("GSM", "SC< dial ignored (gprs)");
            return true;
        }
        try {
            if (this.countActiveLines() > 1) {
                Rlog.d("GSM", "SC< dial fail (invalid call state)");
                return false;
            }
        }
        catch (InvalidStateEx ex) {
            Rlog.d("GSM", "SC< dial fail (invalid call state)");
            return false;
        }
        for (int i = 0; i < this.mCalls.length; ++i) {
            if (freeSlot < 0 && this.mCalls[i] == null) {
                freeSlot = i;
            }
            if (this.mCalls[i] != null && !this.mCalls[i].isActiveOrHeld()) {
                Rlog.d("GSM", "SC< dial fail (invalid call state)");
                return false;
            }
            if (this.mCalls[i] == null || this.mCalls[i].mState != CallInfo.State.ACTIVE) continue;
            this.mCalls[i].mState = CallInfo.State.HOLDING;
        }
        if (freeSlot < 0) {
            Rlog.d("GSM", "SC< dial fail (invalid call state)");
            return false;
        }
        this.mCalls[freeSlot] = CallInfo.createOutgoingCall(phNum);
        if (this.mAutoProgressConnecting) {
            this.sendMessageDelayed(this.obtainMessage(1, this.mCalls[freeSlot]), 500L);
        }
        Rlog.d("GSM", "SC< dial (slot = " + freeSlot + ")");
        return true;
    }

    public List<DriverCall> getDriverCalls() {
        ArrayList<DriverCall> ret = new ArrayList<DriverCall>(this.mCalls.length);
        for (int i = 0; i < this.mCalls.length; ++i) {
            CallInfo c = this.mCalls[i];
            if (c == null) continue;
            DriverCall dc = c.toDriverCall(i + 1);
            ret.add(dc);
        }
        Rlog.d("GSM", "SC< getDriverCalls " + ret);
        return ret;
    }

    public List<String> getClccLines() {
        ArrayList<String> ret = new ArrayList<String>(this.mCalls.length);
        for (int i = 0; i < this.mCalls.length; ++i) {
            CallInfo c = this.mCalls[i];
            if (c == null) continue;
            ret.add(c.toCLCCLine(i + 1));
        }
        return ret;
    }

    private int countActiveLines() throws InvalidStateEx {
        boolean hasMpty = false;
        boolean hasHeld = false;
        boolean hasActive = false;
        boolean hasConnecting = false;
        boolean hasRinging = false;
        boolean mptyIsHeld = false;
        for (int i = 0; i < this.mCalls.length; ++i) {
            CallInfo call = this.mCalls[i];
            if (call == null) continue;
            if (!hasMpty && call.mIsMpty) {
                mptyIsHeld = call.mState == CallInfo.State.HOLDING;
            } else {
                if (call.mIsMpty && mptyIsHeld && call.mState == CallInfo.State.ACTIVE) {
                    Rlog.e("ModelInterpreter", "Invalid state");
                    throw new InvalidStateEx();
                }
                if (!call.mIsMpty && hasMpty && mptyIsHeld && call.mState == CallInfo.State.HOLDING) {
                    Rlog.e("ModelInterpreter", "Invalid state");
                    throw new InvalidStateEx();
                }
            }
            hasMpty |= call.mIsMpty;
            hasHeld |= call.mState == CallInfo.State.HOLDING;
            hasActive |= call.mState == CallInfo.State.ACTIVE;
            hasConnecting |= call.isConnecting();
            hasRinging |= call.isRinging();
        }
        int ret = 0;
        if (hasHeld) {
            ++ret;
        }
        if (hasActive) {
            ++ret;
        }
        if (hasConnecting) {
            ++ret;
        }
        if (hasRinging) {
            ++ret;
        }
        return ret;
    }
}

