/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.uicc;

import android.content.Context;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.Message;
import android.os.Registrant;
import android.os.RegistrantList;
import android.telephony.Rlog;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.uicc.IccCardStatus;
import com.android.internal.telephony.uicc.IccFileHandler;
import com.android.internal.telephony.uicc.IccRecords;
import com.android.internal.telephony.uicc.UiccCard;
import com.android.internal.telephony.uicc.UiccCardApplication;
import java.io.FileDescriptor;
import java.io.PrintWriter;

public class UiccController
extends Handler {
    private static final boolean DBG = true;
    private static final String LOG_TAG = "UiccController";
    public static final int APP_FAM_3GPP = 1;
    public static final int APP_FAM_3GPP2 = 2;
    public static final int APP_FAM_IMS = 3;
    private static final int EVENT_ICC_STATUS_CHANGED = 1;
    private static final int EVENT_GET_ICC_STATUS_DONE = 2;
    private static final Object mLock = new Object();
    private static UiccController mInstance;
    private Context mContext;
    private CommandsInterface mCi;
    private UiccCard mUiccCard;
    private RegistrantList mIccChangedRegistrants = new RegistrantList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UiccController make(Context c, CommandsInterface ci) {
        Object object = mLock;
        synchronized (object) {
            if (mInstance != null) {
                throw new RuntimeException("UiccController.make() should only be called once");
            }
            mInstance = new UiccController(c, ci);
            return mInstance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UiccController getInstance() {
        Object object = mLock;
        synchronized (object) {
            if (mInstance == null) {
                throw new RuntimeException("UiccController.getInstance can't be called before make()");
            }
            return mInstance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UiccCard getUiccCard() {
        Object object = mLock;
        synchronized (object) {
            return this.mUiccCard;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UiccCardApplication getUiccCardApplication(int family) {
        Object object = mLock;
        synchronized (object) {
            if (this.mUiccCard != null) {
                return this.mUiccCard.getApplication(family);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IccRecords getIccRecords(int family) {
        Object object = mLock;
        synchronized (object) {
            UiccCardApplication app;
            if (this.mUiccCard != null && (app = this.mUiccCard.getApplication(family)) != null) {
                return app.getIccRecords();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IccFileHandler getIccFileHandler(int family) {
        Object object = mLock;
        synchronized (object) {
            UiccCardApplication app;
            if (this.mUiccCard != null && (app = this.mUiccCard.getApplication(family)) != null) {
                return app.getIccFileHandler();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerForIccChanged(Handler h, int what, Object obj) {
        Object object = mLock;
        synchronized (object) {
            Registrant r = new Registrant(h, what, obj);
            this.mIccChangedRegistrants.add(r);
            r.notifyRegistrant();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterForIccChanged(Handler h) {
        Object object = mLock;
        synchronized (object) {
            this.mIccChangedRegistrants.remove(h);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleMessage(Message msg) {
        Object object = mLock;
        synchronized (object) {
            switch (msg.what) {
                case 1: {
                    this.log("Received EVENT_ICC_STATUS_CHANGED, calling getIccCardStatus");
                    this.mCi.getIccCardStatus(this.obtainMessage(2));
                    break;
                }
                case 2: {
                    this.log("Received EVENT_GET_ICC_STATUS_DONE");
                    AsyncResult ar = (AsyncResult)msg.obj;
                    this.onGetIccCardStatusDone(ar);
                    break;
                }
                default: {
                    Rlog.e(LOG_TAG, " Unknown Event " + msg.what);
                }
            }
        }
    }

    private UiccController(Context c, CommandsInterface ci) {
        this.log("Creating UiccController");
        this.mContext = c;
        this.mCi = ci;
        this.mCi.registerForIccStatusChanged(this, 1, null);
        this.mCi.registerForOn(this, 1, null);
    }

    private synchronized void onGetIccCardStatusDone(AsyncResult ar) {
        if (ar.exception != null) {
            Rlog.e(LOG_TAG, "Error getting ICC status. RIL_REQUEST_GET_ICC_STATUS should never return an error", ar.exception);
            return;
        }
        IccCardStatus status = (IccCardStatus)ar.result;
        if (this.mUiccCard == null) {
            this.mUiccCard = new UiccCard(this.mContext, this.mCi, status);
        } else {
            this.mUiccCard.update(this.mContext, this.mCi, status);
        }
        this.log("Notifying IccChangedRegistrants");
        this.mIccChangedRegistrants.notifyRegistrants();
    }

    private void log(String string2) {
        Rlog.d(LOG_TAG, string2);
    }

    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        pw.println("UiccController: " + this);
        pw.println(" mContext=" + this.mContext);
        pw.println(" mInstance=" + mInstance);
        pw.println(" mCi=" + this.mCi);
        pw.println(" mUiccCard=" + this.mUiccCard);
        pw.println(" mIccChangedRegistrants: size=" + this.mIccChangedRegistrants.size());
        for (int i = 0; i < this.mIccChangedRegistrants.size(); ++i) {
            pw.println("  mIccChangedRegistrants[" + i + "]=" + ((Registrant)this.mIccChangedRegistrants.get(i)).getHandler());
        }
        pw.println();
        pw.flush();
        if (this.mUiccCard != null) {
            this.mUiccCard.dump(fd, pw, args);
        }
    }
}

