/*
 * Decompiled with CFR 0.152.
 */
package com.android.org.chromium.com.google.common.primitives;

import com.android.org.chromium.com.google.common.base.Preconditions;
import com.android.org.chromium.javax.annotation.CheckForNull;

final class AndroidInteger {
    @CheckForNull
    static Integer tryParse(String string2) {
        return AndroidInteger.tryParse(string2, 10);
    }

    @CheckForNull
    static Integer tryParse(String string2, int radix) {
        boolean negative;
        Preconditions.checkNotNull(string2);
        Preconditions.checkArgument(radix >= 2, "Invalid radix %s, min radix is %s", radix, 2);
        Preconditions.checkArgument(radix <= 36, "Invalid radix %s, max radix is %s", radix, 36);
        int length = string2.length();
        int i = 0;
        if (length == 0) {
            return null;
        }
        boolean bl = negative = string2.charAt(i) == '-';
        if (negative && ++i == length) {
            return null;
        }
        return AndroidInteger.tryParse(string2, i, radix, negative);
    }

    @CheckForNull
    private static Integer tryParse(String string2, int offset, int radix, boolean negative) {
        int max = Integer.MIN_VALUE / radix;
        int result = 0;
        int length = string2.length();
        while (offset < length) {
            int digit;
            if ((digit = Character.digit(string2.charAt(offset++), radix)) == -1) {
                return null;
            }
            if (max > result) {
                return null;
            }
            int next = result * radix - digit;
            if (next > result) {
                return null;
            }
            result = next;
        }
        if (!negative && (result = -result) < 0) {
            return null;
        }
        if (result > Integer.MAX_VALUE || result < Integer.MIN_VALUE) {
            return null;
        }
        return result;
    }

    private AndroidInteger() {
    }
}

