/*
 * Decompiled with CFR 0.152.
 */
package com.android.org.chromium.com.googlecode.eyesfree.braille.display;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;
import com.android.org.chromium.com.googlecode.eyesfree.braille.display.BrailleDisplayProperties;
import com.android.org.chromium.com.googlecode.eyesfree.braille.display.BrailleInputEvent;
import com.android.org.chromium.com.googlecode.eyesfree.braille.display.IBrailleService;
import com.android.org.chromium.com.googlecode.eyesfree.braille.display.IBrailleServiceCallback;

public class Display {
    private static final String LOG_TAG = Display.class.getSimpleName();
    public static final String ACTION_DISPLAY_SERVICE = "com.android.org.chromium.com.googlecode.eyesfree.braille.service.ACTION_DISPLAY_SERVICE";
    private static final int STATE_UNKNOWN = -2;
    public static final int STATE_ERROR = -1;
    public static final int STATE_NOT_CONNECTED = 0;
    public static final int STATE_CONNECTED = 1;
    private final OnConnectionStateChangeListener mConnectionStateChangeListener;
    private final Context mContext;
    private final DisplayHandler mHandler;
    private volatile OnInputEventListener mInputEventListener;
    private static final Intent mServiceIntent = new Intent("com.android.org.chromium.com.googlecode.eyesfree.braille.service.ACTION_DISPLAY_SERVICE");
    private Connection mConnection;
    private int currentConnectionState = -2;
    private BrailleDisplayProperties mDisplayProperties;
    private ServiceCallback mServiceCallback = new ServiceCallback();
    private static final int REBIND_DELAY_MILLIS = 500;
    private static final int MAX_REBIND_ATTEMPTS = 5;
    private int mNumFailedBinds = 0;

    public Display(Context context, OnConnectionStateChangeListener listener) {
        this(context, listener, null);
    }

    public Display(Context context, OnConnectionStateChangeListener listener, Handler handler) {
        this.mContext = context;
        this.mConnectionStateChangeListener = listener;
        this.mHandler = handler == null ? new DisplayHandler() : new DisplayHandler(handler);
        this.doBindService();
    }

    public void setOnInputEventListener(OnInputEventListener listener) {
        this.mInputEventListener = listener;
    }

    public BrailleDisplayProperties getDisplayProperties() {
        return this.mDisplayProperties;
    }

    public void displayDots(byte[] patterns) {
        IBrailleService localService = this.getBrailleService();
        if (localService != null) {
            try {
                localService.displayDots(patterns);
            }
            catch (RemoteException ex) {
                Log.e(LOG_TAG, "Error in displayDots", ex);
            }
        } else {
            Log.v(LOG_TAG, "Error in displayDots: service not connected");
        }
    }

    public void shutdown() {
        this.doUnbindService();
    }

    private void doBindService() {
        Connection localConnection = new Connection();
        if (!this.mContext.bindService(mServiceIntent, localConnection, 1)) {
            Log.e(LOG_TAG, "Failed to bind Service");
            this.mHandler.scheduleRebind();
            return;
        }
        this.mConnection = localConnection;
        Log.i(LOG_TAG, "Bound to braille service");
    }

    private void doUnbindService() {
        IBrailleService localService = this.getBrailleService();
        if (localService != null) {
            try {
                localService.unregisterCallback(this.mServiceCallback);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        if (this.mConnection != null) {
            this.mContext.unbindService(this.mConnection);
            this.mConnection = null;
        }
    }

    private IBrailleService getBrailleService() {
        Connection localConnection = this.mConnection;
        if (localConnection != null) {
            return localConnection.mService;
        }
        return null;
    }

    private class DisplayHandler
    extends Handler {
        private static final int MSG_REPORT_CONNECTION_STATE = 1;
        private static final int MSG_REPORT_INPUT_EVENT = 2;
        private static final int MSG_REBIND_SERVICE = 3;

        public DisplayHandler() {
        }

        public DisplayHandler(Handler handler) {
            super(handler.getLooper());
        }

        public void reportConnectionState(int newState, BrailleDisplayProperties displayProperties) {
            this.obtainMessage(1, newState, 0, displayProperties).sendToTarget();
        }

        public void reportInputEvent(BrailleInputEvent event) {
            this.obtainMessage(2, event).sendToTarget();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void scheduleRebind() {
            DisplayHandler displayHandler = this;
            synchronized (displayHandler) {
                if (Display.this.mNumFailedBinds < 5) {
                    int delay = 500 << Display.this.mNumFailedBinds;
                    this.sendEmptyMessageDelayed(3, delay);
                    ++Display.this.mNumFailedBinds;
                    Log.w(LOG_TAG, String.format("Will rebind to braille service in %d ms.", delay));
                } else {
                    this.reportConnectionState(-1, null);
                }
            }
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    this.handleReportConnectionState(msg.arg1, (BrailleDisplayProperties)msg.obj);
                    break;
                }
                case 2: {
                    this.handleReportInputEvent((BrailleInputEvent)msg.obj);
                    break;
                }
                case 3: {
                    this.handleRebindService();
                }
            }
        }

        private void handleReportConnectionState(int newState, BrailleDisplayProperties displayProperties) {
            Display.this.mDisplayProperties = displayProperties;
            if (newState != Display.this.currentConnectionState && Display.this.mConnectionStateChangeListener != null) {
                Display.this.mConnectionStateChangeListener.onConnectionStateChanged(newState);
            }
            Display.this.currentConnectionState = newState;
        }

        private void handleReportInputEvent(BrailleInputEvent event) {
            OnInputEventListener localListener = Display.this.mInputEventListener;
            if (localListener != null) {
                localListener.onInputEvent(event);
            }
        }

        private void handleRebindService() {
            if (Display.this.mConnection != null) {
                Display.this.doUnbindService();
            }
            Display.this.doBindService();
        }
    }

    private class ServiceCallback
    extends IBrailleServiceCallback.Stub {
        private ServiceCallback() {
        }

        public void onDisplayConnected(BrailleDisplayProperties displayProperties) {
            Display.this.mHandler.reportConnectionState(1, displayProperties);
        }

        public void onDisplayDisconnected() {
            Display.this.mHandler.reportConnectionState(0, null);
        }

        public void onInput(BrailleInputEvent inputEvent) {
            Display.this.mHandler.reportInputEvent(inputEvent);
        }
    }

    private class Connection
    implements ServiceConnection {
        private volatile IBrailleService mService;

        private Connection() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onServiceConnected(ComponentName className, IBinder binder) {
            Log.i(LOG_TAG, "Connected to braille service");
            IBrailleService localService = IBrailleService.Stub.asInterface(binder);
            try {
                localService.registerCallback(Display.this.mServiceCallback);
                this.mService = localService;
                DisplayHandler displayHandler = Display.this.mHandler;
                synchronized (displayHandler) {
                    Display.this.mNumFailedBinds = 0;
                }
            }
            catch (RemoteException e) {
                Log.e(LOG_TAG, "Failed to register callback on service", e);
            }
        }

        public void onServiceDisconnected(ComponentName className) {
            this.mService = null;
            Log.e(LOG_TAG, "Disconnected from braille service");
            Display.this.mHandler.reportConnectionState(0, null);
            Display.this.mHandler.scheduleRebind();
        }
    }

    public static interface OnInputEventListener {
        public void onInputEvent(BrailleInputEvent var1);
    }

    public static interface OnConnectionStateChangeListener {
        public void onConnectionStateChanged(int var1);
    }
}

