/*
 * Decompiled with CFR 0.152.
 */
package com.android.org.chromium.content.browser.input;

import android.content.Context;
import com.android.org.chromium.base.CalledByNative;
import com.android.org.chromium.base.JNINamespace;
import com.android.org.chromium.content.browser.ContentViewCore;
import com.android.org.chromium.content.browser.input.InputDialogContainer;

@JNINamespace(value="content")
class DateTimeChooserAndroid {
    private final int mNativeDateTimeChooserAndroid;
    private final InputDialogContainer mInputDialogContainer;

    private DateTimeChooserAndroid(Context context, int nativeDateTimeChooserAndroid) {
        this.mNativeDateTimeChooserAndroid = nativeDateTimeChooserAndroid;
        this.mInputDialogContainer = new InputDialogContainer(context, new InputDialogContainer.InputActionDelegate(){

            public void replaceDateTime(int dialogType, int year, int month, int day, int hour, int minute, int second, int week) {
                DateTimeChooserAndroid.this.nativeReplaceDateTime(DateTimeChooserAndroid.this.mNativeDateTimeChooserAndroid, dialogType, year, month, day, hour, minute, second, week);
            }

            public void cancelDateTimeDialog() {
                DateTimeChooserAndroid.this.nativeCancelDialog(DateTimeChooserAndroid.this.mNativeDateTimeChooserAndroid);
            }
        });
    }

    private void showDialog(int dialogType, int year, int month, int monthDay, int hour, int minute, int second, int week, double min, double max) {
        this.mInputDialogContainer.showDialog(dialogType, year, month, monthDay, hour, minute, second, week, min, max);
    }

    @CalledByNative
    private static DateTimeChooserAndroid createDateTimeChooser(ContentViewCore contentViewCore, int nativeDateTimeChooserAndroid, int dialogType, int year, int month, int day, int hour, int minute, int second, int week, double min, double max) {
        DateTimeChooserAndroid chooser = new DateTimeChooserAndroid(contentViewCore.getContext(), nativeDateTimeChooserAndroid);
        chooser.showDialog(dialogType, year, month, day, hour, minute, second, week, min, max);
        return chooser;
    }

    @CalledByNative
    private static void initializeDateInputTypes(int textInputTypeDate, int textInputTypeDateTime, int textInputTypeDateTimeLocal, int textInputTypeMonth, int textInputTypeTime, int textInputTypeWeek) {
        InputDialogContainer.initializeInputTypes(textInputTypeDate, textInputTypeDateTime, textInputTypeDateTimeLocal, textInputTypeMonth, textInputTypeTime, textInputTypeWeek);
    }

    private native void nativeReplaceDateTime(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9);

    private native void nativeCancelDialog(int var1);
}

