/*
 * Decompiled with CFR 0.152.
 */
package com.android.org.chromium.content.browser.input;

import android.app.AlertDialog;
import android.app.DatePickerDialog;
import android.app.TimePickerDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.text.format.DateFormat;
import android.text.format.Time;
import android.widget.DatePicker;
import android.widget.TimePicker;
import com.android.org.chromium.content.R;
import com.android.org.chromium.content.browser.input.DateDialogNormalizer;
import com.android.org.chromium.content.browser.input.DateTimePickerDialog;
import com.android.org.chromium.content.browser.input.MonthPickerDialog;
import com.android.org.chromium.content.browser.input.TimeDialog;
import com.android.org.chromium.content.browser.input.TwoFieldDatePickerDialog;
import com.android.org.chromium.content.browser.input.WeekPicker;
import com.android.org.chromium.content.browser.input.WeekPickerDialog;
import java.util.Calendar;

public class InputDialogContainer {
    private static final int YEAR_DEFAULT = 1970;
    private static final int MONTH_DEFAULT = 0;
    private static final int MONTHDAY_DEFAULT = 1;
    private static final int HOUR_DEFAULT = 0;
    private static final int MINUTE_DEFAULT = 0;
    private static final int WEEK_DEFAULT = 0;
    private static final String HTML_DATE_FORMAT = "%Y-%m-%d";
    private static final String HTML_TIME_FORMAT = "%H:%M";
    private static final String HTML_DATE_TIME_FORMAT = "%Y-%m-%dT%H:%MZ";
    private static final String HTML_DATE_TIME_LOCAL_FORMAT = "%Y-%m-%dT%H:%M";
    private static final String HTML_MONTH_FORMAT = "%Y-%m";
    private static final String HTML_WEEK_FORMAT = "%Y-%w";
    private static int sTextInputTypeDate;
    private static int sTextInputTypeDateTime;
    private static int sTextInputTypeDateTimeLocal;
    private static int sTextInputTypeMonth;
    private static int sTextInputTypeTime;
    private static int sTextInputTypeWeek;
    private Context mContext;
    private boolean mDialogAlreadyDismissed;
    private AlertDialog mDialog;
    private InputActionDelegate mInputActionDelegate;

    static void initializeInputTypes(int textInputTypeDate, int textInputTypeDateTime, int textInputTypeDateTimeLocal, int textInputTypeMonth, int textInputTypeTime, int textInputTypeWeek) {
        sTextInputTypeDate = textInputTypeDate;
        sTextInputTypeDateTime = textInputTypeDateTime;
        sTextInputTypeDateTimeLocal = textInputTypeDateTimeLocal;
        sTextInputTypeMonth = textInputTypeMonth;
        sTextInputTypeTime = textInputTypeTime;
        sTextInputTypeWeek = textInputTypeWeek;
    }

    static boolean isDialogInputType(int type) {
        return type == sTextInputTypeDate || type == sTextInputTypeTime || type == sTextInputTypeDateTime || type == sTextInputTypeDateTimeLocal || type == sTextInputTypeMonth || type == sTextInputTypeWeek;
    }

    InputDialogContainer(Context context, InputActionDelegate inputActionDelegate) {
        this.mContext = context;
        this.mInputActionDelegate = inputActionDelegate;
    }

    private Time normalizeTime(int year, int month, int monthDay, int hour, int minute, int second) {
        Time result = new Time();
        if (year == 0 && month == 0 && monthDay == 0 && hour == 0 && minute == 0 && second == 0) {
            Calendar cal = Calendar.getInstance();
            result.set(cal.get(13), cal.get(12), cal.get(11), cal.get(5), cal.get(2), cal.get(1));
        } else {
            result.set(second, minute, hour, monthDay, month, year);
        }
        return result;
    }

    void showDialog(final int dialogType, int year, int month, int monthDay, int hour, int minute, int second, int week, double min, double max) {
        if (this.isDialogShowing()) {
            this.mDialog.dismiss();
        }
        long minTime = (long)min;
        long maxTime = (long)max;
        Time time = this.normalizeTime(year, month, monthDay, hour, minute, second);
        if (dialogType == sTextInputTypeDate) {
            DatePickerDialog dialog = new DatePickerDialog(this.mContext, new DateListener(dialogType), time.year, time.month, time.monthDay);
            DateDialogNormalizer.normalize(dialog.getDatePicker(), dialog, time.year, time.month, time.monthDay, 0, 0, minTime, maxTime);
            dialog.setTitle(this.mContext.getText(R.string.date_picker_dialog_title));
            this.mDialog = dialog;
        } else if (dialogType == sTextInputTypeTime) {
            this.mDialog = TimeDialog.create(this.mContext, new TimeListener(dialogType), time.hour, time.minute, DateFormat.is24HourFormat(this.mContext), minTime, maxTime);
        } else if (dialogType == sTextInputTypeDateTime || dialogType == sTextInputTypeDateTimeLocal) {
            this.mDialog = new DateTimePickerDialog(this.mContext, new DateTimeListener(dialogType), time.year, time.month, time.monthDay, time.hour, time.minute, DateFormat.is24HourFormat(this.mContext), minTime, maxTime);
        } else if (dialogType == sTextInputTypeMonth) {
            this.mDialog = new MonthPickerDialog(this.mContext, new MonthOrWeekListener(dialogType), time.year, time.month, minTime, maxTime);
        } else if (dialogType == sTextInputTypeWeek) {
            if (week == 0) {
                Calendar cal = Calendar.getInstance();
                year = WeekPicker.getISOWeekYearForDate(cal);
                week = WeekPicker.getWeekForDate(cal);
            }
            this.mDialog = new WeekPickerDialog(this.mContext, new MonthOrWeekListener(dialogType), year, week, minTime, maxTime);
        }
        this.mDialog.setButton(-1, this.mContext.getText(R.string.date_picker_dialog_set), (DialogInterface.OnClickListener)((Object)this.mDialog));
        this.mDialog.setButton(-2, this.mContext.getText(0x1040000), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                InputDialogContainer.this.mDialogAlreadyDismissed = true;
                InputDialogContainer.this.mInputActionDelegate.cancelDateTimeDialog();
            }
        });
        this.mDialog.setButton(-3, this.mContext.getText(R.string.date_picker_dialog_clear), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                InputDialogContainer.this.mDialogAlreadyDismissed = true;
                InputDialogContainer.this.mInputActionDelegate.replaceDateTime(dialogType, 0, 0, 0, 0, 0, 0, 0);
            }
        });
        this.mDialogAlreadyDismissed = false;
        this.mDialog.show();
    }

    boolean isDialogShowing() {
        return this.mDialog != null && this.mDialog.isShowing();
    }

    void dismissDialog() {
        if (this.isDialogShowing()) {
            this.mDialog.dismiss();
        }
    }

    private void setFieldDateTimeValue(int dialogType, int year, int month, int monthDay, int hourOfDay, int minute, int week, String dateFormat) {
        this.mDialogAlreadyDismissed = true;
        this.mInputActionDelegate.replaceDateTime(dialogType, year, month, monthDay, hourOfDay, minute, 0, week);
    }

    private class MonthOrWeekListener
    implements TwoFieldDatePickerDialog.OnValueSetListener {
        private final int mDialogType;

        MonthOrWeekListener(int dialogType) {
            this.mDialogType = dialogType;
        }

        public void onValueSet(int year, int positionInYear) {
            if (!InputDialogContainer.this.mDialogAlreadyDismissed) {
                if (this.mDialogType == sTextInputTypeMonth) {
                    InputDialogContainer.this.setFieldDateTimeValue(this.mDialogType, year, positionInYear, 1, 0, 0, 0, InputDialogContainer.HTML_MONTH_FORMAT);
                } else {
                    InputDialogContainer.this.setFieldDateTimeValue(this.mDialogType, year, 0, 1, 0, 0, positionInYear, InputDialogContainer.HTML_WEEK_FORMAT);
                }
            }
        }
    }

    private class DateTimeListener
    implements DateTimePickerDialog.OnDateTimeSetListener {
        private final boolean mLocal;
        private final int mDialogType;

        public DateTimeListener(int dialogType) {
            this.mLocal = dialogType == sTextInputTypeDateTimeLocal;
            this.mDialogType = dialogType;
        }

        public void onDateTimeSet(DatePicker dateView, TimePicker timeView, int year, int month, int monthDay, int hourOfDay, int minute) {
            if (!InputDialogContainer.this.mDialogAlreadyDismissed) {
                InputDialogContainer.this.setFieldDateTimeValue(this.mDialogType, year, month, monthDay, hourOfDay, minute, 0, this.mLocal ? InputDialogContainer.HTML_DATE_TIME_LOCAL_FORMAT : InputDialogContainer.HTML_DATE_TIME_FORMAT);
            }
        }
    }

    private class TimeListener
    implements TimePickerDialog.OnTimeSetListener {
        private final int mDialogType;

        TimeListener(int dialogType) {
            this.mDialogType = dialogType;
        }

        public void onTimeSet(TimePicker view, int hourOfDay, int minute) {
            if (!InputDialogContainer.this.mDialogAlreadyDismissed) {
                InputDialogContainer.this.setFieldDateTimeValue(this.mDialogType, 1970, 0, 1, hourOfDay, minute, 0, InputDialogContainer.HTML_TIME_FORMAT);
            }
        }
    }

    private class DateListener
    implements DatePickerDialog.OnDateSetListener {
        private final int mDialogType;

        DateListener(int dialogType) {
            this.mDialogType = dialogType;
        }

        public void onDateSet(DatePicker view, int year, int month, int monthDay) {
            if (!InputDialogContainer.this.mDialogAlreadyDismissed) {
                InputDialogContainer.this.setFieldDateTimeValue(this.mDialogType, year, month, monthDay, 0, 0, 0, InputDialogContainer.HTML_DATE_FORMAT);
            }
        }
    }

    static interface InputActionDelegate {
        public void cancelDateTimeDialog();

        public void replaceDateTime(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8);
    }
}

