/*
 * Decompiled with CFR 0.152.
 */
package com.android.org.chromium.content.browser.input;

import android.content.Context;
import com.android.org.chromium.content.R;
import com.android.org.chromium.content.browser.input.TwoFieldDatePicker;
import java.text.DateFormatSymbols;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Locale;

public class MonthPicker
extends TwoFieldDatePicker {
    private static final int MONTHS_NUMBER = 12;
    private String[] mShortMonths;

    public MonthPicker(Context context, long minValue, long maxValue) {
        super(context, minValue, maxValue);
        this.getPositionInYearSpinner().setContentDescription(this.getResources().getString(R.string.accessibility_date_picker_month));
        this.mShortMonths = DateFormatSymbols.getInstance(Locale.getDefault()).getShortMonths();
        Calendar cal = Calendar.getInstance();
        this.init(cal.get(1), cal.get(2), null);
    }

    protected Calendar createDateFromValue(long value) {
        int year = (int)Math.min(value / 12L + 1970L, Integer.MAX_VALUE);
        int month = (int)(value % 12L);
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.set(year, month, 1);
        return cal;
    }

    protected void setCurrentDate(int year, int month) {
        Calendar date = Calendar.getInstance();
        date.set(year, month, 1);
        if (date.before(this.getMinDate())) {
            this.setCurrentDate(this.getMinDate());
        } else if (date.after(this.getMaxDate())) {
            this.setCurrentDate(this.getMaxDate());
        } else {
            this.setCurrentDate(date);
        }
    }

    protected void updateSpinners() {
        super.updateSpinners();
        String[] displayedValues = Arrays.copyOfRange(this.mShortMonths, this.getPositionInYearSpinner().getMinValue(), this.getPositionInYearSpinner().getMaxValue() + 1);
        this.getPositionInYearSpinner().setDisplayedValues(displayedValues);
    }

    public int getMonth() {
        return this.getCurrentDate().get(2);
    }

    public int getPositionInYear() {
        return this.getMonth();
    }

    protected int getMaxYear() {
        return this.getMaxDate().get(1);
    }

    protected int getMinYear() {
        return this.getMinDate().get(1);
    }

    protected int getMaxPositionInYear(int year) {
        if (year == this.getMaxDate().get(1)) {
            return this.getMaxDate().get(2);
        }
        return 11;
    }

    protected int getMinPositionInYear(int year) {
        if (year == this.getMinDate().get(1)) {
            return this.getMinDate().get(2);
        }
        return 0;
    }
}

