/*
 * Decompiled with CFR 0.152.
 */
package com.android.org.chromium.ui;

import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.text.TextUtils;
import com.android.org.chromium.base.CalledByNative;
import com.android.org.chromium.base.JNINamespace;

@JNINamespace(value="ui")
public class Clipboard {
    private final Context mContext;
    private final ClipboardManager mClipboardManager;

    private Clipboard(Context context) {
        this.mContext = context;
        this.mClipboardManager = (ClipboardManager)context.getSystemService("clipboard");
    }

    @CalledByNative
    private static Clipboard create(Context context) {
        return new Clipboard(context);
    }

    @CalledByNative
    private String getCoercedText() {
        CharSequence sequence;
        ClipData clip = this.mClipboardManager.getPrimaryClip();
        if (clip != null && clip.getItemCount() > 0 && (sequence = clip.getItemAt(0).coerceToText(this.mContext)) != null) {
            return ((Object)sequence).toString();
        }
        return null;
    }

    @CalledByNative
    private void setText(String text) {
        this.mClipboardManager.setPrimaryClip(ClipData.newPlainText(null, text));
    }

    @CalledByNative
    private boolean hasPlainText() {
        ClipData clip = this.mClipboardManager.getPrimaryClip();
        if (clip != null && clip.getItemCount() > 0) {
            CharSequence text = clip.getItemAt(0).getText();
            return !TextUtils.isEmpty(text);
        }
        return false;
    }
}

