/*
 * Decompiled with CFR 0.152.
 */
package com.android.org.chromium.ui;

import android.content.Context;
import android.graphics.Color;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.SeekBar;
import com.android.org.chromium.ui.ColorPickerAdvancedComponent;
import com.android.org.chromium.ui.OnColorChangedListener;
import com.android.org.chromium.ui.R;

public class ColorPickerAdvanced
extends LinearLayout
implements SeekBar.OnSeekBarChangeListener {
    private static final int HUE_SEEK_BAR_MAX = 360;
    private static final int HUE_COLOR_COUNT = 7;
    private static final int SATURATION_SEEK_BAR_MAX = 100;
    private static final int SATURATION_COLOR_COUNT = 2;
    private static final int VALUE_SEEK_BAR_MAX = 100;
    private static final int VALUE_COLOR_COUNT = 2;
    ColorPickerAdvancedComponent mHueDetails;
    ColorPickerAdvancedComponent mSaturationDetails;
    ColorPickerAdvancedComponent mValueDetails;
    private OnColorChangedListener mOnColorChangedListener;
    private int mCurrentColor;
    private final float[] mCurrentHsvValues = new float[3];

    public ColorPickerAdvanced(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public ColorPickerAdvanced(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
    }

    public ColorPickerAdvanced(Context context) {
        super(context);
        this.init();
    }

    private void init() {
        this.setOrientation(1);
        this.mHueDetails = this.createAndAddNewGradient(R.string.color_picker_hue, 360, this);
        this.mSaturationDetails = this.createAndAddNewGradient(R.string.color_picker_saturation, 100, this);
        this.mValueDetails = this.createAndAddNewGradient(R.string.color_picker_value, 100, this);
        this.refreshGradientComponents();
    }

    public ColorPickerAdvancedComponent createAndAddNewGradient(int textResourceId, int seekBarMax, SeekBar.OnSeekBarChangeListener seekBarListener) {
        LayoutInflater inflater = (LayoutInflater)this.getContext().getSystemService("layout_inflater");
        View newComponent = inflater.inflate(R.layout.color_picker_advanced_component, null);
        this.addView(newComponent);
        return new ColorPickerAdvancedComponent(newComponent, textResourceId, seekBarMax, seekBarListener);
    }

    public void setListener(OnColorChangedListener onColorChangedListener) {
        this.mOnColorChangedListener = onColorChangedListener;
    }

    public int getColor() {
        return this.mCurrentColor;
    }

    public void setColor(int color2) {
        this.mCurrentColor = color2;
        Color.colorToHSV(this.mCurrentColor, this.mCurrentHsvValues);
        this.refreshGradientComponents();
    }

    private void notifyColorChanged() {
        if (this.mOnColorChangedListener != null) {
            this.mOnColorChangedListener.onColorChanged(this.getColor());
        }
    }

    public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
        if (fromUser) {
            this.mCurrentHsvValues[0] = this.mHueDetails.getValue();
            this.mCurrentHsvValues[1] = this.mSaturationDetails.getValue() / 100.0f;
            this.mCurrentHsvValues[2] = this.mValueDetails.getValue() / 100.0f;
            this.mCurrentColor = Color.HSVToColor(this.mCurrentHsvValues);
            this.updateHueGradient();
            this.updateSaturationGradient();
            this.updateValueGradient();
            this.notifyColorChanged();
        }
    }

    private void updateHueGradient() {
        float[] tempHsvValues = new float[3];
        tempHsvValues[1] = this.mCurrentHsvValues[1];
        tempHsvValues[2] = this.mCurrentHsvValues[2];
        int[] newColors = new int[7];
        for (int i = 0; i < 7; ++i) {
            tempHsvValues[0] = (float)i * 60.0f;
            newColors[i] = Color.HSVToColor(tempHsvValues);
        }
        this.mHueDetails.setGradientColors(newColors);
    }

    private void updateSaturationGradient() {
        float[] tempHsvValues = new float[]{this.mCurrentHsvValues[0], 0.0f, this.mCurrentHsvValues[2]};
        int[] newColors = new int[2];
        newColors[0] = Color.HSVToColor(tempHsvValues);
        tempHsvValues[1] = 1.0f;
        newColors[1] = Color.HSVToColor(tempHsvValues);
        this.mSaturationDetails.setGradientColors(newColors);
    }

    private void updateValueGradient() {
        float[] tempHsvValues = new float[]{this.mCurrentHsvValues[0], this.mCurrentHsvValues[1], 0.0f};
        int[] newColors = new int[2];
        newColors[0] = Color.HSVToColor(tempHsvValues);
        tempHsvValues[2] = 1.0f;
        newColors[1] = Color.HSVToColor(tempHsvValues);
        this.mValueDetails.setGradientColors(newColors);
    }

    private void refreshGradientComponents() {
        int saturationValue = Math.round(this.mCurrentHsvValues[1] * 100.0f);
        saturationValue = Math.min(saturationValue, 100);
        saturationValue = Math.max(saturationValue, 0);
        int valueValue = Math.round(this.mCurrentHsvValues[2] * 100.0f);
        valueValue = Math.min(valueValue, 100);
        valueValue = Math.max(valueValue, 0);
        this.mHueDetails.setValue(this.mCurrentHsvValues[0]);
        this.mSaturationDetails.setValue(saturationValue);
        this.mValueDetails.setValue(valueValue);
        this.updateHueGradient();
        this.updateSaturationGradient();
        this.updateValueGradient();
    }

    public void onStartTrackingTouch(SeekBar seekBar) {
    }

    public void onStopTrackingTouch(SeekBar seekBar) {
    }
}

