/*
 * Decompiled with CFR 0.152.
 */
package com.android.org.chromium.ui;

import android.view.View;
import com.android.org.chromium.base.JNINamespace;
import com.android.org.chromium.ui.ViewAndroidDelegate;
import com.android.org.chromium.ui.WindowAndroid;

@JNINamespace(value="ui")
public class ViewAndroid {
    private int mNativeViewAndroid = 0;
    private final ViewAndroidDelegate mViewAndroidDelegate;
    private final WindowAndroid mWindowAndroid;
    private int mKeepScreenOnCount;
    private View mKeepScreenOnView;

    public ViewAndroid(WindowAndroid nativeWindow, ViewAndroidDelegate viewAndroidDelegate) {
        this.mWindowAndroid = nativeWindow;
        this.mViewAndroidDelegate = viewAndroidDelegate;
        this.mNativeViewAndroid = this.nativeInit(this.mWindowAndroid.getNativePointer());
    }

    public ViewAndroidDelegate getViewAndroidDelegate() {
        return this.mViewAndroidDelegate;
    }

    public void destroy() {
        if (this.mNativeViewAndroid != 0) {
            this.nativeDestroy(this.mNativeViewAndroid);
            this.mNativeViewAndroid = 0;
        }
    }

    public int getNativePointer() {
        return this.mNativeViewAndroid;
    }

    public void incrementKeepScreenOnCount() {
        ++this.mKeepScreenOnCount;
        if (this.mKeepScreenOnCount == 1) {
            this.mKeepScreenOnView = this.mViewAndroidDelegate.acquireAnchorView();
            this.mKeepScreenOnView.setKeepScreenOn(true);
        }
    }

    public void decrementKeepScreenOnCount() {
        assert (this.mKeepScreenOnCount > 0);
        --this.mKeepScreenOnCount;
        if (this.mKeepScreenOnCount == 0) {
            this.mViewAndroidDelegate.releaseAnchorView(this.mKeepScreenOnView);
            this.mKeepScreenOnView = null;
        }
    }

    private native int nativeInit(int var1);

    private native void nativeDestroy(int var1);
}

