/*
 * Decompiled with CFR 0.152.
 */
package com.android.org.chromium.ui.gfx;

import android.graphics.SurfaceTexture;
import android.os.Build;
import com.android.org.chromium.base.CalledByNative;
import com.android.org.chromium.base.JNINamespace;
import com.android.org.chromium.ui.gfx.SurfaceTextureListener;

@JNINamespace(value="gfx")
class SurfaceTextureBridge {
    SurfaceTextureBridge() {
    }

    @CalledByNative
    private static SurfaceTexture create(int textureId) {
        return new SurfaceTexture(textureId);
    }

    @CalledByNative
    private static void destroy(SurfaceTexture surfaceTexture) {
        surfaceTexture.setOnFrameAvailableListener(null);
        surfaceTexture.release();
    }

    @CalledByNative
    private static void setFrameAvailableCallback(SurfaceTexture surfaceTexture, int nativeSurfaceTextureListener) {
        surfaceTexture.setOnFrameAvailableListener(new SurfaceTextureListener(nativeSurfaceTextureListener));
    }

    @CalledByNative
    private static void updateTexImage(SurfaceTexture surfaceTexture) {
        surfaceTexture.updateTexImage();
    }

    @CalledByNative
    private static void setDefaultBufferSize(SurfaceTexture surfaceTexture, int width, int height) {
        surfaceTexture.setDefaultBufferSize(width, height);
    }

    @CalledByNative
    private static void getTransformMatrix(SurfaceTexture surfaceTexture, float[] matrix) {
        surfaceTexture.getTransformMatrix(matrix);
    }

    @CalledByNative
    private static void attachToGLContext(SurfaceTexture surfaceTexture, int texName) {
        assert (Build.VERSION.SDK_INT >= 16);
        surfaceTexture.attachToGLContext(texName);
    }

    @CalledByNative
    private static void detachFromGLContext(SurfaceTexture surfaceTexture) {
        assert (Build.VERSION.SDK_INT >= 16);
        surfaceTexture.detachFromGLContext();
    }
}

