/*
 * Decompiled with CFR 0.152.
 */
package com.android.org.conscrypt;

import com.android.org.conscrypt.util.EmptyArray;
import java.io.PrintStream;

public class Logger {
    private static String[] names;

    public static Stream getStream(String name) {
        for (int i = 0; i < names.length; ++i) {
            if (!names[i].equals(name)) continue;
            return new Stream(name);
        }
        return null;
    }

    static {
        try {
            names = System.getProperty("jsse", "").split(",");
        }
        catch (Exception e) {
            names = EmptyArray.STRING;
        }
    }

    public static class Stream
    extends PrintStream {
        private final String prefix;
        private static int indent = 0;

        public Stream(String name) {
            super(System.err);
            this.prefix = name + "[" + Thread.currentThread().getName() + "] ";
        }

        public void print(String msg) {
            for (int i = 0; i < indent; ++i) {
                super.print("  ");
            }
            super.print(msg);
        }

        public void newIndent() {
            ++indent;
        }

        public void endIndent() {
            --indent;
        }

        public void println(String msg) {
            this.print(this.prefix);
            super.println(msg);
        }

        public void print(byte[] data) {
            this.printAsHex(16, " ", "", data, 0, data.length);
        }

        public void print(byte[] data, int offset, int len) {
            this.printAsHex(16, " ", "", data, offset, len);
        }

        public void printAsHex(int perLine, String prefix, String delimiter, byte[] data) {
            this.printAsHex(perLine, prefix, delimiter, data, 0, data.length);
        }

        public void printAsHex(int perLine, String prefix, String delimiter, byte[] data, int offset, int len) {
            StringBuilder line = new StringBuilder();
            for (int i = 0; i < len; ++i) {
                line.append(prefix);
                line.append(Byte.toHexString((byte)data[i + offset], (boolean)false));
                line.append(delimiter);
                if ((i + 1) % perLine != 0) continue;
                super.println(line.toString());
                line = new StringBuilder();
            }
            super.println(line.toString());
        }
    }
}

