/*
 * Decompiled with CFR 0.152.
 */
package com.android.org.conscrypt;

import com.android.org.conscrypt.NativeCrypto;
import com.android.org.conscrypt.OpenSSLDSAParams;
import com.android.org.conscrypt.OpenSSLKey;
import com.android.org.conscrypt.OpenSSLKeyHolder;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPrivateKey;
import java.security.spec.DSAPrivateKeySpec;
import java.security.spec.InvalidKeySpecException;

public class OpenSSLDSAPrivateKey
implements DSAPrivateKey,
OpenSSLKeyHolder {
    private static final long serialVersionUID = 6524734576187424628L;
    private transient OpenSSLKey key;
    private transient OpenSSLDSAParams params;

    OpenSSLDSAPrivateKey(OpenSSLKey key) {
        this.key = key;
    }

    public OpenSSLKey getOpenSSLKey() {
        return this.key;
    }

    OpenSSLDSAPrivateKey(DSAPrivateKeySpec dsaKeySpec) throws InvalidKeySpecException {
        try {
            this.key = new OpenSSLKey(NativeCrypto.EVP_PKEY_new_DSA(dsaKeySpec.getP().toByteArray(), dsaKeySpec.getQ().toByteArray(), dsaKeySpec.getG().toByteArray(), null, dsaKeySpec.getX().toByteArray()));
        }
        catch (Exception e) {
            throw new InvalidKeySpecException(e);
        }
    }

    private void ensureReadParams() {
        if (this.params == null) {
            this.params = new OpenSSLDSAParams(this.key);
        }
    }

    static OpenSSLKey getInstance(DSAPrivateKey dsaPrivateKey) throws InvalidKeyException {
        try {
            DSAParams dsaParams = dsaPrivateKey.getParams();
            return new OpenSSLKey(NativeCrypto.EVP_PKEY_new_DSA(dsaParams.getP().toByteArray(), dsaParams.getQ().toByteArray(), dsaParams.getG().toByteArray(), null, dsaPrivateKey.getX().toByteArray()));
        }
        catch (Exception e) {
            throw new InvalidKeyException(e);
        }
    }

    public DSAParams getParams() {
        this.ensureReadParams();
        return this.params;
    }

    public String getAlgorithm() {
        return "DSA";
    }

    public String getFormat() {
        if (this.key.isEngineBased()) {
            return null;
        }
        return "PKCS#8";
    }

    public byte[] getEncoded() {
        if (this.key.isEngineBased()) {
            return null;
        }
        return NativeCrypto.i2d_PKCS8_PRIV_KEY_INFO(this.key.getPkeyContext());
    }

    public BigInteger getX() {
        if (this.key.isEngineBased()) {
            throw new UnsupportedOperationException("private key value X cannot be extracted");
        }
        this.ensureReadParams();
        return this.params.getX();
    }

    public boolean equals(Object o) {
        OpenSSLDSAPrivateKey other;
        if (o == this) {
            return true;
        }
        if (o instanceof OpenSSLDSAPrivateKey && this.key.equals((other = (OpenSSLDSAPrivateKey)o).getOpenSSLKey())) {
            return true;
        }
        if (!(o instanceof DSAPrivateKey)) {
            return false;
        }
        this.ensureReadParams();
        BigInteger x = this.params.getX();
        if (x == null) {
            return false;
        }
        DSAPrivateKey other2 = (DSAPrivateKey)o;
        return x.equals(other2.getX()) && this.params.equals(other2.getParams());
    }

    public int hashCode() {
        this.ensureReadParams();
        int hash = 1;
        BigInteger x = this.getX();
        if (x != null) {
            hash = hash * 3 + x.hashCode();
        }
        hash = hash * 7 + this.params.hashCode();
        return hash;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("OpenSSLDSAPrivateKey{");
        if (this.key.isEngineBased()) {
            sb.append("key=");
            sb.append(this.key);
            sb.append('}');
            return sb.toString();
        }
        this.ensureReadParams();
        sb.append("X=");
        sb.append(this.params.getX().toString(16));
        sb.append(',');
        sb.append("params=");
        sb.append(this.params.toString());
        sb.append('}');
        return sb.toString();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        BigInteger g = (BigInteger)stream.readObject();
        BigInteger p = (BigInteger)stream.readObject();
        BigInteger q = (BigInteger)stream.readObject();
        BigInteger x = (BigInteger)stream.readObject();
        this.key = new OpenSSLKey(NativeCrypto.EVP_PKEY_new_DSA(p.toByteArray(), q.toByteArray(), g.toByteArray(), null, x.toByteArray()));
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        if (this.getOpenSSLKey().isEngineBased()) {
            throw new NotSerializableException("engine-based keys can not be serialized");
        }
        stream.defaultWriteObject();
        this.ensureReadParams();
        stream.writeObject(this.params.getG());
        stream.writeObject(this.params.getP());
        stream.writeObject(this.params.getQ());
        stream.writeObject(this.params.getX());
    }
}

