/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import com.google.android.collect.Lists;
import java.util.ArrayList;

public class NativeDaemonEvent {
    private final int mCmdNumber;
    private final int mCode;
    private final String mMessage;
    private final String mRawEvent;
    private String[] mParsed;

    private NativeDaemonEvent(int cmdNumber, int code, String message, String rawEvent) {
        this.mCmdNumber = cmdNumber;
        this.mCode = code;
        this.mMessage = message;
        this.mRawEvent = rawEvent;
        this.mParsed = null;
    }

    public int getCmdNumber() {
        return this.mCmdNumber;
    }

    public int getCode() {
        return this.mCode;
    }

    public String getMessage() {
        return this.mMessage;
    }

    @Deprecated
    public String getRawEvent() {
        return this.mRawEvent;
    }

    public String toString() {
        return this.mRawEvent;
    }

    public boolean isClassContinue() {
        return this.mCode >= 100 && this.mCode < 200;
    }

    public boolean isClassOk() {
        return this.mCode >= 200 && this.mCode < 300;
    }

    public boolean isClassServerError() {
        return this.mCode >= 400 && this.mCode < 500;
    }

    public boolean isClassClientError() {
        return this.mCode >= 500 && this.mCode < 600;
    }

    public boolean isClassUnsolicited() {
        return NativeDaemonEvent.isClassUnsolicited(this.mCode);
    }

    private static boolean isClassUnsolicited(int code) {
        return code >= 600 && code < 700;
    }

    public void checkCode(int code) {
        if (this.mCode != code) {
            throw new IllegalStateException("Expected " + code + " but was: " + this);
        }
    }

    public static NativeDaemonEvent parseRawEvent(String rawEvent) {
        int code;
        String[] parsed = rawEvent.split(" ");
        if (parsed.length < 2) {
            throw new IllegalArgumentException("Insufficient arguments");
        }
        int skiplength = 0;
        try {
            code = Integer.parseInt(parsed[0]);
            skiplength = parsed[0].length() + 1;
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("problem parsing code", e);
        }
        int cmdNumber = -1;
        if (!NativeDaemonEvent.isClassUnsolicited(code)) {
            if (parsed.length < 3) {
                throw new IllegalArgumentException("Insufficient arguemnts");
            }
            try {
                cmdNumber = Integer.parseInt(parsed[1]);
                skiplength += parsed[1].length() + 1;
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("problem parsing cmdNumber", e);
            }
        }
        String message = rawEvent.substring(skiplength);
        return new NativeDaemonEvent(cmdNumber, code, message, rawEvent);
    }

    public static String[] filterMessageList(NativeDaemonEvent[] events, int matchCode) {
        ArrayList<String> result = Lists.newArrayList();
        for (NativeDaemonEvent event : events) {
            if (event.getCode() != matchCode) continue;
            result.add(event.getMessage());
        }
        return result.toArray(new String[result.size()]);
    }

    public String getField(int n) {
        if (this.mParsed == null) {
            this.mParsed = NativeDaemonEvent.unescapeArgs(this.mRawEvent);
        }
        if ((n += 2) > this.mParsed.length) {
            return null;
        }
        return this.mParsed[n];
    }

    public static String[] unescapeArgs(String rawEvent) {
        boolean DEBUG_ROUTINE = false;
        String LOGTAG = "unescapeArgs";
        ArrayList<String> parsed = new ArrayList<String>();
        int length = rawEvent.length();
        int current = 0;
        int wordEnd = -1;
        boolean quoted = false;
        if (rawEvent.charAt(current) == '\"') {
            quoted = true;
            ++current;
        }
        while (current < length) {
            if (quoted) {
                wordEnd = current;
                while ((wordEnd = rawEvent.indexOf(34, wordEnd)) != -1 && rawEvent.charAt(wordEnd - 1) == '\\') {
                    ++wordEnd;
                }
            } else {
                wordEnd = rawEvent.indexOf(32, current);
            }
            if (wordEnd == -1) {
                wordEnd = length;
            }
            String word = rawEvent.substring(current, wordEnd);
            current += word.length();
            if (!quoted) {
                word = word.trim();
            } else {
                ++current;
            }
            word = word.replace("\\\\", "\\");
            word = word.replace("\\\"", "\"");
            parsed.add(word);
            int nextSpace = rawEvent.indexOf(32, current);
            int nextQuote = rawEvent.indexOf(" \"", current);
            if (nextQuote > -1 && nextQuote <= nextSpace) {
                quoted = true;
                current = nextQuote + 2;
                continue;
            }
            quoted = false;
            if (nextSpace <= -1) continue;
            current = nextSpace + 1;
        }
        return parsed.toArray(new String[parsed.size()]);
    }
}

