/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.app.ActivityManagerNative;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.IPackageManager;
import android.content.res.Configuration;
import android.media.AudioService;
import android.net.wifi.p2p.WifiP2pService;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Process;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.StrictMode;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.UserHandle;
import android.util.DisplayMetrics;
import android.util.EventLog;
import android.util.Log;
import android.util.Slog;
import android.view.WindowManager;
import com.android.internal.os.BinderInternal;
import com.android.server.AlarmManagerService;
import com.android.server.AppWidgetService;
import com.android.server.AssetAtlasService;
import com.android.server.AttributeCache;
import com.android.server.BackupManagerService;
import com.android.server.BatteryService;
import com.android.server.BluetoothManagerService;
import com.android.server.CertBlacklister;
import com.android.server.ClipboardService;
import com.android.server.CommonTimeManagementService;
import com.android.server.ConnectivityService;
import com.android.server.ConsumerIrService;
import com.android.server.CountryDetectorService;
import com.android.server.DevicePolicyManagerService;
import com.android.server.DeviceStorageMonitorService;
import com.android.server.DiskStatsService;
import com.android.server.DockObserver;
import com.android.server.DropBoxManagerService;
import com.android.server.EntropyMixer;
import com.android.server.IdleMaintenanceService;
import com.android.server.InputMethodManagerService;
import com.android.server.LightsService;
import com.android.server.LocationManagerService;
import com.android.server.LockSettingsService;
import com.android.server.MountService;
import com.android.server.NetworkManagementService;
import com.android.server.NetworkTimeUpdateService;
import com.android.server.NotificationManagerService;
import com.android.server.NsdService;
import com.android.server.RecognitionManagerService;
import com.android.server.SamplingProfilerService;
import com.android.server.SerialService;
import com.android.server.StatusBarManagerService;
import com.android.server.TelephonyRegistry;
import com.android.server.TextServicesManagerService;
import com.android.server.TwilightService;
import com.android.server.UiModeManagerService;
import com.android.server.UpdateLockService;
import com.android.server.VibratorService;
import com.android.server.WallpaperManagerService;
import com.android.server.Watchdog;
import com.android.server.WiredAccessoryManager;
import com.android.server.accessibility.AccessibilityManagerService;
import com.android.server.accounts.AccountManagerService;
import com.android.server.am.ActivityManagerService;
import com.android.server.am.BatteryStatsService;
import com.android.server.content.ContentService;
import com.android.server.display.DisplayManagerService;
import com.android.server.dreams.DreamManagerService;
import com.android.server.input.InputManagerService;
import com.android.server.net.NetworkPolicyManagerService;
import com.android.server.net.NetworkStatsService;
import com.android.server.os.SchedulingPolicyService;
import com.android.server.pm.Installer;
import com.android.server.pm.PackageManagerService;
import com.android.server.pm.UserManagerService;
import com.android.server.power.PowerManagerService;
import com.android.server.power.ShutdownThread;
import com.android.server.print.PrintManagerService;
import com.android.server.search.SearchManagerService;
import com.android.server.usb.UsbService;
import com.android.server.wifi.WifiService;
import com.android.server.wm.WindowManagerService;
import dalvik.system.VMRuntime;
import dalvik.system.Zygote;
import java.io.File;

class ServerThread {
    private static final String TAG = "SystemServer";
    private static final String ENCRYPTING_STATE = "trigger_restart_min_framework";
    private static final String ENCRYPTED_STATE = "1";
    ContentResolver mContentResolver;

    ServerThread() {
    }

    void reportWtf(String msg, Throwable e) {
        Slog.w(TAG, "***********************************************");
        Log.wtf(TAG, "BOOT FAILURE " + msg, e);
    }

    public void initAndLoop() {
        boolean safeMode;
        String factoryTestStr;
        EventLog.writeEvent(3010, SystemClock.uptimeMillis());
        Looper.prepareMainLooper();
        Process.setThreadPriority(-2);
        BinderInternal.disableBackgroundScheduling(true);
        Process.setCanSelfBackground(false);
        String shutdownAction = SystemProperties.get("sys.shutdown.requested", "");
        if (shutdownAction != null && shutdownAction.length() > 0) {
            boolean reboot = shutdownAction.charAt(0) == '1';
            String reason = shutdownAction.length() > 1 ? shutdownAction.substring(1, shutdownAction.length()) : null;
            ShutdownThread.rebootOrShutdown(reboot, reason);
        }
        int factoryTest = "".equals(factoryTestStr = SystemProperties.get("ro.factorytest")) ? 0 : Integer.parseInt(factoryTestStr);
        final boolean headless = ENCRYPTED_STATE.equals(SystemProperties.get("ro.config.headless", "0"));
        Installer installer = null;
        AccountManagerService accountManager = null;
        ContentService contentService = null;
        LightsService lights = null;
        PowerManagerService power = null;
        DisplayManagerService display = null;
        BatteryService battery = null;
        VibratorService vibrator = null;
        AlarmManagerService alarm = null;
        MountService mountService = null;
        NetworkManagementService networkManagement = null;
        NetworkStatsService networkStats = null;
        NetworkPolicyManagerService networkPolicy = null;
        ConnectivityService connectivity = null;
        WifiP2pService wifiP2p = null;
        WifiService wifi = null;
        NsdService serviceDiscovery = null;
        IPackageManager pm = null;
        Context context = null;
        WindowManagerService wm = null;
        BluetoothManagerService bluetooth = null;
        DockObserver dock = null;
        UsbService usb = null;
        SerialService serial = null;
        TwilightService twilight = null;
        UiModeManagerService uiMode = null;
        RecognitionManagerService recognition = null;
        NetworkTimeUpdateService networkTimeUpdater = null;
        CommonTimeManagementService commonTimeMgmtService = null;
        InputManagerService inputManager = null;
        TelephonyRegistry telephonyRegistry = null;
        ConsumerIrService consumerIr = null;
        HandlerThread wmHandlerThread = new HandlerThread("WindowManager");
        wmHandlerThread.start();
        Handler wmHandler = new Handler(wmHandlerThread.getLooper());
        wmHandler.post(new Runnable(){

            public void run() {
                Process.setThreadPriority(-4);
                Process.setCanSelfBackground(false);
                if (StrictMode.conditionallyEnableDebugLogging()) {
                    Slog.i(ServerThread.TAG, "Enabled StrictMode logging for WM Looper");
                }
            }
        });
        boolean onlyCore = false;
        boolean firstBoot = false;
        try {
            Slog.i(TAG, "Waiting for installd to be ready.");
            installer = new Installer();
            installer.ping();
            Slog.i(TAG, "Power Manager");
            power = new PowerManagerService();
            ServiceManager.addService("power", power);
            Slog.i(TAG, "Activity Manager");
            context = ActivityManagerService.main(factoryTest);
        }
        catch (RuntimeException e) {
            Slog.e("System", "******************************************");
            Slog.e("System", "************ Failure starting bootstrap service", e);
        }
        boolean disableStorage = SystemProperties.getBoolean("config.disable_storage", false);
        boolean disableMedia = SystemProperties.getBoolean("config.disable_media", false);
        boolean disableBluetooth = SystemProperties.getBoolean("config.disable_bluetooth", false);
        boolean disableTelephony = SystemProperties.getBoolean("config.disable_telephony", false);
        boolean disableLocation = SystemProperties.getBoolean("config.disable_location", false);
        boolean disableSystemUI = SystemProperties.getBoolean("config.disable_systemui", false);
        boolean disableNonCoreServices = SystemProperties.getBoolean("config.disable_noncore", false);
        boolean disableNetwork = SystemProperties.getBoolean("config.disable_network", false);
        try {
            Slog.i(TAG, "Display Manager");
            display = new DisplayManagerService(context, wmHandler);
            ServiceManager.addService("display", display, true);
            Slog.i(TAG, "Telephony Registry");
            telephonyRegistry = new TelephonyRegistry(context);
            ServiceManager.addService("telephony.registry", telephonyRegistry);
            Slog.i(TAG, "Scheduling Policy");
            ServiceManager.addService("scheduling_policy", new SchedulingPolicyService());
            AttributeCache.init(context);
            if (!display.waitForDefaultDisplay()) {
                this.reportWtf("Timeout waiting for default display to be initialized.", new Throwable());
            }
            Slog.i(TAG, "Package Manager");
            String cryptState = SystemProperties.get("vold.decrypt");
            if (ENCRYPTING_STATE.equals(cryptState)) {
                Slog.w(TAG, "Detected encryption in progress - only parsing core apps");
                onlyCore = true;
            } else if (ENCRYPTED_STATE.equals(cryptState)) {
                Slog.w(TAG, "Device encrypted - only parsing core apps");
                onlyCore = true;
            }
            pm = PackageManagerService.main(context, installer, factoryTest != 0, onlyCore);
            try {
                firstBoot = pm.isFirstBoot();
            }
            catch (RemoteException e) {
                // empty catch block
            }
            ActivityManagerService.setSystemProcess();
            Slog.i(TAG, "Entropy Mixer");
            ServiceManager.addService("entropy", new EntropyMixer(context));
            Slog.i(TAG, "User Service");
            ServiceManager.addService("user", UserManagerService.getInstance());
            this.mContentResolver = context.getContentResolver();
            try {
                Slog.i(TAG, "Account Manager");
                accountManager = new AccountManagerService(context);
                ServiceManager.addService("account", accountManager);
            }
            catch (Throwable e) {
                Slog.e(TAG, "Failure starting Account Manager", e);
            }
            Slog.i(TAG, "Content Manager");
            contentService = ContentService.main(context, factoryTest == 1);
            Slog.i(TAG, "System Content Providers");
            ActivityManagerService.installSystemProviders();
            Slog.i(TAG, "Lights Service");
            lights = new LightsService(context);
            Slog.i(TAG, "Battery Service");
            battery = new BatteryService(context, lights);
            ServiceManager.addService("battery", battery);
            Slog.i(TAG, "Vibrator Service");
            vibrator = new VibratorService(context);
            ServiceManager.addService("vibrator", vibrator);
            Slog.i(TAG, "Consumer IR Service");
            consumerIr = new ConsumerIrService(context);
            ServiceManager.addService("consumer_ir", consumerIr);
            power.init(context, lights, ActivityManagerService.self(), battery, BatteryStatsService.getService(), ActivityManagerService.self().getAppOpsService(), display);
            Slog.i(TAG, "Alarm Manager");
            alarm = new AlarmManagerService(context);
            ServiceManager.addService("alarm", alarm);
            Slog.i(TAG, "Init Watchdog");
            Watchdog.getInstance().init(context, battery, power, alarm, ActivityManagerService.self());
            Watchdog.getInstance().addThread(wmHandler, "WindowManager thread");
            Slog.i(TAG, "Input Manager");
            inputManager = new InputManagerService(context, wmHandler);
            Slog.i(TAG, "Window Manager");
            wm = WindowManagerService.main(context, power, display, inputManager, wmHandler, factoryTest != 1, !firstBoot, onlyCore);
            ServiceManager.addService("window", wm);
            ServiceManager.addService("input", inputManager);
            ActivityManagerService.self().setWindowManager(wm);
            inputManager.setWindowManagerCallbacks(wm.getInputMonitor());
            inputManager.start();
            display.setWindowManager(wm);
            display.setInputManager(inputManager);
            if (SystemProperties.get("ro.kernel.qemu").equals(ENCRYPTED_STATE)) {
                Slog.i(TAG, "No Bluetooh Service (emulator)");
            } else if (factoryTest == 1) {
                Slog.i(TAG, "No Bluetooth Service (factory test)");
            } else if (!context.getPackageManager().hasSystemFeature("android.hardware.bluetooth")) {
                Slog.i(TAG, "No Bluetooth Service (Bluetooth Hardware Not Present)");
            } else if (disableBluetooth) {
                Slog.i(TAG, "Bluetooth Service disabled by config");
            } else {
                Slog.i(TAG, "Bluetooth Manager Service");
                bluetooth = new BluetoothManagerService(context);
                ServiceManager.addService("bluetooth_manager", bluetooth);
            }
        }
        catch (RuntimeException e) {
            Slog.e("System", "******************************************");
            Slog.e("System", "************ Failure starting core service", e);
        }
        DevicePolicyManagerService devicePolicy = null;
        StatusBarManagerService statusBar = null;
        InputMethodManagerService imm = null;
        AppWidgetService appWidget = null;
        NotificationManagerService notification = null;
        WallpaperManagerService wallpaper = null;
        LocationManagerService location = null;
        CountryDetectorService countryDetector = null;
        TextServicesManagerService tsms = null;
        LockSettingsService lockSettings = null;
        DreamManagerService dreamy = null;
        AssetAtlasService atlas = null;
        PrintManagerService printManager = null;
        if (factoryTest != 1) {
            try {
                Slog.i(TAG, "Input Method Service");
                imm = new InputMethodManagerService(context, wm);
                ServiceManager.addService("input_method", imm);
            }
            catch (Throwable e) {
                this.reportWtf("starting Input Manager Service", e);
            }
            try {
                Slog.i(TAG, "Accessibility Manager");
                ServiceManager.addService("accessibility", new AccessibilityManagerService(context));
            }
            catch (Throwable e) {
                this.reportWtf("starting Accessibility Manager", e);
            }
        }
        try {
            wm.displayReady();
        }
        catch (Throwable e) {
            this.reportWtf("making display ready", e);
        }
        try {
            pm.performBootDexOpt();
        }
        catch (Throwable e) {
            this.reportWtf("performing boot dexopt", e);
        }
        try {
            ActivityManagerNative.getDefault().showBootMessage(context.getResources().getText(17040399), false);
        }
        catch (RemoteException e) {
            // empty catch block
        }
        if (factoryTest != 1) {
            if (!disableStorage && !"0".equals(SystemProperties.get("system_init.startmountservice"))) {
                try {
                    Slog.i(TAG, "Mount Service");
                    mountService = new MountService(context);
                    ServiceManager.addService("mount", mountService);
                }
                catch (Throwable e) {
                    this.reportWtf("starting Mount Service", e);
                }
            }
            if (!disableNonCoreServices) {
                try {
                    Slog.i(TAG, "LockSettingsService");
                    lockSettings = new LockSettingsService(context);
                    ServiceManager.addService("lock_settings", lockSettings);
                }
                catch (Throwable e) {
                    this.reportWtf("starting LockSettingsService service", e);
                }
                try {
                    Slog.i(TAG, "Device Policy");
                    devicePolicy = new DevicePolicyManagerService(context);
                    ServiceManager.addService("device_policy", devicePolicy);
                }
                catch (Throwable e) {
                    this.reportWtf("starting DevicePolicyService", e);
                }
            }
            if (!disableSystemUI) {
                try {
                    Slog.i(TAG, "Status Bar");
                    statusBar = new StatusBarManagerService(context, wm);
                    ServiceManager.addService("statusbar", statusBar);
                }
                catch (Throwable e) {
                    this.reportWtf("starting StatusBarManagerService", e);
                }
            }
            if (!disableNonCoreServices) {
                try {
                    Slog.i(TAG, "Clipboard Service");
                    ServiceManager.addService("clipboard", new ClipboardService(context));
                }
                catch (Throwable e) {
                    this.reportWtf("starting Clipboard Service", e);
                }
            }
            if (!disableNetwork) {
                try {
                    Slog.i(TAG, "NetworkManagement Service");
                    networkManagement = NetworkManagementService.create(context);
                    ServiceManager.addService("network_management", networkManagement);
                }
                catch (Throwable e) {
                    this.reportWtf("starting NetworkManagement Service", e);
                }
            }
            if (!disableNonCoreServices) {
                try {
                    Slog.i(TAG, "Text Service Manager Service");
                    tsms = new TextServicesManagerService(context);
                    ServiceManager.addService("textservices", tsms);
                }
                catch (Throwable e) {
                    this.reportWtf("starting Text Service Manager Service", e);
                }
            }
            if (!disableNetwork) {
                try {
                    Slog.i(TAG, "NetworkStats Service");
                    networkStats = new NetworkStatsService(context, networkManagement, alarm);
                    ServiceManager.addService("netstats", networkStats);
                }
                catch (Throwable e) {
                    this.reportWtf("starting NetworkStats Service", e);
                }
                try {
                    Slog.i(TAG, "NetworkPolicy Service");
                    networkPolicy = new NetworkPolicyManagerService(context, ActivityManagerService.self(), power, networkStats, networkManagement);
                    ServiceManager.addService("netpolicy", networkPolicy);
                }
                catch (Throwable e) {
                    this.reportWtf("starting NetworkPolicy Service", e);
                }
                try {
                    Slog.i(TAG, "Wi-Fi P2pService");
                    wifiP2p = new WifiP2pService(context);
                    ServiceManager.addService("wifip2p", wifiP2p);
                }
                catch (Throwable e) {
                    this.reportWtf("starting Wi-Fi P2pService", e);
                }
                try {
                    Slog.i(TAG, "Wi-Fi Service");
                    wifi = new WifiService(context);
                    ServiceManager.addService("wifi", wifi);
                }
                catch (Throwable e) {
                    this.reportWtf("starting Wi-Fi Service", e);
                }
                try {
                    Slog.i(TAG, "Connectivity Service");
                    connectivity = new ConnectivityService(context, networkManagement, networkStats, networkPolicy);
                    ServiceManager.addService("connectivity", connectivity);
                    networkStats.bindConnectivityManager(connectivity);
                    networkPolicy.bindConnectivityManager(connectivity);
                    wifiP2p.connectivityServiceReady();
                    wifi.checkAndStartWifi();
                }
                catch (Throwable e) {
                    this.reportWtf("starting Connectivity Service", e);
                }
                try {
                    Slog.i(TAG, "Network Service Discovery Service");
                    serviceDiscovery = NsdService.create(context);
                    ServiceManager.addService("servicediscovery", serviceDiscovery);
                }
                catch (Throwable e) {
                    this.reportWtf("starting Service Discovery Service", e);
                }
            }
            if (!disableNonCoreServices) {
                try {
                    Slog.i(TAG, "UpdateLock Service");
                    ServiceManager.addService("updatelock", new UpdateLockService(context));
                }
                catch (Throwable e) {
                    this.reportWtf("starting UpdateLockService", e);
                }
            }
            if (mountService != null && !onlyCore) {
                mountService.waitForAsecScan();
            }
            try {
                if (accountManager != null) {
                    accountManager.systemReady();
                }
            }
            catch (Throwable e) {
                this.reportWtf("making Account Manager Service ready", e);
            }
            try {
                if (contentService != null) {
                    contentService.systemReady();
                }
            }
            catch (Throwable e) {
                this.reportWtf("making Content Service ready", e);
            }
            try {
                Slog.i(TAG, "Notification Manager");
                notification = new NotificationManagerService(context, statusBar, lights);
                ServiceManager.addService("notification", notification);
                networkPolicy.bindNotificationManager(notification);
            }
            catch (Throwable e) {
                this.reportWtf("starting Notification Manager", e);
            }
            try {
                Slog.i(TAG, "Device Storage Monitor");
                ServiceManager.addService("devicestoragemonitor", new DeviceStorageMonitorService(context));
            }
            catch (Throwable e) {
                this.reportWtf("starting DeviceStorageMonitor service", e);
            }
            if (!disableLocation) {
                try {
                    Slog.i(TAG, "Location Manager");
                    location = new LocationManagerService(context);
                    ServiceManager.addService("location", location);
                }
                catch (Throwable e) {
                    this.reportWtf("starting Location Manager", e);
                }
                try {
                    Slog.i(TAG, "Country Detector");
                    countryDetector = new CountryDetectorService(context);
                    ServiceManager.addService("country_detector", countryDetector);
                }
                catch (Throwable e) {
                    this.reportWtf("starting Country Detector", e);
                }
            }
            if (!disableNonCoreServices) {
                try {
                    Slog.i(TAG, "Search Service");
                    ServiceManager.addService("search", new SearchManagerService(context));
                }
                catch (Throwable e) {
                    this.reportWtf("starting Search Service", e);
                }
            }
            try {
                Slog.i(TAG, "DropBox Service");
                ServiceManager.addService("dropbox", new DropBoxManagerService(context, new File("/data/system/dropbox")));
            }
            catch (Throwable e) {
                this.reportWtf("starting DropBoxManagerService", e);
            }
            if (!disableNonCoreServices && context.getResources().getBoolean(0x1110030)) {
                try {
                    Slog.i(TAG, "Wallpaper Service");
                    if (!headless) {
                        wallpaper = new WallpaperManagerService(context);
                        ServiceManager.addService("wallpaper", wallpaper);
                    }
                }
                catch (Throwable e) {
                    this.reportWtf("starting Wallpaper Service", e);
                }
            }
            if (!disableMedia && !"0".equals(SystemProperties.get("system_init.startaudioservice"))) {
                try {
                    Slog.i(TAG, "Audio Service");
                    ServiceManager.addService("audio", new AudioService(context));
                }
                catch (Throwable e) {
                    this.reportWtf("starting Audio Service", e);
                }
            }
            if (!disableNonCoreServices) {
                try {
                    Slog.i(TAG, "Dock Observer");
                    dock = new DockObserver(context);
                }
                catch (Throwable e) {
                    this.reportWtf("starting DockObserver", e);
                }
            }
            if (!disableMedia) {
                try {
                    Slog.i(TAG, "Wired Accessory Manager");
                    inputManager.setWiredAccessoryCallbacks(new WiredAccessoryManager(context, inputManager));
                }
                catch (Throwable e) {
                    this.reportWtf("starting WiredAccessoryManager", e);
                }
            }
            if (!disableNonCoreServices) {
                try {
                    Slog.i(TAG, "USB Service");
                    usb = new UsbService(context);
                    ServiceManager.addService("usb", usb);
                }
                catch (Throwable e) {
                    this.reportWtf("starting UsbService", e);
                }
                try {
                    Slog.i(TAG, "Serial Service");
                    serial = new SerialService(context);
                    ServiceManager.addService("serial", serial);
                }
                catch (Throwable e) {
                    Slog.e(TAG, "Failure starting SerialService", e);
                }
            }
            try {
                Slog.i(TAG, "Twilight Service");
                twilight = new TwilightService(context);
            }
            catch (Throwable e) {
                this.reportWtf("starting TwilightService", e);
            }
            try {
                Slog.i(TAG, "UI Mode Manager Service");
                uiMode = new UiModeManagerService(context, twilight);
            }
            catch (Throwable e) {
                this.reportWtf("starting UiModeManagerService", e);
            }
            if (!disableNonCoreServices) {
                try {
                    Slog.i(TAG, "Backup Service");
                    ServiceManager.addService("backup", new BackupManagerService(context));
                }
                catch (Throwable e) {
                    Slog.e(TAG, "Failure starting Backup Service", e);
                }
                try {
                    Slog.i(TAG, "AppWidget Service");
                    appWidget = new AppWidgetService(context);
                    ServiceManager.addService("appwidget", appWidget);
                }
                catch (Throwable e) {
                    this.reportWtf("starting AppWidget Service", e);
                }
                try {
                    Slog.i(TAG, "Recognition Service");
                    recognition = new RecognitionManagerService(context);
                }
                catch (Throwable e) {
                    this.reportWtf("starting Recognition Service", e);
                }
            }
            try {
                Slog.i(TAG, "DiskStats Service");
                ServiceManager.addService("diskstats", new DiskStatsService(context));
            }
            catch (Throwable e) {
                this.reportWtf("starting DiskStats Service", e);
            }
            try {
                Slog.i(TAG, "SamplingProfiler Service");
                ServiceManager.addService("samplingprofiler", new SamplingProfilerService(context));
            }
            catch (Throwable e) {
                this.reportWtf("starting SamplingProfiler Service", e);
            }
            if (!disableNetwork) {
                try {
                    Slog.i(TAG, "NetworkTimeUpdateService");
                    networkTimeUpdater = new NetworkTimeUpdateService(context);
                }
                catch (Throwable e) {
                    this.reportWtf("starting NetworkTimeUpdate service", e);
                }
            }
            if (!disableMedia) {
                try {
                    Slog.i(TAG, "CommonTimeManagementService");
                    commonTimeMgmtService = new CommonTimeManagementService(context);
                    ServiceManager.addService("commontime_management", commonTimeMgmtService);
                }
                catch (Throwable e) {
                    this.reportWtf("starting CommonTimeManagementService service", e);
                }
            }
            if (!disableNetwork) {
                try {
                    Slog.i(TAG, "CertBlacklister");
                    CertBlacklister blacklister = new CertBlacklister(context);
                }
                catch (Throwable e) {
                    this.reportWtf("starting CertBlacklister", e);
                }
            }
            if (!disableNonCoreServices && context.getResources().getBoolean(17891401)) {
                try {
                    Slog.i(TAG, "Dreams Service");
                    dreamy = new DreamManagerService(context, wmHandler);
                    ServiceManager.addService("dreams", dreamy);
                }
                catch (Throwable e) {
                    this.reportWtf("starting DreamManagerService", e);
                }
            }
            if (!disableNonCoreServices) {
                try {
                    Slog.i(TAG, "Assets Atlas Service");
                    atlas = new AssetAtlasService(context);
                    ServiceManager.addService("assetatlas", atlas);
                }
                catch (Throwable e) {
                    this.reportWtf("starting AssetAtlasService", e);
                }
            }
            try {
                Slog.i(TAG, "IdleMaintenanceService");
                new IdleMaintenanceService(context, battery);
            }
            catch (Throwable e) {
                this.reportWtf("starting IdleMaintenanceService", e);
            }
            try {
                Slog.i(TAG, "Print Service");
                printManager = new PrintManagerService(context);
                ServiceManager.addService("print", printManager);
            }
            catch (Throwable e) {
                this.reportWtf("starting Print Service", e);
            }
        }
        if (safeMode = wm.detectSafeMode()) {
            ActivityManagerService.self().enterSafeMode();
            Zygote.systemInSafeMode = true;
            VMRuntime.getRuntime().disableJitCompilation();
        } else {
            VMRuntime.getRuntime().startJitCompilation();
        }
        try {
            vibrator.systemReady();
        }
        catch (Throwable e) {
            this.reportWtf("making Vibrator Service ready", e);
        }
        if (lockSettings != null) {
            try {
                lockSettings.systemReady();
            }
            catch (Throwable e) {
                this.reportWtf("making Lock Settings Service ready", e);
            }
        }
        if (devicePolicy != null) {
            try {
                devicePolicy.systemReady();
            }
            catch (Throwable e) {
                this.reportWtf("making Device Policy Service ready", e);
            }
        }
        if (notification != null) {
            try {
                notification.systemReady();
            }
            catch (Throwable e) {
                this.reportWtf("making Notification Service ready", e);
            }
        }
        try {
            wm.systemReady();
        }
        catch (Throwable e) {
            this.reportWtf("making Window Manager Service ready", e);
        }
        if (safeMode) {
            ActivityManagerService.self().showSafeModeOverlay();
        }
        Configuration config = wm.computeNewConfiguration();
        DisplayMetrics metrics = new DisplayMetrics();
        WindowManager w = (WindowManager)context.getSystemService("window");
        w.getDefaultDisplay().getMetrics(metrics);
        context.getResources().updateConfiguration(config, metrics);
        try {
            power.systemReady(twilight, dreamy);
        }
        catch (Throwable e) {
            this.reportWtf("making Power Manager Service ready", e);
        }
        try {
            pm.systemReady();
        }
        catch (Throwable e) {
            this.reportWtf("making Package Manager Service ready", e);
        }
        try {
            display.systemReady(safeMode, onlyCore);
        }
        catch (Throwable e) {
            this.reportWtf("making Display Manager Service ready", e);
        }
        final Context contextF = context;
        final MountService mountServiceF = mountService;
        final BatteryService batteryF = battery;
        final NetworkManagementService networkManagementF = networkManagement;
        final NetworkStatsService networkStatsF = networkStats;
        final NetworkPolicyManagerService networkPolicyF = networkPolicy;
        final ConnectivityService connectivityF = connectivity;
        final DockObserver dockF = dock;
        final UsbService usbF = usb;
        final TwilightService twilightF = twilight;
        final UiModeManagerService uiModeF = uiMode;
        final AppWidgetService appWidgetF = appWidget;
        final WallpaperManagerService wallpaperF = wallpaper;
        final InputMethodManagerService immF = imm;
        final RecognitionManagerService recognitionF = recognition;
        final LocationManagerService locationF = location;
        final CountryDetectorService countryDetectorF = countryDetector;
        final NetworkTimeUpdateService networkTimeUpdaterF = networkTimeUpdater;
        final CommonTimeManagementService commonTimeMgmtServiceF = commonTimeMgmtService;
        final TextServicesManagerService textServiceManagerServiceF = tsms;
        final StatusBarManagerService statusBarF = statusBar;
        final DreamManagerService dreamyF = dreamy;
        final AssetAtlasService atlasF = atlas;
        final InputManagerService inputManagerF = inputManager;
        final TelephonyRegistry telephonyRegistryF = telephonyRegistry;
        final PrintManagerService printManagerF = printManager;
        ActivityManagerService.self().systemReady(new Runnable(){

            public void run() {
                Slog.i(ServerThread.TAG, "Making services ready");
                try {
                    ActivityManagerService.self().startObservingNativeCrashes();
                }
                catch (Throwable e) {
                    ServerThread.this.reportWtf("observing native crashes", e);
                }
                if (!headless) {
                    ServerThread.startSystemUi(contextF);
                }
                try {
                    if (mountServiceF != null) {
                        mountServiceF.systemReady();
                    }
                }
                catch (Throwable e) {
                    ServerThread.this.reportWtf("making Mount Service ready", e);
                }
                try {
                    if (batteryF != null) {
                        batteryF.systemReady();
                    }
                }
                catch (Throwable e) {
                    ServerThread.this.reportWtf("making Battery Service ready", e);
                }
                try {
                    if (networkManagementF != null) {
                        networkManagementF.systemReady();
                    }
                }
                catch (Throwable e) {
                    ServerThread.this.reportWtf("making Network Managment Service ready", e);
                }
                try {
                    if (networkStatsF != null) {
                        networkStatsF.systemReady();
                    }
                }
                catch (Throwable e) {
                    ServerThread.this.reportWtf("making Network Stats Service ready", e);
                }
                try {
                    if (networkPolicyF != null) {
                        networkPolicyF.systemReady();
                    }
                }
                catch (Throwable e) {
                    ServerThread.this.reportWtf("making Network Policy Service ready", e);
                }
                try {
                    if (connectivityF != null) {
                        connectivityF.systemReady();
                    }
                }
                catch (Throwable e) {
                    ServerThread.this.reportWtf("making Connectivity Service ready", e);
                }
                try {
                    if (dockF != null) {
                        dockF.systemReady();
                    }
                }
                catch (Throwable e) {
                    ServerThread.this.reportWtf("making Dock Service ready", e);
                }
                try {
                    if (usbF != null) {
                        usbF.systemReady();
                    }
                }
                catch (Throwable e) {
                    ServerThread.this.reportWtf("making USB Service ready", e);
                }
                try {
                    if (twilightF != null) {
                        twilightF.systemReady();
                    }
                }
                catch (Throwable e) {
                    ServerThread.this.reportWtf("makin Twilight Service ready", e);
                }
                try {
                    if (uiModeF != null) {
                        uiModeF.systemReady();
                    }
                }
                catch (Throwable e) {
                    ServerThread.this.reportWtf("making UI Mode Service ready", e);
                }
                try {
                    if (recognitionF != null) {
                        recognitionF.systemReady();
                    }
                }
                catch (Throwable e) {
                    ServerThread.this.reportWtf("making Recognition Service ready", e);
                }
                Watchdog.getInstance().start();
                try {
                    if (appWidgetF != null) {
                        appWidgetF.systemRunning(safeMode);
                    }
                }
                catch (Throwable e) {
                    ServerThread.this.reportWtf("Notifying AppWidgetService running", e);
                }
                try {
                    if (wallpaperF != null) {
                        wallpaperF.systemRunning();
                    }
                }
                catch (Throwable e) {
                    ServerThread.this.reportWtf("Notifying WallpaperService running", e);
                }
                try {
                    if (immF != null) {
                        immF.systemRunning(statusBarF);
                    }
                }
                catch (Throwable e) {
                    ServerThread.this.reportWtf("Notifying InputMethodService running", e);
                }
                try {
                    if (locationF != null) {
                        locationF.systemRunning();
                    }
                }
                catch (Throwable e) {
                    ServerThread.this.reportWtf("Notifying Location Service running", e);
                }
                try {
                    if (countryDetectorF != null) {
                        countryDetectorF.systemRunning();
                    }
                }
                catch (Throwable e) {
                    ServerThread.this.reportWtf("Notifying CountryDetectorService running", e);
                }
                try {
                    if (networkTimeUpdaterF != null) {
                        networkTimeUpdaterF.systemRunning();
                    }
                }
                catch (Throwable e) {
                    ServerThread.this.reportWtf("Notifying NetworkTimeService running", e);
                }
                try {
                    if (commonTimeMgmtServiceF != null) {
                        commonTimeMgmtServiceF.systemRunning();
                    }
                }
                catch (Throwable e) {
                    ServerThread.this.reportWtf("Notifying CommonTimeManagementService running", e);
                }
                try {
                    if (textServiceManagerServiceF != null) {
                        textServiceManagerServiceF.systemRunning();
                    }
                }
                catch (Throwable e) {
                    ServerThread.this.reportWtf("Notifying TextServicesManagerService running", e);
                }
                try {
                    if (dreamyF != null) {
                        dreamyF.systemRunning();
                    }
                }
                catch (Throwable e) {
                    ServerThread.this.reportWtf("Notifying DreamManagerService running", e);
                }
                try {
                    if (atlasF != null) {
                        atlasF.systemRunning();
                    }
                }
                catch (Throwable e) {
                    ServerThread.this.reportWtf("Notifying AssetAtlasService running", e);
                }
                try {
                    if (inputManagerF != null) {
                        inputManagerF.systemRunning();
                    }
                }
                catch (Throwable e) {
                    ServerThread.this.reportWtf("Notifying InputManagerService running", e);
                }
                try {
                    if (telephonyRegistryF != null) {
                        telephonyRegistryF.systemRunning();
                    }
                }
                catch (Throwable e) {
                    ServerThread.this.reportWtf("Notifying TelephonyRegistry running", e);
                }
                try {
                    if (printManagerF != null) {
                        printManagerF.systemRuning();
                    }
                }
                catch (Throwable e) {
                    ServerThread.this.reportWtf("Notifying PrintManagerService running", e);
                }
            }
        });
        if (StrictMode.conditionallyEnableDebugLogging()) {
            Slog.i(TAG, "Enabled StrictMode for system server main thread.");
        }
        Looper.loop();
        Slog.d(TAG, "System ServerThread is exiting!");
    }

    static final void startSystemUi(Context context) {
        Intent intent = new Intent();
        intent.setComponent(new ComponentName("com.android.systemui", "com.android.systemui.SystemUIService"));
        context.startServiceAsUser(intent, UserHandle.OWNER);
    }
}

