/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.pm;

import android.content.pm.PackageStats;
import android.net.LocalSocket;
import android.net.LocalSocketAddress;
import android.util.Slog;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class Installer {
    private static final String TAG = "Installer";
    private static final boolean LOCAL_DEBUG = false;
    InputStream mIn;
    OutputStream mOut;
    LocalSocket mSocket;
    byte[] buf = new byte[1024];
    int buflen = 0;

    private boolean connect() {
        if (this.mSocket != null) {
            return true;
        }
        Slog.i(TAG, "connecting...");
        try {
            this.mSocket = new LocalSocket();
            LocalSocketAddress address = new LocalSocketAddress("installd", LocalSocketAddress.Namespace.RESERVED);
            this.mSocket.connect(address);
            this.mIn = this.mSocket.getInputStream();
            this.mOut = this.mSocket.getOutputStream();
        }
        catch (IOException ex) {
            this.disconnect();
            return false;
        }
        return true;
    }

    private void disconnect() {
        Slog.i(TAG, "disconnecting...");
        try {
            if (this.mSocket != null) {
                this.mSocket.close();
            }
        }
        catch (IOException ex) {
            // empty catch block
        }
        try {
            if (this.mIn != null) {
                this.mIn.close();
            }
        }
        catch (IOException ex) {
            // empty catch block
        }
        try {
            if (this.mOut != null) {
                this.mOut.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.mSocket = null;
        this.mIn = null;
        this.mOut = null;
    }

    private boolean readBytes(byte[] buffer, int len) {
        int off;
        int count;
        if (len < 0) {
            return false;
        }
        for (off = 0; off != len; off += count) {
            try {
                count = this.mIn.read(buffer, off, len - off);
                if (count > 0) continue;
                Slog.e(TAG, "read error " + count);
                break;
            }
            catch (IOException ex) {
                Slog.e(TAG, "read exception");
                break;
            }
        }
        if (off == len) {
            return true;
        }
        this.disconnect();
        return false;
    }

    private boolean readReply() {
        this.buflen = 0;
        if (!this.readBytes(this.buf, 2)) {
            return false;
        }
        int len = this.buf[0] & 0xFF | (this.buf[1] & 0xFF) << 8;
        if (len < 1 || len > 1024) {
            Slog.e(TAG, "invalid reply length (" + len + ")");
            this.disconnect();
            return false;
        }
        if (!this.readBytes(this.buf, len)) {
            return false;
        }
        this.buflen = len;
        return true;
    }

    private boolean writeCommand(String _cmd) {
        byte[] cmd = _cmd.getBytes();
        int len = cmd.length;
        if (len < 1 || len > 1024) {
            return false;
        }
        this.buf[0] = (byte)(len & 0xFF);
        this.buf[1] = (byte)(len >> 8 & 0xFF);
        try {
            this.mOut.write(this.buf, 0, 2);
            this.mOut.write(cmd, 0, len);
        }
        catch (IOException ex) {
            Slog.e(TAG, "write error");
            this.disconnect();
            return false;
        }
        return true;
    }

    private synchronized String transaction(String cmd) {
        if (!this.connect()) {
            Slog.e(TAG, "connection failed");
            return "-1";
        }
        if (!this.writeCommand(cmd)) {
            Slog.e(TAG, "write command failed? reconnect!");
            if (!this.connect() || !this.writeCommand(cmd)) {
                return "-1";
            }
        }
        if (this.readReply()) {
            String s = new String(this.buf, 0, this.buflen);
            return s;
        }
        return "-1";
    }

    private int execute(String cmd) {
        String res = this.transaction(cmd);
        try {
            return Integer.parseInt(res);
        }
        catch (NumberFormatException ex) {
            return -1;
        }
    }

    public int install(String name, int uid, int gid, String seinfo) {
        StringBuilder builder = new StringBuilder("install");
        builder.append(' ');
        builder.append(name);
        builder.append(' ');
        builder.append(uid);
        builder.append(' ');
        builder.append(gid);
        builder.append(' ');
        builder.append(seinfo != null ? seinfo : "!");
        return this.execute(builder.toString());
    }

    public int dexopt(String apkPath, int uid, boolean isPublic) {
        StringBuilder builder = new StringBuilder("dexopt");
        builder.append(' ');
        builder.append(apkPath);
        builder.append(' ');
        builder.append(uid);
        builder.append(isPublic ? " 1" : " 0");
        return this.execute(builder.toString());
    }

    public int movedex(String srcPath, String dstPath) {
        StringBuilder builder = new StringBuilder("movedex");
        builder.append(' ');
        builder.append(srcPath);
        builder.append(' ');
        builder.append(dstPath);
        return this.execute(builder.toString());
    }

    public int rmdex(String codePath) {
        StringBuilder builder = new StringBuilder("rmdex");
        builder.append(' ');
        builder.append(codePath);
        return this.execute(builder.toString());
    }

    public int remove(String name, int userId) {
        StringBuilder builder = new StringBuilder("remove");
        builder.append(' ');
        builder.append(name);
        builder.append(' ');
        builder.append(userId);
        return this.execute(builder.toString());
    }

    public int rename(String oldname, String newname) {
        StringBuilder builder = new StringBuilder("rename");
        builder.append(' ');
        builder.append(oldname);
        builder.append(' ');
        builder.append(newname);
        return this.execute(builder.toString());
    }

    public int fixUid(String name, int uid, int gid) {
        StringBuilder builder = new StringBuilder("fixuid");
        builder.append(' ');
        builder.append(name);
        builder.append(' ');
        builder.append(uid);
        builder.append(' ');
        builder.append(gid);
        return this.execute(builder.toString());
    }

    public int deleteCacheFiles(String name, int userId) {
        StringBuilder builder = new StringBuilder("rmcache");
        builder.append(' ');
        builder.append(name);
        builder.append(' ');
        builder.append(userId);
        return this.execute(builder.toString());
    }

    public int createUserData(String name, int uid, int userId) {
        StringBuilder builder = new StringBuilder("mkuserdata");
        builder.append(' ');
        builder.append(name);
        builder.append(' ');
        builder.append(uid);
        builder.append(' ');
        builder.append(userId);
        return this.execute(builder.toString());
    }

    public int removeUserDataDirs(int userId) {
        StringBuilder builder = new StringBuilder("rmuser");
        builder.append(' ');
        builder.append(userId);
        return this.execute(builder.toString());
    }

    public int clearUserData(String name, int userId) {
        StringBuilder builder = new StringBuilder("rmuserdata");
        builder.append(' ');
        builder.append(name);
        builder.append(' ');
        builder.append(userId);
        return this.execute(builder.toString());
    }

    public boolean ping() {
        return this.execute("ping") >= 0;
    }

    public int freeCache(long freeStorageSize) {
        StringBuilder builder = new StringBuilder("freecache");
        builder.append(' ');
        builder.append(String.valueOf(freeStorageSize));
        return this.execute(builder.toString());
    }

    public int getSizeInfo(String pkgName, int persona, String apkPath, String libDirPath, String fwdLockApkPath, String asecPath, PackageStats pStats) {
        StringBuilder builder = new StringBuilder("getsize");
        builder.append(' ');
        builder.append(pkgName);
        builder.append(' ');
        builder.append(persona);
        builder.append(' ');
        builder.append(apkPath);
        builder.append(' ');
        builder.append(libDirPath != null ? libDirPath : "!");
        builder.append(' ');
        builder.append(fwdLockApkPath != null ? fwdLockApkPath : "!");
        builder.append(' ');
        builder.append(asecPath != null ? asecPath : "!");
        String s = this.transaction(builder.toString());
        String[] res = s.split(" ");
        if (res == null || res.length != 5) {
            return -1;
        }
        try {
            pStats.codeSize = Long.parseLong(res[1]);
            pStats.dataSize = Long.parseLong(res[2]);
            pStats.cacheSize = Long.parseLong(res[3]);
            pStats.externalCodeSize = Long.parseLong(res[4]);
            return Integer.parseInt(res[0]);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public int moveFiles() {
        return this.execute("movefiles");
    }

    public int linkNativeLibraryDirectory(String dataPath, String nativeLibPath, int userId) {
        if (dataPath == null) {
            Slog.e(TAG, "linkNativeLibraryDirectory dataPath is null");
            return -1;
        }
        if (nativeLibPath == null) {
            Slog.e(TAG, "linkNativeLibraryDirectory nativeLibPath is null");
            return -1;
        }
        StringBuilder builder = new StringBuilder("linklib ");
        builder.append(dataPath);
        builder.append(' ');
        builder.append(nativeLibPath);
        builder.append(' ');
        builder.append(userId);
        return this.execute(builder.toString());
    }
}

