/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.ReadOnlyBufferException;

final class FloatArrayBuffer
extends FloatBuffer {
    private final float[] backingArray;
    private final int arrayOffset;
    private final boolean isReadOnly;

    FloatArrayBuffer(float[] array2) {
        this(array2.length, array2, 0, false);
    }

    private FloatArrayBuffer(int capacity, float[] backingArray, int arrayOffset, boolean isReadOnly) {
        super(capacity);
        this.backingArray = backingArray;
        this.arrayOffset = arrayOffset;
        this.isReadOnly = isReadOnly;
    }

    private static FloatArrayBuffer copy(FloatArrayBuffer other, int markOfOther, boolean isReadOnly) {
        FloatArrayBuffer buf = new FloatArrayBuffer(other.capacity(), other.backingArray, other.arrayOffset, isReadOnly);
        buf.limit = other.limit;
        buf.position = other.position();
        buf.mark = markOfOther;
        return buf;
    }

    public FloatBuffer asReadOnlyBuffer() {
        return FloatArrayBuffer.copy(this, this.mark, true);
    }

    public FloatBuffer compact() {
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        System.arraycopy(this.backingArray, this.position + this.arrayOffset, this.backingArray, this.arrayOffset, this.remaining());
        this.position = this.limit - this.position;
        this.limit = this.capacity;
        this.mark = -1;
        return this;
    }

    public FloatBuffer duplicate() {
        return FloatArrayBuffer.copy(this, this.mark, this.isReadOnly);
    }

    public FloatBuffer slice() {
        return new FloatArrayBuffer(this.remaining(), this.backingArray, this.arrayOffset + this.position, this.isReadOnly);
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    float[] protectedArray() {
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        return this.backingArray;
    }

    int protectedArrayOffset() {
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        return this.arrayOffset;
    }

    boolean protectedHasArray() {
        return !this.isReadOnly;
    }

    public final float get() {
        if (this.position == this.limit) {
            throw new BufferUnderflowException();
        }
        return this.backingArray[this.arrayOffset + this.position++];
    }

    public final float get(int index) {
        this.checkIndex(index);
        return this.backingArray[this.arrayOffset + index];
    }

    public final FloatBuffer get(float[] dst, int dstOffset, int floatCount) {
        if (floatCount > this.remaining()) {
            throw new BufferUnderflowException();
        }
        System.arraycopy(this.backingArray, this.arrayOffset + this.position, dst, dstOffset, floatCount);
        this.position += floatCount;
        return this;
    }

    public final boolean isDirect() {
        return false;
    }

    public final ByteOrder order() {
        return ByteOrder.nativeOrder();
    }

    public FloatBuffer put(float c) {
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        if (this.position == this.limit) {
            throw new BufferOverflowException();
        }
        this.backingArray[this.arrayOffset + this.position++] = c;
        return this;
    }

    public FloatBuffer put(int index, float c) {
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        this.checkIndex(index);
        this.backingArray[this.arrayOffset + index] = c;
        return this;
    }

    public FloatBuffer put(float[] src, int srcOffset, int floatCount) {
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        if (floatCount > this.remaining()) {
            throw new BufferOverflowException();
        }
        System.arraycopy(src, srcOffset, this.backingArray, this.arrayOffset + this.position, floatCount);
        this.position += floatCount;
        return this;
    }
}

