/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.io.FileDescriptor;
import java.io.IOException;
import java.nio.FileDescriptorChannel;
import java.nio.SelectionKeyImpl;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.IllegalSelectorException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.nio.channels.spi.AbstractSelectionKey;
import java.nio.channels.spi.AbstractSelector;
import java.nio.channels.spi.SelectorProvider;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.UnsafeArrayList;
import libcore.io.ErrnoException;
import libcore.io.IoBridge;
import libcore.io.IoUtils;
import libcore.io.Libcore;
import libcore.io.OsConstants;
import libcore.io.StructPollfd;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SelectorImpl
extends AbstractSelector {
    final Object keysLock = new Object();
    private final Set<SelectionKeyImpl> mutableKeys = new HashSet<SelectionKeyImpl>();
    private final Set<SelectionKey> unmodifiableKeys = Collections.unmodifiableSet(this.mutableKeys);
    private final Set<SelectionKey> mutableSelectedKeys = new HashSet<SelectionKey>();
    private final Set<SelectionKey> selectedKeys = new UnaddableSet<SelectionKey>(this.mutableSelectedKeys);
    private final FileDescriptor wakeupIn;
    private final FileDescriptor wakeupOut;
    private final UnsafeArrayList<StructPollfd> pollFds = new UnsafeArrayList<StructPollfd>(StructPollfd.class, 8);

    public SelectorImpl(SelectorProvider selectorProvider) throws IOException {
        super(selectorProvider);
        try {
            FileDescriptor[] pipeFds = Libcore.os.pipe();
            this.wakeupIn = pipeFds[0];
            this.wakeupOut = pipeFds[1];
            IoUtils.setBlocking(this.wakeupIn, false);
            this.pollFds.add(new StructPollfd());
            this.setPollFd(0, this.wakeupIn, OsConstants.POLLIN, null);
        }
        catch (ErrnoException errnoException) {
            throw errnoException.rethrowAsIOException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void implCloseSelector() throws IOException {
        this.wakeup();
        SelectorImpl selectorImpl = this;
        synchronized (selectorImpl) {
            Set<SelectionKey> set = this.unmodifiableKeys;
            synchronized (set) {
                Set<SelectionKey> set2 = this.selectedKeys;
                synchronized (set2) {
                    IoUtils.close(this.wakeupIn);
                    IoUtils.close(this.wakeupOut);
                    this.doCancel();
                    for (SelectionKeyImpl sk : this.mutableKeys) {
                        this.deregister(sk);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected SelectionKey register(AbstractSelectableChannel channel, int operations, Object attachment) {
        if (!this.provider().equals(channel.provider())) {
            throw new IllegalSelectorException();
        }
        SelectorImpl selectorImpl = this;
        synchronized (selectorImpl) {
            Set<SelectionKey> set = this.unmodifiableKeys;
            synchronized (set) {
                SelectionKeyImpl selectionKey = new SelectionKeyImpl(channel, operations, attachment, this);
                this.mutableKeys.add(selectionKey);
                this.ensurePollFdsCapacity();
                return selectionKey;
            }
        }
    }

    @Override
    public synchronized Set<SelectionKey> keys() {
        this.checkClosed();
        return this.unmodifiableKeys;
    }

    private void checkClosed() {
        if (!this.isOpen()) {
            throw new ClosedSelectorException();
        }
    }

    @Override
    public int select() throws IOException {
        return this.selectInternal(-1L);
    }

    @Override
    public int select(long timeout) throws IOException {
        if (timeout < 0L) {
            throw new IllegalArgumentException("timeout < 0: " + timeout);
        }
        return this.selectInternal(timeout == 0L ? -1L : timeout);
    }

    @Override
    public int selectNow() throws IOException {
        return this.selectInternal(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int selectInternal(long timeout) throws IOException {
        this.checkClosed();
        SelectorImpl selectorImpl = this;
        synchronized (selectorImpl) {
            Set<SelectionKey> set = this.unmodifiableKeys;
            synchronized (set) {
                Set<SelectionKey> set2 = this.selectedKeys;
                synchronized (set2) {
                    this.doCancel();
                    boolean isBlocking = timeout != 0L;
                    Object object = this.keysLock;
                    synchronized (object) {
                        this.preparePollFds();
                    }
                    int rc = -1;
                    try {
                        if (isBlocking) {
                            this.begin();
                        }
                        try {
                            rc = Libcore.os.poll(this.pollFds.array(), (int)timeout);
                        }
                        catch (ErrnoException errnoException) {
                            if (errnoException.errno != OsConstants.EINTR) {
                                throw errnoException.rethrowAsIOException();
                            }
                        }
                    }
                    finally {
                        if (isBlocking) {
                            this.end();
                        }
                    }
                    int readyCount = rc > 0 ? this.processPollFds() : 0;
                    return readyCount -= this.doCancel();
                }
            }
        }
    }

    private void setPollFd(int i, FileDescriptor fd, int events, Object object) {
        StructPollfd pollFd = this.pollFds.get(i);
        pollFd.fd = fd;
        pollFd.events = (short)events;
        pollFd.userData = object;
    }

    private void preparePollFds() {
        int i = 1;
        for (SelectionKeyImpl key : this.mutableKeys) {
            int interestOps = key.interestOpsNoCheck();
            int eventMask = 0;
            if ((0x11 & interestOps) != 0) {
                eventMask = (short)(eventMask | OsConstants.POLLIN);
            }
            if ((0xC & interestOps) != 0) {
                eventMask = (short)(eventMask | OsConstants.POLLOUT);
            }
            if (eventMask == 0) continue;
            this.setPollFd(i++, ((FileDescriptorChannel)((Object)key.channel())).getFD(), eventMask, key);
        }
    }

    private void ensurePollFdsCapacity() {
        while (this.pollFds.size() < this.mutableKeys.size() + 1) {
            this.pollFds.add(new StructPollfd());
        }
    }

    private int processPollFds() throws IOException {
        if (this.pollFds.get((int)0).revents == OsConstants.POLLIN) {
            byte[] buffer = new byte[8];
            while (IoBridge.read(this.wakeupIn, buffer, 0, 1) > 0) {
            }
        }
        int readyKeyCount = 0;
        for (int i = 1; i < this.pollFds.size(); ++i) {
            StructPollfd pollFd = this.pollFds.get(i);
            if (pollFd.revents == 0) continue;
            if (pollFd.fd == null) break;
            SelectionKeyImpl key = (SelectionKeyImpl)pollFd.userData;
            pollFd.fd = null;
            pollFd.userData = null;
            int ops = key.interestOpsNoCheck();
            int selectedOps = 0;
            if ((pollFd.revents & OsConstants.POLLHUP) != 0) {
                selectedOps |= ops;
            }
            if ((pollFd.revents & OsConstants.POLLIN) != 0) {
                selectedOps |= ops & 0x11;
            }
            if ((pollFd.revents & OsConstants.POLLOUT) != 0) {
                selectedOps = key.isConnected() ? (selectedOps |= ops & 4) : (selectedOps |= ops & 8);
            }
            if (selectedOps == 0) continue;
            boolean wasSelected = this.mutableSelectedKeys.contains(key);
            if (wasSelected && key.readyOps() != selectedOps) {
                key.setReadyOps(key.readyOps() | selectedOps);
                ++readyKeyCount;
                continue;
            }
            if (wasSelected) continue;
            key.setReadyOps(selectedOps);
            this.mutableSelectedKeys.add(key);
            ++readyKeyCount;
        }
        return readyKeyCount;
    }

    @Override
    public synchronized Set<SelectionKey> selectedKeys() {
        this.checkClosed();
        return this.selectedKeys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int doCancel() {
        Set<SelectionKey> cancelledKeys;
        int deselected = 0;
        Set<SelectionKey> set = cancelledKeys = this.cancelledKeys();
        synchronized (set) {
            if (cancelledKeys.size() > 0) {
                for (SelectionKey currentKey : cancelledKeys) {
                    this.mutableKeys.remove(currentKey);
                    this.deregister((AbstractSelectionKey)currentKey);
                    if (!this.mutableSelectedKeys.remove(currentKey)) continue;
                    ++deselected;
                }
                cancelledKeys.clear();
            }
        }
        return deselected;
    }

    @Override
    public Selector wakeup() {
        try {
            Libcore.os.write(this.wakeupOut, new byte[]{1}, 0, 1);
        }
        catch (ErrnoException errnoException) {
            // empty catch block
        }
        return this;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UnaddableSet<E>
    implements Set<E> {
        private final Set<E> set;

        UnaddableSet(Set<E> set) {
            this.set = set;
        }

        @Override
        public boolean equals(Object object) {
            return ((Object)this.set).equals(object);
        }

        @Override
        public int hashCode() {
            return ((Object)this.set).hashCode();
        }

        @Override
        public boolean add(E object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends E> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            this.set.clear();
        }

        @Override
        public boolean contains(Object object) {
            return this.set.contains(object);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.set.containsAll(c);
        }

        @Override
        public boolean isEmpty() {
            return this.set.isEmpty();
        }

        @Override
        public Iterator<E> iterator() {
            return this.set.iterator();
        }

        @Override
        public boolean remove(Object object) {
            return this.set.remove(object);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return this.set.removeAll(c);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return this.set.retainAll(c);
        }

        @Override
        public int size() {
            return this.set.size();
        }

        @Override
        public Object[] toArray() {
            return this.set.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.set.toArray(a);
        }
    }
}

