/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.nio.ByteBuffer;
import java.security.DigestException;

public abstract class MessageDigestSpi {
    protected int engineGetDigestLength() {
        return 0;
    }

    protected abstract void engineUpdate(byte var1);

    protected abstract void engineUpdate(byte[] var1, int var2, int var3);

    protected void engineUpdate(ByteBuffer input) {
        if (!input.hasRemaining()) {
            return;
        }
        if (input.hasArray()) {
            byte[] tmp = input.array();
            int offset = input.arrayOffset();
            int position = input.position();
            int limit = input.limit();
            this.engineUpdate(tmp, offset + position, limit - position);
            input.position(limit);
        } else {
            byte[] tmp = new byte[input.limit() - input.position()];
            input.get(tmp);
            this.engineUpdate(tmp, 0, tmp.length);
        }
    }

    protected abstract byte[] engineDigest();

    protected int engineDigest(byte[] buf, int offset, int len) throws DigestException {
        if (len < this.engineGetDigestLength()) {
            this.engineReset();
            throw new DigestException("The value of len parameter is less than the actual digest length");
        }
        if (offset < 0) {
            this.engineReset();
            throw new DigestException("offset < 0");
        }
        if (offset + len > buf.length) {
            this.engineReset();
            throw new DigestException("offset + len > buf.length");
        }
        byte[] tmp = this.engineDigest();
        if (len < tmp.length) {
            throw new DigestException("The value of len parameter is less than the actual digest length");
        }
        System.arraycopy(tmp, 0, buf, offset, tmp.length);
        return tmp.length;
    }

    protected abstract void engineReset();

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

