/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractQueue;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.SortedSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PriorityQueue<E>
extends AbstractQueue<E>
implements Serializable {
    private static final long serialVersionUID = -7720805057305804111L;
    private static final int DEFAULT_CAPACITY = 11;
    private static final double DEFAULT_INIT_CAPACITY_RATIO = 1.1;
    private static final int DEFAULT_CAPACITY_RATIO = 2;
    private int size;
    private Comparator<? super E> comparator;
    private transient E[] elements;

    public PriorityQueue() {
        this(11);
    }

    public PriorityQueue(int initialCapacity) {
        this(initialCapacity, null);
    }

    public PriorityQueue(int initialCapacity, Comparator<? super E> comparator) {
        if (initialCapacity < 1) {
            throw new IllegalArgumentException("initialCapacity < 1: " + initialCapacity);
        }
        this.elements = this.newElementArray(initialCapacity);
        this.comparator = comparator;
    }

    public PriorityQueue(Collection<? extends E> c) {
        if (c instanceof PriorityQueue) {
            this.getFromPriorityQueue((PriorityQueue)c);
        } else if (c instanceof SortedSet) {
            this.getFromSortedSet((SortedSet)c);
        } else {
            this.initSize(c);
            this.addAll(c);
        }
    }

    public PriorityQueue(PriorityQueue<? extends E> c) {
        this.getFromPriorityQueue(c);
    }

    public PriorityQueue(SortedSet<? extends E> c) {
        this.getFromSortedSet(c);
    }

    @Override
    public Iterator<E> iterator() {
        return new PriorityIterator();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void clear() {
        Arrays.fill(this.elements, null);
        this.size = 0;
    }

    @Override
    public boolean offer(E o) {
        if (o == null) {
            throw new NullPointerException("o == null");
        }
        this.growToSize(this.size + 1);
        this.elements[this.size] = o;
        this.siftUp(this.size++);
        return true;
    }

    @Override
    public E poll() {
        if (this.isEmpty()) {
            return null;
        }
        E result = this.elements[0];
        this.removeAt(0);
        return result;
    }

    @Override
    public E peek() {
        if (this.isEmpty()) {
            return null;
        }
        return this.elements[0];
    }

    public Comparator<? super E> comparator() {
        return this.comparator;
    }

    @Override
    public boolean remove(Object o) {
        if (o == null) {
            return false;
        }
        for (int targetIndex = 0; targetIndex < this.size; ++targetIndex) {
            if (!o.equals(this.elements[targetIndex])) continue;
            this.removeAt(targetIndex);
            return true;
        }
        return false;
    }

    @Override
    public boolean add(E o) {
        return this.offer(o);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        int capacity = in.readInt();
        this.elements = this.newElementArray(capacity);
        for (int i = 0; i < this.size; ++i) {
            this.elements[i] = in.readObject();
        }
    }

    private E[] newElementArray(int capacity) {
        return new Object[capacity];
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeInt(this.elements.length);
        for (int i = 0; i < this.size; ++i) {
            out.writeObject(this.elements[i]);
        }
    }

    private void getFromPriorityQueue(PriorityQueue<? extends E> c) {
        this.initSize(c);
        this.comparator = c.comparator();
        System.arraycopy(c.elements, 0, this.elements, 0, c.size());
        this.size = c.size();
    }

    private void getFromSortedSet(SortedSet<? extends E> c) {
        this.initSize(c);
        this.comparator = c.comparator();
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            this.elements[this.size++] = iter.next();
        }
    }

    private void removeAt(int index) {
        E moved;
        --this.size;
        this.elements[index] = moved = this.elements[this.size];
        this.siftDown(index);
        this.elements[this.size] = null;
        if (moved == this.elements[index]) {
            this.siftUp(index);
        }
    }

    private int compare(E o1, E o2) {
        if (this.comparator != null) {
            return this.comparator.compare(o1, o2);
        }
        return ((Comparable)o1).compareTo(o2);
    }

    private void siftUp(int childIndex) {
        int parentIndex;
        E parent;
        E target = this.elements[childIndex];
        while (childIndex > 0 && this.compare(parent = this.elements[parentIndex = (childIndex - 1) / 2], target) > 0) {
            this.elements[childIndex] = parent;
            childIndex = parentIndex;
        }
        this.elements[childIndex] = target;
    }

    private void siftDown(int rootIndex) {
        int childIndex;
        E target = this.elements[rootIndex];
        while ((childIndex = rootIndex * 2 + 1) < this.size) {
            if (childIndex + 1 < this.size && this.compare(this.elements[childIndex + 1], this.elements[childIndex]) < 0) {
                ++childIndex;
            }
            if (this.compare(target, this.elements[childIndex]) <= 0) break;
            this.elements[rootIndex] = this.elements[childIndex];
            rootIndex = childIndex;
        }
        this.elements[rootIndex] = target;
    }

    private void initSize(Collection<? extends E> c) {
        if (c == null) {
            throw new NullPointerException("c == null");
        }
        if (c.isEmpty()) {
            this.elements = this.newElementArray(1);
        } else {
            int capacity = (int)Math.ceil((double)c.size() * 1.1);
            this.elements = this.newElementArray(capacity);
        }
    }

    private void growToSize(int size) {
        if (size > this.elements.length) {
            E[] newElements = this.newElementArray(size * 2);
            System.arraycopy(this.elements, 0, newElements, 0, this.elements.length);
            this.elements = newElements;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PriorityIterator
    implements Iterator<E> {
        private int currentIndex = -1;
        private boolean allowRemove = false;

        private PriorityIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.currentIndex < PriorityQueue.this.size - 1;
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.allowRemove = true;
            return PriorityQueue.this.elements[++this.currentIndex];
        }

        @Override
        public void remove() {
            if (!this.allowRemove) {
                throw new IllegalStateException();
            }
            this.allowRemove = false;
            PriorityQueue.this.removeAt(this.currentIndex--);
        }
    }
}

