/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.ServiceConfigurationError;
import java.util.Set;
import libcore.io.IoUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ServiceLoader<S>
implements Iterable<S> {
    private final Class<S> service;
    private final ClassLoader classLoader;
    private final Set<URL> services;

    private ServiceLoader(Class<S> service, ClassLoader classLoader) {
        if (service == null) {
            throw new NullPointerException("service == null");
        }
        this.service = service;
        this.classLoader = classLoader;
        this.services = new HashSet<URL>();
        this.reload();
    }

    public void reload() {
        this.internalLoad();
    }

    @Override
    public Iterator<S> iterator() {
        return new ServiceIterator(this);
    }

    public static <S> ServiceLoader<S> load(Class<S> service, ClassLoader classLoader) {
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        return new ServiceLoader<S>(service, classLoader);
    }

    private void internalLoad() {
        this.services.clear();
        try {
            String name = "META-INF/services/" + this.service.getName();
            this.services.addAll(Collections.list(this.classLoader.getResources(name)));
        }
        catch (IOException e) {
            return;
        }
    }

    public static <S> ServiceLoader<S> load(Class<S> service) {
        return ServiceLoader.load(service, Thread.currentThread().getContextClassLoader());
    }

    public static <S> ServiceLoader<S> loadInstalled(Class<S> service) {
        ClassLoader cl = ClassLoader.getSystemClassLoader();
        if (cl != null) {
            while (cl.getParent() != null) {
                cl = cl.getParent();
            }
        }
        return ServiceLoader.load(service, cl);
    }

    public static <S> S loadFromSystemProperty(Class<S> service) {
        try {
            String className = System.getProperty(service.getName());
            if (className != null) {
                Class<?> c = ClassLoader.getSystemClassLoader().loadClass(className);
                return (S)c.newInstance();
            }
            return null;
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    public String toString() {
        return "ServiceLoader for " + this.service.getName();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ServiceIterator
    implements Iterator<S> {
        private final ClassLoader classLoader;
        private final Class<S> service;
        private final Set<URL> services;
        private boolean isRead = false;
        private LinkedList<String> queue = new LinkedList();

        public ServiceIterator(ServiceLoader<S> sl) {
            this.classLoader = sl.classLoader;
            this.service = sl.service;
            this.services = sl.services;
        }

        @Override
        public boolean hasNext() {
            if (!this.isRead) {
                this.readClass();
            }
            return this.queue != null && !this.queue.isEmpty();
        }

        @Override
        public S next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            String className = this.queue.remove();
            try {
                return this.service.cast(this.classLoader.loadClass(className).newInstance());
            }
            catch (Exception e) {
                throw new ServiceConfigurationError("Couldn't instantiate class " + className, e);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void readClass() {
            Iterator<URL> i$ = this.services.iterator();
            while (i$.hasNext()) {
                Object var8_8;
                URL url = i$.next();
                BufferedReader reader = null;
                try {
                    try {
                        String line;
                        reader = new BufferedReader(new InputStreamReader(url.openStream(), "UTF-8"));
                        while ((line = reader.readLine()) != null) {
                            int commentStart = line.indexOf(35);
                            if (commentStart != -1) {
                                line = line.substring(0, commentStart);
                            }
                            if ((line = line.trim()).isEmpty()) continue;
                            String className = line;
                            this.checkValidJavaClassName(className);
                            if (this.queue.contains(className)) continue;
                            this.queue.add(className);
                        }
                        this.isRead = true;
                    }
                    catch (Exception e) {
                        throw new ServiceConfigurationError("Couldn't read " + url, e);
                    }
                    var8_8 = null;
                }
                catch (Throwable throwable) {
                    var8_8 = null;
                    IoUtils.closeQuietly(reader);
                    throw throwable;
                }
                IoUtils.closeQuietly(reader);
            }
            return;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void checkValidJavaClassName(String className) {
            for (int i = 0; i < className.length(); ++i) {
                char ch = className.charAt(i);
                if (Character.isJavaIdentifierPart(ch) || ch == '.') continue;
                throw new ServiceConfigurationError("Bad character '" + ch + "' in class name");
            }
        }
    }
}

