/*
 * Decompiled with CFR 0.152.
 */
package android.alsa;

import android.alsa.LineTokenizer;
import android.util.Slog;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;

public class AlsaCardsParser {
    private static final String TAG = "AlsaCardsParser";
    private static LineTokenizer tokenizer_ = new LineTokenizer(" :[]");
    private Vector<AlsaCardRecord> cardRecords_ = new Vector();

    public void scan() {
        this.cardRecords_.clear();
        String cardsFilePath = "/proc/asound/cards";
        File cardsFile = new File("/proc/asound/cards");
        try {
            FileReader reader = new FileReader(cardsFile);
            BufferedReader bufferedReader = new BufferedReader(reader);
            String line = "";
            while ((line = bufferedReader.readLine()) != null) {
                AlsaCardRecord cardRecord = new AlsaCardRecord();
                cardRecord.parse(line, 0);
                line = bufferedReader.readLine();
                cardRecord.parse(line, 1);
                this.cardRecords_.add(cardRecord);
            }
            reader.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public AlsaCardRecord getCardRecordAt(int index) {
        return this.cardRecords_.get(index);
    }

    public int getNumCardRecords() {
        return this.cardRecords_.size();
    }

    public void Log() {
        int numCardRecs = this.getNumCardRecords();
        for (int index = 0; index < numCardRecs; ++index) {
            Slog.w(TAG, "usb:" + this.getCardRecordAt(index).textFormat());
        }
    }

    public class AlsaCardRecord {
        public int mCardNum = -1;
        public String mField1 = "";
        public String mCardName = "";
        public String mCardDescription = "";

        public boolean parse(String line, int lineIndex) {
            int tokenIndex = 0;
            int delimIndex = 0;
            if (lineIndex == 0) {
                tokenIndex = tokenizer_.nextToken(line, tokenIndex);
                delimIndex = tokenizer_.nextDelimiter(line, tokenIndex);
                tokenIndex = tokenizer_.nextToken(line, delimIndex);
                delimIndex = tokenizer_.nextDelimiter(line, tokenIndex);
                this.mField1 = line.substring(tokenIndex, delimIndex);
                tokenIndex = tokenizer_.nextToken(line, delimIndex);
                this.mCardName = line.substring(tokenIndex);
            } else if (lineIndex == 1 && (tokenIndex = tokenizer_.nextToken(line, 0)) != -1) {
                this.mCardDescription = line.substring(tokenIndex);
            }
            return true;
        }

        public String textFormat() {
            return this.mCardName + " : " + this.mCardDescription;
        }
    }
}

