/*
 * Decompiled with CFR 0.152.
 */
package android.app.backup;

import java.io.FileDescriptor;
import java.io.IOException;

public class BackupDataOutput {
    long mBackupWriter;

    public BackupDataOutput(FileDescriptor fd) {
        if (fd == null) {
            throw new NullPointerException();
        }
        this.mBackupWriter = BackupDataOutput.ctor(fd);
        if (this.mBackupWriter == 0L) {
            throw new RuntimeException("Native initialization failed with fd=" + fd);
        }
    }

    public int writeEntityHeader(String key, int dataSize) throws IOException {
        int result = BackupDataOutput.writeEntityHeader_native(this.mBackupWriter, key, dataSize);
        if (result >= 0) {
            return result;
        }
        throw new IOException("result=0x" + Integer.toHexString(result));
    }

    public int writeEntityData(byte[] data, int size) throws IOException {
        int result = BackupDataOutput.writeEntityData_native(this.mBackupWriter, data, size);
        if (result >= 0) {
            return result;
        }
        throw new IOException("result=0x" + Integer.toHexString(result));
    }

    public void setKeyPrefix(String keyPrefix) {
        BackupDataOutput.setKeyPrefix_native(this.mBackupWriter, keyPrefix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            BackupDataOutput.dtor(this.mBackupWriter);
        }
        finally {
            super.finalize();
        }
    }

    private static native long ctor(FileDescriptor var0);

    private static native void dtor(long var0);

    private static native int writeEntityHeader_native(long var0, String var2, int var3);

    private static native int writeEntityData_native(long var0, byte[] var2, int var3);

    private static native void setKeyPrefix_native(long var0, String var2);
}

