/*
 * Decompiled with CFR 0.152.
 */
package android.appwidget;

import android.app.Activity;
import android.appwidget.AppWidgetHostView;
import android.appwidget.AppWidgetProviderInfo;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.IntentSender;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.Process;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.widget.RemoteViews;
import com.android.internal.appwidget.IAppWidgetHost;
import com.android.internal.appwidget.IAppWidgetService;
import java.util.ArrayList;
import java.util.HashMap;

public class AppWidgetHost {
    static final int HANDLE_UPDATE = 1;
    static final int HANDLE_PROVIDER_CHANGED = 2;
    static final int HANDLE_PROVIDERS_CHANGED = 3;
    static final int HANDLE_VIEW_DATA_CHANGED = 4;
    static final Object sServiceLock = new Object();
    static IAppWidgetService sService;
    private DisplayMetrics mDisplayMetrics;
    Context mContext;
    Handler mHandler;
    int mHostId;
    Callbacks mCallbacks = new Callbacks();
    final HashMap<Integer, AppWidgetHostView> mViews = new HashMap();
    private RemoteViews.OnClickHandler mOnClickHandler;

    public AppWidgetHost(Context context, int hostId) {
        this(context, hostId, null, context.getMainLooper());
    }

    public AppWidgetHost(Context context, int hostId, RemoteViews.OnClickHandler handler, Looper looper) {
        this.mContext = context;
        this.mHostId = hostId;
        this.mOnClickHandler = handler;
        this.mHandler = new UpdateHandler(looper);
        this.mDisplayMetrics = context.getResources().getDisplayMetrics();
        AppWidgetHost.bindService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void bindService() {
        Object object = sServiceLock;
        synchronized (object) {
            if (sService == null) {
                IBinder b = ServiceManager.getService("appwidget");
                sService = IAppWidgetService.Stub.asInterface(b);
            }
        }
    }

    public void startListening() {
        int[] updatedIds;
        ArrayList<RemoteViews> updatedViews = new ArrayList<RemoteViews>();
        try {
            updatedIds = sService.startListening(this.mCallbacks, this.mContext.getOpPackageName(), this.mHostId, updatedViews);
        }
        catch (RemoteException e) {
            throw new RuntimeException("system server dead?", e);
        }
        int N = updatedIds.length;
        for (int i = 0; i < N; ++i) {
            this.updateAppWidgetView(updatedIds[i], updatedViews.get(i));
        }
    }

    public void stopListening() {
        try {
            sService.stopListening(this.mContext.getOpPackageName(), this.mHostId);
        }
        catch (RemoteException e) {
            throw new RuntimeException("system server dead?", e);
        }
        this.clearViews();
    }

    public int allocateAppWidgetId() {
        try {
            return sService.allocateAppWidgetId(this.mContext.getOpPackageName(), this.mHostId);
        }
        catch (RemoteException e) {
            throw new RuntimeException("system server dead?", e);
        }
    }

    public final void startAppWidgetConfigureActivityForResult(Activity activity, int appWidgetId, int intentFlags, int requestCode, Bundle options) {
        try {
            IntentSender intentSender = sService.createAppWidgetConfigIntentSender(this.mContext.getOpPackageName(), appWidgetId, intentFlags);
            if (intentSender == null) {
                throw new ActivityNotFoundException();
            }
            activity.startIntentSenderForResult(intentSender, requestCode, null, 0, 0, 0, options);
        }
        catch (IntentSender.SendIntentException e) {
            throw new ActivityNotFoundException();
        }
        catch (RemoteException e) {
            throw new RuntimeException("system server dead?", e);
        }
    }

    public int[] getAppWidgetIds() {
        try {
            if (sService == null) {
                AppWidgetHost.bindService();
            }
            return sService.getAppWidgetIdsForHost(this.mContext.getOpPackageName(), this.mHostId);
        }
        catch (RemoteException e) {
            throw new RuntimeException("system server dead?", e);
        }
    }

    private boolean isLocalBinder() {
        return Process.myPid() == Binder.getCallingPid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAppWidgetId(int appWidgetId) {
        HashMap<Integer, AppWidgetHostView> hashMap = this.mViews;
        synchronized (hashMap) {
            this.mViews.remove(appWidgetId);
            try {
                sService.deleteAppWidgetId(this.mContext.getOpPackageName(), appWidgetId);
            }
            catch (RemoteException e) {
                throw new RuntimeException("system server dead?", e);
            }
        }
    }

    public void deleteHost() {
        try {
            sService.deleteHost(this.mContext.getOpPackageName(), this.mHostId);
        }
        catch (RemoteException e) {
            throw new RuntimeException("system server dead?", e);
        }
    }

    public static void deleteAllHosts() {
        try {
            sService.deleteAllHosts();
        }
        catch (RemoteException e) {
            throw new RuntimeException("system server dead?", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final AppWidgetHostView createView(Context context, int appWidgetId, AppWidgetProviderInfo appWidget) {
        RemoteViews views;
        AppWidgetHostView view = this.onCreateView(this.mContext, appWidgetId, appWidget);
        view.setOnClickHandler(this.mOnClickHandler);
        view.setAppWidget(appWidgetId, appWidget);
        HashMap<Integer, AppWidgetHostView> hashMap = this.mViews;
        synchronized (hashMap) {
            this.mViews.put(appWidgetId, view);
        }
        try {
            views = sService.getAppWidgetViews(this.mContext.getOpPackageName(), appWidgetId);
        }
        catch (RemoteException e) {
            throw new RuntimeException("system server dead?", e);
        }
        view.updateAppWidget(views);
        return view;
    }

    protected AppWidgetHostView onCreateView(Context context, int appWidgetId, AppWidgetProviderInfo appWidget) {
        return new AppWidgetHostView(context, this.mOnClickHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onProviderChanged(int appWidgetId, AppWidgetProviderInfo appWidget) {
        AppWidgetHostView v;
        appWidget.minWidth = TypedValue.complexToDimensionPixelSize(appWidget.minWidth, this.mDisplayMetrics);
        appWidget.minHeight = TypedValue.complexToDimensionPixelSize(appWidget.minHeight, this.mDisplayMetrics);
        appWidget.minResizeWidth = TypedValue.complexToDimensionPixelSize(appWidget.minResizeWidth, this.mDisplayMetrics);
        appWidget.minResizeHeight = TypedValue.complexToDimensionPixelSize(appWidget.minResizeHeight, this.mDisplayMetrics);
        HashMap<Integer, AppWidgetHostView> hashMap = this.mViews;
        synchronized (hashMap) {
            v = this.mViews.get(appWidgetId);
        }
        if (v != null) {
            v.resetAppWidget(appWidget);
        }
    }

    protected void onProvidersChanged() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateAppWidgetView(int appWidgetId, RemoteViews views) {
        AppWidgetHostView v;
        HashMap<Integer, AppWidgetHostView> hashMap = this.mViews;
        synchronized (hashMap) {
            v = this.mViews.get(appWidgetId);
        }
        if (v != null) {
            v.updateAppWidget(views);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void viewDataChanged(int appWidgetId, int viewId) {
        AppWidgetHostView v;
        HashMap<Integer, AppWidgetHostView> hashMap = this.mViews;
        synchronized (hashMap) {
            v = this.mViews.get(appWidgetId);
        }
        if (v != null) {
            v.viewDataChanged(viewId);
        }
    }

    protected void clearViews() {
        this.mViews.clear();
    }

    class UpdateHandler
    extends Handler {
        public UpdateHandler(Looper looper) {
            super(looper);
        }

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    AppWidgetHost.this.updateAppWidgetView(msg.arg1, (RemoteViews)msg.obj);
                    break;
                }
                case 2: {
                    AppWidgetHost.this.onProviderChanged(msg.arg1, (AppWidgetProviderInfo)msg.obj);
                    break;
                }
                case 3: {
                    AppWidgetHost.this.onProvidersChanged();
                    break;
                }
                case 4: {
                    AppWidgetHost.this.viewDataChanged(msg.arg1, msg.arg2);
                }
            }
        }
    }

    class Callbacks
    extends IAppWidgetHost.Stub {
        Callbacks() {
        }

        @Override
        public void updateAppWidget(int appWidgetId, RemoteViews views) {
            if (AppWidgetHost.this.isLocalBinder() && views != null) {
                views = views.clone();
            }
            Message msg = AppWidgetHost.this.mHandler.obtainMessage(1, appWidgetId, 0, views);
            msg.sendToTarget();
        }

        @Override
        public void providerChanged(int appWidgetId, AppWidgetProviderInfo info) {
            if (AppWidgetHost.this.isLocalBinder() && info != null) {
                info = info.clone();
            }
            Message msg = AppWidgetHost.this.mHandler.obtainMessage(2, appWidgetId, 0, info);
            msg.sendToTarget();
        }

        @Override
        public void providersChanged() {
            AppWidgetHost.this.mHandler.obtainMessage(3).sendToTarget();
        }

        @Override
        public void viewDataChanged(int appWidgetId, int viewId) {
            Message msg = AppWidgetHost.this.mHandler.obtainMessage(4, appWidgetId, viewId);
            msg.sendToTarget();
        }
    }
}

