/*
 * Decompiled with CFR 0.152.
 */
package android.ddm;

import android.opengl.GLUtils;
import android.util.Log;
import android.view.View;
import android.view.ViewDebug;
import android.view.WindowManagerGlobal;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Method;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import org.apache.harmony.dalvik.ddmc.Chunk;
import org.apache.harmony.dalvik.ddmc.ChunkHandler;
import org.apache.harmony.dalvik.ddmc.DdmServer;

public class DdmHandleViewDebug
extends ChunkHandler {
    public static final int CHUNK_VUGL = DdmHandleViewDebug.type("VUGL");
    private static final int CHUNK_VULW = DdmHandleViewDebug.type("VULW");
    private static final int CHUNK_VURT = DdmHandleViewDebug.type("VURT");
    private static final int VURT_DUMP_HIERARCHY = 1;
    private static final int VURT_CAPTURE_LAYERS = 2;
    private static final int VURT_DUMP_THEME = 3;
    private static final int CHUNK_VUOP = DdmHandleViewDebug.type("VUOP");
    private static final int VUOP_CAPTURE_VIEW = 1;
    private static final int VUOP_DUMP_DISPLAYLIST = 2;
    private static final int VUOP_PROFILE_VIEW = 3;
    private static final int VUOP_INVOKE_VIEW_METHOD = 4;
    private static final int VUOP_SET_LAYOUT_PARAMETER = 5;
    private static final int ERR_INVALID_OP = -1;
    private static final int ERR_INVALID_PARAM = -2;
    private static final int ERR_EXCEPTION = -3;
    private static final String TAG = "DdmViewDebug";
    private static final DdmHandleViewDebug sInstance = new DdmHandleViewDebug();

    private DdmHandleViewDebug() {
    }

    public static void register() {
        DdmServer.registerHandler(CHUNK_VUGL, sInstance);
        DdmServer.registerHandler(CHUNK_VULW, sInstance);
        DdmServer.registerHandler(CHUNK_VURT, sInstance);
        DdmServer.registerHandler(CHUNK_VUOP, sInstance);
    }

    @Override
    public void connected() {
    }

    @Override
    public void disconnected() {
    }

    @Override
    public Chunk handleChunk(Chunk request) {
        int type = request.type;
        if (type == CHUNK_VUGL) {
            return this.handleOpenGlTrace(request);
        }
        if (type == CHUNK_VULW) {
            return this.listWindows();
        }
        ByteBuffer in = DdmHandleViewDebug.wrapChunk(request);
        int op = in.getInt();
        View rootView = this.getRootView(in);
        if (rootView == null) {
            return DdmHandleViewDebug.createFailChunk(-2, "Invalid View Root");
        }
        if (type == CHUNK_VURT) {
            if (op == 1) {
                return this.dumpHierarchy(rootView, in);
            }
            if (op == 2) {
                return this.captureLayers(rootView);
            }
            if (op == 3) {
                return this.dumpTheme(rootView);
            }
            return DdmHandleViewDebug.createFailChunk(-1, "Unknown view root operation: " + op);
        }
        View targetView = this.getTargetView(rootView, in);
        if (targetView == null) {
            return DdmHandleViewDebug.createFailChunk(-2, "Invalid target view");
        }
        if (type == CHUNK_VUOP) {
            switch (op) {
                case 1: {
                    return this.captureView(rootView, targetView);
                }
                case 2: {
                    return this.dumpDisplayLists(rootView, targetView);
                }
                case 3: {
                    return this.profileView(rootView, targetView);
                }
                case 4: {
                    return this.invokeViewMethod(rootView, targetView, in);
                }
                case 5: {
                    return this.setLayoutParameter(rootView, targetView, in);
                }
            }
            return DdmHandleViewDebug.createFailChunk(-1, "Unknown view operation: " + op);
        }
        throw new RuntimeException("Unknown packet " + ChunkHandler.name(type));
    }

    private Chunk handleOpenGlTrace(Chunk request) {
        ByteBuffer in = DdmHandleViewDebug.wrapChunk(request);
        GLUtils.setTracingLevel(in.getInt());
        return null;
    }

    private Chunk listWindows() {
        String[] windowNames = WindowManagerGlobal.getInstance().getViewRootNames();
        int responseLength = 4;
        for (String name : windowNames) {
            responseLength += 4;
            responseLength += name.length() * 2;
        }
        ByteBuffer out = ByteBuffer.allocate(responseLength);
        out.order(ChunkHandler.CHUNK_ORDER);
        out.putInt(windowNames.length);
        for (String name : windowNames) {
            out.putInt(name.length());
            DdmHandleViewDebug.putString(out, name);
        }
        return new Chunk(CHUNK_VULW, out);
    }

    private View getRootView(ByteBuffer in) {
        try {
            int viewRootNameLength = in.getInt();
            String viewRootName = DdmHandleViewDebug.getString(in, viewRootNameLength);
            return WindowManagerGlobal.getInstance().getRootView(viewRootName);
        }
        catch (BufferUnderflowException e) {
            return null;
        }
    }

    private View getTargetView(View root, ByteBuffer in) {
        String viewName;
        try {
            int viewLength = in.getInt();
            viewName = DdmHandleViewDebug.getString(in, viewLength);
        }
        catch (BufferUnderflowException e) {
            return null;
        }
        return ViewDebug.findView(root, viewName);
    }

    private Chunk dumpHierarchy(View rootView, ByteBuffer in) {
        boolean skipChildren = in.getInt() > 0;
        boolean includeProperties = in.getInt() > 0;
        ByteArrayOutputStream b = new ByteArrayOutputStream(1024);
        try {
            ViewDebug.dump(rootView, skipChildren, includeProperties, b);
        }
        catch (IOException e) {
            return DdmHandleViewDebug.createFailChunk(1, "Unexpected error while obtaining view hierarchy: " + e.getMessage());
        }
        byte[] data = b.toByteArray();
        return new Chunk(CHUNK_VURT, data, 0, data.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Chunk captureLayers(View rootView) {
        ByteArrayOutputStream b = new ByteArrayOutputStream(1024);
        DataOutputStream dos = new DataOutputStream(b);
        try {
            ViewDebug.captureLayers(rootView, dos);
        }
        catch (IOException e) {
            Chunk chunk = DdmHandleViewDebug.createFailChunk(1, "Unexpected error while obtaining view hierarchy: " + e.getMessage());
            return chunk;
        }
        finally {
            try {
                dos.close();
            }
            catch (IOException e) {}
        }
        byte[] data = b.toByteArray();
        return new Chunk(CHUNK_VURT, data, 0, data.length);
    }

    private Chunk dumpTheme(View rootView) {
        ByteArrayOutputStream b = new ByteArrayOutputStream(1024);
        try {
            ViewDebug.dumpTheme(rootView, b);
        }
        catch (IOException e) {
            return DdmHandleViewDebug.createFailChunk(1, "Unexpected error while dumping the theme: " + e.getMessage());
        }
        byte[] data = b.toByteArray();
        return new Chunk(CHUNK_VURT, data, 0, data.length);
    }

    private Chunk captureView(View rootView, View targetView) {
        ByteArrayOutputStream b = new ByteArrayOutputStream(1024);
        try {
            ViewDebug.capture(rootView, (OutputStream)b, targetView);
        }
        catch (IOException e) {
            return DdmHandleViewDebug.createFailChunk(1, "Unexpected error while capturing view: " + e.getMessage());
        }
        byte[] data = b.toByteArray();
        return new Chunk(CHUNK_VUOP, data, 0, data.length);
    }

    private Chunk dumpDisplayLists(final View rootView, final View targetView) {
        rootView.post(new Runnable(){

            @Override
            public void run() {
                ViewDebug.outputDisplayList(rootView, targetView);
            }
        });
        return null;
    }

    private Chunk invokeViewMethod(View rootView, View targetView, ByteBuffer in) {
        Object[] args;
        Class[] argTypes;
        int l = in.getInt();
        String methodName = DdmHandleViewDebug.getString(in, l);
        if (!in.hasRemaining()) {
            argTypes = new Class[]{};
            args = new Object[]{};
        } else {
            int nArgs = in.getInt();
            argTypes = new Class[nArgs];
            args = new Object[nArgs];
            block14: for (int i = 0; i < nArgs; ++i) {
                char c = in.getChar();
                switch (c) {
                    case 'Z': {
                        argTypes[i] = Boolean.TYPE;
                        args[i] = in.get() != 0;
                        continue block14;
                    }
                    case 'B': {
                        argTypes[i] = Byte.TYPE;
                        args[i] = in.get();
                        continue block14;
                    }
                    case 'C': {
                        argTypes[i] = Character.TYPE;
                        args[i] = Character.valueOf(in.getChar());
                        continue block14;
                    }
                    case 'S': {
                        argTypes[i] = Short.TYPE;
                        args[i] = in.getShort();
                        continue block14;
                    }
                    case 'I': {
                        argTypes[i] = Integer.TYPE;
                        args[i] = in.getInt();
                        continue block14;
                    }
                    case 'J': {
                        argTypes[i] = Long.TYPE;
                        args[i] = in.getLong();
                        continue block14;
                    }
                    case 'F': {
                        argTypes[i] = Float.TYPE;
                        args[i] = Float.valueOf(in.getFloat());
                        continue block14;
                    }
                    case 'D': {
                        argTypes[i] = Double.TYPE;
                        args[i] = in.getDouble();
                        continue block14;
                    }
                    default: {
                        Log.e(TAG, "arg " + i + ", unrecognized type: " + c);
                        return DdmHandleViewDebug.createFailChunk(-2, "Unsupported parameter type (" + c + ") to invoke view method.");
                    }
                }
            }
        }
        Method method = null;
        try {
            method = targetView.getClass().getMethod(methodName, argTypes);
        }
        catch (NoSuchMethodException e) {
            Log.e(TAG, "No such method: " + e.getMessage());
            return DdmHandleViewDebug.createFailChunk(-2, "No such method: " + e.getMessage());
        }
        try {
            ViewDebug.invokeViewMethod(targetView, method, args);
        }
        catch (Exception e) {
            Log.e(TAG, "Exception while invoking method: " + e.getCause().getMessage());
            String msg = e.getCause().getMessage();
            if (msg == null) {
                msg = e.getCause().toString();
            }
            return DdmHandleViewDebug.createFailChunk(-3, msg);
        }
        return null;
    }

    private Chunk setLayoutParameter(View rootView, View targetView, ByteBuffer in) {
        int l = in.getInt();
        String param = DdmHandleViewDebug.getString(in, l);
        int value = in.getInt();
        try {
            ViewDebug.setLayoutParameter(targetView, param, value);
        }
        catch (Exception e) {
            Log.e(TAG, "Exception setting layout parameter: " + e);
            return DdmHandleViewDebug.createFailChunk(-3, "Error accessing field " + param + ":" + e.getMessage());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Chunk profileView(View rootView, View targetView) {
        ByteArrayOutputStream b = new ByteArrayOutputStream(32768);
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(b), 32768);
        try {
            ViewDebug.profileViewAndChildren(targetView, bw);
        }
        catch (IOException e) {
            Chunk chunk = DdmHandleViewDebug.createFailChunk(1, "Unexpected error while profiling view: " + e.getMessage());
            return chunk;
        }
        finally {
            try {
                bw.close();
            }
            catch (IOException e) {}
        }
        byte[] data = b.toByteArray();
        return new Chunk(CHUNK_VUOP, data, 0, data.length);
    }
}

