/*
 * Decompiled with CFR 0.152.
 */
package android.emoji;

import android.graphics.Bitmap;
import java.lang.ref.WeakReference;
import java.util.LinkedHashMap;
import java.util.Map;

public final class EmojiFactory {
    private int sCacheSize = 100;
    private long mNativeEmojiFactory;
    private String mName;
    private Map<Integer, WeakReference<Bitmap>> mCache;

    private EmojiFactory(long nativeEmojiFactory, String name) {
        this.mNativeEmojiFactory = nativeEmojiFactory;
        this.mName = name;
        this.mCache = new CustomLinkedHashMap<Integer, WeakReference<Bitmap>>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.nativeDestructor(this.mNativeEmojiFactory);
        }
        finally {
            super.finalize();
        }
    }

    public String name() {
        return this.mName;
    }

    public synchronized Bitmap getBitmapFromAndroidPua(int pua) {
        WeakReference<Bitmap> cache = this.mCache.get(pua);
        if (cache == null) {
            Bitmap ret = this.nativeGetBitmapFromAndroidPua(this.mNativeEmojiFactory, pua);
            if (ret != null) {
                this.mCache.put(pua, new WeakReference<Bitmap>(ret));
            }
            return ret;
        }
        Bitmap tmp = (Bitmap)cache.get();
        if (tmp == null) {
            Bitmap ret = this.nativeGetBitmapFromAndroidPua(this.mNativeEmojiFactory, pua);
            this.mCache.put(pua, new WeakReference<Bitmap>(ret));
            return ret;
        }
        return tmp;
    }

    public synchronized Bitmap getBitmapFromVendorSpecificSjis(char sjis) {
        return this.getBitmapFromAndroidPua(this.getAndroidPuaFromVendorSpecificSjis(sjis));
    }

    public synchronized Bitmap getBitmapFromVendorSpecificPua(int vsp) {
        return this.getBitmapFromAndroidPua(this.getAndroidPuaFromVendorSpecificPua(vsp));
    }

    public int getAndroidPuaFromVendorSpecificSjis(char sjis) {
        return this.nativeGetAndroidPuaFromVendorSpecificSjis(this.mNativeEmojiFactory, sjis);
    }

    public int getVendorSpecificSjisFromAndroidPua(int pua) {
        return this.nativeGetVendorSpecificSjisFromAndroidPua(this.mNativeEmojiFactory, pua);
    }

    public int getAndroidPuaFromVendorSpecificPua(int vsp) {
        return this.nativeGetAndroidPuaFromVendorSpecificPua(this.mNativeEmojiFactory, vsp);
    }

    public String getAndroidPuaFromVendorSpecificPua(String vspString) {
        if (vspString == null) {
            return null;
        }
        int minVsp = this.nativeGetMinimumVendorSpecificPua(this.mNativeEmojiFactory);
        int maxVsp = this.nativeGetMaximumVendorSpecificPua(this.mNativeEmojiFactory);
        int len = vspString.length();
        int[] codePoints = new int[vspString.codePointCount(0, len)];
        int new_len = 0;
        int i = 0;
        while (i < len) {
            int newCodePoint;
            int codePoint = vspString.codePointAt(i);
            codePoints[new_len] = minVsp <= codePoint && codePoint <= maxVsp && (newCodePoint = this.getAndroidPuaFromVendorSpecificPua(codePoint)) > 0 ? newCodePoint : codePoint;
            i = vspString.offsetByCodePoints(i, 1);
            ++new_len;
        }
        return new String(codePoints, 0, new_len);
    }

    public int getVendorSpecificPuaFromAndroidPua(int pua) {
        return this.nativeGetVendorSpecificPuaFromAndroidPua(this.mNativeEmojiFactory, pua);
    }

    public String getVendorSpecificPuaFromAndroidPua(String puaString) {
        if (puaString == null) {
            return null;
        }
        int minVsp = this.nativeGetMinimumAndroidPua(this.mNativeEmojiFactory);
        int maxVsp = this.nativeGetMaximumAndroidPua(this.mNativeEmojiFactory);
        int len = puaString.length();
        int[] codePoints = new int[puaString.codePointCount(0, len)];
        int new_len = 0;
        int i = 0;
        while (i < len) {
            int newCodePoint;
            int codePoint = puaString.codePointAt(i);
            codePoints[new_len] = minVsp <= codePoint && codePoint <= maxVsp && (newCodePoint = this.getVendorSpecificPuaFromAndroidPua(codePoint)) > 0 ? newCodePoint : codePoint;
            i = puaString.offsetByCodePoints(i, 1);
            ++new_len;
        }
        return new String(codePoints, 0, new_len);
    }

    public static native EmojiFactory newInstance(String var0);

    public static native EmojiFactory newAvailableInstance();

    public int getMinimumAndroidPua() {
        return this.nativeGetMinimumAndroidPua(this.mNativeEmojiFactory);
    }

    public int getMaximumAndroidPua() {
        return this.nativeGetMaximumAndroidPua(this.mNativeEmojiFactory);
    }

    private native void nativeDestructor(long var1);

    private native Bitmap nativeGetBitmapFromAndroidPua(long var1, int var3);

    private native int nativeGetAndroidPuaFromVendorSpecificSjis(long var1, char var3);

    private native int nativeGetVendorSpecificSjisFromAndroidPua(long var1, int var3);

    private native int nativeGetAndroidPuaFromVendorSpecificPua(long var1, int var3);

    private native int nativeGetVendorSpecificPuaFromAndroidPua(long var1, int var3);

    private native int nativeGetMaximumVendorSpecificPua(long var1);

    private native int nativeGetMinimumVendorSpecificPua(long var1);

    private native int nativeGetMaximumAndroidPua(long var1);

    private native int nativeGetMinimumAndroidPua(long var1);

    private class CustomLinkedHashMap<K, V>
    extends LinkedHashMap<K, V> {
        public CustomLinkedHashMap() {
            super(16, 0.75f, true);
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            return this.size() > EmojiFactory.this.sCacheSize;
        }
    }
}

