/*
 * Decompiled with CFR 0.152.
 */
package android.filterfw;

import android.filterfw.core.CachedFrameManager;
import android.filterfw.core.FilterContext;
import android.filterfw.core.FrameManager;
import android.filterfw.core.GLEnvironment;

public class MffEnvironment {
    private FilterContext mContext;

    protected MffEnvironment(FrameManager frameManager) {
        if (frameManager == null) {
            frameManager = new CachedFrameManager();
        }
        this.mContext = new FilterContext();
        this.mContext.setFrameManager(frameManager);
    }

    public FilterContext getContext() {
        return this.mContext;
    }

    public void setGLEnvironment(GLEnvironment glEnvironment) {
        this.mContext.initGLEnvironment(glEnvironment);
    }

    public void createGLEnvironment() {
        GLEnvironment glEnvironment = new GLEnvironment();
        glEnvironment.initWithNewContext();
        this.setGLEnvironment(glEnvironment);
    }

    public void activateGLEnvironment() {
        GLEnvironment glEnv = this.mContext.getGLEnvironment();
        if (glEnv == null) {
            throw new NullPointerException("No GLEnvironment in place to activate!");
        }
        this.mContext.getGLEnvironment().activate();
    }

    public void deactivateGLEnvironment() {
        GLEnvironment glEnv = this.mContext.getGLEnvironment();
        if (glEnv == null) {
            throw new NullPointerException("No GLEnvironment in place to deactivate!");
        }
        this.mContext.getGLEnvironment().deactivate();
    }
}

