/*
 * Decompiled with CFR 0.152.
 */
package android.filterfw.io;

import android.filterfw.core.Filter;
import android.filterfw.core.FilterFactory;
import android.filterfw.core.FilterGraph;
import android.filterfw.core.KeyValueMap;
import android.filterfw.core.ProtocolException;
import android.filterfw.io.GraphIOException;
import android.filterfw.io.GraphReader;
import android.filterfw.io.PatternScanner;
import java.util.ArrayList;
import java.util.regex.Pattern;

public class TextGraphReader
extends GraphReader {
    private ArrayList<Command> mCommands = new ArrayList();
    private Filter mCurrentFilter;
    private FilterGraph mCurrentGraph;
    private KeyValueMap mBoundReferences;
    private KeyValueMap mSettings;
    private FilterFactory mFactory;

    @Override
    public FilterGraph readGraphString(String graphString) throws GraphIOException {
        FilterGraph result = new FilterGraph();
        this.reset();
        this.mCurrentGraph = result;
        this.parseString(graphString);
        this.applySettings();
        this.executeCommands();
        this.reset();
        return result;
    }

    private void reset() {
        this.mCurrentGraph = null;
        this.mCurrentFilter = null;
        this.mCommands.clear();
        this.mBoundReferences = new KeyValueMap();
        this.mSettings = new KeyValueMap();
        this.mFactory = new FilterFactory();
    }

    private void parseString(String graphString) throws GraphIOException {
        Pattern commandPattern = Pattern.compile("@[a-zA-Z]+");
        Pattern curlyClosePattern = Pattern.compile("\\}");
        Pattern curlyOpenPattern = Pattern.compile("\\{");
        Pattern ignorePattern = Pattern.compile("(\\s+|//[^\\n]*\\n)+");
        Pattern packageNamePattern = Pattern.compile("[a-zA-Z\\.]+");
        Pattern libraryNamePattern = Pattern.compile("[a-zA-Z\\./:]+");
        Pattern portPattern = Pattern.compile("\\[[a-zA-Z0-9\\-_]+\\]");
        Pattern rightArrowPattern = Pattern.compile("=>");
        Pattern semicolonPattern = Pattern.compile(";");
        Pattern wordPattern = Pattern.compile("[a-zA-Z0-9\\-_]+");
        boolean STATE_COMMAND = false;
        boolean STATE_IMPORT_PKG = true;
        int STATE_ADD_LIBRARY = 2;
        int STATE_FILTER_CLASS = 3;
        int STATE_FILTER_NAME = 4;
        int STATE_CURLY_OPEN = 5;
        int STATE_PARAMETERS = 6;
        int STATE_CURLY_CLOSE = 7;
        int STATE_SOURCE_FILTERNAME = 8;
        int STATE_SOURCE_PORT = 9;
        int STATE_RIGHT_ARROW = 10;
        int STATE_TARGET_FILTERNAME = 11;
        int STATE_TARGET_PORT = 12;
        int STATE_ASSIGNMENT = 13;
        int STATE_EXTERNAL = 14;
        int STATE_SETTING = 15;
        int STATE_SEMICOLON = 16;
        int state = 0;
        PatternScanner scanner = new PatternScanner(graphString, ignorePattern);
        String curClassName = null;
        String curSourceFilterName = null;
        String curSourcePortName = null;
        String curTargetFilterName = null;
        String curTargetPortName = null;
        while (!scanner.atEnd()) {
            switch (state) {
                case 0: {
                    String curCommand = scanner.eat(commandPattern, "<command>");
                    if (curCommand.equals("@import")) {
                        state = 1;
                        break;
                    }
                    if (curCommand.equals("@library")) {
                        state = 2;
                        break;
                    }
                    if (curCommand.equals("@filter")) {
                        state = 3;
                        break;
                    }
                    if (curCommand.equals("@connect")) {
                        state = 8;
                        break;
                    }
                    if (curCommand.equals("@set")) {
                        state = 13;
                        break;
                    }
                    if (curCommand.equals("@external")) {
                        state = 14;
                        break;
                    }
                    if (curCommand.equals("@setting")) {
                        state = 15;
                        break;
                    }
                    throw new GraphIOException("Unknown command '" + curCommand + "'!");
                }
                case 1: {
                    String packageName = scanner.eat(packageNamePattern, "<package-name>");
                    this.mCommands.add(new ImportPackageCommand(packageName));
                    state = 16;
                    break;
                }
                case 2: {
                    String libraryName = scanner.eat(libraryNamePattern, "<library-name>");
                    this.mCommands.add(new AddLibraryCommand(libraryName));
                    state = 16;
                    break;
                }
                case 3: {
                    curClassName = scanner.eat(wordPattern, "<class-name>");
                    state = 4;
                    break;
                }
                case 4: {
                    String curFilterName = scanner.eat(wordPattern, "<filter-name>");
                    this.mCommands.add(new AllocateFilterCommand(curClassName, curFilterName));
                    state = 5;
                    break;
                }
                case 5: {
                    scanner.eat(curlyOpenPattern, "{");
                    state = 6;
                    break;
                }
                case 6: {
                    KeyValueMap params = this.readKeyValueAssignments(scanner, curlyClosePattern);
                    this.mCommands.add(new InitFilterCommand(params));
                    state = 7;
                    break;
                }
                case 7: {
                    scanner.eat(curlyClosePattern, "}");
                    state = 0;
                    break;
                }
                case 8: {
                    curSourceFilterName = scanner.eat(wordPattern, "<source-filter-name>");
                    state = 9;
                    break;
                }
                case 9: {
                    String portString = scanner.eat(portPattern, "[<source-port-name>]");
                    curSourcePortName = portString.substring(1, portString.length() - 1);
                    state = 10;
                    break;
                }
                case 10: {
                    scanner.eat(rightArrowPattern, "=>");
                    state = 11;
                    break;
                }
                case 11: {
                    curTargetFilterName = scanner.eat(wordPattern, "<target-filter-name>");
                    state = 12;
                    break;
                }
                case 12: {
                    String portString = scanner.eat(portPattern, "[<target-port-name>]");
                    curTargetPortName = portString.substring(1, portString.length() - 1);
                    this.mCommands.add(new ConnectCommand(curSourceFilterName, curSourcePortName, curTargetFilterName, curTargetPortName));
                    state = 16;
                    break;
                }
                case 13: {
                    KeyValueMap assignment = this.readKeyValueAssignments(scanner, semicolonPattern);
                    this.mBoundReferences.putAll(assignment);
                    state = 16;
                    break;
                }
                case 14: {
                    String externalName = scanner.eat(wordPattern, "<external-identifier>");
                    this.bindExternal(externalName);
                    state = 16;
                    break;
                }
                case 15: {
                    KeyValueMap setting = this.readKeyValueAssignments(scanner, semicolonPattern);
                    this.mSettings.putAll(setting);
                    state = 16;
                    break;
                }
                case 16: {
                    scanner.eat(semicolonPattern, ";");
                    state = 0;
                }
            }
        }
        if (state != 16 && state != 0) {
            throw new GraphIOException("Unexpected end of input!");
        }
    }

    @Override
    public KeyValueMap readKeyValueAssignments(String assignments) throws GraphIOException {
        Pattern ignorePattern = Pattern.compile("\\s+");
        PatternScanner scanner = new PatternScanner(assignments, ignorePattern);
        return this.readKeyValueAssignments(scanner, null);
    }

    private KeyValueMap readKeyValueAssignments(PatternScanner scanner, Pattern endPattern) throws GraphIOException {
        boolean STATE_IDENTIFIER = false;
        boolean STATE_EQUALS = true;
        int STATE_VALUE = 2;
        int STATE_POST_VALUE = 3;
        Pattern equalsPattern = Pattern.compile("=");
        Pattern semicolonPattern = Pattern.compile(";");
        Pattern wordPattern = Pattern.compile("[a-zA-Z]+[a-zA-Z0-9]*");
        Pattern stringPattern = Pattern.compile("'[^']*'|\\\"[^\\\"]*\\\"");
        Pattern intPattern = Pattern.compile("[0-9]+");
        Pattern floatPattern = Pattern.compile("[0-9]*\\.[0-9]+f?");
        Pattern referencePattern = Pattern.compile("\\$[a-zA-Z]+[a-zA-Z0-9]");
        Pattern booleanPattern = Pattern.compile("true|false");
        int state = 0;
        KeyValueMap newVals = new KeyValueMap();
        String curKey = null;
        String curValue = null;
        while (!(scanner.atEnd() || endPattern != null && scanner.peek(endPattern))) {
            switch (state) {
                case 0: {
                    curKey = scanner.eat(wordPattern, "<identifier>");
                    state = 1;
                    break;
                }
                case 1: {
                    scanner.eat(equalsPattern, "=");
                    state = 2;
                    break;
                }
                case 2: {
                    curValue = scanner.tryEat(stringPattern);
                    if (curValue != null) {
                        newVals.put(curKey, curValue.substring(1, curValue.length() - 1));
                    } else {
                        curValue = scanner.tryEat(referencePattern);
                        if (curValue != null) {
                            Object referencedObject;
                            String refName = curValue.substring(1, curValue.length());
                            Object v = referencedObject = this.mBoundReferences != null ? (Object)this.mBoundReferences.get(refName) : null;
                            if (referencedObject == null) {
                                throw new GraphIOException("Unknown object reference to '" + refName + "'!");
                            }
                            newVals.put(curKey, referencedObject);
                        } else {
                            curValue = scanner.tryEat(booleanPattern);
                            if (curValue != null) {
                                newVals.put(curKey, Boolean.parseBoolean(curValue));
                            } else {
                                curValue = scanner.tryEat(floatPattern);
                                if (curValue != null) {
                                    newVals.put(curKey, Float.valueOf(Float.parseFloat(curValue)));
                                } else {
                                    curValue = scanner.tryEat(intPattern);
                                    if (curValue != null) {
                                        newVals.put(curKey, Integer.parseInt(curValue));
                                    } else {
                                        throw new GraphIOException(scanner.unexpectedTokenMessage("<value>"));
                                    }
                                }
                            }
                        }
                    }
                    state = 3;
                    break;
                }
                case 3: {
                    scanner.eat(semicolonPattern, ";");
                    state = 0;
                }
            }
        }
        if (state != 0 && state != 3) {
            throw new GraphIOException("Unexpected end of assignments on line " + scanner.lineNo() + "!");
        }
        return newVals;
    }

    private void bindExternal(String name) throws GraphIOException {
        if (!this.mReferences.containsKey(name)) {
            throw new GraphIOException("Unknown external variable '" + name + "'! " + "You must add a reference to this external in the host program using " + "addReference(...)!");
        }
        Object value = this.mReferences.get(name);
        this.mBoundReferences.put(name, value);
    }

    private void checkReferences() throws GraphIOException {
        for (String reference : this.mReferences.keySet()) {
            if (this.mBoundReferences.containsKey(reference)) continue;
            throw new GraphIOException("Host program specifies reference to '" + reference + "', which is not " + "declared @external in graph file!");
        }
    }

    private void applySettings() throws GraphIOException {
        for (String setting : this.mSettings.keySet()) {
            Object value = this.mSettings.get(setting);
            if (setting.equals("autoBranch")) {
                this.expectSettingClass(setting, value, String.class);
                if (value.equals("synced")) {
                    this.mCurrentGraph.setAutoBranchMode(1);
                    continue;
                }
                if (value.equals("unsynced")) {
                    this.mCurrentGraph.setAutoBranchMode(2);
                    continue;
                }
                if (value.equals("off")) {
                    this.mCurrentGraph.setAutoBranchMode(0);
                    continue;
                }
                throw new GraphIOException("Unknown autobranch setting: " + value + "!");
            }
            if (setting.equals("discardUnconnectedOutputs")) {
                this.expectSettingClass(setting, value, Boolean.class);
                this.mCurrentGraph.setDiscardUnconnectedOutputs((Boolean)value);
                continue;
            }
            throw new GraphIOException("Unknown @setting '" + setting + "'!");
        }
    }

    private void expectSettingClass(String setting, Object value, Class expectedClass) throws GraphIOException {
        if (value.getClass() != expectedClass) {
            throw new GraphIOException("Setting '" + setting + "' must have a value of type " + expectedClass.getSimpleName() + ", but found a value of type " + value.getClass().getSimpleName() + "!");
        }
    }

    private void executeCommands() throws GraphIOException {
        for (Command command : this.mCommands) {
            command.execute(this);
        }
    }

    private class ConnectCommand
    implements Command {
        private String mSourceFilter;
        private String mSourcePort;
        private String mTargetFilter;
        private String mTargetName;

        public ConnectCommand(String sourceFilter, String sourcePort, String targetFilter, String targetName) {
            this.mSourceFilter = sourceFilter;
            this.mSourcePort = sourcePort;
            this.mTargetFilter = targetFilter;
            this.mTargetName = targetName;
        }

        @Override
        public void execute(TextGraphReader reader) {
            reader.mCurrentGraph.connect(this.mSourceFilter, this.mSourcePort, this.mTargetFilter, this.mTargetName);
        }
    }

    private class InitFilterCommand
    implements Command {
        private KeyValueMap mParams;

        public InitFilterCommand(KeyValueMap params) {
            this.mParams = params;
        }

        @Override
        public void execute(TextGraphReader reader) throws GraphIOException {
            Filter filter = reader.mCurrentFilter;
            try {
                filter.initWithValueMap(this.mParams);
            }
            catch (ProtocolException e) {
                throw new GraphIOException(e.getMessage());
            }
            reader.mCurrentGraph.addFilter(TextGraphReader.this.mCurrentFilter);
        }
    }

    private class AllocateFilterCommand
    implements Command {
        private String mClassName;
        private String mFilterName;

        public AllocateFilterCommand(String className, String filterName) {
            this.mClassName = className;
            this.mFilterName = filterName;
        }

        @Override
        public void execute(TextGraphReader reader) throws GraphIOException {
            Filter filter = null;
            try {
                filter = reader.mFactory.createFilterByClassName(this.mClassName, this.mFilterName);
            }
            catch (IllegalArgumentException e) {
                throw new GraphIOException(e.getMessage());
            }
            reader.mCurrentFilter = filter;
        }
    }

    private class AddLibraryCommand
    implements Command {
        private String mLibraryName;

        public AddLibraryCommand(String libraryName) {
            this.mLibraryName = libraryName;
        }

        @Override
        public void execute(TextGraphReader reader) {
            reader.mFactory;
            FilterFactory.addFilterLibrary(this.mLibraryName);
        }
    }

    private class ImportPackageCommand
    implements Command {
        private String mPackageName;

        public ImportPackageCommand(String packageName) {
            this.mPackageName = packageName;
        }

        @Override
        public void execute(TextGraphReader reader) throws GraphIOException {
            try {
                reader.mFactory.addPackage(this.mPackageName);
            }
            catch (IllegalArgumentException e) {
                throw new GraphIOException(e.getMessage());
            }
        }
    }

    private static interface Command {
        public void execute(TextGraphReader var1) throws GraphIOException;
    }
}

