/*
 * Decompiled with CFR 0.152.
 */
package android.filterpacks.numeric;

import android.filterfw.core.Filter;
import android.filterfw.core.FilterContext;
import android.filterfw.core.Frame;
import android.filterfw.core.FrameFormat;
import android.filterfw.core.GenerateFieldPort;
import android.filterfw.format.ObjectFormat;

public class SinWaveFilter
extends Filter {
    @GenerateFieldPort(name="stepSize", hasDefault=true)
    private float mStepSize = 0.05f;
    private float mValue = 0.0f;
    private FrameFormat mOutputFormat;

    public SinWaveFilter(String name) {
        super(name);
    }

    @Override
    public void setupPorts() {
        this.mOutputFormat = ObjectFormat.fromClass(Float.class, 1);
        this.addOutputPort("value", this.mOutputFormat);
    }

    @Override
    public void open(FilterContext env) {
        this.mValue = 0.0f;
    }

    @Override
    public void process(FilterContext env) {
        Frame output = env.getFrameManager().newFrame(this.mOutputFormat);
        output.setObjectValue(Float.valueOf(((float)Math.sin(this.mValue) + 1.0f) / 2.0f));
        this.pushOutput("value", output);
        this.mValue += this.mStepSize;
        output.release();
    }
}

