/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.Matrix;

public class Shader {
    private long native_instance;
    private Matrix mLocalMatrix;

    protected void init(long ni) {
        this.native_instance = ni;
    }

    public boolean getLocalMatrix(Matrix localM) {
        if (this.mLocalMatrix != null) {
            localM.set(this.mLocalMatrix);
            return !this.mLocalMatrix.isIdentity();
        }
        return false;
    }

    public void setLocalMatrix(Matrix localM) {
        this.mLocalMatrix = localM;
        Shader.nativeSetLocalMatrix(this.native_instance, localM == null ? 0L : localM.native_instance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            super.finalize();
        }
        finally {
            Shader.nativeDestructor(this.native_instance);
        }
    }

    protected Shader copy() {
        Shader copy = new Shader();
        this.copyLocalMatrix(copy);
        return copy;
    }

    protected void copyLocalMatrix(Shader dest) {
        if (this.mLocalMatrix != null) {
            Matrix lm = new Matrix();
            this.getLocalMatrix(lm);
            dest.setLocalMatrix(lm);
        } else {
            dest.setLocalMatrix(null);
        }
    }

    long getNativeInstance() {
        return this.native_instance;
    }

    private static native void nativeDestructor(long var0);

    private static native void nativeSetLocalMatrix(long var0, long var2);

    public static enum TileMode {
        CLAMP(0),
        REPEAT(1),
        MIRROR(2);

        final int nativeInt;

        private TileMode(int nativeInt) {
            this.nativeInt = nativeInt;
        }
    }
}

