/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.Gravity;
import com.android.internal.R;
import java.io.IOException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class ClipDrawable
extends Drawable
implements Drawable.Callback {
    private ClipState mClipState;
    private final Rect mTmpRect = new Rect();
    public static final int HORIZONTAL = 1;
    public static final int VERTICAL = 2;

    ClipDrawable() {
        this(null, null);
    }

    public ClipDrawable(Drawable drawable2, int gravity, int orientation) {
        this(null, null);
        this.mClipState.mDrawable = drawable2;
        this.mClipState.mGravity = gravity;
        this.mClipState.mOrientation = orientation;
        if (drawable2 != null) {
            drawable2.setCallback(this);
        }
    }

    @Override
    public void inflate(Resources r, XmlPullParser parser, AttributeSet attrs, Resources.Theme theme) throws XmlPullParserException, IOException {
        int type;
        super.inflate(r, parser, attrs, theme);
        TypedArray a = ClipDrawable.obtainAttributes(r, theme, attrs, R.styleable.ClipDrawable);
        int orientation = a.getInt(2, 1);
        int g = a.getInt(0, 3);
        Drawable dr = a.getDrawable(1);
        a.recycle();
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            if (type != 2) continue;
            dr = Drawable.createFromXmlInner(r, parser, attrs, theme);
        }
        if (dr == null) {
            throw new IllegalArgumentException("No drawable specified for <clip>");
        }
        this.mClipState.mDrawable = dr;
        this.mClipState.mOrientation = orientation;
        this.mClipState.mGravity = g;
        dr.setCallback(this);
    }

    @Override
    public void invalidateDrawable(Drawable who) {
        Drawable.Callback callback = this.getCallback();
        if (callback != null) {
            callback.invalidateDrawable(this);
        }
    }

    @Override
    public void scheduleDrawable(Drawable who, Runnable what, long when) {
        Drawable.Callback callback = this.getCallback();
        if (callback != null) {
            callback.scheduleDrawable(this, what, when);
        }
    }

    @Override
    public void unscheduleDrawable(Drawable who, Runnable what) {
        Drawable.Callback callback = this.getCallback();
        if (callback != null) {
            callback.unscheduleDrawable(this, what);
        }
    }

    @Override
    public int getChangingConfigurations() {
        return super.getChangingConfigurations() | this.mClipState.mChangingConfigurations | this.mClipState.mDrawable.getChangingConfigurations();
    }

    @Override
    public boolean getPadding(Rect padding) {
        return this.mClipState.mDrawable.getPadding(padding);
    }

    @Override
    public boolean setVisible(boolean visible, boolean restart) {
        this.mClipState.mDrawable.setVisible(visible, restart);
        return super.setVisible(visible, restart);
    }

    @Override
    public void setAlpha(int alpha) {
        this.mClipState.mDrawable.setAlpha(alpha);
    }

    @Override
    public int getAlpha() {
        return this.mClipState.mDrawable.getAlpha();
    }

    @Override
    public void setColorFilter(ColorFilter cf) {
        this.mClipState.mDrawable.setColorFilter(cf);
    }

    @Override
    public void setTintList(ColorStateList tint) {
        this.mClipState.mDrawable.setTintList(tint);
    }

    @Override
    public void setTintMode(PorterDuff.Mode tintMode) {
        this.mClipState.mDrawable.setTintMode(tintMode);
    }

    @Override
    public int getOpacity() {
        return this.mClipState.mDrawable.getOpacity();
    }

    @Override
    public boolean isStateful() {
        return this.mClipState.mDrawable.isStateful();
    }

    @Override
    protected boolean onStateChange(int[] state) {
        return this.mClipState.mDrawable.setState(state);
    }

    @Override
    protected boolean onLevelChange(int level) {
        this.mClipState.mDrawable.setLevel(level);
        this.invalidateSelf();
        return true;
    }

    @Override
    protected void onBoundsChange(Rect bounds) {
        this.mClipState.mDrawable.setBounds(bounds);
    }

    @Override
    public void draw(Canvas canvas) {
        if (this.mClipState.mDrawable.getLevel() == 0) {
            return;
        }
        Rect r = this.mTmpRect;
        Rect bounds = this.getBounds();
        int level = this.getLevel();
        int w = bounds.width();
        boolean iw = false;
        if ((this.mClipState.mOrientation & 1) != 0) {
            w -= (w - 0) * (10000 - level) / 10000;
        }
        int h = bounds.height();
        boolean ih = false;
        if ((this.mClipState.mOrientation & 2) != 0) {
            h -= (h - 0) * (10000 - level) / 10000;
        }
        int layoutDirection = this.getLayoutDirection();
        Gravity.apply(this.mClipState.mGravity, w, h, bounds, r, layoutDirection);
        if (w > 0 && h > 0) {
            canvas.save();
            canvas.clipRect(r);
            this.mClipState.mDrawable.draw(canvas);
            canvas.restore();
        }
    }

    @Override
    public int getIntrinsicWidth() {
        return this.mClipState.mDrawable.getIntrinsicWidth();
    }

    @Override
    public int getIntrinsicHeight() {
        return this.mClipState.mDrawable.getIntrinsicHeight();
    }

    @Override
    public Drawable.ConstantState getConstantState() {
        if (this.mClipState.canConstantState()) {
            this.mClipState.mChangingConfigurations = this.getChangingConfigurations();
            return this.mClipState;
        }
        return null;
    }

    @Override
    public void setLayoutDirection(int layoutDirection) {
        this.mClipState.mDrawable.setLayoutDirection(layoutDirection);
        super.setLayoutDirection(layoutDirection);
    }

    private ClipDrawable(ClipState state, Resources res) {
        this.mClipState = new ClipState(state, this, res);
    }

    static final class ClipState
    extends Drawable.ConstantState {
        Drawable mDrawable;
        int mChangingConfigurations;
        int mOrientation;
        int mGravity;
        private boolean mCheckedConstantState;
        private boolean mCanConstantState;

        ClipState(ClipState orig, ClipDrawable owner, Resources res) {
            if (orig != null) {
                this.mDrawable = res != null ? orig.mDrawable.getConstantState().newDrawable(res) : orig.mDrawable.getConstantState().newDrawable();
                this.mDrawable.setCallback(owner);
                this.mDrawable.setLayoutDirection(orig.mDrawable.getLayoutDirection());
                this.mDrawable.setBounds(orig.mDrawable.getBounds());
                this.mDrawable.setLevel(orig.mDrawable.getLevel());
                this.mOrientation = orig.mOrientation;
                this.mGravity = orig.mGravity;
                this.mCanConstantState = true;
                this.mCheckedConstantState = true;
            }
        }

        @Override
        public Drawable newDrawable() {
            return new ClipDrawable(this, null);
        }

        @Override
        public Drawable newDrawable(Resources res) {
            return new ClipDrawable(this, res);
        }

        @Override
        public int getChangingConfigurations() {
            return this.mChangingConfigurations;
        }

        boolean canConstantState() {
            if (!this.mCheckedConstantState) {
                this.mCanConstantState = this.mDrawable.getConstantState() != null;
                this.mCheckedConstantState = true;
            }
            return this.mCanConstantState;
        }
    }
}

