/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.DrawableContainer;
import android.util.AttributeSet;
import com.android.internal.R;
import java.io.IOException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class LevelListDrawable
extends DrawableContainer {
    private final LevelListState mLevelListState;
    private boolean mMutated;

    public LevelListDrawable() {
        this(null, null);
    }

    public void addLevel(int low, int high, Drawable drawable2) {
        if (drawable2 != null) {
            this.mLevelListState.addLevel(low, high, drawable2);
            this.onLevelChange(this.getLevel());
        }
    }

    @Override
    protected boolean onLevelChange(int level) {
        int idx = this.mLevelListState.indexOfLevel(level);
        if (this.selectDrawable(idx)) {
            return true;
        }
        return super.onLevelChange(level);
    }

    @Override
    public void inflate(Resources r, XmlPullParser parser, AttributeSet attrs, Resources.Theme theme) throws XmlPullParserException, IOException {
        int depth;
        int type;
        super.inflate(r, parser, attrs, theme);
        int low = 0;
        int innerDepth = parser.getDepth() + 1;
        while ((type = parser.next()) != 1 && ((depth = parser.getDepth()) >= innerDepth || type != 3)) {
            Drawable dr;
            if (type != 2 || depth > innerDepth || !parser.getName().equals("item")) continue;
            TypedArray a = LevelListDrawable.obtainAttributes(r, theme, attrs, R.styleable.LevelListDrawableItem);
            low = a.getInt(1, 0);
            int high = a.getInt(2, 0);
            int drawableRes = a.getResourceId(0, 0);
            a.recycle();
            if (high < 0) {
                throw new XmlPullParserException(parser.getPositionDescription() + ": <item> tag requires a 'maxLevel' attribute");
            }
            if (drawableRes != 0) {
                dr = r.getDrawable(drawableRes, theme);
            } else {
                while ((type = parser.next()) == 4) {
                }
                if (type != 2) {
                    throw new XmlPullParserException(parser.getPositionDescription() + ": <item> tag requires a 'drawable' attribute or " + "child tag defining a drawable");
                }
                dr = Drawable.createFromXmlInner(r, parser, attrs, theme);
            }
            this.mLevelListState.addLevel(low, high, dr);
        }
        this.onLevelChange(this.getLevel());
    }

    @Override
    public Drawable mutate() {
        if (!this.mMutated && super.mutate() == this) {
            LevelListState.access$002(this.mLevelListState, (int[])this.mLevelListState.mLows.clone());
            LevelListState.access$102(this.mLevelListState, (int[])this.mLevelListState.mHighs.clone());
            this.mMutated = true;
        }
        return this;
    }

    private LevelListDrawable(LevelListState state, Resources res) {
        LevelListState as;
        this.mLevelListState = as = new LevelListState(state, this, res);
        this.setConstantState(as);
        this.onLevelChange(this.getLevel());
    }

    private static final class LevelListState
    extends DrawableContainer.DrawableContainerState {
        private int[] mLows;
        private int[] mHighs;

        LevelListState(LevelListState orig, LevelListDrawable owner, Resources res) {
            super(orig, owner, res);
            if (orig != null) {
                this.mLows = orig.mLows;
                this.mHighs = orig.mHighs;
            } else {
                this.mLows = new int[this.getCapacity()];
                this.mHighs = new int[this.getCapacity()];
            }
        }

        public void addLevel(int low, int high, Drawable drawable2) {
            int pos = this.addChild(drawable2);
            this.mLows[pos] = low;
            this.mHighs[pos] = high;
        }

        public int indexOfLevel(int level) {
            int[] lows = this.mLows;
            int[] highs = this.mHighs;
            int N = this.getChildCount();
            for (int i = 0; i < N; ++i) {
                if (level < lows[i] || level > highs[i]) continue;
                return i;
            }
            return -1;
        }

        @Override
        public Drawable newDrawable() {
            return new LevelListDrawable(this, null);
        }

        @Override
        public Drawable newDrawable(Resources res) {
            return new LevelListDrawable(this, res);
        }

        @Override
        public void growArray(int oldSize, int newSize) {
            super.growArray(oldSize, newSize);
            int[] newInts = new int[newSize];
            System.arraycopy((int[])this.mLows, (int)0, (int[])newInts, (int)0, (int)oldSize);
            this.mLows = newInts;
            newInts = new int[newSize];
            System.arraycopy((int[])this.mHighs, (int)0, (int[])newInts, (int)0, (int)oldSize);
            this.mHighs = newInts;
        }

        static /* synthetic */ int[] access$002(LevelListState x0, int[] x1) {
            x0.mLows = x1;
            return x1;
        }

        static /* synthetic */ int[] access$102(LevelListState x0, int[] x1) {
            x0.mHighs = x1;
            return x1;
        }
    }
}

