/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.DrawableContainer;
import android.util.AttributeSet;
import android.util.StateSet;
import com.android.internal.R;
import java.io.IOException;
import java.util.Arrays;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class StateListDrawable
extends DrawableContainer {
    private static final String TAG = StateListDrawable.class.getSimpleName();
    private static final boolean DEBUG = false;
    private static final boolean DEFAULT_DITHER = true;
    private StateListState mStateListState;
    private boolean mMutated;

    public StateListDrawable() {
        this(null, null);
    }

    public void addState(int[] stateSet, Drawable drawable2) {
        if (drawable2 != null) {
            this.mStateListState.addStateSet(stateSet, drawable2);
            this.onStateChange(this.getState());
        }
    }

    @Override
    public boolean isStateful() {
        return true;
    }

    @Override
    protected boolean onStateChange(int[] stateSet) {
        int idx = this.mStateListState.indexOfStateSet(stateSet);
        if (idx < 0) {
            idx = this.mStateListState.indexOfStateSet(StateSet.WILD_CARD);
        }
        if (this.selectDrawable(idx)) {
            return true;
        }
        return super.onStateChange(stateSet);
    }

    @Override
    public void inflate(Resources r, XmlPullParser parser, AttributeSet attrs, Resources.Theme theme) throws XmlPullParserException, IOException {
        int depth;
        int type;
        TypedArray a = StateListDrawable.obtainAttributes(r, theme, attrs, R.styleable.StateListDrawable);
        super.inflateWithAttributes(r, parser, a, 1);
        this.mStateListState.setVariablePadding(a.getBoolean(2, false));
        this.mStateListState.setConstantSize(a.getBoolean(3, false));
        this.mStateListState.setEnterFadeDuration(a.getInt(4, 0));
        this.mStateListState.setExitFadeDuration(a.getInt(5, 0));
        this.setDither(a.getBoolean(0, true));
        this.setAutoMirrored(a.getBoolean(6, false));
        a.recycle();
        int innerDepth = parser.getDepth() + 1;
        while ((type = parser.next()) != 1 && ((depth = parser.getDepth()) >= innerDepth || type != 3)) {
            Drawable dr;
            int stateResId;
            if (type != 2 || depth > innerDepth || !parser.getName().equals("item")) continue;
            int drawableRes = 0;
            int j = 0;
            int numAttrs = attrs.getAttributeCount();
            int[] states = new int[numAttrs];
            for (int i = 0; i < numAttrs && (stateResId = attrs.getAttributeNameResource(i)) != 0; ++i) {
                if (stateResId == 0x1010199) {
                    drawableRes = attrs.getAttributeResourceValue(i, 0);
                    continue;
                }
                states[j++] = attrs.getAttributeBooleanValue(i, false) ? stateResId : -stateResId;
            }
            states = StateSet.trimStateSet(states, j);
            if (drawableRes != 0) {
                dr = r.getDrawable(drawableRes, theme);
            } else {
                while ((type = parser.next()) == 4) {
                }
                if (type != 2) {
                    throw new XmlPullParserException(parser.getPositionDescription() + ": <item> tag requires a 'drawable' attribute or " + "child tag defining a drawable");
                }
                dr = Drawable.createFromXmlInner(r, parser, attrs, theme);
            }
            this.mStateListState.addStateSet(states, dr);
        }
        this.onStateChange(this.getState());
    }

    StateListState getStateListState() {
        return this.mStateListState;
    }

    public int getStateCount() {
        return this.mStateListState.getChildCount();
    }

    public int[] getStateSet(int index) {
        return this.mStateListState.mStateSets[index];
    }

    public Drawable getStateDrawable(int index) {
        return this.mStateListState.getChild(index);
    }

    public int getStateDrawableIndex(int[] stateSet) {
        return this.mStateListState.indexOfStateSet(stateSet);
    }

    @Override
    public Drawable mutate() {
        if (!this.mMutated && super.mutate() == this) {
            int[][] sets = this.mStateListState.mStateSets;
            int count = sets.length;
            this.mStateListState.mStateSets = new int[count][];
            for (int i = 0; i < count; ++i) {
                int[] set = sets[i];
                if (set == null) continue;
                this.mStateListState.mStateSets[i] = (int[])set.clone();
            }
            this.mMutated = true;
        }
        return this;
    }

    @Override
    public void setLayoutDirection(int layoutDirection) {
        super.setLayoutDirection(layoutDirection);
        this.mStateListState.setLayoutDirection(layoutDirection);
    }

    void setConstantState(StateListState state) {
        super.setConstantState(state);
        this.mStateListState = state;
    }

    private StateListDrawable(StateListState state, Resources res) {
        StateListState newState = new StateListState(state, this, res);
        this.setConstantState(newState);
        this.onStateChange(this.getState());
    }

    StateListDrawable(StateListState state) {
        if (state != null) {
            this.setConstantState(state);
        }
    }

    static class StateListState
    extends DrawableContainer.DrawableContainerState {
        int[][] mStateSets;

        StateListState(StateListState orig, StateListDrawable owner, Resources res) {
            super(orig, owner, res);
            this.mStateSets = orig != null ? (int[][])Arrays.copyOf(orig.mStateSets, orig.mStateSets.length) : (int[][])new int[this.getCapacity()][];
        }

        int addStateSet(int[] stateSet, Drawable drawable2) {
            int pos = this.addChild(drawable2);
            this.mStateSets[pos] = stateSet;
            return pos;
        }

        int indexOfStateSet(int[] stateSet) {
            int[][] stateSets = this.mStateSets;
            int N = this.getChildCount();
            for (int i = 0; i < N; ++i) {
                if (!StateSet.stateSetMatches(stateSets[i], stateSet)) continue;
                return i;
            }
            return -1;
        }

        @Override
        public Drawable newDrawable() {
            return new StateListDrawable(this, null);
        }

        @Override
        public Drawable newDrawable(Resources res) {
            return new StateListDrawable(this, res);
        }

        @Override
        public void growArray(int oldSize, int newSize) {
            super.growArray(oldSize, newSize);
            int[][] newStateSets = new int[newSize][];
            System.arraycopy(this.mStateSets, 0, newStateSets, 0, oldSize);
            this.mStateSets = newStateSets;
        }
    }
}

