/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathMeasure;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.Rect;
import android.graphics.Region;
import android.graphics.drawable.Drawable;
import android.util.ArrayMap;
import android.util.AttributeSet;
import android.util.Log;
import android.util.PathParser;
import android.util.Xml;
import com.android.internal.R;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Stack;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class VectorDrawable
extends Drawable {
    private static final String LOGTAG = VectorDrawable.class.getSimpleName();
    private static final String SHAPE_CLIP_PATH = "clip-path";
    private static final String SHAPE_GROUP = "group";
    private static final String SHAPE_PATH = "path";
    private static final String SHAPE_VECTOR = "vector";
    private static final int LINECAP_BUTT = 0;
    private static final int LINECAP_ROUND = 1;
    private static final int LINECAP_SQUARE = 2;
    private static final int LINEJOIN_MITER = 0;
    private static final int LINEJOIN_ROUND = 1;
    private static final int LINEJOIN_BEVEL = 2;
    private static final boolean DBG_VECTOR_DRAWABLE = false;
    private VectorDrawableState mVectorState;
    private PorterDuffColorFilter mTintFilter;
    private ColorFilter mColorFilter;
    private boolean mMutated;
    private boolean mAllowCaching = true;

    public VectorDrawable() {
        this.mVectorState = new VectorDrawableState();
    }

    private VectorDrawable(VectorDrawableState state, Resources res, Resources.Theme theme) {
        if (theme != null && state.canApplyTheme()) {
            this.mVectorState = new VectorDrawableState(state);
            this.applyTheme(theme);
        } else {
            this.mVectorState = state;
        }
        this.mTintFilter = this.updateTintFilter(this.mTintFilter, state.mTint, state.mTintMode);
    }

    @Override
    public Drawable mutate() {
        if (!this.mMutated && super.mutate() == this) {
            this.mVectorState = new VectorDrawableState(this.mVectorState);
            this.mMutated = true;
        }
        return this;
    }

    Object getTargetByName(String name) {
        return this.mVectorState.mVPathRenderer.mVGTargetsMap.get(name);
    }

    @Override
    public Drawable.ConstantState getConstantState() {
        this.mVectorState.mChangingConfigurations = this.getChangingConfigurations();
        return this.mVectorState;
    }

    @Override
    public void draw(Canvas canvas) {
        ColorFilter colorFilter;
        Rect bounds = this.getBounds();
        if (bounds.width() == 0 || bounds.height() == 0) {
            return;
        }
        int saveCount = canvas.save();
        boolean needMirroring = this.needMirroring();
        canvas.translate(bounds.left, bounds.top);
        if (needMirroring) {
            canvas.translate(bounds.width(), 0.0f);
            canvas.scale(-1.0f, 1.0f);
        }
        ColorFilter colorFilter2 = colorFilter = this.mColorFilter == null ? this.mTintFilter : this.mColorFilter;
        if (!this.mAllowCaching) {
            if (!this.mVectorState.hasTranslucentRoot()) {
                this.mVectorState.mVPathRenderer.draw(canvas, bounds.width(), bounds.height(), colorFilter);
            } else {
                this.mVectorState.createCachedBitmapIfNeeded(bounds);
                this.mVectorState.updateCachedBitmap(bounds);
                this.mVectorState.drawCachedBitmapWithRootAlpha(canvas, colorFilter);
            }
        } else {
            this.mVectorState.createCachedBitmapIfNeeded(bounds);
            if (!this.mVectorState.canReuseCache()) {
                this.mVectorState.updateCachedBitmap(bounds);
                this.mVectorState.updateCacheStates();
            }
            this.mVectorState.drawCachedBitmapWithRootAlpha(canvas, colorFilter);
        }
        canvas.restoreToCount(saveCount);
    }

    @Override
    public int getAlpha() {
        return this.mVectorState.mVPathRenderer.getRootAlpha();
    }

    @Override
    public void setAlpha(int alpha) {
        if (this.mVectorState.mVPathRenderer.getRootAlpha() != alpha) {
            this.mVectorState.mVPathRenderer.setRootAlpha(alpha);
            this.invalidateSelf();
        }
    }

    @Override
    public void setColorFilter(ColorFilter colorFilter) {
        this.mColorFilter = colorFilter;
        this.invalidateSelf();
    }

    @Override
    public void setTintList(ColorStateList tint) {
        VectorDrawableState state = this.mVectorState;
        if (state.mTint != tint) {
            state.mTint = tint;
            this.mTintFilter = this.updateTintFilter(this.mTintFilter, tint, state.mTintMode);
            this.invalidateSelf();
        }
    }

    @Override
    public void setTintMode(PorterDuff.Mode tintMode) {
        VectorDrawableState state = this.mVectorState;
        if (state.mTintMode != tintMode) {
            state.mTintMode = tintMode;
            this.mTintFilter = this.updateTintFilter(this.mTintFilter, state.mTint, tintMode);
            this.invalidateSelf();
        }
    }

    @Override
    public boolean isStateful() {
        return super.isStateful() || this.mVectorState != null && this.mVectorState.mTint != null && this.mVectorState.mTint.isStateful();
    }

    @Override
    protected boolean onStateChange(int[] stateSet) {
        VectorDrawableState state = this.mVectorState;
        if (state.mTint != null && state.mTintMode != null) {
            this.mTintFilter = this.updateTintFilter(this.mTintFilter, state.mTint, state.mTintMode);
            this.invalidateSelf();
            return true;
        }
        return false;
    }

    @Override
    public int getOpacity() {
        return -3;
    }

    @Override
    public int getIntrinsicWidth() {
        return (int)this.mVectorState.mVPathRenderer.mBaseWidth;
    }

    @Override
    public int getIntrinsicHeight() {
        return (int)this.mVectorState.mVPathRenderer.mBaseHeight;
    }

    @Override
    public boolean canApplyTheme() {
        return super.canApplyTheme() || this.mVectorState != null && this.mVectorState.canApplyTheme();
    }

    @Override
    public void applyTheme(Resources.Theme t) {
        VPathRenderer path;
        super.applyTheme(t);
        VectorDrawableState state = this.mVectorState;
        if (state != null && state.mThemeAttrs != null) {
            TypedArray a = t.resolveAttributes(state.mThemeAttrs, R.styleable.VectorDrawable);
            try {
                state.mCacheDirty = true;
                this.updateStateFromTypedArray(a);
            }
            catch (XmlPullParserException e) {
                throw new RuntimeException(e);
            }
            finally {
                a.recycle();
            }
            this.mTintFilter = this.updateTintFilter(this.mTintFilter, state.mTint, state.mTintMode);
        }
        if ((path = state.mVPathRenderer) != null && path.canApplyTheme()) {
            path.applyTheme(t);
        }
    }

    public float getPixelSize() {
        if (this.mVectorState == null && this.mVectorState.mVPathRenderer == null || this.mVectorState.mVPathRenderer.mBaseWidth == 0.0f || this.mVectorState.mVPathRenderer.mBaseHeight == 0.0f || this.mVectorState.mVPathRenderer.mViewportHeight == 0.0f || this.mVectorState.mVPathRenderer.mViewportWidth == 0.0f) {
            return 1.0f;
        }
        float intrinsicWidth = this.mVectorState.mVPathRenderer.mBaseWidth;
        float intrinsicHeight = this.mVectorState.mVPathRenderer.mBaseHeight;
        float viewportWidth = this.mVectorState.mVPathRenderer.mViewportWidth;
        float viewportHeight = this.mVectorState.mVPathRenderer.mViewportHeight;
        float scaleX = viewportWidth / intrinsicWidth;
        float scaleY = viewportHeight / intrinsicHeight;
        return Math.min(scaleX, scaleY);
    }

    public static VectorDrawable create(Resources resources, int rid) {
        try {
            int type;
            XmlResourceParser parser = resources.getXml(rid);
            AttributeSet attrs = Xml.asAttributeSet(parser);
            while ((type = parser.next()) != 2 && type != 1) {
            }
            if (type != 2) {
                throw new XmlPullParserException("No start tag found");
            }
            VectorDrawable drawable2 = new VectorDrawable();
            drawable2.inflate(resources, parser, attrs);
            return drawable2;
        }
        catch (XmlPullParserException e) {
            Log.e(LOGTAG, "parser error", e);
        }
        catch (IOException e) {
            Log.e(LOGTAG, "parser error", e);
        }
        return null;
    }

    private static int applyAlpha(int color2, float alpha) {
        int alphaBytes = Color.alpha(color2);
        color2 &= 0xFFFFFF;
        return color2 |= (int)((float)alphaBytes * alpha) << 24;
    }

    @Override
    public void inflate(Resources res, XmlPullParser parser, AttributeSet attrs, Resources.Theme theme) throws XmlPullParserException, IOException {
        VPathRenderer pathRenderer;
        VectorDrawableState state = this.mVectorState;
        state.mVPathRenderer = pathRenderer = new VPathRenderer();
        TypedArray a = VectorDrawable.obtainAttributes(res, theme, attrs, R.styleable.VectorDrawable);
        this.updateStateFromTypedArray(a);
        a.recycle();
        state.mCacheDirty = true;
        this.inflateInternal(res, parser, attrs, theme);
        this.mTintFilter = this.updateTintFilter(this.mTintFilter, state.mTint, state.mTintMode);
    }

    private void updateStateFromTypedArray(TypedArray a) throws XmlPullParserException {
        ColorStateList tint;
        VectorDrawableState state = this.mVectorState;
        VPathRenderer pathRenderer = state.mVPathRenderer;
        state.mChangingConfigurations |= a.getChangingConfigurations();
        state.mThemeAttrs = a.extractThemeAttrs();
        int tintMode = a.getInt(6, -1);
        if (tintMode != -1) {
            state.mTintMode = Drawable.parseTintMode(tintMode, PorterDuff.Mode.SRC_IN);
        }
        if ((tint = a.getColorStateList(1)) != null) {
            state.mTint = tint;
        }
        state.mAutoMirrored = a.getBoolean(5, state.mAutoMirrored);
        pathRenderer.mViewportWidth = a.getFloat(7, pathRenderer.mViewportWidth);
        pathRenderer.mViewportHeight = a.getFloat(8, pathRenderer.mViewportHeight);
        if (pathRenderer.mViewportWidth <= 0.0f) {
            throw new XmlPullParserException(a.getPositionDescription() + "<vector> tag requires viewportWidth > 0");
        }
        if (pathRenderer.mViewportHeight <= 0.0f) {
            throw new XmlPullParserException(a.getPositionDescription() + "<vector> tag requires viewportHeight > 0");
        }
        pathRenderer.mBaseWidth = a.getDimension(3, pathRenderer.mBaseWidth);
        pathRenderer.mBaseHeight = a.getDimension(2, pathRenderer.mBaseHeight);
        if (pathRenderer.mBaseWidth <= 0.0f) {
            throw new XmlPullParserException(a.getPositionDescription() + "<vector> tag requires width > 0");
        }
        if (pathRenderer.mBaseHeight <= 0.0f) {
            throw new XmlPullParserException(a.getPositionDescription() + "<vector> tag requires height > 0");
        }
        float alphaInFloat = a.getFloat(4, pathRenderer.getAlpha());
        pathRenderer.setAlpha(alphaInFloat);
        String name = a.getString(0);
        if (name != null) {
            pathRenderer.mRootName = name;
            pathRenderer.mVGTargetsMap.put(name, pathRenderer);
        }
    }

    private void inflateInternal(Resources res, XmlPullParser parser, AttributeSet attrs, Resources.Theme theme) throws XmlPullParserException, IOException {
        VectorDrawableState state = this.mVectorState;
        VPathRenderer pathRenderer = state.mVPathRenderer;
        boolean noPathTag = true;
        Stack<VGroup> groupStack = new Stack<VGroup>();
        groupStack.push(pathRenderer.mRootGroup);
        int eventType = parser.getEventType();
        while (eventType != 1) {
            String tagName;
            if (eventType == 2) {
                VPath path;
                tagName = parser.getName();
                VGroup currentGroup = (VGroup)groupStack.peek();
                if (SHAPE_PATH.equals(tagName)) {
                    path = new VFullPath();
                    ((VFullPath)path).inflate(res, attrs, theme);
                    currentGroup.mChildren.add(path);
                    if (path.getPathName() != null) {
                        pathRenderer.mVGTargetsMap.put(path.getPathName(), path);
                    }
                    noPathTag = false;
                    state.mChangingConfigurations |= ((VFullPath)path).mChangingConfigurations;
                } else if (SHAPE_CLIP_PATH.equals(tagName)) {
                    path = new VClipPath();
                    ((VClipPath)path).inflate(res, attrs, theme);
                    currentGroup.mChildren.add(path);
                    if (path.getPathName() != null) {
                        pathRenderer.mVGTargetsMap.put(path.getPathName(), path);
                    }
                    state.mChangingConfigurations |= ((VClipPath)path).mChangingConfigurations;
                } else if (SHAPE_GROUP.equals(tagName)) {
                    VGroup newChildGroup = new VGroup();
                    newChildGroup.inflate(res, attrs, theme);
                    currentGroup.mChildren.add(newChildGroup);
                    groupStack.push(newChildGroup);
                    if (newChildGroup.getGroupName() != null) {
                        pathRenderer.mVGTargetsMap.put(newChildGroup.getGroupName(), newChildGroup);
                    }
                    state.mChangingConfigurations |= newChildGroup.mChangingConfigurations;
                }
            } else if (eventType == 3 && SHAPE_GROUP.equals(tagName = parser.getName())) {
                groupStack.pop();
            }
            eventType = parser.next();
        }
        if (noPathTag) {
            StringBuffer tag = new StringBuffer();
            if (tag.length() > 0) {
                tag.append(" or ");
            }
            tag.append(SHAPE_PATH);
            throw new XmlPullParserException("no " + tag + " defined");
        }
    }

    private void printGroupTree(VGroup currentGroup, int level) {
        int i;
        String indent = "";
        for (i = 0; i < level; ++i) {
            indent = indent + "    ";
        }
        Log.v(LOGTAG, indent + "current group is :" + currentGroup.getGroupName() + " rotation is " + currentGroup.mRotate);
        Log.v(LOGTAG, indent + "matrix is :" + currentGroup.getLocalMatrix().toString());
        for (i = 0; i < currentGroup.mChildren.size(); ++i) {
            Object child = currentGroup.mChildren.get(i);
            if (!(child instanceof VGroup)) continue;
            this.printGroupTree((VGroup)child, level + 1);
        }
    }

    @Override
    public int getChangingConfigurations() {
        return super.getChangingConfigurations() | this.mVectorState.mChangingConfigurations;
    }

    void setAllowCaching(boolean allowCaching) {
        this.mAllowCaching = allowCaching;
    }

    private boolean needMirroring() {
        return this.isAutoMirrored() && this.getLayoutDirection() == 1;
    }

    @Override
    public void setAutoMirrored(boolean mirrored) {
        if (this.mVectorState.mAutoMirrored != mirrored) {
            this.mVectorState.mAutoMirrored = mirrored;
            this.invalidateSelf();
        }
    }

    @Override
    public boolean isAutoMirrored() {
        return this.mVectorState.mAutoMirrored;
    }

    private static class VFullPath
    extends VPath {
        private int[] mThemeAttrs;
        int mStrokeColor = 0;
        float mStrokeWidth = 0.0f;
        int mFillColor = 0;
        float mStrokeAlpha = 1.0f;
        int mFillRule;
        float mFillAlpha = 1.0f;
        float mTrimPathStart = 0.0f;
        float mTrimPathEnd = 1.0f;
        float mTrimPathOffset = 0.0f;
        Paint.Cap mStrokeLineCap = Paint.Cap.BUTT;
        Paint.Join mStrokeLineJoin = Paint.Join.MITER;
        float mStrokeMiterlimit = 4.0f;

        public VFullPath() {
        }

        public VFullPath(VFullPath copy) {
            super(copy);
            this.mThemeAttrs = copy.mThemeAttrs;
            this.mStrokeColor = copy.mStrokeColor;
            this.mStrokeWidth = copy.mStrokeWidth;
            this.mStrokeAlpha = copy.mStrokeAlpha;
            this.mFillColor = copy.mFillColor;
            this.mFillRule = copy.mFillRule;
            this.mFillAlpha = copy.mFillAlpha;
            this.mTrimPathStart = copy.mTrimPathStart;
            this.mTrimPathEnd = copy.mTrimPathEnd;
            this.mTrimPathOffset = copy.mTrimPathOffset;
            this.mStrokeLineCap = copy.mStrokeLineCap;
            this.mStrokeLineJoin = copy.mStrokeLineJoin;
            this.mStrokeMiterlimit = copy.mStrokeMiterlimit;
        }

        private Paint.Cap getStrokeLineCap(int id2, Paint.Cap defValue) {
            switch (id2) {
                case 0: {
                    return Paint.Cap.BUTT;
                }
                case 1: {
                    return Paint.Cap.ROUND;
                }
                case 2: {
                    return Paint.Cap.SQUARE;
                }
            }
            return defValue;
        }

        private Paint.Join getStrokeLineJoin(int id2, Paint.Join defValue) {
            switch (id2) {
                case 0: {
                    return Paint.Join.MITER;
                }
                case 1: {
                    return Paint.Join.ROUND;
                }
                case 2: {
                    return Paint.Join.BEVEL;
                }
            }
            return defValue;
        }

        @Override
        public boolean canApplyTheme() {
            return this.mThemeAttrs != null;
        }

        public void inflate(Resources r, AttributeSet attrs, Resources.Theme theme) {
            TypedArray a = Drawable.obtainAttributes(r, theme, attrs, R.styleable.VectorDrawablePath);
            this.updateStateFromTypedArray(a);
            a.recycle();
        }

        private void updateStateFromTypedArray(TypedArray a) {
            String pathData;
            this.mChangingConfigurations |= a.getChangingConfigurations();
            this.mThemeAttrs = a.extractThemeAttrs();
            String pathName = a.getString(0);
            if (pathName != null) {
                this.mPathName = pathName;
            }
            if ((pathData = a.getString(2)) != null) {
                this.mNodes = PathParser.createNodesFromPathData(pathData);
            }
            this.mFillColor = a.getColor(1, this.mFillColor);
            this.mFillAlpha = a.getFloat(12, this.mFillAlpha);
            this.mStrokeLineCap = this.getStrokeLineCap(a.getInt(8, -1), this.mStrokeLineCap);
            this.mStrokeLineJoin = this.getStrokeLineJoin(a.getInt(9, -1), this.mStrokeLineJoin);
            this.mStrokeMiterlimit = a.getFloat(10, this.mStrokeMiterlimit);
            this.mStrokeColor = a.getColor(3, this.mStrokeColor);
            this.mStrokeAlpha = a.getFloat(11, this.mStrokeAlpha);
            this.mStrokeWidth = a.getFloat(4, this.mStrokeWidth);
            this.mTrimPathEnd = a.getFloat(6, this.mTrimPathEnd);
            this.mTrimPathOffset = a.getFloat(7, this.mTrimPathOffset);
            this.mTrimPathStart = a.getFloat(5, this.mTrimPathStart);
        }

        @Override
        public void applyTheme(Resources.Theme t) {
            if (this.mThemeAttrs == null) {
                return;
            }
            TypedArray a = t.resolveAttributes(this.mThemeAttrs, R.styleable.VectorDrawablePath);
            this.updateStateFromTypedArray(a);
            a.recycle();
        }

        int getStrokeColor() {
            return this.mStrokeColor;
        }

        void setStrokeColor(int strokeColor) {
            this.mStrokeColor = strokeColor;
        }

        float getStrokeWidth() {
            return this.mStrokeWidth;
        }

        void setStrokeWidth(float strokeWidth) {
            this.mStrokeWidth = strokeWidth;
        }

        float getStrokeAlpha() {
            return this.mStrokeAlpha;
        }

        void setStrokeAlpha(float strokeAlpha) {
            this.mStrokeAlpha = strokeAlpha;
        }

        int getFillColor() {
            return this.mFillColor;
        }

        void setFillColor(int fillColor) {
            this.mFillColor = fillColor;
        }

        float getFillAlpha() {
            return this.mFillAlpha;
        }

        void setFillAlpha(float fillAlpha) {
            this.mFillAlpha = fillAlpha;
        }

        float getTrimPathStart() {
            return this.mTrimPathStart;
        }

        void setTrimPathStart(float trimPathStart) {
            this.mTrimPathStart = trimPathStart;
        }

        float getTrimPathEnd() {
            return this.mTrimPathEnd;
        }

        void setTrimPathEnd(float trimPathEnd) {
            this.mTrimPathEnd = trimPathEnd;
        }

        float getTrimPathOffset() {
            return this.mTrimPathOffset;
        }

        void setTrimPathOffset(float trimPathOffset) {
            this.mTrimPathOffset = trimPathOffset;
        }
    }

    private static class VClipPath
    extends VPath {
        public VClipPath() {
        }

        public VClipPath(VClipPath copy) {
            super(copy);
        }

        public void inflate(Resources r, AttributeSet attrs, Resources.Theme theme) {
            TypedArray a = Drawable.obtainAttributes(r, theme, attrs, R.styleable.VectorDrawableClipPath);
            this.updateStateFromTypedArray(a);
            a.recycle();
        }

        private void updateStateFromTypedArray(TypedArray a) {
            String pathData;
            this.mChangingConfigurations |= a.getChangingConfigurations();
            String pathName = a.getString(0);
            if (pathName != null) {
                this.mPathName = pathName;
            }
            if ((pathData = a.getString(1)) != null) {
                this.mNodes = PathParser.createNodesFromPathData(pathData);
            }
        }

        @Override
        public boolean isClipPath() {
            return true;
        }
    }

    private static class VPath {
        protected PathParser.PathDataNode[] mNodes = null;
        String mPathName;
        int mChangingConfigurations;

        public VPath() {
        }

        public VPath(VPath copy) {
            this.mPathName = copy.mPathName;
            this.mChangingConfigurations = copy.mChangingConfigurations;
            this.mNodes = PathParser.deepCopyNodes(copy.mNodes);
        }

        public void toPath(Path path) {
            path.reset();
            if (this.mNodes != null) {
                PathParser.PathDataNode.nodesToPath(this.mNodes, path);
            }
        }

        public String getPathName() {
            return this.mPathName;
        }

        public boolean canApplyTheme() {
            return false;
        }

        public void applyTheme(Resources.Theme t) {
        }

        public boolean isClipPath() {
            return false;
        }

        public PathParser.PathDataNode[] getPathData() {
            return this.mNodes;
        }

        public void setPathData(PathParser.PathDataNode[] nodes) {
            if (!PathParser.canMorph(this.mNodes, nodes)) {
                this.mNodes = PathParser.deepCopyNodes(nodes);
            } else {
                PathParser.updateNodes(this.mNodes, nodes);
            }
        }
    }

    private static class VGroup {
        private final Matrix mStackedMatrix = new Matrix();
        final ArrayList<Object> mChildren = new ArrayList();
        private float mRotate = 0.0f;
        private float mPivotX = 0.0f;
        private float mPivotY = 0.0f;
        private float mScaleX = 1.0f;
        private float mScaleY = 1.0f;
        private float mTranslateX = 0.0f;
        private float mTranslateY = 0.0f;
        private final Matrix mLocalMatrix = new Matrix();
        private int mChangingConfigurations;
        private int[] mThemeAttrs;
        private String mGroupName = null;

        public VGroup(VGroup copy, ArrayMap<String, Object> targetsMap) {
            this.mRotate = copy.mRotate;
            this.mPivotX = copy.mPivotX;
            this.mPivotY = copy.mPivotY;
            this.mScaleX = copy.mScaleX;
            this.mScaleY = copy.mScaleY;
            this.mTranslateX = copy.mTranslateX;
            this.mTranslateY = copy.mTranslateY;
            this.mThemeAttrs = copy.mThemeAttrs;
            this.mGroupName = copy.mGroupName;
            this.mChangingConfigurations = copy.mChangingConfigurations;
            if (this.mGroupName != null) {
                targetsMap.put(this.mGroupName, this);
            }
            this.mLocalMatrix.set(copy.mLocalMatrix);
            ArrayList<Object> children = copy.mChildren;
            for (int i = 0; i < children.size(); ++i) {
                Object copyChild = children.get(i);
                if (copyChild instanceof VGroup) {
                    VGroup copyGroup = (VGroup)copyChild;
                    this.mChildren.add(new VGroup(copyGroup, targetsMap));
                    continue;
                }
                VPath newPath = null;
                if (copyChild instanceof VFullPath) {
                    newPath = new VFullPath((VFullPath)copyChild);
                } else if (copyChild instanceof VClipPath) {
                    newPath = new VClipPath((VClipPath)copyChild);
                } else {
                    throw new IllegalStateException("Unknown object in the tree!");
                }
                this.mChildren.add(newPath);
                if (newPath.mPathName == null) continue;
                targetsMap.put(newPath.mPathName, newPath);
            }
        }

        public VGroup() {
        }

        public String getGroupName() {
            return this.mGroupName;
        }

        public Matrix getLocalMatrix() {
            return this.mLocalMatrix;
        }

        public void inflate(Resources res, AttributeSet attrs, Resources.Theme theme) {
            TypedArray a = Drawable.obtainAttributes(res, theme, attrs, R.styleable.VectorDrawableGroup);
            this.updateStateFromTypedArray(a);
            a.recycle();
        }

        private void updateStateFromTypedArray(TypedArray a) {
            this.mChangingConfigurations |= a.getChangingConfigurations();
            this.mThemeAttrs = a.extractThemeAttrs();
            this.mRotate = a.getFloat(5, this.mRotate);
            this.mPivotX = a.getFloat(1, this.mPivotX);
            this.mPivotY = a.getFloat(2, this.mPivotY);
            this.mScaleX = a.getFloat(3, this.mScaleX);
            this.mScaleY = a.getFloat(4, this.mScaleY);
            this.mTranslateX = a.getFloat(6, this.mTranslateX);
            this.mTranslateY = a.getFloat(7, this.mTranslateY);
            String groupName = a.getString(0);
            if (groupName != null) {
                this.mGroupName = groupName;
            }
            this.updateLocalMatrix();
        }

        public boolean canApplyTheme() {
            return this.mThemeAttrs != null;
        }

        public void applyTheme(Resources.Theme t) {
            if (this.mThemeAttrs == null) {
                return;
            }
            TypedArray a = t.resolveAttributes(this.mThemeAttrs, R.styleable.VectorDrawableGroup);
            this.updateStateFromTypedArray(a);
            a.recycle();
        }

        private void updateLocalMatrix() {
            this.mLocalMatrix.reset();
            this.mLocalMatrix.postTranslate(-this.mPivotX, -this.mPivotY);
            this.mLocalMatrix.postScale(this.mScaleX, this.mScaleY);
            this.mLocalMatrix.postRotate(this.mRotate, 0.0f, 0.0f);
            this.mLocalMatrix.postTranslate(this.mTranslateX + this.mPivotX, this.mTranslateY + this.mPivotY);
        }

        public float getRotation() {
            return this.mRotate;
        }

        public void setRotation(float rotation) {
            if (rotation != this.mRotate) {
                this.mRotate = rotation;
                this.updateLocalMatrix();
            }
        }

        public float getPivotX() {
            return this.mPivotX;
        }

        public void setPivotX(float pivotX) {
            if (pivotX != this.mPivotX) {
                this.mPivotX = pivotX;
                this.updateLocalMatrix();
            }
        }

        public float getPivotY() {
            return this.mPivotY;
        }

        public void setPivotY(float pivotY) {
            if (pivotY != this.mPivotY) {
                this.mPivotY = pivotY;
                this.updateLocalMatrix();
            }
        }

        public float getScaleX() {
            return this.mScaleX;
        }

        public void setScaleX(float scaleX) {
            if (scaleX != this.mScaleX) {
                this.mScaleX = scaleX;
                this.updateLocalMatrix();
            }
        }

        public float getScaleY() {
            return this.mScaleY;
        }

        public void setScaleY(float scaleY) {
            if (scaleY != this.mScaleY) {
                this.mScaleY = scaleY;
                this.updateLocalMatrix();
            }
        }

        public float getTranslateX() {
            return this.mTranslateX;
        }

        public void setTranslateX(float translateX) {
            if (translateX != this.mTranslateX) {
                this.mTranslateX = translateX;
                this.updateLocalMatrix();
            }
        }

        public float getTranslateY() {
            return this.mTranslateY;
        }

        public void setTranslateY(float translateY) {
            if (translateY != this.mTranslateY) {
                this.mTranslateY = translateY;
                this.updateLocalMatrix();
            }
        }
    }

    private static class VPathRenderer {
        private final Path mPath;
        private final Path mRenderPath;
        private static final Matrix IDENTITY_MATRIX = new Matrix();
        private final Matrix mFinalPathMatrix = new Matrix();
        private Paint mStrokePaint;
        private Paint mFillPaint;
        private PathMeasure mPathMeasure;
        private int mChangingConfigurations;
        private final VGroup mRootGroup;
        float mBaseWidth = 0.0f;
        float mBaseHeight = 0.0f;
        float mViewportWidth = 0.0f;
        float mViewportHeight = 0.0f;
        int mRootAlpha = 255;
        String mRootName = null;
        final ArrayMap<String, Object> mVGTargetsMap = new ArrayMap();

        public VPathRenderer() {
            this.mRootGroup = new VGroup();
            this.mPath = new Path();
            this.mRenderPath = new Path();
        }

        public void setRootAlpha(int alpha) {
            this.mRootAlpha = alpha;
        }

        public int getRootAlpha() {
            return this.mRootAlpha;
        }

        public void setAlpha(float alpha) {
            this.setRootAlpha((int)(alpha * 255.0f));
        }

        public float getAlpha() {
            return (float)this.getRootAlpha() / 255.0f;
        }

        public VPathRenderer(VPathRenderer copy) {
            this.mRootGroup = new VGroup(copy.mRootGroup, this.mVGTargetsMap);
            this.mPath = new Path(copy.mPath);
            this.mRenderPath = new Path(copy.mRenderPath);
            this.mBaseWidth = copy.mBaseWidth;
            this.mBaseHeight = copy.mBaseHeight;
            this.mViewportWidth = copy.mViewportWidth;
            this.mViewportHeight = copy.mViewportHeight;
            this.mChangingConfigurations = copy.mChangingConfigurations;
            this.mRootAlpha = copy.mRootAlpha;
            this.mRootName = copy.mRootName;
            if (copy.mRootName != null) {
                this.mVGTargetsMap.put(copy.mRootName, this);
            }
        }

        public boolean canApplyTheme() {
            return this.recursiveCanApplyTheme(this.mRootGroup);
        }

        private boolean recursiveCanApplyTheme(VGroup currentGroup) {
            ArrayList<Object> children = currentGroup.mChildren;
            for (int i = 0; i < children.size(); ++i) {
                VPath childPath;
                VGroup childGroup;
                Object child = children.get(i);
                if (!(child instanceof VGroup ? (childGroup = (VGroup)child).canApplyTheme() || this.recursiveCanApplyTheme(childGroup) : child instanceof VPath && (childPath = (VPath)child).canApplyTheme())) continue;
                return true;
            }
            return false;
        }

        public void applyTheme(Resources.Theme t) {
            this.recursiveApplyTheme(this.mRootGroup, t);
        }

        private void recursiveApplyTheme(VGroup currentGroup, Resources.Theme t) {
            ArrayList<Object> children = currentGroup.mChildren;
            for (int i = 0; i < children.size(); ++i) {
                VPath childPath;
                Object child = children.get(i);
                if (child instanceof VGroup) {
                    VGroup childGroup = (VGroup)child;
                    if (childGroup.canApplyTheme()) {
                        childGroup.applyTheme(t);
                    }
                    this.recursiveApplyTheme(childGroup, t);
                    continue;
                }
                if (!(child instanceof VPath) || !(childPath = (VPath)child).canApplyTheme()) continue;
                childPath.applyTheme(t);
            }
        }

        private void drawGroupTree(VGroup currentGroup, Matrix currentMatrix, Canvas canvas, int w, int h, ColorFilter filter) {
            currentGroup.mStackedMatrix.set(currentMatrix);
            currentGroup.mStackedMatrix.preConcat(currentGroup.mLocalMatrix);
            for (int i = 0; i < currentGroup.mChildren.size(); ++i) {
                Object child = currentGroup.mChildren.get(i);
                if (child instanceof VGroup) {
                    VGroup childGroup = (VGroup)child;
                    this.drawGroupTree(childGroup, currentGroup.mStackedMatrix, canvas, w, h, filter);
                    continue;
                }
                if (!(child instanceof VPath)) continue;
                VPath childPath = (VPath)child;
                this.drawPath(currentGroup, childPath, canvas, w, h, filter);
            }
        }

        public void draw(Canvas canvas, int w, int h, ColorFilter filter) {
            this.drawGroupTree(this.mRootGroup, IDENTITY_MATRIX, canvas, w, h, filter);
        }

        private void drawPath(VGroup vGroup, VPath vPath, Canvas canvas, int w, int h, ColorFilter filter) {
            float scaleX = (float)w / this.mViewportWidth;
            float scaleY = (float)h / this.mViewportHeight;
            float minScale = Math.min(scaleX, scaleY);
            this.mFinalPathMatrix.set(vGroup.mStackedMatrix);
            this.mFinalPathMatrix.postScale(scaleX, scaleY);
            vPath.toPath(this.mPath);
            Path path = this.mPath;
            this.mRenderPath.reset();
            if (vPath.isClipPath()) {
                this.mRenderPath.addPath(path, this.mFinalPathMatrix);
                canvas.clipPath(this.mRenderPath, Region.Op.REPLACE);
            } else {
                VFullPath fullPath = (VFullPath)vPath;
                if (fullPath.mTrimPathStart != 0.0f || fullPath.mTrimPathEnd != 1.0f) {
                    float start = (fullPath.mTrimPathStart + fullPath.mTrimPathOffset) % 1.0f;
                    float end = (fullPath.mTrimPathEnd + fullPath.mTrimPathOffset) % 1.0f;
                    if (this.mPathMeasure == null) {
                        this.mPathMeasure = new PathMeasure();
                    }
                    this.mPathMeasure.setPath(this.mPath, false);
                    float len = this.mPathMeasure.getLength();
                    start *= len;
                    end *= len;
                    path.reset();
                    if (start > end) {
                        this.mPathMeasure.getSegment(start, len, path, true);
                        this.mPathMeasure.getSegment(0.0f, end, path, true);
                    } else {
                        this.mPathMeasure.getSegment(start, end, path, true);
                    }
                    path.rLineTo(0.0f, 0.0f);
                }
                this.mRenderPath.addPath(path, this.mFinalPathMatrix);
                if (fullPath.mFillColor != 0) {
                    if (this.mFillPaint == null) {
                        this.mFillPaint = new Paint();
                        this.mFillPaint.setStyle(Paint.Style.FILL);
                        this.mFillPaint.setAntiAlias(true);
                    }
                    Paint fillPaint = this.mFillPaint;
                    fillPaint.setColor(VectorDrawable.applyAlpha(fullPath.mFillColor, fullPath.mFillAlpha));
                    fillPaint.setColorFilter(filter);
                    canvas.drawPath(this.mRenderPath, fillPaint);
                }
                if (fullPath.mStrokeColor != 0) {
                    if (this.mStrokePaint == null) {
                        this.mStrokePaint = new Paint();
                        this.mStrokePaint.setStyle(Paint.Style.STROKE);
                        this.mStrokePaint.setAntiAlias(true);
                    }
                    Paint strokePaint = this.mStrokePaint;
                    if (fullPath.mStrokeLineJoin != null) {
                        strokePaint.setStrokeJoin(fullPath.mStrokeLineJoin);
                    }
                    if (fullPath.mStrokeLineCap != null) {
                        strokePaint.setStrokeCap(fullPath.mStrokeLineCap);
                    }
                    strokePaint.setStrokeMiter(fullPath.mStrokeMiterlimit);
                    strokePaint.setColor(VectorDrawable.applyAlpha(fullPath.mStrokeColor, fullPath.mStrokeAlpha));
                    strokePaint.setColorFilter(filter);
                    strokePaint.setStrokeWidth(fullPath.mStrokeWidth * minScale);
                    canvas.drawPath(this.mRenderPath, strokePaint);
                }
            }
        }
    }

    private static class VectorDrawableState
    extends Drawable.ConstantState {
        int[] mThemeAttrs;
        int mChangingConfigurations;
        VPathRenderer mVPathRenderer;
        ColorStateList mTint = null;
        PorterDuff.Mode mTintMode = Drawable.DEFAULT_TINT_MODE;
        boolean mAutoMirrored;
        Bitmap mCachedBitmap;
        int[] mCachedThemeAttrs;
        ColorStateList mCachedTint;
        PorterDuff.Mode mCachedTintMode;
        int mCachedRootAlpha;
        boolean mCachedAutoMirrored;
        boolean mCacheDirty;
        Paint mTempPaint;

        public VectorDrawableState(VectorDrawableState copy) {
            if (copy != null) {
                this.mThemeAttrs = copy.mThemeAttrs;
                this.mChangingConfigurations = copy.mChangingConfigurations;
                this.mVPathRenderer = new VPathRenderer(copy.mVPathRenderer);
                if (copy.mVPathRenderer.mFillPaint != null) {
                    this.mVPathRenderer.mFillPaint = new Paint(copy.mVPathRenderer.mFillPaint);
                }
                if (copy.mVPathRenderer.mStrokePaint != null) {
                    this.mVPathRenderer.mStrokePaint = new Paint(copy.mVPathRenderer.mStrokePaint);
                }
                this.mTint = copy.mTint;
                this.mTintMode = copy.mTintMode;
                this.mAutoMirrored = copy.mAutoMirrored;
            }
        }

        public void drawCachedBitmapWithRootAlpha(Canvas canvas, ColorFilter filter) {
            Paint p = this.getPaint(filter);
            canvas.drawBitmap(this.mCachedBitmap, 0.0f, 0.0f, p);
        }

        public boolean hasTranslucentRoot() {
            return this.mVPathRenderer.getRootAlpha() < 255;
        }

        public Paint getPaint(ColorFilter filter) {
            if (!this.hasTranslucentRoot() && filter == null) {
                return null;
            }
            if (this.mTempPaint == null) {
                this.mTempPaint = new Paint();
                this.mTempPaint.setFilterBitmap(true);
            }
            this.mTempPaint.setAlpha(this.mVPathRenderer.getRootAlpha());
            this.mTempPaint.setColorFilter(filter);
            return this.mTempPaint;
        }

        public void updateCachedBitmap(Rect bounds) {
            this.mCachedBitmap.eraseColor(0);
            Canvas tmpCanvas = new Canvas(this.mCachedBitmap);
            this.mVPathRenderer.draw(tmpCanvas, bounds.width(), bounds.height(), null);
        }

        public void createCachedBitmapIfNeeded(Rect bounds) {
            if (this.mCachedBitmap == null || !this.canReuseBitmap(bounds.width(), bounds.height())) {
                this.mCachedBitmap = Bitmap.createBitmap(bounds.width(), bounds.height(), Bitmap.Config.ARGB_8888);
                this.mCacheDirty = true;
            }
        }

        public boolean canReuseBitmap(int width, int height) {
            return width == this.mCachedBitmap.getWidth() && height == this.mCachedBitmap.getHeight();
        }

        public boolean canReuseCache() {
            return !this.mCacheDirty && this.mCachedThemeAttrs == this.mThemeAttrs && this.mCachedTint == this.mTint && this.mCachedTintMode == this.mTintMode && this.mCachedAutoMirrored == this.mAutoMirrored && this.mCachedRootAlpha == this.mVPathRenderer.getRootAlpha();
        }

        public void updateCacheStates() {
            this.mCachedThemeAttrs = this.mThemeAttrs;
            this.mCachedTint = this.mTint;
            this.mCachedTintMode = this.mTintMode;
            this.mCachedRootAlpha = this.mVPathRenderer.getRootAlpha();
            this.mCachedAutoMirrored = this.mAutoMirrored;
            this.mCacheDirty = false;
        }

        @Override
        public boolean canApplyTheme() {
            return super.canApplyTheme() || this.mThemeAttrs != null || this.mVPathRenderer != null && this.mVPathRenderer.canApplyTheme();
        }

        public VectorDrawableState() {
            this.mVPathRenderer = new VPathRenderer();
        }

        @Override
        public Drawable newDrawable() {
            return new VectorDrawable(this, null, null);
        }

        @Override
        public Drawable newDrawable(Resources res) {
            return new VectorDrawable(this, res, null);
        }

        @Override
        public Drawable newDrawable(Resources res, Resources.Theme theme) {
            return new VectorDrawable(this, res, theme);
        }

        @Override
        public int getChangingConfigurations() {
            return this.mChangingConfigurations;
        }
    }
}

