/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.pdf;

import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.graphics.Point;
import android.graphics.Rect;
import android.os.ParcelFileDescriptor;
import android.system.ErrnoException;
import android.system.OsConstants;
import dalvik.system.CloseGuard;
import java.io.FileDescriptor;
import java.io.IOException;
import libcore.io.Libcore;

public final class PdfRenderer
implements AutoCloseable {
    private final CloseGuard mCloseGuard = CloseGuard.get();
    private final Point mTempPoint = new Point();
    private final long mNativeDocument;
    private final int mPageCount;
    private ParcelFileDescriptor mInput;
    private Page mCurrentPage;

    public PdfRenderer(ParcelFileDescriptor input) throws IOException {
        long size;
        if (input == null) {
            throw new NullPointerException("input cannot be null");
        }
        try {
            Libcore.os.lseek(input.getFileDescriptor(), 0L, OsConstants.SEEK_SET);
            size = Libcore.os.fstat((FileDescriptor)input.getFileDescriptor()).st_size;
        }
        catch (ErrnoException ee) {
            throw new IllegalArgumentException("file descriptor not seekable");
        }
        this.mInput = input;
        this.mNativeDocument = PdfRenderer.nativeCreate(this.mInput.getFd(), size);
        this.mPageCount = PdfRenderer.nativeGetPageCount(this.mNativeDocument);
        this.mCloseGuard.open("close");
    }

    @Override
    public void close() {
        this.throwIfClosed();
        this.throwIfPageOpened();
        this.doClose();
    }

    public int getPageCount() {
        this.throwIfClosed();
        return this.mPageCount;
    }

    public boolean shouldScaleForPrinting() {
        this.throwIfClosed();
        return PdfRenderer.nativeScaleForPrinting(this.mNativeDocument);
    }

    public Page openPage(int index) {
        this.throwIfClosed();
        this.throwIfPageOpened();
        this.throwIfPageNotInDocument(index);
        this.mCurrentPage = new Page(index);
        return this.mCurrentPage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.mCloseGuard.warnIfOpen();
            if (this.mInput != null) {
                this.doClose();
            }
        }
        finally {
            super.finalize();
        }
    }

    private void doClose() {
        if (this.mCurrentPage != null) {
            this.mCurrentPage.close();
        }
        PdfRenderer.nativeClose(this.mNativeDocument);
        try {
            this.mInput.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.mInput = null;
        this.mCloseGuard.close();
    }

    private void throwIfClosed() {
        if (this.mInput == null) {
            throw new IllegalStateException("Already closed");
        }
    }

    private void throwIfPageOpened() {
        if (this.mCurrentPage != null) {
            throw new IllegalStateException("Current page not closed");
        }
    }

    private void throwIfPageNotInDocument(int pageIndex) {
        if (pageIndex < 0 || pageIndex >= this.mPageCount) {
            throw new IllegalArgumentException("Invalid page index");
        }
    }

    private static native long nativeCreate(int var0, long var1);

    private static native void nativeClose(long var0);

    private static native int nativeGetPageCount(long var0);

    private static native boolean nativeScaleForPrinting(long var0);

    private static native void nativeRenderPage(long var0, long var2, long var4, int var6, int var7, int var8, int var9, long var10, int var12);

    private static native long nativeOpenPageAndGetSize(long var0, int var2, Point var3);

    private static native void nativeClosePage(long var0);

    public final class Page
    implements AutoCloseable {
        private final CloseGuard mCloseGuard = CloseGuard.get();
        public static final int RENDER_MODE_FOR_DISPLAY = 1;
        public static final int RENDER_MODE_FOR_PRINT = 2;
        private final int mIndex;
        private final int mWidth;
        private final int mHeight;
        private long mNativePage;

        private Page(int index) {
            Point size = PdfRenderer.this.mTempPoint;
            this.mNativePage = PdfRenderer.nativeOpenPageAndGetSize(PdfRenderer.this.mNativeDocument, index, size);
            this.mIndex = index;
            this.mWidth = size.x;
            this.mHeight = size.y;
            this.mCloseGuard.open("close");
        }

        public int getIndex() {
            return this.mIndex;
        }

        public int getWidth() {
            return this.mWidth;
        }

        public int getHeight() {
            return this.mHeight;
        }

        public void render(Bitmap destination, Rect destClip, Matrix transform, int renderMode) {
            if (destination.getConfig() != Bitmap.Config.ARGB_8888) {
                throw new IllegalArgumentException("Unsupported pixel format");
            }
            if (destClip != null && (destClip.left < 0 || destClip.top < 0 || destClip.right > destination.getWidth() || destClip.bottom > destination.getHeight())) {
                throw new IllegalArgumentException("destBounds not in destination");
            }
            if (transform != null && !transform.isAffine()) {
                throw new IllegalArgumentException("transform not affine");
            }
            if (renderMode != 2 && renderMode != 1) {
                throw new IllegalArgumentException("Unsupported render mode");
            }
            if (renderMode == 2 && renderMode == 1) {
                throw new IllegalArgumentException("Only single render mode supported");
            }
            int contentLeft = destClip != null ? destClip.left : 0;
            int contentTop = destClip != null ? destClip.top : 0;
            int contentRight = destClip != null ? destClip.right : destination.getWidth();
            int contentBottom = destClip != null ? destClip.bottom : destination.getHeight();
            long transformPtr = transform != null ? transform.native_instance : 0L;
            PdfRenderer.nativeRenderPage(PdfRenderer.this.mNativeDocument, this.mNativePage, destination.mNativeBitmap, contentLeft, contentTop, contentRight, contentBottom, transformPtr, renderMode);
        }

        @Override
        public void close() {
            this.throwIfClosed();
            this.doClose();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() throws Throwable {
            try {
                this.mCloseGuard.warnIfOpen();
                if (this.mNativePage != 0L) {
                    this.doClose();
                }
            }
            finally {
                super.finalize();
            }
        }

        private void doClose() {
            PdfRenderer.nativeClosePage(this.mNativePage);
            this.mNativePage = 0L;
            this.mCloseGuard.close();
            PdfRenderer.this.mCurrentPage = null;
        }

        private void throwIfClosed() {
            if (this.mNativePage == 0L) {
                throw new IllegalStateException("Already closed");
            }
        }
    }
}

